/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearch;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPSearchOutputHandler;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
final class ValuesOnlyLDAPSearchOutputHandler
extends LDAPSearchOutputHandler {
    private final LDAPSearch ldapSearch;

    ValuesOnlyLDAPSearchOutputHandler(LDAPSearch ldapSearch) {
        this.ldapSearch = ldapSearch;
    }

    @Override
    public void formatHeader() {
    }

    @Override
    public void formatSearchResultEntry(SearchResultEntry entry) {
        try {
            for (Attribute a : entry.getAttributes()) {
                for (byte[] value : a.getValueByteArrays()) {
                    this.ldapSearch.getOutStream().write(value);
                    this.ldapSearch.getOutStream().write(StaticUtils.EOL_BYTES);
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPRuntimeException(new LDAPException(ResultCode.OTHER, ToolMessages.ERR_VALUES_ONLY_OUTPUT_FORMAT_WRITE_ERROR.get(StaticUtils.getExceptionMessage(e)), e));
        }
    }

    @Override
    public void formatSearchResultReference(SearchResultReference ref) {
    }

    @Override
    public void formatResult(LDAPResult result) {
        this.ldapSearch.getOutStream().flush();
    }

    @Override
    public void formatUnsolicitedNotification(LDAPConnection connection, ExtendedResult notification) {
        this.ldapSearch.getOutStream().flush();
    }
}

