/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OID
implements Serializable,
Comparable<OID> {
    private static final long serialVersionUID = -4542498394670806081L;
    private final List<Integer> components;
    private final String oidString;

    public OID(String oidString) {
        this.oidString = oidString == null ? "" : oidString;
        this.components = OID.parseComponents(oidString);
    }

    public OID(int ... components) {
        this(OID.toList(components));
    }

    public OID(List<Integer> components) {
        if (components == null || components.isEmpty()) {
            this.components = null;
            this.oidString = "";
        } else {
            this.components = Collections.unmodifiableList(new ArrayList<Integer>(components));
            StringBuilder buffer = new StringBuilder();
            for (Integer i : components) {
                if (buffer.length() > 0) {
                    buffer.append('.');
                }
                buffer.append(i);
            }
            this.oidString = buffer.toString();
        }
    }

    private OID(String oidString, List<Integer> components) {
        this.oidString = oidString;
        this.components = Collections.unmodifiableList(components);
    }

    private static List<Integer> toList(int ... components) {
        if (components == null) {
            return null;
        }
        ArrayList<Integer> compList = new ArrayList<Integer>(components.length);
        for (int i : components) {
            compList.add(i);
        }
        return compList;
    }

    public static List<Integer> parseComponents(String oidString) {
        if (oidString == null || oidString.isEmpty() || oidString.startsWith(".") || oidString.endsWith(".") || oidString.indexOf("..") > 0) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(oidString, ".");
        ArrayList<Integer> compList = new ArrayList<Integer>(10);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                compList.add(Integer.parseInt(token));
            }
            catch (Exception e) {
                Debug.debugException(e);
                return null;
            }
        }
        return Collections.unmodifiableList(compList);
    }

    public static OID parseNumericOID(String oidString, boolean strict) throws ParseException {
        if (oidString == null || oidString.isEmpty()) {
            throw new ParseException(UtilityMessages.ERR_OID_EMPTY.get(), 0);
        }
        int componentStartPos = 0;
        ArrayList<Integer> components = new ArrayList<Integer>(oidString.length());
        StringBuilder buffer = new StringBuilder(oidString.length());
        block12: for (int i = 0; i < oidString.length(); ++i) {
            char c = oidString.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    buffer.append(c);
                    continue block12;
                }
                case '.': {
                    if (buffer.length() == 0) {
                        if (i == 0) {
                            throw new ParseException(UtilityMessages.ERR_OID_STARTS_WITH_PERIOD.get(oidString), i);
                        }
                        throw new ParseException(UtilityMessages.ERR_OID_CONSECUTIVE_PERIODS.get(oidString, i), i);
                    }
                    if (buffer.length() > 1 && buffer.charAt(0) == '0') {
                        throw new ParseException(UtilityMessages.ERR_OID_LEADING_ZERO.get(oidString, buffer.toString()), componentStartPos);
                    }
                    try {
                        components.add(Integer.parseInt(buffer.toString()));
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new ParseException(UtilityMessages.ERR_OID_CANNOT_PARSE_AS_INT.get(oidString, buffer.toString(), componentStartPos), componentStartPos);
                    }
                    buffer.setLength(0);
                    componentStartPos = i + 1;
                    continue block12;
                }
                default: {
                    throw new ParseException(UtilityMessages.ERR_OID_ILLEGAL_CHARACTER.get(oidString, Character.valueOf(c), i), i);
                }
            }
        }
        if (buffer.length() == 0) {
            throw new ParseException(UtilityMessages.ERR_OID_ENDS_WITH_PERIOD.get(oidString), oidString.length() - 1);
        }
        if (buffer.length() > 1 && buffer.charAt(0) == '0') {
            throw new ParseException(UtilityMessages.ERR_OID_LEADING_ZERO.get(oidString, buffer.toString()), componentStartPos);
        }
        try {
            components.add(Integer.parseInt(buffer.toString()));
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ParseException(UtilityMessages.ERR_OID_CANNOT_PARSE_AS_INT.get(oidString, buffer.toString(), componentStartPos), componentStartPos);
        }
        if (strict) {
            if (components.size() < 2) {
                throw new ParseException(UtilityMessages.ERR_OID_NOT_ENOUGH_COMPONENTS.get(oidString), 0);
            }
            int firstComponent = (Integer)components.get(0);
            int secondComponent = (Integer)components.get(1);
            switch (firstComponent) {
                case 0: 
                case 1: {
                    if (secondComponent <= 39) break;
                    throw new ParseException(UtilityMessages.ERR_OID_ILLEGAL_SECOND_COMPONENT.get(oidString, secondComponent, firstComponent), 0);
                }
                case 2: {
                    break;
                }
                default: {
                    throw new ParseException(UtilityMessages.ERR_OID_ILLEGAL_FIRST_COMPONENT.get(oidString, firstComponent), 0);
                }
            }
        }
        return new OID(oidString, components);
    }

    public static boolean isValidNumericOID(String s) {
        return new OID(s).isValidNumericOID();
    }

    public boolean isValidNumericOID() {
        return this.components != null;
    }

    public static boolean isStrictlyValidNumericOID(String s) {
        return new OID(s).isStrictlyValidNumericOID();
    }

    public boolean isStrictlyValidNumericOID() {
        if (this.components == null || this.components.size() < 2) {
            return false;
        }
        int firstComponent = this.components.get(0);
        int secondComponent = this.components.get(1);
        switch (firstComponent) {
            case 0: 
            case 1: {
                return secondComponent <= 39;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public List<Integer> getComponents() {
        return this.components;
    }

    public int hashCode() {
        if (this.components == null) {
            return this.oidString.hashCode();
        }
        int hashCode = 0;
        for (int i : this.components) {
            hashCode += i;
        }
        return hashCode;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof OID) {
            OID oid = (OID)o;
            if (this.components == null) {
                return this.oidString.equals(oid.oidString);
            }
            return this.components.equals(oid.components);
        }
        return false;
    }

    @Override
    public int compareTo(OID oid) {
        if (this.components == null) {
            if (oid.components == null) {
                return this.oidString.compareTo(oid.oidString);
            }
            return 1;
        }
        if (oid.components == null) {
            return -1;
        }
        for (int i = 0; i < Math.min(this.components.size(), oid.components.size()); ++i) {
            int thatValue;
            int thisValue = this.components.get(i);
            if (thisValue < (thatValue = oid.components.get(i).intValue())) {
                return -1;
            }
            if (thisValue <= thatValue) continue;
            return 1;
        }
        if (this.components.size() < oid.components.size()) {
            return -1;
        }
        if (this.components.size() > oid.components.size()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.oidString;
    }
}

