/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.ANONYMOUSBindRequest;
import com.unboundid.ldap.sdk.CRAMMD5BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequest;
import com.unboundid.ldap.sdk.DIGESTMD5BindRequestProperties;
import com.unboundid.ldap.sdk.EXTERNALBindRequest;
import com.unboundid.ldap.sdk.GSSAPIBindRequest;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.PLAINBindRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import com.unboundid.ldap.sdk.unboundidds.SingleUseTOTPBindRequest;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDCertificatePlusPasswordBindRequest;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDeliveredOTPBindRequest;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDYubiKeyOTPBindRequest;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.SASLMechanismInfo;
import com.unboundid.util.SASLOption;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SASLUtils {
    public static final String SASL_OPTION_AUTH_ID = "authID";
    public static final String SASL_OPTION_AUTHZ_ID = "authzID";
    public static final String SASL_OPTION_CONFIG_FILE = "configFile";
    public static final String SASL_OPTION_DEBUG = "debug";
    public static final String SASL_OPTION_KDC_ADDRESS = "kdcAddress";
    public static final String SASL_OPTION_MECHANISM = "mech";
    public static final String SASL_OPTION_OTP = "otp";
    public static final String SASL_OPTION_PROMPT_FOR_STATIC_PW = "promptForStaticPassword";
    public static final String SASL_OPTION_PROTOCOL = "protocol";
    public static final String SASL_OPTION_QOP = "qop";
    public static final String SASL_OPTION_REALM = "realm";
    public static final String SASL_OPTION_REQUIRE_CACHE = "requireCache";
    public static final String SASL_OPTION_RENEW_TGT = "renewTGT";
    public static final String SASL_OPTION_TICKET_CACHE_PATH = "ticketCache";
    public static final String SASL_OPTION_TOTP_PASSWORD = "totpPassword";
    public static final String SASL_OPTION_TRACE = "trace";
    public static final String SASL_OPTION_USE_TICKET_CACHE = "useTicketCache";
    private static final Map<String, SASLMechanismInfo> SASL_MECHANISMS;

    private SASLUtils() {
    }

    public static List<SASLMechanismInfo> getSupportedSASLMechanisms() {
        return Collections.unmodifiableList(new ArrayList<SASLMechanismInfo>(SASL_MECHANISMS.values()));
    }

    public static SASLMechanismInfo getSASLMechanismInfo(String mechanism) {
        return SASL_MECHANISMS.get(StaticUtils.toLowerCase(mechanism));
    }

    public static SASLBindRequest createBindRequest(String bindDN, String password, String mechanism, String ... options) throws LDAPException {
        return SASLUtils.createBindRequest(bindDN, password == null ? null : StaticUtils.getBytes(password), mechanism, StaticUtils.toList(options), new Control[0]);
    }

    public static SASLBindRequest createBindRequest(String bindDN, String password, String mechanism, List<String> options, Control ... controls) throws LDAPException {
        return SASLUtils.createBindRequest(bindDN, password == null ? null : StaticUtils.getBytes(password), mechanism, options, controls);
    }

    public static SASLBindRequest createBindRequest(String bindDN, byte[] password, String mechanism, String ... options) throws LDAPException {
        return SASLUtils.createBindRequest(bindDN, password, mechanism, StaticUtils.toList(options), new Control[0]);
    }

    public static SASLBindRequest createBindRequest(String bindDN, byte[] password, String mechanism, List<String> options, Control ... controls) throws LDAPException {
        return SASLUtils.createBindRequest(bindDN, password, false, null, mechanism, options, controls);
    }

    public static SASLBindRequest createBindRequest(String bindDN, byte[] password, boolean promptForPassword, CommandLineTool tool, String mechanism, List<String> options, Control ... controls) throws LDAPException {
        String mech;
        Map<String, String> optionsMap;
        String mechOption;
        if (promptForPassword) {
            Validator.ensureNotNull(tool);
        }
        if ((mechOption = (optionsMap = SASLUtils.parseOptions(options)).remove(StaticUtils.toLowerCase(SASL_OPTION_MECHANISM))) != null) {
            mech = mechOption;
            if (mechanism != null && !mech.equalsIgnoreCase(mechanism)) {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_CONFLICT.get(mechanism, mech));
            }
        } else {
            mech = mechanism;
        }
        if (mech == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_NO_MECH.get());
        }
        if (mech.equalsIgnoreCase("ANONYMOUS")) {
            return SASLUtils.createANONYMOUSBindRequest(password, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("CRAM-MD5")) {
            return SASLUtils.createCRAMMD5BindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("DIGEST-MD5")) {
            return SASLUtils.createDIGESTMD5BindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("EXTERNAL")) {
            return SASLUtils.createEXTERNALBindRequest(password, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("GSSAPI")) {
            return SASLUtils.createGSSAPIBindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("PLAIN")) {
            return SASLUtils.createPLAINBindRequest(password, promptForPassword, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("UNBOUNDID-CERTIFICATE-PLUS-PASSWORD")) {
            return SASLUtils.createUnboundIDCertificatePlusPasswordBindRequest(password, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("UNBOUNDID-DELIVERED-OTP")) {
            return SASLUtils.createUNBOUNDIDDeliveredOTPBindRequest(password, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("UNBOUNDID-TOTP")) {
            return SASLUtils.createUNBOUNDIDTOTPBindRequest(password, tool, optionsMap, controls);
        }
        if (mech.equalsIgnoreCase("UNBOUNDID-YUBIKEY-OTP")) {
            return SASLUtils.createUNBOUNDIDYUBIKEYOTPBindRequest(password, tool, optionsMap, controls);
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_UNSUPPORTED_MECH.get(mech));
    }

    private static ANONYMOUSBindRequest createANONYMOUSBindRequest(byte[] password, Map<String, String> options, Control[] controls) throws LDAPException {
        if (password != null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_DOESNT_ACCEPT_PASSWORD.get("ANONYMOUS"));
        }
        String trace = options.remove(StaticUtils.toLowerCase(SASL_OPTION_TRACE));
        SASLUtils.ensureNoUnsupportedOptions(options, "ANONYMOUS");
        return new ANONYMOUSBindRequest(trace, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CRAMMD5BindRequest createCRAMMD5BindRequest(byte[] password, boolean promptForPassword, CommandLineTool tool, Map<String, String> options, Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            if (!promptForPassword) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_REQUIRES_PASSWORD.get("CRAM-MD5"));
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "CRAM-MD5"));
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "CRAM-MD5");
        return new CRAMMD5BindRequest(authID, pw, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DIGESTMD5BindRequest createDIGESTMD5BindRequest(byte[] password, boolean promptForPassword, CommandLineTool tool, Map<String, String> options, Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            if (!promptForPassword) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_REQUIRES_PASSWORD.get("CRAM-MD5"));
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "CRAM-MD5"));
        }
        DIGESTMD5BindRequestProperties properties = new DIGESTMD5BindRequestProperties(authID, pw);
        properties.setAuthorizationID(options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID)));
        properties.setRealm(options.remove(StaticUtils.toLowerCase(SASL_OPTION_REALM)));
        String qopString = options.remove(StaticUtils.toLowerCase(SASL_OPTION_QOP));
        if (qopString != null) {
            properties.setAllowedQoP(SASLQualityOfProtection.decodeQoPList(qopString));
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "DIGEST-MD5");
        return new DIGESTMD5BindRequest(properties, controls);
    }

    private static EXTERNALBindRequest createEXTERNALBindRequest(byte[] password, Map<String, String> options, Control[] controls) throws LDAPException {
        if (password != null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_DOESNT_ACCEPT_PASSWORD.get("EXTERNAL"));
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "EXTERNAL");
        return new EXTERNALBindRequest(controls);
    }

    private static GSSAPIBindRequest createGSSAPIBindRequest(byte[] password, boolean promptForPassword, CommandLineTool tool, Map<String, String> options, Control[] controls) throws LDAPException {
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "GSSAPI"));
        }
        GSSAPIBindRequestProperties gssapiProperties = new GSSAPIBindRequestProperties(authID, password);
        gssapiProperties.setAuthorizationID(options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID)));
        gssapiProperties.setConfigFilePath(options.remove(StaticUtils.toLowerCase(SASL_OPTION_CONFIG_FILE)));
        gssapiProperties.setEnableGSSAPIDebugging(SASLUtils.getBooleanValue(options, SASL_OPTION_DEBUG, false));
        gssapiProperties.setKDCAddress(options.remove(StaticUtils.toLowerCase(SASL_OPTION_KDC_ADDRESS)));
        String protocol = options.remove(StaticUtils.toLowerCase(SASL_OPTION_PROTOCOL));
        if (protocol != null) {
            gssapiProperties.setServicePrincipalProtocol(protocol);
        }
        gssapiProperties.setRealm(options.remove(StaticUtils.toLowerCase(SASL_OPTION_REALM)));
        String qopString = options.remove(StaticUtils.toLowerCase(SASL_OPTION_QOP));
        if (qopString != null) {
            gssapiProperties.setAllowedQoP(SASLQualityOfProtection.decodeQoPList(qopString));
        }
        gssapiProperties.setRenewTGT(SASLUtils.getBooleanValue(options, SASL_OPTION_RENEW_TGT, false));
        gssapiProperties.setRequireCachedCredentials(SASLUtils.getBooleanValue(options, SASL_OPTION_REQUIRE_CACHE, false));
        gssapiProperties.setTicketCachePath(options.remove(StaticUtils.toLowerCase(SASL_OPTION_TICKET_CACHE_PATH)));
        gssapiProperties.setUseTicketCache(SASLUtils.getBooleanValue(options, SASL_OPTION_USE_TICKET_CACHE, true));
        SASLUtils.ensureNoUnsupportedOptions(options, "GSSAPI");
        if (!(password != null || gssapiProperties.useTicketCache() && gssapiProperties.requireCachedCredentials())) {
            if (promptForPassword) {
                tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
                gssapiProperties.setPassword(PasswordReader.readPassword());
                tool.getOriginalOut().println();
            } else {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_GSSAPI_PASSWORD_REQUIRED.get());
            }
        }
        return new GSSAPIBindRequest(gssapiProperties, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PLAINBindRequest createPLAINBindRequest(byte[] password, boolean promptForPassword, CommandLineTool tool, Map<String, String> options, Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            if (!promptForPassword) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_REQUIRES_PASSWORD.get("CRAM-MD5"));
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "PLAIN"));
        }
        String authzID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID));
        SASLUtils.ensureNoUnsupportedOptions(options, "PLAIN");
        return new PLAINBindRequest(authID, authzID, pw, controls);
    }

    private static UnboundIDCertificatePlusPasswordBindRequest createUnboundIDCertificatePlusPasswordBindRequest(byte[] password, CommandLineTool tool, Map<String, String> options, Control[] controls) throws LDAPException {
        byte[] pw;
        if (password == null) {
            tool.getOriginalOut().print(UtilityMessages.INFO_LDAP_TOOL_ENTER_BIND_PASSWORD.get());
            pw = PasswordReader.readPassword();
            tool.getOriginalOut().println();
        } else {
            pw = password;
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "UNBOUNDID-CERTIFICATE-PLUS-PASSWORD");
        return new UnboundIDCertificatePlusPasswordBindRequest(pw, controls);
    }

    private static UnboundIDDeliveredOTPBindRequest createUNBOUNDIDDeliveredOTPBindRequest(byte[] password, Map<String, String> options, Control ... controls) throws LDAPException {
        if (password != null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MECH_DOESNT_ACCEPT_PASSWORD.get("UNBOUNDID-DELIVERED-OTP"));
        }
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "UNBOUNDID-DELIVERED-OTP"));
        }
        String otp = options.remove(StaticUtils.toLowerCase(SASL_OPTION_OTP));
        if (otp == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_OTP, "UNBOUNDID-DELIVERED-OTP"));
        }
        String authzID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID));
        SASLUtils.ensureNoUnsupportedOptions(options, "UNBOUNDID-DELIVERED-OTP");
        return new UnboundIDDeliveredOTPBindRequest(authID, authzID, otp, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SingleUseTOTPBindRequest createUNBOUNDIDTOTPBindRequest(byte[] password, CommandLineTool tool, Map<String, String> options, Control ... controls) throws LDAPException {
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "UNBOUNDID-TOTP"));
        }
        String totpPassword = options.remove(StaticUtils.toLowerCase(SASL_OPTION_TOTP_PASSWORD));
        if (totpPassword == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_TOTP_PASSWORD, "UNBOUNDID-TOTP"));
        }
        byte[] pwBytes = password;
        String authzID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID));
        String promptStr = options.remove(StaticUtils.toLowerCase(SASL_OPTION_PROMPT_FOR_STATIC_PW));
        if (promptStr != null) {
            if (promptStr.equalsIgnoreCase("true")) {
                if (pwBytes != null) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_PROMPT_FOR_PROVIDED_PW.get(SASL_OPTION_PROMPT_FOR_STATIC_PW));
                tool.getOriginalOut().print(UtilityMessages.INFO_SASL_ENTER_STATIC_PW.get());
                pwBytes = PasswordReader.readPassword();
                tool.getOriginalOut().println();
            } else if (!promptStr.equalsIgnoreCase("false")) {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_PROMPT_FOR_STATIC_PW_BAD_VALUE.get(SASL_OPTION_PROMPT_FOR_STATIC_PW));
            }
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "UNBOUNDID-TOTP");
        return new SingleUseTOTPBindRequest(authID, authzID, totpPassword, pwBytes, controls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static UnboundIDYubiKeyOTPBindRequest createUNBOUNDIDYUBIKEYOTPBindRequest(byte[] password, CommandLineTool tool, Map<String, String> options, Control ... controls) throws LDAPException {
        String authID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTH_ID));
        if (authID == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_AUTH_ID, "UNBOUNDID-YUBIKEY-OTP"));
        }
        String otp = options.remove(StaticUtils.toLowerCase(SASL_OPTION_OTP));
        if (otp == null) {
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_MISSING_REQUIRED_OPTION.get(SASL_OPTION_OTP, "UNBOUNDID-YUBIKEY-OTP"));
        }
        String authzID = options.remove(StaticUtils.toLowerCase(SASL_OPTION_AUTHZ_ID));
        byte[] pwBytes = password;
        String promptStr = options.remove(StaticUtils.toLowerCase(SASL_OPTION_PROMPT_FOR_STATIC_PW));
        if (promptStr != null) {
            if (promptStr.equalsIgnoreCase("true")) {
                if (pwBytes != null) throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_PROMPT_FOR_PROVIDED_PW.get(SASL_OPTION_PROMPT_FOR_STATIC_PW));
                tool.getOriginalOut().print(UtilityMessages.INFO_SASL_ENTER_STATIC_PW.get());
                pwBytes = PasswordReader.readPassword();
                tool.getOriginalOut().println();
            } else if (!promptStr.equalsIgnoreCase("false")) {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_PROMPT_FOR_STATIC_PW_BAD_VALUE.get(SASL_OPTION_PROMPT_FOR_STATIC_PW));
            }
        }
        SASLUtils.ensureNoUnsupportedOptions(options, "UNBOUNDID-YUBIKEY-OTP");
        return new UnboundIDYubiKeyOTPBindRequest(authID, authzID, pwBytes, otp, controls);
    }

    private static Map<String, String> parseOptions(List<String> options) throws LDAPException {
        if (options == null) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> m = new HashMap<String, String>(StaticUtils.computeMapCapacity(options.size()));
        for (String s : options) {
            int equalPos = s.indexOf(61);
            if (equalPos < 0) {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MISSING_EQUAL.get(s));
            }
            if (equalPos == 0) {
                throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_STARTS_WITH_EQUAL.get(s));
            }
            String name = s.substring(0, equalPos);
            String value = s.substring(equalPos + 1);
            if (m.put(StaticUtils.toLowerCase(name), value) == null) continue;
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_NOT_MULTI_VALUED.get(name));
        }
        return m;
    }

    @InternalUseOnly
    public static void ensureNoUnsupportedOptions(Map<String, String> options, String mechanism) throws LDAPException {
        Iterator<String> i$;
        if (!options.isEmpty() && (i$ = options.keySet().iterator()).hasNext()) {
            String s = i$.next();
            throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_UNSUPPORTED_FOR_MECH.get(s, mechanism));
        }
    }

    static boolean getBooleanValue(Map<String, String> m, String o, boolean d) throws LDAPException {
        String s = StaticUtils.toLowerCase(m.remove(StaticUtils.toLowerCase(o)));
        if (s == null) {
            return d;
        }
        if (s.equals("true") || s.equals("t") || s.equals("yes") || s.equals("y") || s.equals("on") || s.equals("1")) {
            return true;
        }
        if (s.equals("false") || s.equals("f") || s.equals("no") || s.equals("n") || s.equals("off") || s.equals("0")) {
            return false;
        }
        throw new LDAPException(ResultCode.PARAM_ERROR, UtilityMessages.ERR_SASL_OPTION_MALFORMED_BOOLEAN_VALUE.get(o));
    }

    public static String getUsageString(int maxWidth) {
        return SASLUtils.getUsageString(null, maxWidth);
    }

    public static String getUsageString(String mechanism, int maxWidth) {
        StringBuilder buffer = new StringBuilder();
        for (String line : SASLUtils.getUsage(mechanism, maxWidth)) {
            buffer.append(line);
            buffer.append(StaticUtils.EOL);
        }
        return buffer.toString();
    }

    public static List<String> getUsage(int maxWidth) {
        return SASLUtils.getUsage(null, maxWidth);
    }

    public static List<String> getUsage(String mechanism, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>(100);
        boolean first = true;
        for (SASLMechanismInfo i : SASLUtils.getSupportedSASLMechanisms()) {
            if (mechanism != null && !i.getName().equalsIgnoreCase(mechanism)) continue;
            if (first) {
                first = false;
            } else {
                lines.add("");
                lines.add("");
            }
            lines.addAll(StaticUtils.wrapLine(UtilityMessages.INFO_SASL_HELP_MECHANISM.get(i.getName()), maxWidth));
            lines.add("");
            for (String line : StaticUtils.wrapLine(i.getDescription(), maxWidth - 4)) {
                lines.add("  " + line);
            }
            lines.add("");
            for (String line : StaticUtils.wrapLine(UtilityMessages.INFO_SASL_HELP_MECHANISM_OPTIONS.get(i.getName()), maxWidth - 4)) {
                lines.add("  " + line);
            }
            if (i.acceptsPassword()) {
                lines.add("");
                if (i.requiresPassword()) {
                    for (String line : StaticUtils.wrapLine(UtilityMessages.INFO_SASL_HELP_PASSWORD_REQUIRED.get(i.getName()), maxWidth - 4)) {
                        lines.add("  " + line);
                    }
                } else {
                    for (String line : StaticUtils.wrapLine(UtilityMessages.INFO_SASL_HELP_PASSWORD_OPTIONAL.get(i.getName()), maxWidth - 4)) {
                        lines.add("  " + line);
                    }
                }
            }
            for (SASLOption o : i.getOptions()) {
                lines.add("");
                lines.add("  * " + o.getName());
                for (String line : StaticUtils.wrapLine(o.getDescription(), maxWidth - 14)) {
                    lines.add("       " + line);
                }
            }
        }
        if (mechanism != null && lines.isEmpty()) {
            return SASLUtils.getUsage(null, maxWidth);
        }
        return lines;
    }

    static {
        TreeMap<String, SASLMechanismInfo> m = new TreeMap<String, SASLMechanismInfo>();
        m.put(StaticUtils.toLowerCase("ANONYMOUS"), new SASLMechanismInfo("ANONYMOUS", UtilityMessages.INFO_SASL_ANONYMOUS_DESCRIPTION.get(), false, false, new SASLOption(SASL_OPTION_TRACE, UtilityMessages.INFO_SASL_ANONYMOUS_OPTION_TRACE.get(), false, false)));
        m.put(StaticUtils.toLowerCase("CRAM-MD5"), new SASLMechanismInfo("CRAM-MD5", UtilityMessages.INFO_SASL_CRAM_MD5_DESCRIPTION.get(), true, true, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_CRAM_MD5_OPTION_AUTH_ID.get(), true, false)));
        m.put(StaticUtils.toLowerCase("DIGEST-MD5"), new SASLMechanismInfo("DIGEST-MD5", UtilityMessages.INFO_SASL_DIGEST_MD5_DESCRIPTION.get(), true, true, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_DIGEST_MD5_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_DIGEST_MD5_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_REALM, UtilityMessages.INFO_SASL_DIGEST_MD5_OPTION_REALM.get(), false, false), new SASLOption(SASL_OPTION_QOP, UtilityMessages.INFO_SASL_DIGEST_MD5_OPTION_QOP.get(), false, false)));
        m.put(StaticUtils.toLowerCase("EXTERNAL"), new SASLMechanismInfo("EXTERNAL", UtilityMessages.INFO_SASL_EXTERNAL_DESCRIPTION.get(), false, false, new SASLOption[0]));
        m.put(StaticUtils.toLowerCase("GSSAPI"), new SASLMechanismInfo("GSSAPI", UtilityMessages.INFO_SASL_GSSAPI_DESCRIPTION.get(), true, false, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_GSSAPI_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_GSSAPI_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_CONFIG_FILE, UtilityMessages.INFO_SASL_GSSAPI_OPTION_CONFIG_FILE.get(), false, false), new SASLOption(SASL_OPTION_DEBUG, UtilityMessages.INFO_SASL_GSSAPI_OPTION_DEBUG.get(), false, false), new SASLOption(SASL_OPTION_KDC_ADDRESS, UtilityMessages.INFO_SASL_GSSAPI_OPTION_KDC_ADDRESS.get(), false, false), new SASLOption(SASL_OPTION_PROTOCOL, UtilityMessages.INFO_SASL_GSSAPI_OPTION_PROTOCOL.get(), false, false), new SASLOption(SASL_OPTION_REALM, UtilityMessages.INFO_SASL_GSSAPI_OPTION_REALM.get(), false, false), new SASLOption(SASL_OPTION_QOP, UtilityMessages.INFO_SASL_GSSAPI_OPTION_QOP.get(), false, false), new SASLOption(SASL_OPTION_RENEW_TGT, UtilityMessages.INFO_SASL_GSSAPI_OPTION_RENEW_TGT.get(), false, false), new SASLOption(SASL_OPTION_REQUIRE_CACHE, UtilityMessages.INFO_SASL_GSSAPI_OPTION_REQUIRE_TICKET_CACHE.get(), false, false), new SASLOption(SASL_OPTION_TICKET_CACHE_PATH, UtilityMessages.INFO_SASL_GSSAPI_OPTION_TICKET_CACHE.get(), false, false), new SASLOption(SASL_OPTION_USE_TICKET_CACHE, UtilityMessages.INFO_SASL_GSSAPI_OPTION_USE_TICKET_CACHE.get(), false, false)));
        m.put(StaticUtils.toLowerCase("PLAIN"), new SASLMechanismInfo("PLAIN", UtilityMessages.INFO_SASL_PLAIN_DESCRIPTION.get(), true, true, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_PLAIN_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_PLAIN_OPTION_AUTHZ_ID.get(), false, false)));
        m.put(StaticUtils.toLowerCase("UNBOUNDID-CERTIFICATE-PLUS-PASSWORD"), new SASLMechanismInfo("UNBOUNDID-CERTIFICATE-PLUS-PASSWORD", UtilityMessages.INFO_SASL_UNBOUNDID_CERT_PLUS_PASSWORD_DESCRIPTION.get(), true, true, new SASLOption[0]));
        m.put(StaticUtils.toLowerCase("UNBOUNDID-DELIVERED-OTP"), new SASLMechanismInfo("UNBOUNDID-DELIVERED-OTP", UtilityMessages.INFO_SASL_UNBOUNDID_DELIVERED_OTP_DESCRIPTION.get(), false, false, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_OTP, UtilityMessages.INFO_SASL_UNBOUNDID_DELIVERED_OTP_OPTION_OTP.get(), true, false)));
        m.put(StaticUtils.toLowerCase("UNBOUNDID-TOTP"), new SASLMechanismInfo("UNBOUNDID-TOTP", UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_DESCRIPTION.get(), true, false, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_PROMPT_FOR_STATIC_PW, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_PROMPT_FOR_PW.get(), false, false), new SASLOption(SASL_OPTION_TOTP_PASSWORD, UtilityMessages.INFO_SASL_UNBOUNDID_TOTP_OPTION_TOTP_PASSWORD.get(), true, false)));
        m.put(StaticUtils.toLowerCase("UNBOUNDID-YUBIKEY-OTP"), new SASLMechanismInfo("UNBOUNDID-YUBIKEY-OTP", UtilityMessages.INFO_SASL_UNBOUNDID_YUBIKEY_OTP_DESCRIPTION.get(), true, false, new SASLOption(SASL_OPTION_AUTH_ID, UtilityMessages.INFO_SASL_UNBOUNDID_YUBIKEY_OTP_OPTION_AUTH_ID.get(), true, false), new SASLOption(SASL_OPTION_AUTHZ_ID, UtilityMessages.INFO_SASL_UNBOUNDID_YUBIKEY_OTP_OPTION_AUTHZ_ID.get(), false, false), new SASLOption(SASL_OPTION_OTP, UtilityMessages.INFO_SASL_UNBOUNDID_YUBIKEY_OTP_OPTION_OTP.get(), true, false), new SASLOption(SASL_OPTION_PROMPT_FOR_STATIC_PW, UtilityMessages.INFO_SASL_UNBOUNDID_YUBIKEY_OTP_OPTION_PROMPT_FOR_PW.get(), false, false)));
        SASL_MECHANISMS = Collections.unmodifiableMap(m);
    }
}

