/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.OID;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentValueValidator;
import java.io.Serializable;
import java.text.ParseException;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OIDArgumentValueValidator
extends ArgumentValueValidator
implements Serializable {
    private static final long serialVersionUID = 2195078137238476902L;
    private final boolean isStrict;

    public OIDArgumentValueValidator() {
        this(true);
    }

    public OIDArgumentValueValidator(boolean isStrict) {
        this.isStrict = isStrict;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    @Override
    public void validateArgumentValue(Argument argument, String valueString) throws ArgumentException {
        try {
            OID.parseNumericOID(valueString, this.isStrict);
        }
        catch (ParseException e) {
            Debug.debugException(e);
            throw new ArgumentException(ArgsMessages.ERR_OID_VALIDATOR_INVALID_VALUE.get(argument.getIdentifierString(), e.getMessage()), e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("OIDArgumentValueValidator(isStrict=");
        buffer.append(this.isStrict);
        buffer.append(')');
    }
}

