/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.OAUTHBEARERBindRequest;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class OAUTHBEARERBindRequestProperties
implements Serializable {
    private static final long serialVersionUID = -7664683436256231975L;
    @Nullable
    private Integer serverPort;
    @NotNull
    private String accessToken;
    @Nullable
    private String authorizationID;
    @Nullable
    private String requestMethod;
    @Nullable
    private String requestPath;
    @Nullable
    private String requestPostData;
    @Nullable
    private String requestQueryString;
    @Nullable
    private String serverAddress;

    public OAUTHBEARERBindRequestProperties(@NotNull String accessToken) {
        Validator.ensureNotNullOrEmpty(accessToken, "OAUTHBEARERBindRequestProperties.accessToken must not be null or empty.");
        this.accessToken = accessToken;
        this.authorizationID = null;
        this.serverAddress = null;
        this.serverPort = null;
        this.requestMethod = null;
        this.requestPath = null;
        this.requestPostData = null;
        this.requestQueryString = null;
    }

    public OAUTHBEARERBindRequestProperties(@NotNull OAUTHBEARERBindRequestProperties properties) {
        Validator.ensureNotNullWithMessage(properties, "OAUTHBEARERBindRequestProperties.properties must not be null.");
        this.accessToken = properties.accessToken;
        this.authorizationID = properties.authorizationID;
        this.serverAddress = properties.serverAddress;
        this.serverPort = properties.serverPort;
        this.requestMethod = properties.requestMethod;
        this.requestPath = properties.requestPath;
        this.requestPostData = properties.requestPostData;
        this.requestQueryString = properties.requestQueryString;
    }

    public OAUTHBEARERBindRequestProperties(@NotNull OAUTHBEARERBindRequest bindRequest) {
        Validator.ensureNotNullWithMessage(bindRequest, "OAUTHBEARERBindRequestProperties.bindRequest must not be null.");
        this.accessToken = bindRequest.getAccessToken();
        this.authorizationID = bindRequest.getAuthorizationID();
        this.serverAddress = bindRequest.getServerAddress();
        this.serverPort = bindRequest.getServerPort();
        this.requestMethod = bindRequest.getRequestMethod();
        this.requestPath = bindRequest.getRequestPath();
        this.requestPostData = bindRequest.getRequestPostData();
        this.requestQueryString = bindRequest.getRequestQueryString();
    }

    @NotNull
    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(@NotNull String accessToken) {
        Validator.ensureNotNullOrEmpty(accessToken, "OAUTHBEARERBindRequestProperties.accessToken must not be null or empty.");
        this.accessToken = accessToken;
    }

    @Nullable
    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public void setAuthorizationID(@Nullable String authorizationID) {
        this.authorizationID = authorizationID;
    }

    @Nullable
    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(@Nullable String serverAddress) {
        this.serverAddress = serverAddress;
    }

    @Nullable
    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(@Nullable Integer serverPort) {
        if (serverPort != null) {
            Validator.ensureTrue(serverPort >= 1 && serverPort <= 65535, "If provided, OAUTHBEARERBindRequestProperties.serverPort must be between 1 and 65535, inclusive.");
        }
        this.serverPort = serverPort;
    }

    @Nullable
    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(@Nullable String requestMethod) {
        this.requestMethod = requestMethod;
    }

    @Nullable
    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(@Nullable String requestPath) {
        this.requestPath = requestPath;
    }

    @Nullable
    public String getRequestPostData() {
        return this.requestPostData;
    }

    public void setRequestPostData(@Nullable String requestPostData) {
        this.requestPostData = requestPostData;
    }

    @Nullable
    public String getRequestQueryString() {
        return this.requestQueryString;
    }

    public void setRequestQueryString(@Nullable String requestQueryString) {
        this.requestQueryString = requestQueryString;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("OAUTHBEARERBindRequestProperties(accessToken='{redacted}'");
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if (this.serverAddress != null) {
            buffer.append(", serverAddress='");
            buffer.append(this.serverAddress);
            buffer.append('\'');
        }
        if (this.serverPort != null) {
            buffer.append(", serverPort=");
            buffer.append(this.serverPort);
        }
        if (this.requestMethod != null) {
            buffer.append(", requestMethod='");
            buffer.append(this.requestMethod);
            buffer.append('\'');
        }
        if (this.requestPath != null) {
            buffer.append(", requestPath='");
            buffer.append(this.requestPath);
            buffer.append('\'');
        }
        if (this.requestPostData != null) {
            buffer.append(", requestPostData='{redacted}'");
        }
        if (this.requestQueryString != null) {
            buffer.append(", requestQueryString='");
            buffer.append(this.requestQueryString);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

