/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessMultipleAttributeBehavior;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessValidationLevel;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class UniquenessRequestControlProperties
implements Serializable {
    private static final long serialVersionUID = 4330352906527176309L;
    private boolean preventConflictsWithSoftDeletedEntries = false;
    @Nullable
    private Filter filter = null;
    @NotNull
    private Set<String> attributeTypes = Collections.emptySet();
    @Nullable
    private String baseDN = null;
    @NotNull
    private UniquenessMultipleAttributeBehavior multipleAttributeBehavior = UniquenessMultipleAttributeBehavior.UNIQUE_WITHIN_EACH_ATTRIBUTE;
    @NotNull
    private UniquenessValidationLevel postCommitValidationLevel = UniquenessValidationLevel.ALL_SUBTREE_VIEWS;
    @NotNull
    private UniquenessValidationLevel preCommitValidationLevel = UniquenessValidationLevel.ALL_SUBTREE_VIEWS;

    private UniquenessRequestControlProperties() {
    }

    public UniquenessRequestControlProperties(String ... attributeTypes) {
        this();
        Validator.ensureTrue(attributeTypes != null && attributeTypes.length > 0, "The set of attribute types must not be null or empty.");
        this.attributeTypes = Collections.unmodifiableSet(new LinkedHashSet<String>(StaticUtils.toList(attributeTypes)));
    }

    public UniquenessRequestControlProperties(@NotNull Collection<String> attributeTypes) {
        this();
        Validator.ensureTrue(attributeTypes != null && !attributeTypes.isEmpty(), "The set of attribute types must not be null or empty.");
        this.attributeTypes = Collections.unmodifiableSet(new LinkedHashSet<String>(attributeTypes));
    }

    public UniquenessRequestControlProperties(@NotNull Filter filter) {
        this();
        Validator.ensureNotNull(filter);
        this.filter = filter;
    }

    @NotNull
    public Set<String> getAttributeTypes() {
        return this.attributeTypes;
    }

    public void setAttributeTypes(String ... attributeTypes) {
        this.attributeTypes = attributeTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(StaticUtils.toList(attributeTypes)));
    }

    public void setAttributeTypes(@Nullable Collection<String> attributeTypes) {
        this.attributeTypes = attributeTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(new LinkedHashSet<String>(attributeTypes));
    }

    @NotNull
    public UniquenessMultipleAttributeBehavior getMultipleAttributeBehavior() {
        return this.multipleAttributeBehavior;
    }

    public void setMultipleAttributeBehavior(@NotNull UniquenessMultipleAttributeBehavior multipleAttributeBehavior) {
        Validator.ensureNotNull((Object)multipleAttributeBehavior);
        this.multipleAttributeBehavior = multipleAttributeBehavior;
    }

    @Nullable
    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(@Nullable String baseDN) {
        this.baseDN = baseDN;
    }

    @Nullable
    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(@Nullable Filter filter) {
        this.filter = filter;
    }

    public boolean preventConflictsWithSoftDeletedEntries() {
        return this.preventConflictsWithSoftDeletedEntries;
    }

    public void setPreventConflictsWithSoftDeletedEntries(boolean preventConflictsWithSoftDeletedEntries) {
        this.preventConflictsWithSoftDeletedEntries = preventConflictsWithSoftDeletedEntries;
    }

    @NotNull
    public UniquenessValidationLevel getPreCommitValidationLevel() {
        return this.preCommitValidationLevel;
    }

    public void setPreCommitValidationLevel(@NotNull UniquenessValidationLevel preCommitValidationLevel) {
        Validator.ensureNotNull((Object)preCommitValidationLevel);
        this.preCommitValidationLevel = preCommitValidationLevel;
    }

    @NotNull
    public UniquenessValidationLevel getPostCommitValidationLevel() {
        return this.postCommitValidationLevel;
    }

    public void setPostCommitValidationLevel(@NotNull UniquenessValidationLevel postCommitValidationLevel) {
        Validator.ensureNotNull((Object)postCommitValidationLevel);
        this.postCommitValidationLevel = postCommitValidationLevel;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("UniquenessRequestControlProperties(attributeTypes={");
        Iterator<String> attributeTypesIterator = this.attributeTypes.iterator();
        while (attributeTypesIterator.hasNext()) {
            buffer.append('\'');
            buffer.append(attributeTypesIterator.next());
            buffer.append('\'');
            if (!attributeTypesIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, multipleAttributeBehavior=");
        buffer.append((Object)this.multipleAttributeBehavior);
        if (this.baseDN != null) {
            buffer.append(", baseDN='");
            buffer.append(this.baseDN);
            buffer.append('\'');
        }
        if (this.filter != null) {
            buffer.append(", filter='");
            buffer.append(this.filter);
            buffer.append('\'');
        }
        buffer.append(", preventConflictsWithSoftDeletedEntries=");
        buffer.append(this.preventConflictsWithSoftDeletedEntries);
        buffer.append(", preCommitValidationLevel=");
        buffer.append((Object)this.preCommitValidationLevel);
        buffer.append(", postCommitValidationLevel=");
        buffer.append((Object)this.postCommitValidationLevel);
        buffer.append(')');
    }
}

