/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.TLSCipherSuiteComparator;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TLSCipherSuiteSelector
extends CommandLineTool {
    @NotNull
    private static final TLSCipherSuiteSelector INSTANCE = new TLSCipherSuiteSelector();
    @NotNull
    private final SortedMap<String, List<String>> nonRecommendedCipherSuites;
    @NotNull
    private final SortedSet<String> defaultCipherSuites;
    @NotNull
    private final SortedSet<String> recommendedCipherSuites;
    @NotNull
    private final SortedSet<String> supportedCipherSuites;
    @NotNull
    private final String[] recommendedCipherSuiteArray;

    public static void main(String ... args) {
        ResultCode resultCode = TLSCipherSuiteSelector.main(System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        TLSCipherSuiteSelector tool = new TLSCipherSuiteSelector(out, err);
        return tool.runTool(args);
    }

    private TLSCipherSuiteSelector() {
        this(null, null);
    }

    public TLSCipherSuiteSelector(@Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
        try {
            SSLContext sslContext = SSLContext.getDefault();
            SSLParameters supportedParameters = sslContext.getSupportedSSLParameters();
            TreeSet<String> supportedSet = new TreeSet<String>(TLSCipherSuiteComparator.getInstance());
            supportedSet.addAll(Arrays.asList(supportedParameters.getCipherSuites()));
            this.supportedCipherSuites = Collections.unmodifiableSortedSet(supportedSet);
            SSLParameters defaultParameters = sslContext.getDefaultSSLParameters();
            TreeSet<String> defaultSet = new TreeSet<String>(TLSCipherSuiteComparator.getInstance());
            defaultSet.addAll(Arrays.asList(defaultParameters.getCipherSuites()));
            this.defaultCipherSuites = Collections.unmodifiableSortedSet(supportedSet);
            ObjectPair<SortedSet<String>, SortedMap<String, List<String>>> selectedPair = TLSCipherSuiteSelector.selectCipherSuites(supportedParameters.getCipherSuites());
            this.recommendedCipherSuites = Collections.unmodifiableSortedSet(selectedPair.getFirst());
            this.nonRecommendedCipherSuites = Collections.unmodifiableSortedMap(selectedPair.getSecond());
            this.recommendedCipherSuiteArray = this.recommendedCipherSuites.toArray(StaticUtils.NO_STRINGS);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPRuntimeException(new LDAPException(ResultCode.LOCAL_ERROR, SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_INIT_ERROR.get(StaticUtils.getExceptionMessage(e)), e));
        }
        String debugProperty = StaticUtils.getSystemProperty("javax.net.debug");
        if (debugProperty != null && debugProperty.equals("all")) {
            System.err.println();
            System.err.println(this.getClass().getName() + " Results:");
            this.generateOutput(System.err);
            System.err.println();
        }
    }

    @NotNull
    public static SortedSet<String> getSupportedCipherSuites() {
        return TLSCipherSuiteSelector.INSTANCE.supportedCipherSuites;
    }

    @NotNull
    public static SortedSet<String> getDefaultCipherSuites() {
        return TLSCipherSuiteSelector.INSTANCE.defaultCipherSuites;
    }

    @NotNull
    public static SortedSet<String> getRecommendedCipherSuites() {
        return TLSCipherSuiteSelector.INSTANCE.recommendedCipherSuites;
    }

    @NotNull
    public static String[] getRecommendedCipherSuiteArray() {
        return (String[])TLSCipherSuiteSelector.INSTANCE.recommendedCipherSuiteArray.clone();
    }

    @NotNull
    public static SortedMap<String, List<String>> getNonRecommendedCipherSuites() {
        return TLSCipherSuiteSelector.INSTANCE.nonRecommendedCipherSuites;
    }

    @NotNull
    static ObjectPair<SortedSet<String>, SortedMap<String, List<String>>> selectCipherSuites(@NotNull String[] cipherSuiteArray) {
        TreeSet<String> recommendedSet = new TreeSet<String>(TLSCipherSuiteComparator.getInstance());
        TreeMap nonRecommendedMap = new TreeMap(TLSCipherSuiteComparator.getInstance());
        for (String cipherSuiteName : cipherSuiteArray) {
            String name = StaticUtils.toUpperCase(cipherSuiteName).replace('-', '_');
            if (name.endsWith("_SCSV")) {
                recommendedSet.add(cipherSuiteName);
                continue;
            }
            ArrayList<String> nonRecommendedReasons = new ArrayList<String>(5);
            if (name.startsWith("SSL_")) {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_LEGACY_SSL_PROTOCOL.get());
            } else if (name.startsWith("TLS_")) {
                if (!(name.startsWith("TLS_AES_") || name.startsWith("TLS_CHACHA20_") || name.startsWith("TLS_ECDHE_") || name.startsWith("TLS_DHE_") || name.startsWith("TLS_RSA_"))) {
                    if (name.startsWith("TLS_ECDH_")) {
                        nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_KE_ALG.get("ECDH"));
                    } else if (name.startsWith("TLS_DH_")) {
                        nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_KE_ALG.get("DH"));
                    } else if (name.startsWith("TLS_KRB5_")) {
                        nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_KE_ALG.get("KRB5"));
                    } else {
                        nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_UNKNOWN_KE_ALG.get());
                    }
                }
            } else {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_UNRECOGNIZED_PROTOCOL.get());
            }
            if (name.contains("_PSK")) {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_PSK.get());
            }
            if (name.contains("_NULL")) {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NULL_COMPONENT.get());
            }
            if (name.contains("_ANON")) {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_ANON_AUTH.get());
            }
            if (name.contains("_EXPORT")) {
                nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_EXPORT_ENCRYPTION.get());
            }
            if (!name.contains("_AES") && !name.contains("_CHACHA20")) {
                if (name.contains("_RC4")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("RC4"));
                } else if (name.contains("_3DES")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("3DES"));
                } else if (name.contains("_DES")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("DES"));
                } else if (name.contains("_IDEA")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("IDEA"));
                } else if (name.contains("_CAMELLIA")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("Camellia"));
                } else if (name.contains("_ARIA")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_BE_ALG.get("ARIA"));
                } else {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_UNKNOWN_BE_ALG.get());
                }
            }
            if (!(name.endsWith("_SHA512") || name.endsWith("_SHA384") || name.endsWith("_SHA256") || name.endsWith("_SHA"))) {
                if (name.endsWith("_MD5")) {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_KNOWN_DIGEST_ALG.get("MD5"));
                } else {
                    nonRecommendedReasons.add(SSLMessages.ERR_TLS_CIPHER_SUITE_SELECTOR_NON_RECOMMENDED_UNKNOWN_DIGEST_ALG.get());
                }
            }
            if (nonRecommendedReasons.isEmpty()) {
                recommendedSet.add(cipherSuiteName);
                continue;
            }
            nonRecommendedMap.put(cipherSuiteName, Collections.unmodifiableList(nonRecommendedReasons));
        }
        return new ObjectPair<SortedSet<String>, SortedMap<String, List<String>>>(recommendedSet, nonRecommendedMap);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "tls-cipher-suite-selector";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return SSLMessages.INFO_TLS_CIPHER_SUITE_SELECTOR_TOOL_DESC.get();
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "5.1.1";
    }

    @Override
    public void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        this.generateOutput(this.getOut());
        return ResultCode.SUCCESS;
    }

    private void generateOutput(@NotNull PrintStream s) {
        s.println("Supported TLS Cipher Suites:");
        for (String string : this.supportedCipherSuites) {
            s.println("* " + string);
        }
        s.println();
        s.println("JVM-Default TLS Cipher Suites:");
        for (String string : this.defaultCipherSuites) {
            s.println("* " + string);
        }
        s.println();
        s.println("Non-Recommended TLS Cipher Suites:");
        for (Map.Entry entry : this.nonRecommendedCipherSuites.entrySet()) {
            s.println("* " + (String)entry.getKey());
            for (String reason : (List)entry.getValue()) {
                s.println("  - " + reason);
            }
        }
        s.println();
        s.println("Recommended TLS Cipher Suites:");
        for (String string : this.recommendedCipherSuites) {
            s.println("* " + string);
        }
    }

    @NotNull
    public static Set<String> selectSupportedCipherSuites(@Nullable Collection<String> potentialSuiteNames) {
        if (potentialSuiteNames == null) {
            return Collections.emptySet();
        }
        int capacity = StaticUtils.computeMapCapacity(TLSCipherSuiteSelector.INSTANCE.supportedCipherSuites.size());
        HashMap<String, String> supportedMap = new HashMap<String, String>(capacity);
        for (String supportedSuite : TLSCipherSuiteSelector.INSTANCE.supportedCipherSuites) {
            supportedMap.put(StaticUtils.toUpperCase(supportedSuite).replace('-', '_'), supportedSuite);
        }
        LinkedHashSet<String> selectedSet = new LinkedHashSet<String>(capacity);
        for (String potentialSuite : potentialSuiteNames) {
            String supportedName = (String)supportedMap.get(StaticUtils.toUpperCase(potentialSuite).replace('-', '_'));
            if (supportedName == null) continue;
            selectedSet.add(supportedName);
        }
        return Collections.unmodifiableSet(selectedSet);
    }
}

