/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.ldap.listener.IntermediateResponseTransformer;
import com.unboundid.ldap.listener.LDAPListener;
import com.unboundid.ldap.listener.LDAPListenerConfig;
import com.unboundid.ldap.listener.LDAPListenerExceptionHandler;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.listener.ListenerMessages;
import com.unboundid.ldap.listener.SearchEntryTransformer;
import com.unboundid.ldap.listener.SearchReferenceTransformer;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.IntermediateResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.SearchResultEntryProtocolOp;
import com.unboundid.ldap.protocol.SearchResultReferenceProtocolOp;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.NoticeOfDisconnectionExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPListenerClientConnection
extends Thread
implements Closeable {
    @NotNull
    private static final Control[] EMPTY_CONTROL_ARRAY = new Control[0];
    @NotNull
    private final ASN1Buffer asn1Buffer;
    @NotNull
    private volatile ASN1StreamReader asn1Reader;
    @NotNull
    private final AtomicBoolean suppressNextResponse;
    @NotNull
    private final CopyOnWriteArrayList<IntermediateResponseTransformer> intermediateResponseTransformers;
    @NotNull
    private final CopyOnWriteArrayList<SearchEntryTransformer> searchEntryTransformers;
    @NotNull
    private final CopyOnWriteArrayList<SearchReferenceTransformer> searchReferenceTransformers;
    @Nullable
    private final LDAPListener listener;
    @Nullable
    private final LDAPListenerExceptionHandler exceptionHandler;
    @NotNull
    private final LDAPListenerRequestHandler requestHandler;
    private final long connectionID;
    @NotNull
    private volatile OutputStream outputStream;
    @NotNull
    private volatile Socket socket;

    public LDAPListenerClientConnection(@Nullable LDAPListener listener, @NotNull Socket socket, @NotNull LDAPListenerRequestHandler requestHandler, @Nullable LDAPListenerExceptionHandler exceptionHandler) throws LDAPException {
        Validator.ensureNotNull(socket, requestHandler);
        this.setName("LDAPListener client connection reader for connection from " + socket.getInetAddress().getHostAddress() + ':' + socket.getPort() + " to " + socket.getLocalAddress().getHostAddress() + ':' + socket.getLocalPort());
        this.listener = listener;
        this.socket = socket;
        this.exceptionHandler = exceptionHandler;
        this.asn1Buffer = new ASN1Buffer();
        this.suppressNextResponse = new AtomicBoolean(false);
        this.intermediateResponseTransformers = new CopyOnWriteArrayList();
        this.searchEntryTransformers = new CopyOnWriteArrayList();
        this.searchReferenceTransformers = new CopyOnWriteArrayList();
        this.connectionID = listener == null ? -1L : listener.nextConnectionID();
        try {
            LDAPListenerConfig config = listener == null ? new LDAPListenerConfig(0, requestHandler) : listener.getConfig();
            socket.setKeepAlive(config.useKeepAlive());
            socket.setReuseAddress(config.useReuseAddress());
            socket.setSoLinger(config.useLinger(), config.getLingerTimeoutSeconds());
            socket.setTcpNoDelay(config.useTCPNoDelay());
            int sendBufferSize = config.getSendBufferSize();
            if (sendBufferSize > 0) {
                socket.setSendBufferSize(sendBufferSize);
            }
            if (socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)socket;
                if (config.requestClientCertificate()) {
                    if (config.requireClientCertificate()) {
                        sslSocket.setNeedClientAuth(true);
                    } else {
                        sslSocket.setWantClientAuth(true);
                    }
                } else {
                    sslSocket.setWantClientAuth(false);
                }
            }
            this.asn1Reader = new ASN1StreamReader(socket.getInputStream());
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            try {
                socket.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            throw new LDAPException(ResultCode.CONNECT_ERROR, ListenerMessages.ERR_CONN_CREATE_IO_EXCEPTION.get(StaticUtils.getExceptionMessage(ioe)), ioe);
        }
        try {
            this.outputStream = socket.getOutputStream();
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            try {
                this.asn1Reader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                socket.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            throw new LDAPException(ResultCode.CONNECT_ERROR, ListenerMessages.ERR_CONN_CREATE_IO_EXCEPTION.get(StaticUtils.getExceptionMessage(ioe)), ioe);
        }
        try {
            this.requestHandler = requestHandler.newInstance(this);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            try {
                this.asn1Reader.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                this.outputStream.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            try {
                socket.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
            throw le;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.requestHandler.closeInstance();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            this.asn1Reader.close();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            this.outputStream.close();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        this.socket.close();
    }

    void close(@NotNull LDAPException le) {
        if (this.exceptionHandler == null) {
            Debug.debugException(le);
        } else {
            try {
                this.exceptionHandler.connectionTerminated(this, le);
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        try {
            this.sendUnsolicitedNotification(new NoticeOfDisconnectionExtendedResult(le));
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            this.close();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InternalUseOnly
    public void run() {
        while (true) {
            block48: {
                try {
                    requestMessage = LDAPMessage.readFrom(this.asn1Reader, false);
                    if (requestMessage != null) break block48;
                    try {
                        this.close();
                    }
                    catch (IOException ioe) {
                        Debug.debugException(ioe);
                    }
                    if (this.listener != null) {
                        this.listener.connectionClosed(this);
                    }
                    return;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.close(le);
                    if (this.listener != null) {
                        this.listener.connectionClosed(this);
                    }
                    return;
                    catch (Throwable var6_18) {
                        if (this.listener != null) {
                            this.listener.connectionClosed(this);
                        }
                        throw var6_18;
                    }
                }
            }
            messageID = requestMessage.getMessageID();
            controls = requestMessage.getControls();
            switch (requestMessage.getProtocolOpType()) {
                case 80: {
                    this.requestHandler.processAbandonRequest(messageID, requestMessage.getAbandonRequestProtocolOp(), controls);
                    responseMessage = null;
                    ** break;
                }
                case 104: {
                    try {
                        responseMessage = this.requestHandler.processAddRequest(messageID, requestMessage.getAddRequestProtocolOp(), controls);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        responseMessage = new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(80, null, ListenerMessages.ERR_CONN_REQUEST_HANDLER_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), null), new Control[0]);
                    }
                    ** break;
                }
                case 96: {
                    try {
                        responseMessage = this.requestHandler.processBindRequest(messageID, requestMessage.getBindRequestProtocolOp(), controls);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        responseMessage = new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(80, null, ListenerMessages.ERR_CONN_REQUEST_HANDLER_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), null, null), new Control[0]);
                    }
                    ** break;
                }
                case 110: {
                    try {
                        responseMessage = this.requestHandler.processCompareRequest(messageID, requestMessage.getCompareRequestProtocolOp(), controls);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        responseMessage = new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(80, null, ListenerMessages.ERR_CONN_REQUEST_HANDLER_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), null), new Control[0]);
                    }
                    ** break;
                }
                case 74: {
                    try {
                        responseMessage = this.requestHandler.processDeleteRequest(messageID, requestMessage.getDeleteRequestProtocolOp(), controls);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        responseMessage = new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(80, null, ListenerMessages.ERR_CONN_REQUEST_HANDLER_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), null), new Control[0]);
                    }
                    ** break;
                }
                case 119: {
                    try {
                        responseMessage = this.requestHandler.processExtendedRequest(messageID, requestMessage.getExtendedRequestProtocolOp(), controls);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        responseMessage = new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(80, null, ListenerMessages.ERR_CONN_REQUEST_HANDLER_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), null, null, null), new Control[0]);
                    }
                    ** break;
                }
                case 102: {
                    try {
                        responseMessage = this.requestHandler.processModifyRequest(messageID, requestMessage.getModifyRequestProtocolOp(), controls);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        responseMessage = new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(80, null, ListenerMessages.ERR_CONN_REQUEST_HANDLER_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), null), new Control[0]);
                    }
                    ** break;
                }
                case 108: {
                    try {
                        responseMessage = this.requestHandler.processModifyDNRequest(messageID, requestMessage.getModifyDNRequestProtocolOp(), controls);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        responseMessage = new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(80, null, ListenerMessages.ERR_CONN_REQUEST_HANDLER_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), null), new Control[0]);
                    }
                    ** break;
                }
                case 99: {
                    try {
                        responseMessage = this.requestHandler.processSearchRequest(messageID, requestMessage.getSearchRequestProtocolOp(), controls);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        responseMessage = new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(80, null, ListenerMessages.ERR_CONN_REQUEST_HANDLER_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), null), new Control[0]);
                    }
                    ** break;
                }
                case 66: {
                    this.requestHandler.processUnbindRequest(messageID, requestMessage.getUnbindRequestProtocolOp(), controls);
                    this.close();
                    if (this.listener != null) {
                        this.listener.connectionClosed(this);
                    }
                    return;
                }
                default: {
                    this.close(new LDAPException(ResultCode.PROTOCOL_ERROR, ListenerMessages.ERR_CONN_INVALID_PROTOCOL_OP_TYPE.get(new Object[]{StaticUtils.toHex(requestMessage.getProtocolOpType())})));
                    if (this.listener != null) {
                        this.listener.connectionClosed(this);
                    }
                    return;
                }
            }
            {
                catch (Throwable t) {
                    this.close(new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_CONN_EXCEPTION_IN_REQUEST_HANDLER.get(new Object[]{String.valueOf(requestMessage), StaticUtils.getExceptionMessage(t)})));
                    StaticUtils.throwErrorOrRuntimeException(t);
                    continue;
                }
            }
lbl112:
            // 18 sources

            if (responseMessage == null) continue;
            try {
                this.sendMessage(responseMessage);
                continue;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.close(le);
                if (this.listener != null) {
                    this.listener.connectionClosed(this);
                }
                return;
            }
            break;
        }
    }

    private synchronized void sendMessage(@NotNull LDAPMessage message) throws LDAPException {
        if (this.suppressNextResponse.compareAndSet(true, false)) {
            return;
        }
        this.asn1Buffer.clear();
        try {
            message.writeTo(this.asn1Buffer);
        }
        catch (LDAPRuntimeException lre) {
            Debug.debugException(lre);
            lre.throwLDAPException();
        }
        try {
            this.asn1Buffer.writeTo(this.outputStream);
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_CONN_SEND_MESSAGE_EXCEPTION.get(StaticUtils.getExceptionMessage(ioe)), ioe);
        }
        finally {
            if (this.asn1Buffer.zeroBufferOnClear()) {
                this.asn1Buffer.clear();
            }
        }
    }

    public void sendSearchResultEntry(int messageID, @NotNull SearchResultEntryProtocolOp protocolOp, Control ... controls) throws LDAPException {
        if (this.searchEntryTransformers.isEmpty()) {
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)protocolOp, controls));
        } else {
            SearchResultEntryProtocolOp op = protocolOp;
            Control[] c = controls == null ? EMPTY_CONTROL_ARRAY : controls;
            for (SearchEntryTransformer t : this.searchEntryTransformers) {
                try {
                    ObjectPair<SearchResultEntryProtocolOp, Control[]> p = t.transformEntry(messageID, op, c);
                    if (p == null) {
                        return;
                    }
                    op = p.getFirst();
                    c = p.getSecond();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)protocolOp, c));
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_CONN_SEARCH_ENTRY_TRANSFORMER_EXCEPTION.get(t.getClass().getName(), String.valueOf(op), StaticUtils.getExceptionMessage(e)), e);
                }
            }
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)op, c));
        }
    }

    public void sendSearchResultEntry(int messageID, @NotNull Entry entry, Control ... controls) throws LDAPException {
        this.sendSearchResultEntry(messageID, new SearchResultEntryProtocolOp(entry.getDN(), new ArrayList<Attribute>(entry.getAttributes())), controls);
    }

    public void sendSearchResultReference(int messageID, @NotNull SearchResultReferenceProtocolOp protocolOp, Control ... controls) throws LDAPException {
        if (this.searchReferenceTransformers.isEmpty()) {
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)protocolOp, controls));
        } else {
            SearchResultReferenceProtocolOp op = protocolOp;
            Control[] c = controls == null ? EMPTY_CONTROL_ARRAY : controls;
            for (SearchReferenceTransformer t : this.searchReferenceTransformers) {
                try {
                    ObjectPair<SearchResultReferenceProtocolOp, Control[]> p = t.transformReference(messageID, op, c);
                    if (p == null) {
                        return;
                    }
                    op = p.getFirst();
                    c = p.getSecond();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)protocolOp, c));
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_CONN_SEARCH_REFERENCE_TRANSFORMER_EXCEPTION.get(t.getClass().getName(), String.valueOf(op), StaticUtils.getExceptionMessage(e)), e);
                }
            }
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)op, c));
        }
    }

    public void sendIntermediateResponse(int messageID, @NotNull IntermediateResponseProtocolOp protocolOp, Control ... controls) throws LDAPException {
        if (this.intermediateResponseTransformers.isEmpty()) {
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)protocolOp, controls));
        } else {
            IntermediateResponseProtocolOp op = protocolOp;
            Control[] c = controls == null ? EMPTY_CONTROL_ARRAY : controls;
            for (IntermediateResponseTransformer t : this.intermediateResponseTransformers) {
                try {
                    ObjectPair<IntermediateResponseProtocolOp, Control[]> p = t.transformIntermediateResponse(messageID, op, c);
                    if (p == null) {
                        return;
                    }
                    op = p.getFirst();
                    c = p.getSecond();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)protocolOp, c));
                    throw new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_CONN_INTERMEDIATE_RESPONSE_TRANSFORMER_EXCEPTION.get(t.getClass().getName(), String.valueOf(op), StaticUtils.getExceptionMessage(e)), e);
                }
            }
            this.sendMessage(new LDAPMessage(messageID, (ProtocolOp)op, c));
        }
    }

    public void sendUnsolicitedNotification(@NotNull ExtendedResult result) throws LDAPException {
        this.sendUnsolicitedNotification(new ExtendedResponseProtocolOp(result.getResultCode().intValue(), result.getMatchedDN(), result.getDiagnosticMessage(), StaticUtils.toList(result.getReferralURLs()), result.getOID(), result.getValue()), result.getResponseControls());
    }

    public void sendUnsolicitedNotification(@NotNull ExtendedResponseProtocolOp extendedResponse, Control ... controls) throws LDAPException {
        this.sendMessage(new LDAPMessage(0, (ProtocolOp)extendedResponse, controls));
    }

    @NotNull
    public synchronized Socket getSocket() {
        return this.socket;
    }

    @NotNull
    public synchronized OutputStream convertToTLS(@NotNull SSLSocketFactory sslSocketFactory) throws LDAPException {
        return this.convertToTLS(sslSocketFactory, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public synchronized OutputStream convertToTLS(@NotNull SSLSocketFactory sslSocketFactory, boolean requestClientCertificate, boolean requireClientCertificate) throws LDAPException {
        OutputStream clearOutputStream = this.outputStream;
        Socket origSocket = this.socket;
        String hostname = LDAPConnectionOptions.DEFAULT_NAME_RESOLVER.getHostName(origSocket.getInetAddress());
        int port = origSocket.getPort();
        try {
            SSLSocketFactory sSLSocketFactory = sslSocketFactory;
            synchronized (sSLSocketFactory) {
                this.socket = sslSocketFactory.createSocket(this.socket, hostname, port, true);
            }
            SSLSocket sslSocket = (SSLSocket)this.socket;
            sslSocket.setUseClientMode(false);
            if (requestClientCertificate) {
                if (requireClientCertificate) {
                    sslSocket.setNeedClientAuth(true);
                } else {
                    sslSocket.setWantClientAuth(true);
                }
            } else {
                sslSocket.setWantClientAuth(false);
            }
            this.outputStream = this.socket.getOutputStream();
            this.asn1Reader = new ASN1StreamReader(this.socket.getInputStream());
            this.suppressNextResponse.set(true);
            return clearOutputStream;
        }
        catch (Exception e) {
            Debug.debugException(e);
            LDAPException le = new LDAPException(ResultCode.LOCAL_ERROR, ListenerMessages.ERR_CONN_CONVERT_TO_TLS_FAILURE.get(StaticUtils.getExceptionMessage(e)), e);
            this.close(le);
            throw le;
        }
    }

    public long getConnectionID() {
        return this.connectionID;
    }

    public void addSearchEntryTransformer(@NotNull SearchEntryTransformer t) {
        this.searchEntryTransformers.add(t);
    }

    public void removeSearchEntryTransformer(@NotNull SearchEntryTransformer t) {
        this.searchEntryTransformers.remove(t);
    }

    public void addSearchReferenceTransformer(@NotNull SearchReferenceTransformer t) {
        this.searchReferenceTransformers.add(t);
    }

    public void removeSearchReferenceTransformer(@NotNull SearchReferenceTransformer t) {
        this.searchReferenceTransformers.remove(t);
    }

    public void addIntermediateResponseTransformer(@NotNull IntermediateResponseTransformer t) {
        this.intermediateResponseTransformers.add(t);
    }

    public void removeIntermediateResponseTransformer(@NotNull IntermediateResponseTransformer t) {
        this.intermediateResponseTransformers.remove(t);
    }
}

