/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.LDAPListenerExceptionHandler;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.net.InetAddress;
import javax.net.ServerSocketFactory;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPListenerConfig {
    private boolean requestClientCertificate;
    private boolean requireClientCertificate;
    private boolean useKeepAlive;
    private boolean useLinger;
    private boolean useReuseAddress;
    private boolean useTCPNoDelay;
    @Nullable
    private InetAddress listenAddress;
    private int lingerTimeout;
    private int listenPort;
    private int maxConnections;
    private int receiveBufferSize;
    private int sendBufferSize;
    @Nullable
    private LDAPListenerExceptionHandler exceptionHandler;
    @NotNull
    private LDAPListenerRequestHandler requestHandler;
    @NotNull
    private ServerSocketFactory serverSocketFactory;

    public LDAPListenerConfig(int listenPort, @NotNull LDAPListenerRequestHandler requestHandler) {
        Validator.ensureTrue(listenPort >= 0 && listenPort <= 65535);
        Validator.ensureNotNull(requestHandler);
        this.listenPort = listenPort;
        this.requestHandler = requestHandler;
        this.requestClientCertificate = false;
        this.requireClientCertificate = false;
        this.useKeepAlive = true;
        this.useLinger = true;
        this.useReuseAddress = true;
        this.useTCPNoDelay = true;
        this.lingerTimeout = 5;
        this.listenAddress = null;
        this.maxConnections = 0;
        this.receiveBufferSize = 0;
        this.sendBufferSize = 0;
        this.exceptionHandler = null;
        this.serverSocketFactory = ServerSocketFactory.getDefault();
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        Validator.ensureTrue(listenPort >= 0 && listenPort <= 65535);
        this.listenPort = listenPort;
    }

    @NotNull
    public LDAPListenerRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(@NotNull LDAPListenerRequestHandler requestHandler) {
        Validator.ensureNotNull(requestHandler);
        this.requestHandler = requestHandler;
    }

    public boolean useKeepAlive() {
        return this.useKeepAlive;
    }

    public void setUseKeepAlive(boolean useKeepAlive) {
        this.useKeepAlive = useKeepAlive;
    }

    public boolean useLinger() {
        return this.useLinger;
    }

    public void setUseLinger(boolean useLinger) {
        this.useLinger = useLinger;
    }

    public boolean useReuseAddress() {
        return this.useReuseAddress;
    }

    public void setUseReuseAddress(boolean useReuseAddress) {
        this.useReuseAddress = useReuseAddress;
    }

    public boolean useTCPNoDelay() {
        return this.useTCPNoDelay;
    }

    public void setUseTCPNoDelay(boolean useTCPNoDelay) {
        this.useTCPNoDelay = useTCPNoDelay;
    }

    @Nullable
    public InetAddress getListenAddress() {
        return this.listenAddress;
    }

    public void setListenAddress(@Nullable InetAddress listenAddress) {
        this.listenAddress = listenAddress;
    }

    public int getLingerTimeoutSeconds() {
        return this.lingerTimeout;
    }

    public void setLingerTimeoutSeconds(int lingerTimeout) {
        Validator.ensureTrue(lingerTimeout >= 0 && lingerTimeout <= 65535);
        this.lingerTimeout = lingerTimeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections > 0 ? maxConnections : 0;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize > 0 ? receiveBufferSize : 0;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize > 0 ? sendBufferSize : 0;
    }

    @Nullable
    public LDAPListenerExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(@Nullable LDAPListenerExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @NotNull
    public ServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setServerSocketFactory(@Nullable ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory == null ? ServerSocketFactory.getDefault() : serverSocketFactory;
    }

    public boolean requestClientCertificate() {
        return this.requestClientCertificate;
    }

    public void setRequestClientCertificate(boolean requestClientCertificate) {
        this.requestClientCertificate = requestClientCertificate;
    }

    public boolean requireClientCertificate() {
        return this.requireClientCertificate;
    }

    public void setRequireClientCertificate(boolean requireClientCertificate) {
        this.requireClientCertificate = requireClientCertificate;
    }

    @NotNull
    public LDAPListenerConfig duplicate() {
        LDAPListenerConfig copy = new LDAPListenerConfig(this.listenPort, this.requestHandler);
        copy.requestClientCertificate = this.requestClientCertificate;
        copy.requireClientCertificate = this.requireClientCertificate;
        copy.useKeepAlive = this.useKeepAlive;
        copy.useLinger = this.useLinger;
        copy.useReuseAddress = this.useReuseAddress;
        copy.useTCPNoDelay = this.useTCPNoDelay;
        copy.listenAddress = this.listenAddress;
        copy.lingerTimeout = this.lingerTimeout;
        copy.maxConnections = this.maxConnections;
        copy.receiveBufferSize = this.receiveBufferSize;
        copy.sendBufferSize = this.sendBufferSize;
        copy.exceptionHandler = this.exceptionHandler;
        copy.serverSocketFactory = this.serverSocketFactory;
        return copy;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("LDAPListenerConfig(listenAddress=");
        if (this.listenAddress == null) {
            buffer.append("null");
        } else {
            buffer.append('\'');
            buffer.append(this.listenAddress.getHostAddress());
            buffer.append('\'');
        }
        buffer.append(", listenPort=");
        buffer.append(this.listenPort);
        buffer.append(", requestHandlerClass='");
        buffer.append(this.requestHandler.getClass().getName());
        buffer.append("', serverSocketFactoryClass='");
        buffer.append(this.serverSocketFactory.getClass().getName());
        buffer.append('\'');
        if (this.exceptionHandler != null) {
            buffer.append(", exceptionHandlerClass='");
            buffer.append(this.exceptionHandler.getClass().getName());
            buffer.append('\'');
        }
        buffer.append(", useKeepAlive=");
        buffer.append(this.useKeepAlive);
        buffer.append(", useTCPNoDelay=");
        buffer.append(this.useTCPNoDelay);
        if (this.useLinger) {
            buffer.append(", useLinger=true, lingerTimeout=");
            buffer.append(this.lingerTimeout);
        } else {
            buffer.append(", useLinger=false");
        }
        buffer.append(", maxConnections=");
        buffer.append(this.maxConnections);
        buffer.append(", useReuseAddress=");
        buffer.append(this.useReuseAddress);
        buffer.append(", receiveBufferSize=");
        buffer.append(this.receiveBufferSize);
        buffer.append(", sendBufferSize=");
        buffer.append(this.sendBufferSize);
        buffer.append(", requestClientCertificate=");
        buffer.append(this.requestClientCertificate);
        buffer.append(", requireClientCertificate=");
        buffer.append(this.requireClientCertificate);
        buffer.append(')');
    }
}

