/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityRequestControl;
import com.unboundid.ldap.sdk.examples.AuthRateThread;
import com.unboundid.ldap.sdk.experimental.DraftBeheraLDAPPasswordPolicy10RequestControl;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.RateAdjustor;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ValuePattern;
import com.unboundid.util.WakeableSleeper;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class AuthRate
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = 6918029871717330547L;
    @NotNull
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    @NotNull
    private final AtomicInteger runningThreads = new AtomicInteger(0);
    @Nullable
    private BooleanArgument authorizationIdentityRequestControl;
    @Nullable
    private BooleanArgument bindOnly;
    @Nullable
    private BooleanArgument csvFormat;
    @Nullable
    private BooleanArgument passwordPolicyRequestControl;
    @Nullable
    private BooleanArgument suppressErrorsArgument;
    @Nullable
    private ControlArgument bindControl;
    @Nullable
    private ControlArgument searchControl;
    @Nullable
    private FileArgument sampleRateFile;
    @Nullable
    private FileArgument variableRateData;
    @Nullable
    private IntegerArgument collectionInterval;
    @Nullable
    private IntegerArgument numIntervals;
    @Nullable
    private IntegerArgument numThreads;
    @Nullable
    private IntegerArgument randomSeed;
    @Nullable
    private IntegerArgument ratePerSecond;
    @Nullable
    private IntegerArgument warmUpIntervals;
    @Nullable
    private StringArgument attributes;
    @Nullable
    private StringArgument authType;
    @Nullable
    private StringArgument baseDN;
    @Nullable
    private StringArgument filter;
    @Nullable
    private ScopeArgument scopeArg;
    @Nullable
    private StringArgument timestampFormat;
    @Nullable
    private StringArgument userPassword;
    @NotNull
    private final WakeableSleeper sleeper = new WakeableSleeper();

    public static void main(@NotNull String[] args) {
        ResultCode resultCode = AuthRate.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@NotNull String[] args, @Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        AuthRate authRate = new AuthRate(outStream, errStream);
        return authRate.runTool(args);
    }

    public AuthRate(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "authrate";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return "Perform repeated authentications against an LDAP directory server, where each authentication consists of a search to find a user followed by a bind to verify the credentials for that user.";
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "5.1.2";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        String description = "The base DN to use for the searches.  It may be a simple DN or a value pattern to specify a range of DNs (e.g., \"uid=user.[1-1000],ou=People,dc=example,dc=com\").  See https://docs.ldap.com/ldap-sdk/docs/javadoc/index.html?com/unboundid/util/ValuePattern.html for complete details about the value pattern syntax.  This must be provided.";
        this.baseDN = new StringArgument(Character.valueOf('b'), "baseDN", true, 1, "{dn}", description);
        this.baseDN.setArgumentGroupName("Search and Authentication Arguments");
        this.baseDN.addLongIdentifier("base-dn", true);
        parser.addArgument(this.baseDN);
        description = "The scope to use for the searches.  It should be 'base', 'one', 'sub', or 'subord'.  If this is not provided, a default scope of 'sub' will be used.";
        this.scopeArg = new ScopeArgument(Character.valueOf('s'), "scope", false, "{scope}", description, SearchScope.SUB);
        this.scopeArg.setArgumentGroupName("Search and Authentication Arguments");
        parser.addArgument(this.scopeArg);
        description = "The filter to use for the searches.  It may be a simple filter or a value pattern to specify a range of filters (e.g., \"(uid=user.[1-1000])\").  See https://docs.ldap.com/ldap-sdk/docs/javadoc/index.html?com/unboundid/util/ValuePattern.html for complete details about the value pattern syntax.  This must be provided.";
        this.filter = new StringArgument(Character.valueOf('f'), "filter", false, 1, "{filter}", description);
        this.filter.setArgumentGroupName("Search and Authentication Arguments");
        parser.addArgument(this.filter);
        description = "The name of an attribute to include in entries returned from the searches.  Multiple attributes may be requested by providing this argument multiple times.  If no return attributes are specified, then entries will be returned with all user attributes.";
        this.attributes = new StringArgument(Character.valueOf('A'), "attribute", false, 0, "{name}", description);
        this.attributes.setArgumentGroupName("Search and Authentication Arguments");
        parser.addArgument(this.attributes);
        description = "The password to use when binding as the users returned from the searches.  This must be provided.";
        this.userPassword = new StringArgument(Character.valueOf('C'), "credentials", true, 1, "{password}", description);
        this.userPassword.setSensitive(true);
        this.userPassword.setArgumentGroupName("Search and Authentication Arguments");
        parser.addArgument(this.userPassword);
        description = "Indicates that the tool should only perform bind operations without the initial search.  If this argument is provided, then the base DN pattern will be used to obtain the bind DNs.";
        this.bindOnly = new BooleanArgument(Character.valueOf('B'), "bindOnly", 1, description);
        this.bindOnly.setArgumentGroupName("Search and Authentication Arguments");
        this.bindOnly.addLongIdentifier("bind-only", true);
        parser.addArgument(this.bindOnly);
        parser.addRequiredArgumentSet(this.filter, this.bindOnly, new Argument[0]);
        description = "The type of authentication to perform.  Allowed values are:  SIMPLE, CRAM-MD5, DIGEST-MD5, and PLAIN.  If no value is provided, then SIMPLE authentication will be performed.";
        Set<String> allowedAuthTypes = StaticUtils.setOf("simple", "cram-md5", "digest-md5", "plain");
        this.authType = new StringArgument(Character.valueOf('a'), "authType", true, 1, "{authType}", description, allowedAuthTypes, "simple");
        this.authType.setArgumentGroupName("Search and Authentication Arguments");
        this.authType.addLongIdentifier("auth-type", true);
        parser.addArgument(this.authType);
        description = "Indicates that bind requests should include the authorization identity request control as described in RFC 3829.";
        this.authorizationIdentityRequestControl = new BooleanArgument(null, "authorizationIdentityRequestControl", 1, description);
        this.authorizationIdentityRequestControl.setArgumentGroupName("Request Control Arguments");
        this.authorizationIdentityRequestControl.addLongIdentifier("authorization-identity-request-control", true);
        parser.addArgument(this.authorizationIdentityRequestControl);
        description = "Indicates that bind requests should include the password policy request control as described in draft-behera-ldap-password-policy-10.";
        this.passwordPolicyRequestControl = new BooleanArgument(null, "passwordPolicyRequestControl", 1, description);
        this.passwordPolicyRequestControl.setArgumentGroupName("Request Control Arguments");
        this.passwordPolicyRequestControl.addLongIdentifier("password-policy-request-control", true);
        parser.addArgument(this.passwordPolicyRequestControl);
        description = "Indicates that search requests should include the specified request control.  This may be provided multiple times to include multiple search request controls.";
        this.searchControl = new ControlArgument(null, "searchControl", false, 0, null, description);
        this.searchControl.setArgumentGroupName("Request Control Arguments");
        this.searchControl.addLongIdentifier("search-control", true);
        parser.addArgument(this.searchControl);
        description = "Indicates that bind requests should include the specified request control.  This may be provided multiple times to include multiple modify request controls.";
        this.bindControl = new ControlArgument(null, "bindControl", false, 0, null, description);
        this.bindControl.setArgumentGroupName("Request Control Arguments");
        this.bindControl.addLongIdentifier("bind-control", true);
        parser.addArgument(this.bindControl);
        description = "The number of threads to use to perform the authentication processing.  If this is not provided, then a default of one thread will be used.";
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 1);
        this.numThreads.setArgumentGroupName("Rate Management Arguments");
        this.numThreads.addLongIdentifier("num-threads", true);
        parser.addArgument(this.numThreads);
        description = "The length of time in seconds between output lines.  If this is not provided, then a default interval of five seconds will be used.";
        this.collectionInterval = new IntegerArgument(Character.valueOf('i'), "intervalDuration", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 5);
        this.collectionInterval.setArgumentGroupName("Rate Management Arguments");
        this.collectionInterval.addLongIdentifier("interval-duration", true);
        parser.addArgument(this.collectionInterval);
        description = "The maximum number of intervals for which to run.  If this is not provided, then the tool will run until it is interrupted.";
        this.numIntervals = new IntegerArgument(Character.valueOf('I'), "numIntervals", true, 1, "{num}", description, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.numIntervals.setArgumentGroupName("Rate Management Arguments");
        this.numIntervals.addLongIdentifier("num-intervals", true);
        parser.addArgument(this.numIntervals);
        description = "The target number of authorizations to perform per second.  It is still necessary to specify a sufficient number of threads for achieving this rate.  If neither this option nor --variableRateData is provided, then the tool will run at the maximum rate for the specified number of threads.";
        this.ratePerSecond = new IntegerArgument(Character.valueOf('r'), "ratePerSecond", false, 1, "{auths-per-second}", description, 1, Integer.MAX_VALUE);
        this.ratePerSecond.setArgumentGroupName("Rate Management Arguments");
        this.ratePerSecond.addLongIdentifier("rate-per-second", true);
        parser.addArgument(this.ratePerSecond);
        String variableRateDataArgName = "variableRateData";
        String generateSampleRateFileArgName = "generateSampleRateFile";
        description = RateAdjustor.getVariableRateDataArgumentDescription("generateSampleRateFile");
        this.variableRateData = new FileArgument(null, "variableRateData", false, 1, "{path}", description, true, true, true, false);
        this.variableRateData.setArgumentGroupName("Rate Management Arguments");
        this.variableRateData.addLongIdentifier("variable-rate-data", true);
        parser.addArgument(this.variableRateData);
        description = RateAdjustor.getGenerateSampleVariableRateFileDescription("variableRateData");
        this.sampleRateFile = new FileArgument(null, "generateSampleRateFile", false, 1, "{path}", description, false, true, true, false);
        this.sampleRateFile.setArgumentGroupName("Rate Management Arguments");
        this.sampleRateFile.addLongIdentifier("generate-sample-rate-file", true);
        this.sampleRateFile.setUsageArgument(true);
        parser.addArgument(this.sampleRateFile);
        parser.addExclusiveArgumentSet(this.variableRateData, this.sampleRateFile, new Argument[0]);
        description = "The number of intervals to complete before beginning overall statistics collection.  Specifying a nonzero number of warm-up intervals gives the client and server a chance to warm up without skewing performance results.";
        this.warmUpIntervals = new IntegerArgument(null, "warmUpIntervals", true, 1, "{num}", description, 0, Integer.MAX_VALUE, 0);
        this.warmUpIntervals.setArgumentGroupName("Rate Management Arguments");
        this.warmUpIntervals.addLongIdentifier("warm-up-intervals", true);
        parser.addArgument(this.warmUpIntervals);
        description = "Indicates the format to use for timestamps included in the output.  A value of 'none' indicates that no timestamps should be included.  A value of 'with-date' indicates that both the date and the time should be included.  A value of 'without-date' indicates that only the time should be included.";
        Set<String> allowedFormats = StaticUtils.setOf("none", "with-date", "without-date");
        this.timestampFormat = new StringArgument(null, "timestampFormat", true, 1, "{format}", description, allowedFormats, "none");
        this.timestampFormat.addLongIdentifier("timestamp-format", true);
        parser.addArgument(this.timestampFormat);
        description = "Indicates that information about the result codes for failed operations should not be displayed.";
        this.suppressErrorsArgument = new BooleanArgument(null, "suppressErrorResultCodes", 1, description);
        this.suppressErrorsArgument.addLongIdentifier("suppress-error-result-codes", true);
        parser.addArgument(this.suppressErrorsArgument);
        description = "Generate output in CSV format rather than a display-friendly format";
        this.csvFormat = new BooleanArgument(Character.valueOf('c'), "csv", 1, description);
        parser.addArgument(this.csvFormat);
        description = "Specifies the seed to use for the random number generator.";
        this.randomSeed = new IntegerArgument(Character.valueOf('R'), "randomSeed", false, 1, "{value}", description);
        this.randomSeed.addLongIdentifier("random-seed", true);
        parser.addArgument(this.randomSeed);
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    @Override
    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        return options;
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        long totalIntervals;
        boolean warmUp;
        String timeFormat;
        boolean includeTimestamp;
        String[] attrs;
        ValuePattern filterPattern;
        ValuePattern dnPattern;
        if (this.sampleRateFile.isPresent()) {
            try {
                RateAdjustor.writeSampleVariableRateFile(this.sampleRateFile.getValue());
                return ResultCode.SUCCESS;
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.err("An error occurred while trying to write sample variable data rate file '", this.sampleRateFile.getValue().getAbsolutePath(), "':  ", StaticUtils.getExceptionMessage(e));
                return ResultCode.LOCAL_ERROR;
            }
        }
        Long seed = this.randomSeed.isPresent() ? Long.valueOf(this.randomSeed.getValue().intValue()) : null;
        try {
            dnPattern = new ValuePattern(this.baseDN.getValue(), seed);
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            this.err("Unable to parse the base DN value pattern:  ", pe.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        if (this.filter.isPresent()) {
            try {
                filterPattern = new ValuePattern(this.filter.getValue(), seed);
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                this.err("Unable to parse the filter pattern:  ", pe.getMessage());
                return ResultCode.PARAM_ERROR;
            }
        } else {
            filterPattern = null;
        }
        if (this.attributes.isPresent()) {
            List<String> attrList = this.attributes.getValues();
            attrs = new String[attrList.size()];
            attrList.toArray(attrs);
        } else {
            attrs = StaticUtils.NO_STRINGS;
        }
        FixedRateBarrier fixedRateBarrier = null;
        if (this.ratePerSecond.isPresent() || this.variableRateData.isPresent()) {
            int intervalSeconds = this.collectionInterval.getValue();
            int ratePerInterval = this.ratePerSecond.getValue() == null ? Integer.MAX_VALUE : this.ratePerSecond.getValue() * intervalSeconds;
            fixedRateBarrier = new FixedRateBarrier(1000L * (long)intervalSeconds, ratePerInterval);
        }
        RateAdjustor rateAdjustor = null;
        if (this.variableRateData.isPresent()) {
            try {
                rateAdjustor = RateAdjustor.newInstance(fixedRateBarrier, this.ratePerSecond.getValue(), this.variableRateData.getValue());
            }
            catch (IOException | IllegalArgumentException e) {
                Debug.debugException(e);
                this.err("Initializing the variable rates failed: " + e.getMessage());
                return ResultCode.PARAM_ERROR;
            }
        }
        if (this.timestampFormat.getValue().equalsIgnoreCase("with-date")) {
            includeTimestamp = true;
            timeFormat = "dd/MM/yyyy HH:mm:ss";
        } else if (this.timestampFormat.getValue().equalsIgnoreCase("without-date")) {
            includeTimestamp = true;
            timeFormat = "HH:mm:ss";
        } else {
            includeTimestamp = false;
            timeFormat = null;
        }
        ArrayList<Control> bindControls = new ArrayList<Control>(5);
        if (this.authorizationIdentityRequestControl.isPresent()) {
            bindControls.add(new AuthorizationIdentityRequestControl());
        }
        if (this.passwordPolicyRequestControl.isPresent()) {
            bindControls.add(new DraftBeheraLDAPPasswordPolicy10RequestControl());
        }
        bindControls.addAll(this.bindControl.getValues());
        int remainingWarmUpIntervals = this.warmUpIntervals.getValue();
        if (remainingWarmUpIntervals > 0) {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue() + (long)remainingWarmUpIntervals;
        } else {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue();
        }
        OutputFormat outputFormat = this.csvFormat.isPresent() ? OutputFormat.CSV : OutputFormat.COLUMNS;
        ColumnFormatter formatter = new ColumnFormatter(includeTimestamp, timeFormat, outputFormat, " ", new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Auths/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Avg Dur ms"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Errors/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Overall", "Auths/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Overall", "Avg Dur ms"));
        AtomicLong authCounter = new AtomicLong(0L);
        AtomicLong errorCounter = new AtomicLong(0L);
        AtomicLong authDurations = new AtomicLong(0L);
        ResultCodeCounter rcCounter = new ResultCodeCounter();
        long intervalMillis = 1000L * (long)this.collectionInterval.getValue().intValue();
        CyclicBarrier barrier = new CyclicBarrier(this.numThreads.getValue() + 1);
        AuthRateThread[] threads = new AuthRateThread[this.numThreads.getValue().intValue()];
        for (int i = 0; i < threads.length; ++i) {
            LDAPConnection bindConnection;
            LDAPConnection searchConnection;
            try {
                searchConnection = this.getConnection();
                bindConnection = this.getConnection();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err("Unable to connect to the directory server:  ", StaticUtils.getExceptionMessage(le));
                return le.getResultCode();
            }
            threads[i] = new AuthRateThread(this, i, searchConnection, bindConnection, dnPattern, this.scopeArg.getValue(), filterPattern, attrs, this.userPassword.getValue(), this.bindOnly.isPresent(), this.authType.getValue(), this.searchControl.getValues(), bindControls, this.runningThreads, barrier, authCounter, authDurations, errorCounter, rcCounter, fixedRateBarrier);
            threads[i].start();
        }
        for (String headerLine : formatter.getHeaderLines(true)) {
            this.out(headerLine);
        }
        if (rateAdjustor != null && remainingWarmUpIntervals <= 0) {
            rateAdjustor.start();
        }
        try {
            barrier.await();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        long overallStartTime = System.nanoTime();
        long nextIntervalStartTime = System.currentTimeMillis() + intervalMillis;
        boolean setOverallStartTime = false;
        long lastDuration = 0L;
        long lastNumErrors = 0L;
        long lastNumAuths = 0L;
        long lastEndTime = System.nanoTime();
        for (long i = 0L; i < totalIntervals; ++i) {
            long totalDuration;
            long numErrors;
            long numAuths;
            if (rateAdjustor != null && !rateAdjustor.isAlive()) {
                this.out("All of the rates in " + this.variableRateData.getValue().getName() + " have been completed.");
                break;
            }
            long startTimeMillis = System.currentTimeMillis();
            long sleepTimeMillis = nextIntervalStartTime - startTimeMillis;
            nextIntervalStartTime += intervalMillis;
            if (sleepTimeMillis > 0L) {
                this.sleeper.sleep(sleepTimeMillis);
            }
            if (this.stopRequested.get()) break;
            long endTime = System.nanoTime();
            long intervalDuration = endTime - lastEndTime;
            if (warmUp && remainingWarmUpIntervals > 0) {
                numAuths = authCounter.getAndSet(0L);
                numErrors = errorCounter.getAndSet(0L);
                totalDuration = authDurations.getAndSet(0L);
            } else {
                numAuths = authCounter.get();
                numErrors = errorCounter.get();
                totalDuration = authDurations.get();
            }
            long recentNumAuths = numAuths - lastNumAuths;
            long recentNumErrors = numErrors - lastNumErrors;
            long recentDuration = totalDuration - lastDuration;
            double numSeconds = (double)intervalDuration / 1.0E9;
            double recentAuthRate = (double)recentNumAuths / numSeconds;
            double recentErrorRate = (double)recentNumErrors / numSeconds;
            double recentAvgDuration = recentNumAuths > 0L ? 1.0 * (double)recentDuration / (double)recentNumAuths / 1000000.0 : 0.0;
            if (warmUp && remainingWarmUpIntervals > 0) {
                this.out(formatter.formatRow(recentAuthRate, recentAvgDuration, recentErrorRate, "warming up", "warming up"));
                if (--remainingWarmUpIntervals == 0) {
                    this.out("Warm-up completed.  Beginning overall statistics collection.");
                    setOverallStartTime = true;
                    if (rateAdjustor != null) {
                        rateAdjustor.start();
                    }
                }
            } else {
                if (setOverallStartTime) {
                    overallStartTime = lastEndTime;
                    setOverallStartTime = false;
                }
                double numOverallSeconds = (double)(endTime - overallStartTime) / 1.0E9;
                double overallAuthRate = (double)numAuths / numOverallSeconds;
                double overallAvgDuration = numAuths > 0L ? 1.0 * (double)totalDuration / (double)numAuths / 1000000.0 : 0.0;
                this.out(formatter.formatRow(recentAuthRate, recentAvgDuration, recentErrorRate, overallAuthRate, overallAvgDuration));
                lastNumAuths = numAuths;
                lastNumErrors = numErrors;
                lastDuration = totalDuration;
            }
            List<ObjectPair<ResultCode, Long>> rcCounts = rcCounter.getCounts(true);
            if (!this.suppressErrorsArgument.isPresent() && !rcCounts.isEmpty()) {
                this.err("\tError Results:");
                for (ObjectPair<ResultCode, Long> p : rcCounts) {
                    this.err("\t", p.getFirst().getName(), ":  ", p.getSecond());
                }
            }
            lastEndTime = endTime;
        }
        if (rateAdjustor != null) {
            rateAdjustor.shutDown();
        }
        ResultCode resultCode = ResultCode.SUCCESS;
        for (AuthRateThread t : threads) {
            ResultCode r = t.stopRunning();
            if (resultCode != ResultCode.SUCCESS) continue;
            resultCode = r;
        }
        return resultCode;
    }

    public void stopRunning() {
        int stillRunning;
        this.stopRequested.set(true);
        this.sleeper.wakeup();
        while ((stillRunning = this.runningThreads.get()) > 0) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "dc=example,dc=com", "--scope", "sub", "--filter", "(uid=user.[1-1000000])", "--credentials", "password", "--numThreads", "10"};
        String description = "Test authentication performance by searching randomly across a set of one million users located below 'dc=example,dc=com' with ten concurrent threads and performing simple binds with a password of 'password'.  The searches will be performed anonymously.";
        examples.put(args, description);
        args = new String[]{"--generateSampleRateFile", "variable-rate-data.txt"};
        description = "Generate a sample variable rate definition file that may be used in conjunction with the --variableRateData argument.  The sample file will include comments that describe the format for data to be included in this file.";
        examples.put(args, description);
        return examples;
    }
}

