/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.extensions;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPExtendedOperationException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.SSLUtil;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class StartTLSExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String STARTTLS_REQUEST_OID = "1.3.6.1.4.1.1466.20037";
    private static final long serialVersionUID = -3234194603452821233L;
    @Nullable
    private final SSLSocketFactory sslSocketFactory;

    public StartTLSExtendedRequest() throws LDAPException {
        this((SSLSocketFactory)null, null);
    }

    public StartTLSExtendedRequest(@Nullable Control[] controls) throws LDAPException {
        this((SSLSocketFactory)null, controls);
    }

    public StartTLSExtendedRequest(@Nullable SSLContext sslContext) throws LDAPException {
        this(sslContext, null);
    }

    public StartTLSExtendedRequest(@Nullable SSLSocketFactory sslSocketFactory) throws LDAPException {
        this(sslSocketFactory, null);
    }

    public StartTLSExtendedRequest(@Nullable SSLContext sslContext, @Nullable Control[] controls) throws LDAPException {
        super(STARTTLS_REQUEST_OID, controls);
        if (sslContext == null) {
            try {
                SSLContext ctx = SSLContext.getInstance(SSLUtil.getDefaultSSLProtocol());
                ctx.init(null, null, null);
                this.sslSocketFactory = ctx.getSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ExtOpMessages.ERR_STARTTLS_REQUEST_CANNOT_CREATE_DEFAULT_CONTEXT.get(e), e);
            }
        } else {
            this.sslSocketFactory = sslContext.getSocketFactory();
        }
    }

    public StartTLSExtendedRequest(@Nullable SSLSocketFactory sslSocketFactory, @Nullable Control[] controls) throws LDAPException {
        super(STARTTLS_REQUEST_OID, controls);
        if (sslSocketFactory == null) {
            try {
                SSLContext ctx = SSLContext.getInstance(SSLUtil.getDefaultSSLProtocol());
                ctx.init(null, null, null);
                this.sslSocketFactory = ctx.getSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, ExtOpMessages.ERR_STARTTLS_REQUEST_CANNOT_CREATE_DEFAULT_CONTEXT.get(e), e);
            }
        } else {
            this.sslSocketFactory = sslSocketFactory;
        }
    }

    public StartTLSExtendedRequest(@NotNull ExtendedRequest extendedRequest) throws LDAPException {
        this(extendedRequest.getControls());
        if (extendedRequest.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_STARTTLS_REQUEST_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public ExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        InternalSDKHelper.setSoTimeout(connection, 50);
        ExtendedResult result = super.process(connection, depth);
        if (result.getResultCode() != ResultCode.SUCCESS) {
            throw new LDAPExtendedOperationException(result);
        }
        InternalSDKHelper.convertToTLS(connection, this.sslSocketFactory);
        return result;
    }

    @Override
    @NotNull
    public StartTLSExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    @NotNull
    public StartTLSExtendedRequest duplicate(@Nullable Control[] controls) {
        try {
            StartTLSExtendedRequest r = new StartTLSExtendedRequest(this.sslSocketFactory, controls);
            r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
            return r;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_START_TLS.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("StartTLSExtendedRequest(");
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

