/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.DeliverOneTimePasswordExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.DeliverOneTimePasswordExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.PasswordReader;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class DeliverOneTimePassword
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = -7414730592661321416L;
    @Nullable
    private BooleanArgument promptForBindPassword = null;
    @Nullable
    private DNArgument bindDN = null;
    @Nullable
    private FileArgument bindPasswordFile = null;
    @Nullable
    private StringArgument compactTextAfterOTP = null;
    @Nullable
    private StringArgument compactTextBeforeOTP = null;
    @Nullable
    private StringArgument deliveryMechanism = null;
    @Nullable
    private StringArgument fullTextAfterOTP = null;
    @Nullable
    private StringArgument fullTextBeforeOTP = null;
    @Nullable
    private StringArgument messageSubject = null;
    @Nullable
    private StringArgument userName = null;
    @Nullable
    private StringArgument bindPassword = null;

    public static void main(String ... args) {
        ResultCode resultCode = DeliverOneTimePassword.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@NotNull String[] args, @Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        DeliverOneTimePassword tool = new DeliverOneTimePassword(outStream, errStream);
        return tool.runTool(args);
    }

    public DeliverOneTimePassword(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "deliver-one-time-password";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return UnboundIDDSMessages.INFO_DELIVER_OTP_TOOL_DESCRIPTION.get();
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "5.1.3";
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.bindDN = new DNArgument(Character.valueOf('D'), "bindDN", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_DN.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_BIND_DN.get());
        this.bindDN.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_ID_AND_AUTH.get());
        this.bindDN.addLongIdentifier("bind-dn", true);
        parser.addArgument(this.bindDN);
        this.userName = new StringArgument(Character.valueOf('n'), "userName", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_USERNAME.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_USERNAME.get());
        this.userName.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_ID_AND_AUTH.get());
        this.userName.addLongIdentifier("user-name", true);
        parser.addArgument(this.userName);
        this.bindPassword = new StringArgument(Character.valueOf('w'), "bindPassword", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_PASSWORD.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_BIND_PW.get());
        this.bindPassword.setSensitive(true);
        this.bindPassword.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_ID_AND_AUTH.get());
        this.bindPassword.addLongIdentifier("bind-password", true);
        parser.addArgument(this.bindPassword);
        this.bindPasswordFile = new FileArgument(Character.valueOf('j'), "bindPasswordFile", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_PATH.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_BIND_PW_FILE.get(), true, true, true, false);
        this.bindPasswordFile.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_ID_AND_AUTH.get());
        this.bindPasswordFile.addLongIdentifier("bind-password-file", true);
        parser.addArgument(this.bindPasswordFile);
        this.promptForBindPassword = new BooleanArgument(null, "promptForBindPassword", 1, UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_BIND_PW_PROMPT.get());
        this.promptForBindPassword.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_ID_AND_AUTH.get());
        this.promptForBindPassword.addLongIdentifier("prompt-for-bind-password", true);
        parser.addArgument(this.promptForBindPassword);
        this.deliveryMechanism = new StringArgument(Character.valueOf('m'), "deliveryMechanism", false, 0, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_NAME.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_MECH.get());
        this.deliveryMechanism.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_DELIVERY_MECH.get());
        this.deliveryMechanism.addLongIdentifier("delivery-mechanism", true);
        parser.addArgument(this.deliveryMechanism);
        this.messageSubject = new StringArgument(Character.valueOf('s'), "messageSubject", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_SUBJECT.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_SUBJECT.get());
        this.messageSubject.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_DELIVERY_MECH.get());
        this.messageSubject.addLongIdentifier("message-subject", true);
        parser.addArgument(this.messageSubject);
        this.fullTextBeforeOTP = new StringArgument(Character.valueOf('f'), "fullTextBeforeOTP", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_FULL_BEFORE.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_FULL_BEFORE.get());
        this.fullTextBeforeOTP.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_DELIVERY_MECH.get());
        this.fullTextBeforeOTP.addLongIdentifier("full-text-before-otp", true);
        parser.addArgument(this.fullTextBeforeOTP);
        this.fullTextAfterOTP = new StringArgument(Character.valueOf('F'), "fullTextAfterOTP", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_FULL_AFTER.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_FULL_AFTER.get());
        this.fullTextAfterOTP.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_DELIVERY_MECH.get());
        this.fullTextAfterOTP.addLongIdentifier("full-text-after-otp", true);
        parser.addArgument(this.fullTextAfterOTP);
        this.compactTextBeforeOTP = new StringArgument(Character.valueOf('c'), "compactTextBeforeOTP", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_COMPACT_BEFORE.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_COMPACT_BEFORE.get());
        this.compactTextBeforeOTP.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_DELIVERY_MECH.get());
        this.compactTextBeforeOTP.addLongIdentifier("compact-text-before-otp", true);
        parser.addArgument(this.compactTextBeforeOTP);
        this.compactTextAfterOTP = new StringArgument(Character.valueOf('C'), "compactTextAfterOTP", false, 1, UnboundIDDSMessages.INFO_DELIVER_OTP_PLACEHOLDER_COMPACT_AFTER.get(), UnboundIDDSMessages.INFO_DELIVER_OTP_DESCRIPTION_COMPACT_AFTER.get());
        this.compactTextAfterOTP.setArgumentGroupName(UnboundIDDSMessages.INFO_DELIVER_OTP_GROUP_DELIVERY_MECH.get());
        this.compactTextAfterOTP.addLongIdentifier("compact-text-after-otp", true);
        parser.addArgument(this.compactTextAfterOTP);
        parser.addRequiredArgumentSet(this.bindDN, this.userName, new Argument[0]);
        parser.addExclusiveArgumentSet(this.bindDN, this.userName, new Argument[0]);
        parser.addExclusiveArgumentSet(this.bindPassword, this.bindPasswordFile, this.promptForBindPassword);
    }

    @Override
    protected boolean supportsAuthentication() {
        return false;
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        LDAPConnection conn;
        ArrayList<ObjectPair<String, String>> preferredDeliveryMechanisms;
        String pw;
        String authID = this.bindDN.isPresent() ? "dn:" + this.bindDN.getValue() : "u:" + this.userName.getValue();
        if (this.bindPassword.isPresent()) {
            pw = this.bindPassword.getValue();
        } else {
            if (this.bindPasswordFile.isPresent()) {
                try {
                    pw = new String(this.getPasswordFileReader().readPassword(this.bindPasswordFile.getValue()));
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_CANNOT_READ_BIND_PW.get(StaticUtils.getExceptionMessage(e)));
                    return ResultCode.LOCAL_ERROR;
                }
            }
            try {
                this.getOut().print(UnboundIDDSMessages.INFO_DELIVER_OTP_ENTER_PW.get());
                pw = StaticUtils.toUTF8String(PasswordReader.readPassword());
                this.getOut().println();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_CANNOT_READ_BIND_PW.get(StaticUtils.getExceptionMessage(e)));
                return ResultCode.LOCAL_ERROR;
            }
        }
        if (this.deliveryMechanism.isPresent()) {
            List<String> dmList = this.deliveryMechanism.getValues();
            preferredDeliveryMechanisms = new ArrayList<ObjectPair<String, String>>(dmList.size());
            for (String s : dmList) {
                preferredDeliveryMechanisms.add(new ObjectPair<String, Object>(s, null));
            }
        } else {
            preferredDeliveryMechanisms = null;
        }
        try {
            conn = this.getConnection();
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_CANNOT_GET_CONNECTION.get(StaticUtils.getExceptionMessage(le)));
            return le.getResultCode();
        }
        try {
            DeliverOneTimePasswordExtendedResult result;
            DeliverOneTimePasswordExtendedRequest request = new DeliverOneTimePasswordExtendedRequest(authID, pw, this.messageSubject.getValue(), this.fullTextBeforeOTP.getValue(), this.fullTextAfterOTP.getValue(), this.compactTextBeforeOTP.getValue(), this.compactTextAfterOTP.getValue(), preferredDeliveryMechanisms, new Control[0]);
            try {
                result = (DeliverOneTimePasswordExtendedResult)conn.processExtendedOperation(request);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_ERROR_PROCESSING_EXTOP.get(StaticUtils.getExceptionMessage(le)));
                ResultCode resultCode = le.getResultCode();
                conn.close();
                return resultCode;
            }
            if (result.getResultCode() == ResultCode.SUCCESS) {
                String mechanism = result.getDeliveryMechanism();
                String id = result.getRecipientID();
                if (id == null) {
                    this.out(UnboundIDDSMessages.INFO_DELIVER_OTP_SUCCESS_RESULT_WITHOUT_ID.get(mechanism));
                } else {
                    this.out(UnboundIDDSMessages.INFO_DELIVER_OTP_SUCCESS_RESULT_WITH_ID.get(mechanism, id));
                }
                String message = result.getDeliveryMessage();
                if (message != null) {
                    this.out(UnboundIDDSMessages.INFO_DELIVER_OTP_SUCCESS_MESSAGE.get(message));
                }
            } else if (result.getDiagnosticMessage() == null) {
                this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_ERROR_RESULT_NO_MESSAGE.get(String.valueOf(result.getResultCode())));
            } else {
                this.err(UnboundIDDSMessages.ERR_DELIVER_OTP_ERROR_RESULT.get(String.valueOf(result.getResultCode()), result.getDiagnosticMessage()));
            }
            ResultCode resultCode = result.getResultCode();
            return resultCode;
        }
        finally {
            conn.close();
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=test.user,ou=People,dc=example,dc=com", "--bindPassword", "password", "--messageSubject", "Your one-time password", "--fullTextBeforeOTP", "Your one-time password is '", "--fullTextAfterOTP", "'.", "--compactTextBeforeOTP", "Your OTP is '", "--compactTextAfterOTP", "'."};
        exampleMap.put(args, UnboundIDDSMessages.INFO_DELIVER_OTP_EXAMPLE_1.get());
        args = new String[]{"--hostname", "server.example.com", "--port", "389", "--userName", "test.user", "--bindPassword", "password", "--deliveryMechanism", "SMS", "--deliveryMechanism", "E-Mail", "--messageSubject", "Your one-time password", "--fullTextBeforeOTP", "Your one-time password is '", "--fullTextAfterOTP", "'.", "--compactTextBeforeOTP", "Your OTP is '", "--compactTextAfterOTP", "'."};
        exampleMap.put(args, UnboundIDDSMessages.INFO_DELIVER_OTP_EXAMPLE_2.get());
        return exampleMap;
    }
}

