/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldif.LDIFException;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.X509TrustManager;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class TopologyRegistryTrustManager
implements X509TrustManager,
Serializable {
    @NotNull
    private static final String INTER_SERVER_CERT_OC = "ds-cfg-server-instance";
    @NotNull
    private static final String INTER_SERVER_CERT_AT = "ds-cfg-inter-server-certificate";
    @NotNull
    private static final String LISTENER_CERT_OC = "ds-cfg-server-instance-listener";
    @NotNull
    private static final String LISTENER_CERT_AT = "ds-cfg-listener-certificate";
    @NotNull
    static final X509Certificate[] NO_CERTIFICATES = new X509Certificate[0];
    private static final long serialVersionUID = -1535917071172094611L;
    @NotNull
    private final AtomicLong cacheExpirationTime;
    @NotNull
    private final AtomicReference<Set<X509Certificate>> cachedCertificates;
    @NotNull
    private final File configurationFile;
    private final long cacheDurationMillis;

    public TopologyRegistryTrustManager(@NotNull File configurationFile, long cacheDurationMillis) {
        this.configurationFile = configurationFile;
        this.cacheDurationMillis = cacheDurationMillis;
        this.cacheExpirationTime = new AtomicLong(0L);
        this.cachedCertificates = new AtomicReference(Collections.emptySet());
    }

    @Override
    public void checkClientTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        this.checkTrusted(chain);
    }

    @Override
    public void checkServerTrusted(@NotNull X509Certificate[] chain, @NotNull String authType) throws CertificateException {
        this.checkTrusted(chain);
    }

    private void checkTrusted(@NotNull X509Certificate[] chain) throws CertificateException {
        X509Certificate peerCert;
        if (chain == null || chain.length == 0) {
            throw new CertificateException(UnboundIDDSMessages.ERR_TR_TM_NO_CHAIN.get());
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime < (peerCert = chain[0]).getNotBefore().getTime()) {
            throw new CertificateException(UnboundIDDSMessages.ERR_TR_TM_PEER_NOT_YET_VALID.get(peerCert.getSubjectX500Principal().getName("RFC2253"), String.valueOf(peerCert.getNotBefore())));
        }
        if (currentTime > peerCert.getNotAfter().getTime()) {
            throw new CertificateException(UnboundIDDSMessages.ERR_TR_TM_PEER_EXPIRED.get(peerCert.getSubjectX500Principal().getName("RFC2253"), String.valueOf(peerCert.getNotAfter())));
        }
        for (int i = 1; i < chain.length; ++i) {
            X509Certificate issuerCert = chain[i];
            if (currentTime < issuerCert.getNotBefore().getTime()) {
                throw new CertificateException(UnboundIDDSMessages.ERR_TR_TM_ISSUER_NOT_YET_VALID.get(peerCert.getSubjectX500Principal().getName("RFC2253"), issuerCert.getSubjectX500Principal().getName("RFC2253"), String.valueOf(peerCert.getNotBefore())));
            }
            if (currentTime <= issuerCert.getNotAfter().getTime()) continue;
            throw new CertificateException(UnboundIDDSMessages.ERR_TR_TM_ISSUER_EXPIRED.get(peerCert.getSubjectX500Principal().getName("RFC2253"), issuerCert.getSubjectX500Principal().getName("RFC2253"), String.valueOf(peerCert.getNotAfter())));
        }
        if (this.cacheExpirationTime.get() >= currentTime && this.cachedCertificates.get().contains(peerCert)) {
            return;
        }
        Set<X509Certificate> topologyRegistryCertificates = this.readTopologyRegistryCertificates(peerCert);
        if (this.cacheDurationMillis > 0L) {
            this.cachedCertificates.set(topologyRegistryCertificates);
            this.cacheExpirationTime.set(currentTime + this.cacheDurationMillis);
        }
        if (topologyRegistryCertificates.contains(peerCert)) {
            return;
        }
        throw new CertificateException(UnboundIDDSMessages.ERR_TP_TM_PEER_NOT_FOUND.get(peerCert.getSubjectX500Principal().getName("RFC2253")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private Set<X509Certificate> readTopologyRegistryCertificates(@NotNull X509Certificate peerCert) throws CertificateException {
        try (LDIFReader ldifReader = new LDIFReader(this.configurationFile);){
            HashSet<X509Certificate> certs = new HashSet<X509Certificate>();
            while (true) {
                Entry entry;
                try {
                    entry = ldifReader.readEntry();
                }
                catch (LDIFException e) {
                    Debug.debugException(e);
                    if (e.mayContinueReading()) continue;
                    throw new CertificateException(UnboundIDDSMessages.ERR_TP_TM_MALFORMED_CONFIG.get(peerCert.getSubjectX500Principal().getName("RFC2253"), this.configurationFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
                }
                if (entry == null) {
                    Set<X509Certificate> set = Collections.unmodifiableSet(certs);
                    return set;
                }
                if (entry.hasObjectClass(INTER_SERVER_CERT_OC) && entry.hasAttribute(INTER_SERVER_CERT_AT)) {
                    this.parseCertificates(certs, entry.getAttribute(INTER_SERVER_CERT_AT));
                    continue;
                }
                if (!entry.hasObjectClass(LISTENER_CERT_OC) || !entry.hasAttribute(LISTENER_CERT_AT)) continue;
                this.parseCertificates(certs, entry.getAttribute(LISTENER_CERT_AT));
                continue;
                break;
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new CertificateException(UnboundIDDSMessages.ERR_TP_TM_ERROR_READING_CONFIG_FILE.get(peerCert.getSubjectX500Principal().getName("RFC2253"), this.configurationFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private void parseCertificates(@NotNull Set<X509Certificate> certs, @NotNull Attribute attr) {
        StringBuilder certBase64 = new StringBuilder();
        for (String value : attr.getValues()) {
            try {
                for (String line : StaticUtils.stringToLines(value)) {
                    if (line.equalsIgnoreCase("-----BEGIN CERTIFICATE-----")) continue;
                    if (line.equalsIgnoreCase("-----END CERTIFICATE-----")) {
                        byte[] certBytes = Base64.decode(certBase64.toString());
                        certBase64.setLength(0);
                        certs.add((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(certBytes)));
                        continue;
                    }
                    certBase64.append(line);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
    }

    @Override
    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        return NO_CERTIFICATES;
    }
}

