/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.unboundidds.AES256EncodedPasswordSecretKey;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.Base64;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AES256EncodedPassword
implements Serializable {
    public static final byte ENCODING_VERSION_0_MASK = 0;
    public static final int ENCODING_VERSION_0 = 0;
    public static final int ENCODING_VERSION_0_GCM_TAG_LENGTH_BITS = 128;
    public static final int ENCODING_VERSION_0_GENERATED_KEY_LENGTH_BITS = 256;
    public static final int ENCODING_VERSION_0_IV_LENGTH_BYTES = 16;
    public static final int ENCODING_VERSION_0_KEY_FACTORY_ITERATION_COUNT = 32768;
    public static final int ENCODING_VERSION_0_KEY_FACTORY_SALT_LENGTH_BYTES = 16;
    public static final int ENCODING_VERSION_0_PADDING_MODULUS = 16;
    @NotNull
    public static final String ENCODING_VERSION_0_CIPHER_ALGORITHM = "AES";
    @NotNull
    public static final String ENCODING_VERSION_0_CIPHER_TRANSFORMATION = "AES/GCM/NoPadding";
    @NotNull
    public static final String ENCODING_VERSION_0_KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA512";
    @NotNull
    public static final String PASSWORD_STORAGE_SCHEME_PREFIX = "{AES256}";
    private static final long serialVersionUID = 8663129897722695672L;
    @NotNull
    private final byte[] encodedRepresentation;
    @NotNull
    private final byte[] encryptedPaddedPassword;
    @NotNull
    private final byte[] encryptionSettingsDefinitionID;
    @NotNull
    private final byte[] initializationVector;
    @NotNull
    private final byte[] keyFactorySalt;
    private final int encodingVersion;
    private final int paddingBytes;

    private AES256EncodedPassword(@NotNull byte[] encodedRepresentation, int encodingVersion, int paddingBytes, @NotNull byte[] keyFactorySalt, @NotNull byte[] initializationVector, @NotNull byte[] encryptionSettingsDefinitionID, @NotNull byte[] encryptedPaddedPassword) {
        this.encodedRepresentation = encodedRepresentation;
        this.encodingVersion = encodingVersion;
        this.paddingBytes = paddingBytes;
        this.keyFactorySalt = keyFactorySalt;
        this.initializationVector = initializationVector;
        this.encryptionSettingsDefinitionID = encryptionSettingsDefinitionID;
        this.encryptedPaddedPassword = encryptedPaddedPassword;
    }

    public int getEncodingVersion() {
        return this.encodingVersion;
    }

    public int getPaddingBytes() {
        return this.paddingBytes;
    }

    @NotNull
    public byte[] getKeyFactorySalt() {
        return this.keyFactorySalt;
    }

    @NotNull
    public byte[] getInitializationVector() {
        return this.initializationVector;
    }

    @NotNull
    public byte[] getEncryptionSettingsDefinitionIDBytes() {
        return this.encryptionSettingsDefinitionID;
    }

    @NotNull
    public String getEncryptionSettingsDefinitionIDString() {
        return StaticUtils.toUpperCase(StaticUtils.toHex(this.encryptionSettingsDefinitionID));
    }

    @NotNull
    public byte[] getEncodedRepresentation() {
        return this.encodedRepresentation;
    }

    @NotNull
    public String getStringRepresentation(boolean includeScheme) {
        String base64String = Base64.encode(this.encodedRepresentation);
        if (includeScheme) {
            return PASSWORD_STORAGE_SCHEME_PREFIX + base64String;
        }
        return base64String;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static AES256EncodedPassword encode(@NotNull String encryptionSettingsDefinitionID, @NotNull String encryptionSettingsDefinitionPassphrase, @NotNull String clearTextPassword) throws GeneralSecurityException, ParseException {
        byte[] encryptionSettingsDefinitionIDBytes = StaticUtils.fromHex(encryptionSettingsDefinitionID);
        char[] encryptionSettingsDefinitionPassphraseChars = encryptionSettingsDefinitionPassphrase.toCharArray();
        byte[] clearTextPasswordBytes = StaticUtils.getBytes(clearTextPassword);
        try {
            AES256EncodedPassword aES256EncodedPassword = AES256EncodedPassword.encode(encryptionSettingsDefinitionIDBytes, encryptionSettingsDefinitionPassphraseChars, clearTextPasswordBytes);
            return aES256EncodedPassword;
        }
        finally {
            Arrays.fill(encryptionSettingsDefinitionPassphraseChars, '\u0000');
            Arrays.fill(clearTextPasswordBytes, (byte)0);
        }
    }

    @NotNull
    public static AES256EncodedPassword encode(@NotNull byte[] encryptionSettingsDefinitionID, @NotNull char[] encryptionSettingsDefinitionPassphrase, @NotNull byte[] clearTextPassword) throws GeneralSecurityException {
        SecureRandom random = CryptoHelper.getSecureRandom();
        byte[] keyFactorySalt = new byte[16];
        random.nextBytes(keyFactorySalt);
        byte[] initializationVector = new byte[16];
        random.nextBytes(initializationVector);
        return AES256EncodedPassword.encode(encryptionSettingsDefinitionID, encryptionSettingsDefinitionPassphrase, keyFactorySalt, initializationVector, clearTextPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static AES256EncodedPassword encode(@NotNull byte[] encryptionSettingsDefinitionID, @NotNull char[] encryptionSettingsDefinitionPassphrase, @NotNull byte[] keyFactorySalt, @NotNull byte[] initializationVector, @NotNull byte[] clearTextPassword) throws GeneralSecurityException {
        AES256EncodedPasswordSecretKey secretKey = AES256EncodedPasswordSecretKey.generate(encryptionSettingsDefinitionID, encryptionSettingsDefinitionPassphrase, keyFactorySalt);
        try {
            AES256EncodedPassword aES256EncodedPassword = AES256EncodedPassword.encode(secretKey, initializationVector, clearTextPassword);
            return aES256EncodedPassword;
        }
        finally {
            secretKey.destroy();
        }
    }

    @NotNull
    public static AES256EncodedPassword encode(@NotNull AES256EncodedPasswordSecretKey secretKey, @NotNull byte[] initializationVector, @NotNull byte[] clearTextPassword) throws GeneralSecurityException {
        int paddingBytesNeeded;
        byte[] paddedClearTextPassword;
        Validator.ensureNotNull(secretKey, "AES256EncodedPassword.encode.secretKey must not be null.");
        Validator.ensureNotNull(initializationVector, "AES256EncodedPassword.encode.initializationVector must not be null.");
        if (initializationVector.length != 16) {
            Validator.violation("AES256EncodedPassword.encode.initializationVector must have a length of exactly 16 bytes.  The provided initialization vector had a length of " + initializationVector.length + " bytes.");
        }
        Validator.ensureNotNullOrEmpty(clearTextPassword, "AES256EncodedPassword.encode.clearTextPassword must not be null or empty.");
        int clearTextPasswordLengthModulus = clearTextPassword.length % 16;
        if (clearTextPasswordLengthModulus == 0) {
            paddedClearTextPassword = clearTextPassword;
            paddingBytesNeeded = 0;
        } else {
            paddingBytesNeeded = 16 - clearTextPasswordLengthModulus;
            paddedClearTextPassword = new byte[clearTextPassword.length + paddingBytesNeeded];
            Arrays.fill(paddedClearTextPassword, (byte)0);
            System.arraycopy(clearTextPassword, 0, paddedClearTextPassword, 0, clearTextPassword.length);
        }
        Cipher cipher = CryptoHelper.getCipher(ENCODING_VERSION_0_CIPHER_TRANSFORMATION);
        cipher.init(1, (Key)secretKey.getSecretKey(), new GCMParameterSpec(128, initializationVector));
        byte[] encryptedPaddedPassword = cipher.doFinal(paddedClearTextPassword);
        ByteStringBuffer buffer = new ByteStringBuffer();
        buffer.append((byte)(0 | paddingBytesNeeded & 0xF));
        byte[] keyFactorySalt = secretKey.getKeyFactorySalt();
        buffer.append(keyFactorySalt);
        buffer.append(initializationVector);
        byte[] encryptionSettingsDefinitionID = secretKey.getEncryptionSettingsDefinitionID();
        buffer.append((byte)(encryptionSettingsDefinitionID.length & 0xFF));
        buffer.append(encryptionSettingsDefinitionID);
        buffer.append(encryptedPaddedPassword);
        return new AES256EncodedPassword(buffer.toByteArray(), 0, paddingBytesNeeded, keyFactorySalt, initializationVector, encryptionSettingsDefinitionID, encryptedPaddedPassword);
    }

    @NotNull
    public static AES256EncodedPassword decode(@NotNull String encodedPassword) throws ParseException {
        byte[] encodedPasswordBytes;
        String base64EncodedString;
        int base64StartPos;
        Validator.ensureNotNullOrEmpty(encodedPassword, "AES256EncodedPassword.decode.encodedPassword must not be null or empty.");
        if (encodedPassword.startsWith(PASSWORD_STORAGE_SCHEME_PREFIX)) {
            base64StartPos = PASSWORD_STORAGE_SCHEME_PREFIX.length();
            base64EncodedString = encodedPassword.substring(base64StartPos);
        } else {
            base64StartPos = 0;
            base64EncodedString = encodedPassword;
        }
        try {
            encodedPasswordBytes = Base64.decode(base64EncodedString);
        }
        catch (ParseException e) {
            Debug.debugException(e);
            throw new ParseException(UnboundIDDSMessages.ERR_AES256_ENC_PW_DECODE_NOT_BASE64.get(StaticUtils.getExceptionMessage(e)), base64StartPos);
        }
        return AES256EncodedPassword.decode(encodedPasswordBytes);
    }

    @NotNull
    public static AES256EncodedPassword decode(@NotNull byte[] encodedPassword) throws ParseException {
        Validator.ensureNotNullOrEmpty(encodedPassword, "AES256EncodedPassword.decode.encodedPassword must not be null or empty.");
        if (encodedPassword.length < 36) {
            throw new ParseException(UnboundIDDSMessages.ERR_AES256_ENC_PW_DECODE_TOO_SHORT_INITIAL.get(encodedPassword.length), 0);
        }
        byte encodingVersionAndPaddingByte = encodedPassword[0];
        int encodingVersion = encodingVersionAndPaddingByte >> 4 & 0xF;
        if (encodingVersion != 0) {
            throw new ParseException(UnboundIDDSMessages.ERR_AES256_ENC_PW_DECODE_UNSUPPORTED_ENCODING_VERSION.get(encodingVersion, 0), 0);
        }
        int paddingBytes = encodingVersionAndPaddingByte & 0xF;
        byte[] keyFactorySalt = new byte[16];
        System.arraycopy(encodedPassword, 1, keyFactorySalt, 0, keyFactorySalt.length);
        byte[] initializationVector = new byte[16];
        System.arraycopy(encodedPassword, 1 + keyFactorySalt.length, initializationVector, 0, initializationVector.length);
        int esdIDLengthPos = 1 + keyFactorySalt.length + initializationVector.length;
        int esdIDLength = encodedPassword[esdIDLengthPos] & 0xFF;
        if (encodedPassword.length < esdIDLengthPos + 2 + esdIDLength) {
            throw new ParseException(UnboundIDDSMessages.ERR_AES256_ENC_PW_DECODE_TOO_SHORT_FOR_ESD_ID.get(encodedPassword.length, esdIDLength), esdIDLengthPos);
        }
        byte[] encryptionSettingsDefinitionID = new byte[esdIDLength];
        System.arraycopy(encodedPassword, esdIDLengthPos + 1, encryptionSettingsDefinitionID, 0, esdIDLength);
        int encryptedPaddedPasswordPos = esdIDLengthPos + 1 + esdIDLength;
        int encryptedPaddedPasswordLength = encodedPassword.length - encryptedPaddedPasswordPos;
        byte[] encryptedPaddedPassword = new byte[encryptedPaddedPasswordLength];
        System.arraycopy(encodedPassword, encryptedPaddedPasswordPos, encryptedPaddedPassword, 0, encryptedPaddedPasswordLength);
        return new AES256EncodedPassword(encodedPassword, encodingVersion, paddingBytes, keyFactorySalt, initializationVector, encryptionSettingsDefinitionID, encryptedPaddedPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] decrypt(@NotNull String encryptionSettingsDefinitionPassphrase) throws GeneralSecurityException {
        char[] passphraseChars = encryptionSettingsDefinitionPassphrase.toCharArray();
        try {
            byte[] byArray = this.decrypt(passphraseChars);
            return byArray;
        }
        finally {
            Arrays.fill(passphraseChars, '\u0000');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] decrypt(@NotNull char[] encryptionSettingsDefinitionPassphrase) throws GeneralSecurityException {
        AES256EncodedPasswordSecretKey secretKey = AES256EncodedPasswordSecretKey.generate(this.encryptionSettingsDefinitionID, encryptionSettingsDefinitionPassphrase, this.keyFactorySalt);
        try {
            byte[] byArray = this.decrypt(secretKey);
            return byArray;
        }
        finally {
            secretKey.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public byte[] decrypt(@NotNull AES256EncodedPasswordSecretKey secretKey) throws GeneralSecurityException {
        byte[] decryptedPassword;
        Validator.ensureNotNull(secretKey, "AES256EncodedPassword.decrypt.secretKey must not be null.");
        Cipher cipher = CryptoHelper.getCipher(ENCODING_VERSION_0_CIPHER_TRANSFORMATION);
        cipher.init(2, (Key)secretKey.getSecretKey(), new GCMParameterSpec(128, this.initializationVector));
        byte[] decryptedPaddedPassword = cipher.doFinal(this.encryptedPaddedPassword);
        if (this.paddingBytes > 0) {
            try {
                decryptedPassword = new byte[decryptedPaddedPassword.length - this.paddingBytes];
                for (int i = 0; i < decryptedPaddedPassword.length; ++i) {
                    if (i < decryptedPassword.length) {
                        decryptedPassword[i] = decryptedPaddedPassword[i];
                        continue;
                    }
                    if (decryptedPaddedPassword[i] == 0) continue;
                    throw new BadPaddingException(UnboundIDDSMessages.ERR_AES256_ENC_PW_DECRYPT_NONZERO_PADDING.get(this.paddingBytes));
                }
                System.arraycopy(decryptedPaddedPassword, 0, decryptedPassword, 0, decryptedPassword.length);
            }
            finally {
                Arrays.fill(decryptedPaddedPassword, (byte)0);
            }
        } else {
            decryptedPassword = decryptedPaddedPassword;
        }
        return decryptedPassword;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AES256EncodedPassword(stringRepresentation='");
        buffer.append(this.getStringRepresentation(true));
        buffer.append("', encodingVersion=");
        buffer.append(this.encodingVersion);
        buffer.append(", paddingBytes=");
        buffer.append(this.paddingBytes);
        buffer.append(", encryptionSettingsDefinitionIDHex='");
        StaticUtils.toHex(this.encryptionSettingsDefinitionID, buffer);
        buffer.append("', keyFactorySaltBytesHex='");
        StaticUtils.toHex(this.keyFactorySalt, buffer);
        buffer.append("', initializationVectorBytesHex='");
        StaticUtils.toHex(this.keyFactorySalt, buffer);
        buffer.append("')");
    }
}

