/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.controls.AssertionRequestControl;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityRequestControl;
import com.unboundid.ldap.sdk.controls.ManageDsaITRequestControl;
import com.unboundid.ldap.sdk.controls.PreReadRequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV1RequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.SubtreeDeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationLocalLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRemoteLevel;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetAuthorizationEntryRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetBackendSetIDRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetServerIDRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetUserResourceLimitsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.HardDeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.NoOpRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.ReplicationRepairRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RouteToBackendSetRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RouteToServerRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressReferentialIntegrityUpdatesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartAdministrativeSessionPostConnectProcessor;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPDeleteSearchListener;
import com.unboundid.ldap.sdk.unboundidds.tools.ReportBindResultLDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.unboundidds.tools.ResultUtils;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolUtils;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.SubtreeDeleter;
import com.unboundid.util.SubtreeDeleterResult;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.DurationArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class LDAPDelete
extends LDAPCommandLineTool
implements UnsolicitedNotificationHandler {
    private static final int WRAP_COLUMN = StaticUtils.TERMINAL_WIDTH_COLUMNS - 1;
    @Nullable
    private ArgumentParser parser = null;
    @Nullable
    private BooleanArgument authorizationIdentity = null;
    @Nullable
    private BooleanArgument clientSideSubtreeDelete = null;
    @Nullable
    private BooleanArgument continueOnError = null;
    @Nullable
    private BooleanArgument dryRun = null;
    @Nullable
    private BooleanArgument followReferrals = null;
    @Nullable
    private BooleanArgument getBackendSetID = null;
    @Nullable
    private BooleanArgument getServerID = null;
    @Nullable
    private BooleanArgument getUserResourceLimits = null;
    @Nullable
    private BooleanArgument hardDelete = null;
    @Nullable
    private BooleanArgument manageDsaIT = null;
    @Nullable
    private BooleanArgument neverRetry = null;
    @Nullable
    private BooleanArgument noOperation = null;
    @Nullable
    private BooleanArgument replicationRepair = null;
    @Nullable
    private BooleanArgument retryFailedOperations = null;
    @Nullable
    private BooleanArgument softDelete = null;
    @Nullable
    private BooleanArgument serverSideSubtreeDelete = null;
    @Nullable
    private BooleanArgument suppressReferentialIntegrityUpdates = null;
    @Nullable
    private BooleanArgument useAdministrativeSession = null;
    @Nullable
    private BooleanArgument useAssuredReplication = null;
    @Nullable
    private BooleanArgument verbose = null;
    @Nullable
    private ControlArgument bindControl = null;
    @Nullable
    private ControlArgument deleteControl = null;
    @Nullable
    private DNArgument entryDN = null;
    @Nullable
    private DNArgument proxyV1As = null;
    @Nullable
    private DNArgument searchBaseDN = null;
    @Nullable
    private DurationArgument assuredReplicationTimeout = null;
    @Nullable
    private FileArgument dnFile = null;
    @Nullable
    private FileArgument encryptionPassphraseFile = null;
    @Nullable
    private FileArgument deleteEntriesMatchingFiltersFromFile = null;
    @Nullable
    private FileArgument rejectFile = null;
    @Nullable
    private FilterArgument assertionFilter = null;
    @Nullable
    private FilterArgument deleteEntriesMatchingFilter = null;
    @Nullable
    private IntegerArgument ratePerSecond = null;
    @Nullable
    private IntegerArgument searchPageSize = null;
    @Nullable
    private StringArgument assuredReplicationLocalLevel = null;
    @Nullable
    private StringArgument assuredReplicationRemoteLevel = null;
    @Nullable
    private StringArgument characterSet = null;
    @Nullable
    private StringArgument getAuthorizationEntryAttribute = null;
    @Nullable
    private StringArgument operationPurpose = null;
    @Nullable
    private StringArgument preReadAttribute = null;
    @Nullable
    private StringArgument proxyAs = null;
    @Nullable
    private StringArgument routeToBackendSet = null;
    @Nullable
    private StringArgument routeToServer = null;
    @NotNull
    private final AtomicReference<LDIFWriter> rejectWriter = new AtomicReference();
    @Nullable
    private volatile FixedRateBarrier deleteRateLimiter = null;
    @NotNull
    private final InputStream in;
    @Nullable
    private volatile LDAPConnectionPool connectionPool = null;
    @NotNull
    private volatile List<Control> deleteControls = Collections.emptyList();
    @NotNull
    private volatile List<Control> searchControls = Collections.emptyList();
    @NotNull
    private final List<RouteToBackendSetRequestControl> routeToBackendSetRequestControls = new ArrayList<RouteToBackendSetRequestControl>(10);
    @Nullable
    private volatile SubtreeDeleter subtreeDeleter = null;

    public static void main(String ... args) {
        ResultCode resultCode = LDAPDelete.main(System.in, System.out, System.err, args);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@Nullable InputStream in, @Nullable OutputStream out, @Nullable OutputStream err, String ... args) {
        LDAPDelete ldapDelete = new LDAPDelete(in, out, err);
        return ldapDelete.runTool(args);
    }

    public LDAPDelete(@Nullable OutputStream out, @Nullable OutputStream err) {
        this(null, out, err);
    }

    public LDAPDelete(@Nullable InputStream in, @Nullable OutputStream out, @Nullable OutputStream err) {
        super(out, err);
        this.in = in == null ? new ByteArrayInputStream(StaticUtils.NO_BYTES) : in;
    }

    @Override
    @NotNull
    public String getToolName() {
        return "ldapdelete";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return ToolMessages.INFO_LDAPDELETE_TOOL_DESCRIPTION.get();
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "5.1.4";
    }

    @Override
    public int getMinTrailingArguments() {
        return 0;
    }

    @Override
    public int getMaxTrailingArguments() {
        return Integer.MAX_VALUE;
    }

    @Override
    @NotNull
    public String getTrailingArgumentsPlaceholder() {
        return ToolMessages.INFO_LDAPDELETE_TRAILING_ARGS_PLACEHOLDER.get();
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    public boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    protected boolean logToolInvocationByDefault() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        this.parser = parser;
        String argGroupData = ToolMessages.INFO_LDAPDELETE_ARG_GROUP_DATA.get();
        this.entryDN = new DNArgument(Character.valueOf('b'), "entryDN", false, 0, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_DN.get());
        this.entryDN.addLongIdentifier("entry-dn", true);
        this.entryDN.addLongIdentifier("dn", true);
        this.entryDN.addLongIdentifier("dnToDelete", true);
        this.entryDN.addLongIdentifier("dn-to-delete", true);
        this.entryDN.addLongIdentifier("entry", true);
        this.entryDN.addLongIdentifier("entryToDelete", true);
        this.entryDN.addLongIdentifier("entry-to-delete", true);
        this.entryDN.setArgumentGroupName(argGroupData);
        parser.addArgument(this.entryDN);
        this.dnFile = new FileArgument(Character.valueOf('f'), "dnFile", false, 0, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_DN_FILE.get(), true, true, true, false);
        this.dnFile.addLongIdentifier("dn-file", true);
        this.dnFile.addLongIdentifier("dnFilename", true);
        this.dnFile.addLongIdentifier("dn-filename", true);
        this.dnFile.addLongIdentifier("deleteEntriesWithDNsFromFile", true);
        this.dnFile.addLongIdentifier("delete-entries0-with-dns-from-file", true);
        this.dnFile.addLongIdentifier("file", true);
        this.dnFile.addLongIdentifier("filename", true);
        this.dnFile.setArgumentGroupName(argGroupData);
        parser.addArgument(this.dnFile);
        this.deleteEntriesMatchingFilter = new FilterArgument(null, "deleteEntriesMatchingFilter", false, 0, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_DELETE_ENTRIES_MATCHING_FILTER.get());
        this.deleteEntriesMatchingFilter.addLongIdentifier("delete-entries-matching-filter", true);
        this.deleteEntriesMatchingFilter.addLongIdentifier("deleteFilter", true);
        this.deleteEntriesMatchingFilter.addLongIdentifier("delete-filter", true);
        this.deleteEntriesMatchingFilter.addLongIdentifier("deleteSearchFilter", true);
        this.deleteEntriesMatchingFilter.addLongIdentifier("delete-search-filter", true);
        this.deleteEntriesMatchingFilter.addLongIdentifier("filter", true);
        this.deleteEntriesMatchingFilter.setArgumentGroupName(argGroupData);
        parser.addArgument(this.deleteEntriesMatchingFilter);
        this.deleteEntriesMatchingFiltersFromFile = new FileArgument(null, "deleteEntriesMatchingFiltersFromFile", false, 0, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_DELETE_ENTRIES_MATCHING_FILTER_FILE.get(), true, true, true, false);
        this.deleteEntriesMatchingFiltersFromFile.addLongIdentifier("delete-entries-matching-filters-from-file", true);
        this.deleteEntriesMatchingFiltersFromFile.addLongIdentifier("deleteEntriesMatchingFilterFromFile", true);
        this.deleteEntriesMatchingFiltersFromFile.addLongIdentifier("delete-entries-matching-filter-from-file", true);
        this.deleteEntriesMatchingFiltersFromFile.addLongIdentifier("deleteFilterFile", true);
        this.deleteEntriesMatchingFiltersFromFile.addLongIdentifier("delete-filter-file", true);
        this.deleteEntriesMatchingFiltersFromFile.addLongIdentifier("deleteSearchFilterFile", true);
        this.deleteEntriesMatchingFiltersFromFile.addLongIdentifier("delete-search-filter-file", true);
        this.deleteEntriesMatchingFiltersFromFile.addLongIdentifier("filterFile", true);
        this.deleteEntriesMatchingFiltersFromFile.addLongIdentifier("filter-file", true);
        this.deleteEntriesMatchingFiltersFromFile.setArgumentGroupName(argGroupData);
        parser.addArgument(this.deleteEntriesMatchingFiltersFromFile);
        this.searchBaseDN = new DNArgument(null, "searchBaseDN", false, 0, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_SEARCH_BASE_DN.get(), DN.NULL_DN);
        this.searchBaseDN.addLongIdentifier("search-base-dn", true);
        this.searchBaseDN.addLongIdentifier("baseDN", true);
        this.searchBaseDN.addLongIdentifier("base-dn", true);
        this.searchBaseDN.setArgumentGroupName(argGroupData);
        parser.addArgument(this.searchBaseDN);
        this.searchPageSize = new IntegerArgument(null, "searchPageSize", false, 1, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_SEARCH_PAGE_SIZE.get(), 1, Integer.MAX_VALUE);
        this.searchPageSize.addLongIdentifier("search-page-size", true);
        this.searchPageSize.addLongIdentifier("simplePagedResultsPageSize", true);
        this.searchPageSize.addLongIdentifier("simple-paged-results-page-size", true);
        this.searchPageSize.addLongIdentifier("pageSize", true);
        this.searchPageSize.addLongIdentifier("page-size", true);
        this.searchPageSize.setArgumentGroupName(argGroupData);
        parser.addArgument(this.searchPageSize);
        this.encryptionPassphraseFile = new FileArgument(null, "encryptionPassphraseFile", false, 1, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_ENCRYPTION_PW_FILE.get(), true, true, true, false);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-passphrase-file", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryptionPasswordFile", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-password-file", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryptionPINFile", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-pin-file", true);
        this.encryptionPassphraseFile.setArgumentGroupName(argGroupData);
        parser.addArgument(this.encryptionPassphraseFile);
        this.characterSet = new StringArgument(Character.valueOf('i'), "characterSet", false, 1, ToolMessages.INFO_LDAPDELETE_ARG_PLACEHOLDER_CHARSET.get(), ToolMessages.INFO_LDAPDELETE_ARG_DESC_CHARSET.get(), "UTF-8");
        this.characterSet.addLongIdentifier("character-set", true);
        this.characterSet.addLongIdentifier("charSet", true);
        this.characterSet.addLongIdentifier("char-set", true);
        this.characterSet.addLongIdentifier("encoding", true);
        this.characterSet.setArgumentGroupName(argGroupData);
        parser.addArgument(this.characterSet);
        this.rejectFile = new FileArgument(Character.valueOf('R'), "rejectFile", false, 1, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_REJECT_FILE.get(), false, true, true, false);
        this.rejectFile.addLongIdentifier("reject-file", true);
        this.rejectFile.addLongIdentifier("errorFile", true);
        this.rejectFile.addLongIdentifier("error-file", true);
        this.rejectFile.addLongIdentifier("failureFile", true);
        this.rejectFile.addLongIdentifier("failure-file", true);
        this.rejectFile.setArgumentGroupName(argGroupData);
        parser.addArgument(this.rejectFile);
        this.verbose = new BooleanArgument(Character.valueOf('v'), "verbose", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_VERBOSE.get());
        this.verbose.setArgumentGroupName(argGroupData);
        parser.addArgument(this.verbose);
        BooleanArgument scriptFriendly = new BooleanArgument(null, "scriptFriendly", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_SCRIPT_FRIENDLY.get());
        scriptFriendly.addLongIdentifier("script-friendly", true);
        scriptFriendly.setArgumentGroupName(argGroupData);
        scriptFriendly.setHidden(true);
        parser.addArgument(scriptFriendly);
        String argGroupOp = ToolMessages.INFO_LDAPDELETE_ARG_GROUP_OPERATION.get();
        this.retryFailedOperations = new BooleanArgument(null, "retryFailedOperations", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_RETRY_FAILED_OPS.get());
        this.retryFailedOperations.addLongIdentifier("retry-failed-operations", true);
        this.retryFailedOperations.addLongIdentifier("retryFailedOps", true);
        this.retryFailedOperations.addLongIdentifier("retry-failed-ops", true);
        this.retryFailedOperations.addLongIdentifier("retry", true);
        this.retryFailedOperations.setArgumentGroupName(argGroupOp);
        this.retryFailedOperations.setHidden(true);
        parser.addArgument(this.retryFailedOperations);
        this.neverRetry = new BooleanArgument(null, "neverRetry", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_NEVER_RETRY.get());
        this.neverRetry.addLongIdentifier("never-retry", true);
        this.neverRetry.setArgumentGroupName(argGroupOp);
        parser.addArgument(this.neverRetry);
        this.dryRun = new BooleanArgument(Character.valueOf('n'), "dryRun", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_DRY_RUN.get());
        this.dryRun.addLongIdentifier("dry-run", true);
        this.dryRun.setArgumentGroupName(argGroupOp);
        parser.addArgument(this.dryRun);
        this.continueOnError = new BooleanArgument(Character.valueOf('c'), "continueOnError", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_CONTINUE_ON_ERROR.get());
        this.continueOnError.addLongIdentifier("continue-on-error", true);
        this.continueOnError.setArgumentGroupName(argGroupOp);
        parser.addArgument(this.continueOnError);
        this.followReferrals = new BooleanArgument(null, "followReferrals", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_FOLLOW_REFERRALS.get());
        this.followReferrals.addLongIdentifier("follow-referrals", true);
        this.followReferrals.setArgumentGroupName(argGroupOp);
        parser.addArgument(this.followReferrals);
        this.useAdministrativeSession = new BooleanArgument(null, "useAdministrativeSession", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_USE_ADMIN_SESSION.get());
        this.useAdministrativeSession.addLongIdentifier("use-administrative-session", true);
        this.useAdministrativeSession.addLongIdentifier("useAdminSession", true);
        this.useAdministrativeSession.addLongIdentifier("use-admin-session", true);
        this.useAdministrativeSession.setArgumentGroupName(argGroupOp);
        parser.addArgument(this.useAdministrativeSession);
        this.ratePerSecond = new IntegerArgument(Character.valueOf('r'), "ratePerSecond", false, 1, ToolMessages.INFO_LDAPDELETE_ARG_PLACEHOLDER_RATE_PER_SECOND.get(), ToolMessages.INFO_LDAPDELETE_ARG_DESC_RATE_PER_SECOND.get(), 1, Integer.MAX_VALUE);
        this.ratePerSecond.addLongIdentifier("rate-per-second", true);
        this.ratePerSecond.addLongIdentifier("deletesPerSecond", true);
        this.ratePerSecond.addLongIdentifier("deletes-per-second", true);
        this.ratePerSecond.addLongIdentifier("operationsPerSecond", true);
        this.ratePerSecond.addLongIdentifier("operations-per-second", true);
        this.ratePerSecond.addLongIdentifier("opsPerSecond", true);
        this.ratePerSecond.addLongIdentifier("ops-per-second", true);
        this.ratePerSecond.setArgumentGroupName(argGroupOp);
        parser.addArgument(this.ratePerSecond);
        IntegerArgument ldapVersion = new IntegerArgument(Character.valueOf('V'), "ldapVersion", false, 1, "{version}", ToolMessages.INFO_LDAPDELETE_ARG_DESC_LDAP_VERSION.get(), 3, 3, 3);
        ldapVersion.addLongIdentifier("ldap-version", true);
        ldapVersion.setArgumentGroupName(argGroupOp);
        ldapVersion.setHidden(true);
        parser.addArgument(ldapVersion);
        String argGroupControls = ToolMessages.INFO_LDAPDELETE_ARG_GROUP_CONTROLS.get();
        this.clientSideSubtreeDelete = new BooleanArgument(null, "clientSideSubtreeDelete", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_CLIENT_SIDE_SUB_DEL.get());
        this.clientSideSubtreeDelete.addLongIdentifier("client-side-subtree-delete", true);
        this.clientSideSubtreeDelete.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.clientSideSubtreeDelete);
        this.serverSideSubtreeDelete = new BooleanArgument(Character.valueOf('x'), "serverSideSubtreeDelete", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_SERVER_SIDE_SUB_DEL.get());
        this.serverSideSubtreeDelete.addLongIdentifier("server-side-subtree-delete", true);
        this.serverSideSubtreeDelete.addLongIdentifier("deleteSubtree", true);
        this.serverSideSubtreeDelete.addLongIdentifier("delete-subtree", true);
        this.serverSideSubtreeDelete.addLongIdentifier("useSubtreeDeleteControl", true);
        this.serverSideSubtreeDelete.addLongIdentifier("use-subtree-delete-control", true);
        this.serverSideSubtreeDelete.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.serverSideSubtreeDelete);
        this.softDelete = new BooleanArgument(Character.valueOf('s'), "softDelete", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_SOFT_DELETE.get());
        this.softDelete.addLongIdentifier("soft-delete", true);
        this.softDelete.addLongIdentifier("useSoftDelete", true);
        this.softDelete.addLongIdentifier("use-soft-delete", true);
        this.softDelete.addLongIdentifier("useSoftDeleteControl", true);
        this.softDelete.addLongIdentifier("use-soft-delete-control", true);
        this.softDelete.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.softDelete);
        this.hardDelete = new BooleanArgument(null, "hardDelete", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_HARD_DELETE.get());
        this.hardDelete.addLongIdentifier("hard-delete", true);
        this.hardDelete.addLongIdentifier("useHardDelete", true);
        this.hardDelete.addLongIdentifier("use-hard-delete", true);
        this.hardDelete.addLongIdentifier("useHardDeleteControl", true);
        this.hardDelete.addLongIdentifier("use-hard-delete-control", true);
        this.hardDelete.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.hardDelete);
        this.proxyAs = new StringArgument(Character.valueOf('Y'), "proxyAs", false, 1, ToolMessages.INFO_LDAPDELETE_ARG_PLACEHOLDER_AUTHZ_ID.get(), ToolMessages.INFO_LDAPDELETE_ARG_DESC_PROXY_AS.get());
        this.proxyAs.addLongIdentifier("proxy-as", true);
        this.proxyAs.addLongIdentifier("proxyV2As", true);
        this.proxyAs.addLongIdentifier("proxy-v2-as", true);
        this.proxyAs.addLongIdentifier("proxiedAuth", true);
        this.proxyAs.addLongIdentifier("proxied-auth", true);
        this.proxyAs.addLongIdentifier("proxiedAuthorization", true);
        this.proxyAs.addLongIdentifier("proxied-authorization", true);
        this.proxyAs.addLongIdentifier("useProxiedAuth", true);
        this.proxyAs.addLongIdentifier("use-proxied-auth", true);
        this.proxyAs.addLongIdentifier("useProxiedAuthorization", true);
        this.proxyAs.addLongIdentifier("use-proxied-authorization", true);
        this.proxyAs.addLongIdentifier("useProxiedAuthControl", true);
        this.proxyAs.addLongIdentifier("use-proxied-auth-control", true);
        this.proxyAs.addLongIdentifier("useProxiedAuthorizationControl", true);
        this.proxyAs.addLongIdentifier("use-proxied-authorization-control", true);
        this.proxyAs.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.proxyAs);
        this.proxyV1As = new DNArgument(null, "proxyV1As", false, 1, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_PROXY_V1_AS.get());
        this.proxyV1As.addLongIdentifier("proxy-v1-as", true);
        this.proxyV1As.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.proxyV1As);
        this.manageDsaIT = new BooleanArgument(null, "useManageDsaIT", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_MANAGE_DSA_IT.get());
        this.manageDsaIT.addLongIdentifier("use-manage-dsa-it", true);
        this.manageDsaIT.addLongIdentifier("manageDsaIT", true);
        this.manageDsaIT.addLongIdentifier("manage-dsa-it", true);
        this.manageDsaIT.addLongIdentifier("manageDsaITControl", true);
        this.manageDsaIT.addLongIdentifier("manage-dsa-it-control", true);
        this.manageDsaIT.addLongIdentifier("useManageDsaITControl", true);
        this.manageDsaIT.addLongIdentifier("use-manage-dsa-it-control", true);
        this.manageDsaIT.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.manageDsaIT);
        this.assertionFilter = new FilterArgument(null, "assertionFilter", false, 1, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_ASSERTION_FILTER.get());
        this.assertionFilter.addLongIdentifier("assertion-filter", true);
        this.assertionFilter.addLongIdentifier("useAssertionFilter", true);
        this.assertionFilter.addLongIdentifier("use-assertion-filter", true);
        this.assertionFilter.addLongIdentifier("assertionControl", true);
        this.assertionFilter.addLongIdentifier("assertion-control", true);
        this.assertionFilter.addLongIdentifier("useAssertionControl", true);
        this.assertionFilter.addLongIdentifier("use-assertion-control", true);
        this.assertionFilter.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.assertionFilter);
        this.preReadAttribute = new StringArgument(null, "preReadAttribute", false, 0, ToolMessages.INFO_LDAPDELETE_ARG_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPDELETE_ARG_DESC_PRE_READ_ATTR.get());
        this.preReadAttribute.addLongIdentifier("pre-read-attribute", true);
        this.preReadAttribute.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.preReadAttribute);
        this.noOperation = new BooleanArgument(null, "noOperation", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_NO_OP.get());
        this.noOperation.addLongIdentifier("no-operation", true);
        this.noOperation.addLongIdentifier("noOp", true);
        this.noOperation.addLongIdentifier("no-op", true);
        this.noOperation.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.noOperation);
        this.getBackendSetID = new BooleanArgument(null, "getBackendSetID", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_GET_BACKEND_SET_ID.get());
        this.getBackendSetID.addLongIdentifier("get-backend-set-id", true);
        this.getBackendSetID.addLongIdentifier("useGetBackendSetID", true);
        this.getBackendSetID.addLongIdentifier("use-get-backend-set-id", true);
        this.getBackendSetID.addLongIdentifier("useGetBackendSetIDControl", true);
        this.getBackendSetID.addLongIdentifier("use-get-backend-set-id-control", true);
        this.getBackendSetID.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.getBackendSetID);
        this.routeToBackendSet = new StringArgument(null, "routeToBackendSet", false, 0, ToolMessages.INFO_LDAPDELETE_ARG_PLACEHOLDER_ROUTE_TO_BACKEND_SET.get(), ToolMessages.INFO_LDAPDELETE_ARG_DESC_ROUTE_TO_BACKEND_SET.get());
        this.routeToBackendSet.addLongIdentifier("route-to-backend-set", true);
        this.routeToBackendSet.addLongIdentifier("useRouteToBackendSet", true);
        this.routeToBackendSet.addLongIdentifier("use0route-to-backend-set", true);
        this.routeToBackendSet.addLongIdentifier("useRouteToBackendSetControl", true);
        this.routeToBackendSet.addLongIdentifier("use-route-to-backend-set-control", true);
        this.routeToBackendSet.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.routeToBackendSet);
        this.getServerID = new BooleanArgument(null, "getServerID", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_GET_SERVER_ID.get());
        this.getServerID.addLongIdentifier("get-server-id", true);
        this.getServerID.addLongIdentifier("getBackendServerID", true);
        this.getServerID.addLongIdentifier("get-backend-server-id", true);
        this.getServerID.addLongIdentifier("useGetServerID", true);
        this.getServerID.addLongIdentifier("use-get-server-id", true);
        this.getServerID.addLongIdentifier("useGetServerIDControl", true);
        this.getServerID.addLongIdentifier("use-get-server-id-control", true);
        this.getServerID.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.getServerID);
        this.routeToServer = new StringArgument(null, "routeToServer", false, 1, ToolMessages.INFO_LDAPDELETE_ARG_PLACEHOLDER_ID.get(), ToolMessages.INFO_LDAPDELETE_ARG_DESC_ROUTE_TO_SERVER.get());
        this.routeToServer.addLongIdentifier("route-to-server", true);
        this.routeToServer.addLongIdentifier("routeToBackendServer", true);
        this.routeToServer.addLongIdentifier("route-to-backend-server", true);
        this.routeToServer.addLongIdentifier("useRouteToServer", true);
        this.routeToServer.addLongIdentifier("use-route-to-server", true);
        this.routeToServer.addLongIdentifier("useRouteToBackendServer", true);
        this.routeToServer.addLongIdentifier("use-route-to-backend-server", true);
        this.routeToServer.addLongIdentifier("useRouteToServerControl", true);
        this.routeToServer.addLongIdentifier("use-route-to-server-control", true);
        this.routeToServer.addLongIdentifier("useRouteToBackendServerControl", true);
        this.routeToServer.addLongIdentifier("use-route-to-backend-server-control", true);
        this.routeToServer.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.routeToServer);
        this.useAssuredReplication = new BooleanArgument(null, "useAssuredReplication", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_USE_ASSURED_REPLICATION.get());
        this.useAssuredReplication.addLongIdentifier("use-assured-replication", true);
        this.useAssuredReplication.addLongIdentifier("assuredReplication", true);
        this.useAssuredReplication.addLongIdentifier("assured-replication", true);
        this.useAssuredReplication.addLongIdentifier("assuredReplicationControl", true);
        this.useAssuredReplication.addLongIdentifier("assured-replication-control", true);
        this.useAssuredReplication.addLongIdentifier("useAssuredReplicationControl", true);
        this.useAssuredReplication.addLongIdentifier("use-assured-replication-control", true);
        this.useAssuredReplication.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.useAssuredReplication);
        this.assuredReplicationLocalLevel = new StringArgument(null, "assuredReplicationLocalLevel", false, 1, ToolMessages.INFO_LDAPDELETE_ARG_PLACEHOLDER_ASSURED_REPLICATION_LOCAL_LEVEL.get(), ToolMessages.INFO_LDAPDELETE_ARG_DESC_ASSURED_REPLICATION_LOCAL_LEVEL.get(), StaticUtils.setOf("none", "received-any-server", "processed-all-servers"));
        this.assuredReplicationLocalLevel.addLongIdentifier("assured-replication-local-level", true);
        this.assuredReplicationLocalLevel.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.assuredReplicationLocalLevel);
        this.assuredReplicationRemoteLevel = new StringArgument(null, "assuredReplicationRemoteLevel", false, 1, ToolMessages.INFO_LDAPDELETE_ARG_PLACEHOLDER_ASSURED_REPLICATION_REMOTE_LEVEL.get(), ToolMessages.INFO_LDAPDELETE_ARG_DESC_ASSURED_REPLICATION_REMOTE_LEVEL.get(), StaticUtils.setOf("none", "received-any-remote-location", "received-all-remote-locations", "processed-all-remote-servers"));
        this.assuredReplicationRemoteLevel.addLongIdentifier("assured-replication-remote-level", true);
        this.assuredReplicationRemoteLevel.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.assuredReplicationRemoteLevel);
        this.assuredReplicationTimeout = new DurationArgument(null, "assuredReplicationTimeout", false, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_ASSURED_REPLICATION_TIMEOUT.get());
        this.assuredReplicationTimeout.addLongIdentifier("assured-replication-timeout", true);
        this.assuredReplicationTimeout.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.assuredReplicationTimeout);
        this.replicationRepair = new BooleanArgument(null, "replicationRepair", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_REPLICATION_REPAIR.get());
        this.replicationRepair.addLongIdentifier("replication-repair", true);
        this.replicationRepair.addLongIdentifier("replicationRepairControl", true);
        this.replicationRepair.addLongIdentifier("replication-repair-control", true);
        this.replicationRepair.addLongIdentifier("useReplicationRepair", true);
        this.replicationRepair.addLongIdentifier("use-replication-repair", true);
        this.replicationRepair.addLongIdentifier("useReplicationRepairControl", true);
        this.replicationRepair.addLongIdentifier("use-replication-repair-control", true);
        this.replicationRepair.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.replicationRepair);
        this.suppressReferentialIntegrityUpdates = new BooleanArgument(null, "suppressReferentialIntegrityUpdates", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_SUPPRESS_REFINT_UPDATES.get());
        this.suppressReferentialIntegrityUpdates.addLongIdentifier("suppress-referential-integrity-updates", true);
        this.suppressReferentialIntegrityUpdates.addLongIdentifier("useSuppressReferentialIntegrityUpdates", true);
        this.suppressReferentialIntegrityUpdates.addLongIdentifier("use-suppress-referential-integrity-updates", true);
        this.suppressReferentialIntegrityUpdates.addLongIdentifier("useSuppressReferentialIntegrityUpdatesControl", true);
        this.suppressReferentialIntegrityUpdates.addLongIdentifier("use-suppress-referential-integrity-updates-control", true);
        this.suppressReferentialIntegrityUpdates.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.suppressReferentialIntegrityUpdates);
        this.operationPurpose = new StringArgument(null, "operationPurpose", false, 1, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_OP_PURPOSE.get());
        this.operationPurpose.addLongIdentifier("operation-purpose", true);
        this.operationPurpose.addLongIdentifier("operationPurposeControl", true);
        this.operationPurpose.addLongIdentifier("operation-purpose-control", true);
        this.operationPurpose.addLongIdentifier("useOperationPurpose", true);
        this.operationPurpose.addLongIdentifier("use-operation-purpose", true);
        this.operationPurpose.addLongIdentifier("useOperationPurposeControl", true);
        this.operationPurpose.addLongIdentifier("use-operation-purpose-control", true);
        this.operationPurpose.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.operationPurpose);
        this.authorizationIdentity = new BooleanArgument(Character.valueOf('E'), "authorizationIdentity", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_AUTHZ_ID.get());
        this.authorizationIdentity.addLongIdentifier("authorization-identity", true);
        this.authorizationIdentity.addLongIdentifier("useAuthorizationIdentity", true);
        this.authorizationIdentity.addLongIdentifier("use-authorization-identity", true);
        this.authorizationIdentity.addLongIdentifier("useAuthorizationIdentityControl", true);
        this.authorizationIdentity.addLongIdentifier("use-authorization-identity-control", true);
        this.authorizationIdentity.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.authorizationIdentity);
        this.getAuthorizationEntryAttribute = new StringArgument(null, "getAuthorizationEntryAttribute", false, 0, ToolMessages.INFO_LDAPDELETE_ARG_PLACEHOLDER_ATTR.get(), ToolMessages.INFO_LDAPDELETE_ARG_DESC_GET_AUTHZ_ENTRY_ATTR.get());
        this.getAuthorizationEntryAttribute.addLongIdentifier("get-authorization-entry-attribute", true);
        this.getAuthorizationEntryAttribute.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.getAuthorizationEntryAttribute);
        this.getUserResourceLimits = new BooleanArgument(null, "getUserResourceLimits", 1, ToolMessages.INFO_LDAPDELETE_ARG_DESC_GET_USER_RESOURCE_LIMITS.get());
        this.getUserResourceLimits.addLongIdentifier("get-user-resource-limits", true);
        this.getUserResourceLimits.addLongIdentifier("getUserResourceLimitsControl", true);
        this.getUserResourceLimits.addLongIdentifier("get-user-resource-limits-control", true);
        this.getUserResourceLimits.addLongIdentifier("useGetUserResourceLimits", true);
        this.getUserResourceLimits.addLongIdentifier("use-get-user-resource-limits", true);
        this.getUserResourceLimits.addLongIdentifier("useGetUserResourceLimitsControl", true);
        this.getUserResourceLimits.addLongIdentifier("use-get-user-resource-limits-control", true);
        this.getUserResourceLimits.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.getUserResourceLimits);
        this.deleteControl = new ControlArgument(Character.valueOf('J'), "deleteControl", false, 0, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_DELETE_CONTROL.get());
        this.deleteControl.addLongIdentifier("delete-control", true);
        this.deleteControl.addLongIdentifier("operationControl", true);
        this.deleteControl.addLongIdentifier("operation-control", true);
        this.deleteControl.addLongIdentifier("control", true);
        this.deleteControl.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.deleteControl);
        this.bindControl = new ControlArgument(null, "bindControl", false, 0, null, ToolMessages.INFO_LDAPDELETE_ARG_DESC_BIND_CONTROL.get());
        this.bindControl.addLongIdentifier("bind-control", true);
        this.bindControl.setArgumentGroupName(argGroupControls);
        parser.addArgument(this.bindControl);
        parser.addExclusiveArgumentSet(this.entryDN, this.dnFile, this.deleteEntriesMatchingFilter, this.deleteEntriesMatchingFiltersFromFile);
        parser.addDependentArgumentSet(this.searchBaseDN, this.deleteEntriesMatchingFilter, this.deleteEntriesMatchingFiltersFromFile);
        parser.addDependentArgumentSet(this.searchPageSize, this.deleteEntriesMatchingFilter, this.deleteEntriesMatchingFiltersFromFile, this.clientSideSubtreeDelete);
        parser.addExclusiveArgumentSet(this.followReferrals, this.manageDsaIT, new Argument[0]);
        parser.addExclusiveArgumentSet(this.clientSideSubtreeDelete, this.serverSideSubtreeDelete, new Argument[0]);
        parser.addExclusiveArgumentSet(this.clientSideSubtreeDelete, this.followReferrals, new Argument[0]);
        parser.addExclusiveArgumentSet(this.clientSideSubtreeDelete, this.preReadAttribute, new Argument[0]);
        parser.addExclusiveArgumentSet(this.clientSideSubtreeDelete, this.getBackendSetID, new Argument[0]);
        parser.addExclusiveArgumentSet(this.clientSideSubtreeDelete, this.getServerID, new Argument[0]);
        parser.addExclusiveArgumentSet(this.clientSideSubtreeDelete, this.noOperation, new Argument[0]);
        parser.addExclusiveArgumentSet(this.clientSideSubtreeDelete, this.dryRun, new Argument[0]);
        parser.addExclusiveArgumentSet(this.softDelete, this.hardDelete, new Argument[0]);
    }

    @Override
    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
        if (!this.parser.getTrailingArguments().isEmpty()) {
            for (Argument a : Arrays.asList(this.entryDN, this.dnFile, this.deleteEntriesMatchingFilter, this.deleteEntriesMatchingFiltersFromFile)) {
                if (!a.isPresent()) continue;
                throw new ArgumentException(ToolMessages.ERR_LDAPDELETE_TRAILING_ARG_CONFLICT.get(a.getIdentifierString()));
            }
        }
        if (this.routeToBackendSet.isPresent()) {
            List<String> values = this.routeToBackendSet.getValues();
            LinkedHashMap<String, ArrayList<String>> idsByRP = new LinkedHashMap<String, ArrayList<String>>(StaticUtils.computeMapCapacity(values.size()));
            for (String string : values) {
                int colonPos = string.indexOf(58);
                if (colonPos <= 0) {
                    throw new ArgumentException(ToolMessages.ERR_LDAPDELETE_ROUTE_TO_BACKEND_SET_INVALID_FORMAT.get(string, this.routeToBackendSet.getIdentifierString()));
                }
                String rpID = string.substring(0, colonPos);
                String bsID = string.substring(colonPos + 1);
                ArrayList<String> idsForRP = (ArrayList<String>)idsByRP.get(rpID);
                if (idsForRP == null) {
                    idsForRP = new ArrayList<String>(values.size());
                    idsByRP.put(rpID, idsForRP);
                }
                idsForRP.add(bsID);
            }
            for (Map.Entry entry : idsByRP.entrySet()) {
                String rpID = (String)entry.getKey();
                List bsIDs = (List)entry.getValue();
                this.routeToBackendSetRequestControls.add(RouteToBackendSetRequestControl.createAbsoluteRoutingRequest(true, rpID, bsIDs));
            }
        }
    }

    @Override
    @NotNull
    protected List<Control> getBindControls() {
        ArrayList<Control> bindControls = new ArrayList<Control>(10);
        if (this.bindControl.isPresent()) {
            bindControls.addAll(this.bindControl.getValues());
        }
        if (this.authorizationIdentity.isPresent()) {
            bindControls.add(new AuthorizationIdentityRequestControl(true));
        }
        if (this.getAuthorizationEntryAttribute.isPresent()) {
            bindControls.add(new GetAuthorizationEntryRequestControl(true, true, this.getAuthorizationEntryAttribute.getValues()));
        }
        if (this.getUserResourceLimits.isPresent()) {
            bindControls.add(new GetUserResourceLimitsRequestControl(true));
        }
        return bindControls;
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    @Override
    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(true);
        options.setFollowReferrals(this.followReferrals.isPresent());
        options.setUnsolicitedNotificationHandler(this);
        options.setResponseTimeoutMillis(0L);
        return options;
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        Charset charset;
        char[] encryptionPassphrase;
        this.searchControls = this.getSearchControls();
        this.deleteControls = this.getDeleteControls();
        if (this.ratePerSecond.isPresent()) {
            this.deleteRateLimiter = new FixedRateBarrier(1000L, this.ratePerSecond.getValue());
        }
        if (this.clientSideSubtreeDelete.isPresent()) {
            this.subtreeDeleter = new SubtreeDeleter();
            this.subtreeDeleter.setAdditionalSearchControls(this.searchControls);
            this.subtreeDeleter.setAdditionalSearchControls(this.deleteControls);
            this.subtreeDeleter.setDeleteRateLimiter(this.deleteRateLimiter);
            if (this.searchPageSize.isPresent()) {
                this.subtreeDeleter.setSimplePagedResultsPageSize(this.searchPageSize.getValue());
            }
        }
        if (this.encryptionPassphraseFile.isPresent()) {
            try {
                encryptionPassphrase = this.getPasswordFileReader().readPassword(this.encryptionPassphraseFile.getValue());
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.commentToErr(e.getMessage());
                return e.getResultCode();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.commentToErr(ToolMessages.ERR_LDAPDELETE_CANNOT_READ_ENCRYPTION_PW_FILE.get(this.encryptionPassphraseFile.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                return ResultCode.LOCAL_ERROR;
            }
        } else {
            encryptionPassphrase = null;
        }
        try {
            charset = Charset.forName(this.characterSet.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.commentToErr(ToolMessages.ERR_LDAPDELETE_UNSUPPORTED_CHARSET.get(this.characterSet.getValue()));
            return ResultCode.PARAM_ERROR;
        }
        StartAdministrativeSessionPostConnectProcessor p = this.useAdministrativeSession.isPresent() ? new StartAdministrativeSessionPostConnectProcessor(new StartAdministrativeSessionExtendedRequest(this.getToolName(), true, new Control[0])) : null;
        try {
            this.connectionPool = this.getConnectionPool(1, 2, 0, p, null, true, new ReportBindResultLDAPConnectionPoolHealthCheck(this, true, this.verbose.isPresent()));
            this.connectionPool.setRetryFailedOperationsDueToInvalidConnections(!this.neverRetry.isPresent());
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            if (e.getResultCode() != ResultCode.INVALID_CREDENTIALS) {
                for (String line : ResultUtils.formatResult(e, true, 0, WRAP_COLUMN)) {
                    this.err(line);
                }
            }
            return e.getResultCode();
        }
        AtomicReference<ResultCode> returnCode = new AtomicReference<ResultCode>();
        if (this.entryDN.isPresent()) {
            this.deleteFromEntryDNArgument(returnCode);
        } else if (this.dnFile.isPresent()) {
            this.deleteFromDNFile(returnCode, charset, encryptionPassphrase);
        } else if (this.deleteEntriesMatchingFilter.isPresent()) {
            this.deleteFromFilters(returnCode);
        } else if (this.deleteEntriesMatchingFiltersFromFile.isPresent()) {
            this.deleteFromFilterFile(returnCode, charset, encryptionPassphrase);
        } else if (!this.parser.getTrailingArguments().isEmpty()) {
            this.deleteFromTrailingArguments(returnCode);
        } else {
            this.deleteFromStandardInput(returnCode, charset, encryptionPassphrase);
        }
        LDIFWriter rw = this.rejectWriter.get();
        if (rw != null) {
            try {
                rw.close();
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.commentToErr(ToolMessages.ERR_LDAPDELETE_ERROR_CLOSING_REJECT_WRITER.get(this.rejectFile.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                returnCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
            }
        }
        this.connectionPool.close();
        returnCode.compareAndSet(null, ResultCode.SUCCESS);
        return returnCode.get();
    }

    private void deleteFromEntryDNArgument(@NotNull AtomicReference<ResultCode> returnCode) {
        for (DN dn : this.entryDN.getValues()) {
            if (this.deleteEntry(dn.toString(), returnCode) || this.continueOnError.isPresent()) continue;
            return;
        }
    }

    private void deleteFromDNFile(@NotNull AtomicReference<ResultCode> returnCode, @NotNull Charset charset, @Nullable char[] encryptionPassphrase) {
        ArrayList<char[]> potentialPassphrases = new ArrayList<char[]>(this.dnFile.getValues().size());
        if (encryptionPassphrase != null) {
            potentialPassphrases.add(encryptionPassphrase);
        }
        for (File f : this.dnFile.getValues()) {
            if (this.verbose.isPresent()) {
                this.commentToOut(ToolMessages.INFO_LDAPDELETE_READING_DNS_FROM_FILE.get(f.getAbsolutePath()));
                this.out(new Object[0]);
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                Throwable throwable = null;
                try {
                    if (this.deleteDNsFromInputStream(returnCode, fis, charset, potentialPassphrases) || this.continueOnError.isPresent()) continue;
                    return;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    fis.close();
                }
            }
            catch (Exception e) {
                this.commentToErr(ToolMessages.ERR_LDAPDELETE_ERROR_OPENING_DN_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                if (this.continueOnError.isPresent()) continue;
                return;
            }
        }
    }

    private boolean deleteDNsFromInputStream(@NotNull AtomicReference<ResultCode> returnCode, @NotNull InputStream inputStream, @NotNull Charset charset, @NotNull List<char[]> potentialPassphrases) throws IOException, GeneralSecurityException {
        boolean successful = true;
        long lineNumber = 0L;
        BufferedReader reader = this.getBufferedReader(inputStream, charset, potentialPassphrases);
        while (true) {
            String line = reader.readLine();
            ++lineNumber;
            if (line == null) {
                return successful;
            }
            if (line.isEmpty() || line.startsWith("#") || this.deleteDNFromInputStream(returnCode, line)) continue;
            if (!this.continueOnError.isPresent()) break;
            successful = false;
        }
        return false;
    }

    private boolean deleteDNFromInputStream(@NotNull AtomicReference<ResultCode> returnCode, @NotNull String rawString) {
        String lowerString = StaticUtils.toLowerCase(rawString);
        if (lowerString.startsWith("dn::")) {
            String base64DecodedDN;
            String base64EncodedDN = rawString.substring(4).trim();
            if (base64EncodedDN.isEmpty()) {
                returnCode.compareAndSet(null, ResultCode.PARAM_ERROR);
                this.commentToErr(ToolMessages.ERR_LDAPDELETE_BASE64_DN_EMPTY.get(rawString));
                return false;
            }
            try {
                base64DecodedDN = Base64.decodeToString(base64EncodedDN);
            }
            catch (Exception e) {
                Debug.debugException(e);
                returnCode.compareAndSet(null, ResultCode.PARAM_ERROR);
                this.commentToErr(ToolMessages.ERR_LDAPDELETE_BASE64_DN_NOT_BASE64.get(rawString));
                return false;
            }
            return this.deleteEntry(base64DecodedDN, returnCode);
        }
        if (lowerString.startsWith("dn:")) {
            String dn = rawString.substring(3).trim();
            if (dn.isEmpty()) {
                returnCode.compareAndSet(null, ResultCode.PARAM_ERROR);
                this.commentToErr(ToolMessages.ERR_LDAPDELETE_DN_EMPTY.get(rawString));
                return false;
            }
            return this.deleteEntry(dn, returnCode);
        }
        return this.deleteEntry(rawString, returnCode);
    }

    @NotNull
    private BufferedReader getBufferedReader(@NotNull InputStream inputStream, @NotNull Charset charset, @NotNull List<char[]> potentialPassphrases) throws IOException, GeneralSecurityException {
        ObjectPair<InputStream, char[]> decryptedInputStreamData = ToolUtils.getPossiblyPassphraseEncryptedInputStream(inputStream, potentialPassphrases, !this.encryptionPassphraseFile.isPresent(), (CharSequence)ToolMessages.INFO_LDAPDELETE_ENCRYPTION_PASSPHRASE_PROMPT.get(), (CharSequence)ToolMessages.ERR_LDAPDELETE_ENCRYPTION_PASSPHRASE_ERROR.get(), this.getOut(), this.getErr());
        InputStream decryptedInputStream = decryptedInputStreamData.getFirst();
        char[] passphrase = decryptedInputStreamData.getSecond();
        if (passphrase != null) {
            boolean isExistingPassphrase = false;
            for (char[] existingPassphrase : potentialPassphrases) {
                if (!Arrays.equals(passphrase, existingPassphrase)) continue;
                isExistingPassphrase = true;
                break;
            }
            if (!isExistingPassphrase) {
                potentialPassphrases.add(passphrase);
            }
        }
        InputStream decompressedInputStream = ToolUtils.getPossiblyGZIPCompressedInputStream(decryptedInputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(decompressedInputStream, charset);
        return new BufferedReader(inputStreamReader);
    }

    private void deleteFromFilters(@NotNull AtomicReference<ResultCode> returnCode) {
        for (Filter f : this.deleteEntriesMatchingFilter.getValues()) {
            if (this.searchAndDelete(f.toString(), returnCode) || this.continueOnError.isPresent()) continue;
            return;
        }
    }

    private void deleteFromFilterFile(@NotNull AtomicReference<ResultCode> returnCode, @NotNull Charset charset, @Nullable char[] encryptionPassphrase) {
        ArrayList<char[]> potentialPassphrases = new ArrayList<char[]>(this.dnFile.getValues().size());
        if (encryptionPassphrase != null) {
            potentialPassphrases.add(encryptionPassphrase);
        }
        for (File f : this.deleteEntriesMatchingFiltersFromFile.getValues()) {
            if (this.verbose.isPresent()) {
                this.commentToOut(ToolMessages.INFO_LDAPDELETE_READING_FILTERS_FROM_FILE.get(f.getAbsolutePath()));
                this.out(new Object[0]);
            }
            try {
                FileInputStream fis = new FileInputStream(f);
                Throwable throwable = null;
                try {
                    BufferedReader reader = this.getBufferedReader(fis, charset, potentialPassphrases);
                    Throwable throwable2 = null;
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (line.isEmpty() || line.startsWith("#")) continue;
                            if (this.searchAndDelete(line, returnCode) || this.continueOnError.isPresent()) continue;
                            return;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable2 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    fis.close();
                }
            }
            catch (IOException | GeneralSecurityException e) {
                this.commentToErr(ToolMessages.ERR_LDAPDELETE_ERROR_READING_FILTER_FILE.get(f.getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                if (this.continueOnError.isPresent()) continue;
                return;
            }
        }
    }

    private boolean searchAndDelete(@NotNull String filterString, @NotNull AtomicReference<ResultCode> returnCode) {
        boolean successful = true;
        AtomicLong entriesDeleted = new AtomicLong(0L);
        for (DN baseDN : this.searchBaseDN.getValues()) {
            if (this.searchPageSize.isPresent()) {
                successful &= this.doPagedSearchAndDelete(baseDN.toString(), filterString, returnCode, entriesDeleted);
                continue;
            }
            successful &= this.doNonPagedSearchAndDelete(baseDN.toString(), filterString, returnCode, entriesDeleted);
        }
        if (successful && entriesDeleted.get() == 0L) {
            this.commentToErr(ToolMessages.ERR_LDAPDELETE_SEARCH_RETURNED_NO_ENTRIES.get(filterString));
            returnCode.compareAndSet(null, ResultCode.NO_RESULTS_RETURNED);
            successful = false;
        }
        return successful;
    }

    private boolean doPagedSearchAndDelete(@NotNull String baseDN, @NotNull String filterString, @NotNull AtomicReference<ResultCode> returnCode, @NotNull AtomicLong entriesDeleted) {
        ASN1OctetString cookie = null;
        TreeSet<DN> matchingEntryDNs = new TreeSet<DN>();
        LDAPDeleteSearchListener searchListener = new LDAPDeleteSearchListener(this, matchingEntryDNs, baseDN, filterString, returnCode);
        block2: while (true) {
            try {
                while (true) {
                    SimplePagedResultsControl responseControl;
                    ArrayList<Control> requestControls = new ArrayList<Control>(10);
                    requestControls.addAll(this.searchControls);
                    requestControls.add(new SimplePagedResultsControl(this.searchPageSize.getValue(), cookie, true));
                    SearchRequest searchRequest = new SearchRequest((SearchResultListener)searchListener, baseDN, SearchScope.SUB, DereferencePolicy.NEVER, 0, 0, false, filterString, "1.1");
                    searchRequest.setControls(requestControls);
                    if (this.verbose.isPresent()) {
                        this.commentToOut(ToolMessages.INFO_LDAPDELETE_ISSUING_SEARCH_REQUEST.get(String.valueOf(searchRequest)));
                    }
                    SearchResult searchResult = this.connectionPool.search(searchRequest);
                    if (this.verbose.isPresent()) {
                        this.commentToOut(ToolMessages.INFO_LDAPDELETE_RECEIVED_SEARCH_RESULT.get(String.valueOf(searchResult)));
                    }
                    if ((responseControl = SimplePagedResultsControl.get(searchResult)) == null) {
                        throw new LDAPException(ResultCode.CONTROL_NOT_FOUND, ToolMessages.ERR_LDAPDELETE_MISSING_PAGED_RESULTS_RESPONSE.get(searchResult));
                    }
                    if (!responseControl.moreResultsToReturn()) break block2;
                    cookie = responseControl.getCookie();
                }
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                returnCode.compareAndSet(null, e.getResultCode());
                this.commentToErr(ToolMessages.ERR_LDAPDELETE_SEARCH_ERROR.get(baseDN, filterString, String.valueOf(e.getResultCode()), e.getMessage()));
                continue;
            }
            break;
        }
        boolean allSuccessful = true;
        Iterator<DN> iterator = matchingEntryDNs.descendingIterator();
        while (iterator.hasNext()) {
            if (this.deleteEntry(iterator.next().toString(), returnCode)) {
                entriesDeleted.incrementAndGet();
                continue;
            }
            allSuccessful = false;
            if (this.continueOnError.isPresent()) continue;
            break;
        }
        return allSuccessful;
    }

    private boolean doNonPagedSearchAndDelete(@NotNull String baseDN, @NotNull String filterString, @NotNull AtomicReference<ResultCode> returnCode, @NotNull AtomicLong entriesDeleted) {
        TreeSet<DN> matchingEntryDNs = new TreeSet<DN>();
        LDAPDeleteSearchListener searchListener = new LDAPDeleteSearchListener(this, matchingEntryDNs, baseDN, filterString, returnCode);
        try {
            SearchRequest searchRequest = new SearchRequest((SearchResultListener)searchListener, baseDN, SearchScope.SUB, DereferencePolicy.NEVER, 0, 0, false, filterString, "1.1");
            searchRequest.setControls(this.searchControls);
            if (this.verbose.isPresent()) {
                this.commentToOut(ToolMessages.INFO_LDAPDELETE_ISSUING_SEARCH_REQUEST.get(String.valueOf(searchRequest)));
            }
            SearchResult searchResult = this.connectionPool.search(searchRequest);
            if (this.verbose.isPresent()) {
                this.commentToOut(ToolMessages.INFO_LDAPDELETE_RECEIVED_SEARCH_RESULT.get(String.valueOf(searchResult)));
            }
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            returnCode.compareAndSet(null, e.getResultCode());
            this.commentToErr(ToolMessages.ERR_LDAPDELETE_SEARCH_ERROR.get(baseDN, filterString, String.valueOf(e.getResultCode()), e.getMessage()));
        }
        boolean allSuccessful = true;
        Iterator<DN> iterator = matchingEntryDNs.descendingIterator();
        while (iterator.hasNext()) {
            if (this.deleteEntry(iterator.next().toString(), returnCode)) {
                entriesDeleted.incrementAndGet();
                continue;
            }
            allSuccessful = false;
            if (this.continueOnError.isPresent()) continue;
            break;
        }
        return allSuccessful;
    }

    private void deleteFromTrailingArguments(@NotNull AtomicReference<ResultCode> returnCode) {
        for (String dn : this.parser.getTrailingArguments()) {
            if (this.deleteEntry(dn, returnCode) || this.continueOnError.isPresent()) continue;
            return;
        }
    }

    private void deleteFromStandardInput(@NotNull AtomicReference<ResultCode> returnCode, @NotNull Charset charset, @Nullable char[] encryptionPassphrase) {
        ArrayList<char[]> potentialPassphrases = new ArrayList<char[]>(1);
        if (encryptionPassphrase != null) {
            potentialPassphrases.add(encryptionPassphrase);
        }
        this.commentToOut(ToolMessages.INFO_LDAPDELETE_READING_FROM_STDIN.get());
        this.out(new Object[0]);
        try {
            this.deleteDNsFromInputStream(returnCode, this.in, charset, potentialPassphrases);
        }
        catch (Exception e) {
            Debug.debugException(e);
            returnCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
            this.commentToErr(ToolMessages.ERR_LDAPDELETE_ERROR_READING_STDIN.get(StaticUtils.getExceptionMessage(e)));
        }
    }

    private boolean deleteEntry(@NotNull String dn, @NotNull AtomicReference<ResultCode> returnCode) {
        SubtreeDeleterResult subtreeDeleterResult;
        if (this.subtreeDeleter == null) {
            this.commentToOut(ToolMessages.INFO_LDAPDELETE_DELETING_ENTRY.get(dn));
        } else {
            this.commentToOut(ToolMessages.INFO_LDAPDELETE_CLIENT_SIDE_SUBTREE_DELETING.get(dn));
        }
        if (this.dryRun.isPresent()) {
            this.commentToOut(ToolMessages.INFO_LDAPDELETE_NOT_DELETING_BECAUSE_OF_DRY_RUN.get(dn));
            return true;
        }
        if (this.subtreeDeleter == null) {
            boolean successlful;
            LDAPResult deleteResult;
            if (this.deleteRateLimiter != null) {
                this.deleteRateLimiter.await();
            }
            DeleteRequest deleteRequest = new DeleteRequest(dn);
            deleteRequest.setControls(this.deleteControls);
            try {
                if (this.verbose.isPresent()) {
                    this.commentToOut(ToolMessages.INFO_LDAPDELETE_SENDING_DELETE_REQUEST.get(String.valueOf(deleteRequest)));
                }
                deleteResult = this.connectionPool.delete(deleteRequest);
                successlful = true;
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                deleteResult = e.toLDAPResult();
                successlful = false;
            }
            for (String resultLine : ResultUtils.formatResult(deleteResult, true, 0, WRAP_COLUMN)) {
                if (successlful) {
                    this.out(resultLine);
                    continue;
                }
                this.err(resultLine);
            }
            ResultCode deleteResultCode = deleteResult.getResultCode();
            if (deleteResultCode != ResultCode.SUCCESS && deleteResultCode != ResultCode.NO_OPERATION) {
                returnCode.compareAndSet(null, deleteResultCode);
                this.writeToRejects(deleteRequest, deleteResult);
                this.err(new Object[0]);
                return false;
            }
            this.out(new Object[0]);
            return true;
        }
        try {
            subtreeDeleterResult = this.subtreeDeleter.delete((LDAPInterface)this.connectionPool, dn);
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            this.commentToErr(e.getMessage());
            this.writeToRejects(new DeleteRequest(dn), e.toLDAPResult());
            returnCode.compareAndSet(null, e.getResultCode());
            return false;
        }
        if (subtreeDeleterResult.completelySuccessful()) {
            long entriesDeleted = subtreeDeleterResult.getEntriesDeleted();
            if (entriesDeleted == 0L) {
                DeleteRequest deleteRequest = new DeleteRequest(dn);
                LDAPResult result = new LDAPResult(-1, ResultCode.NO_SUCH_OBJECT, ToolMessages.ERR_LDAPDELETE_CLIENT_SIDE_SUBTREE_DEL_NO_BASE_ENTRY.get(dn), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
                for (String line : ResultUtils.formatResult(result, true, 0, WRAP_COLUMN)) {
                    this.err(line);
                }
                this.writeToRejects(deleteRequest, result);
                returnCode.compareAndSet(null, ResultCode.NO_SUCH_OBJECT);
                this.err(new Object[0]);
                return false;
            }
            if (entriesDeleted == 1L) {
                this.commentToOut(ToolMessages.INFO_LDAPDELETE_CLIENT_SIDE_SUBTREE_DEL_ONLY_BASE.get(dn));
                this.out(new Object[0]);
                return true;
            }
            long numSubordinates = entriesDeleted - 1L;
            this.commentToOut(ToolMessages.INFO_LDAPDELETE_CLIENT_SIDE_SUBTREE_DEL_WITH_SUBS.get(dn, numSubordinates));
            this.out(new Object[0]);
            return true;
        }
        this.commentToErr(ToolMessages.ERR_LDAPDELETE_CLIENT_SIDE_SUBTREE_DEL_FAILED.get());
        this.err(new Object[0]);
        SearchResult searchError = subtreeDeleterResult.getSearchError();
        if (searchError != null) {
            returnCode.compareAndSet(null, searchError.getResultCode());
            this.commentToErr(ToolMessages.ERR_LDAPDELETE_CLIENT_SIDE_SUBTREE_DEL_SEARCH_ERROR.get(dn));
            for (String line : ResultUtils.formatResult(searchError, true, 0, WRAP_COLUMN)) {
                this.err(line);
            }
            this.err(new Object[0]);
        }
        for (Map.Entry<DN, LDAPResult> deleteError : subtreeDeleterResult.getDeleteErrorsDescendingMap().entrySet()) {
            String failureDN = deleteError.getKey().toString();
            LDAPResult failureResult = deleteError.getValue();
            returnCode.compareAndSet(null, failureResult.getResultCode());
            this.commentToErr(ToolMessages.ERR_LDAPDELETE_CLIENT_SIDE_SUBTREE_DEL_DEL_ERROR.get(failureDN, dn));
            this.writeToRejects(new DeleteRequest(failureDN), failureResult);
            for (String line : ResultUtils.formatResult(failureResult, true, 0, WRAP_COLUMN)) {
                this.err(line);
            }
            this.err(new Object[0]);
        }
        return false;
    }

    private void writeToRejects(@NotNull DeleteRequest deleteRequest, @NotNull LDAPResult deleteResult) {
        LDIFWriter w;
        if (!this.rejectFile.isPresent()) {
            return;
        }
        try {
            w = this.rejectWriter.get();
            if (w == null) {
                w = new LDIFWriter(this.rejectFile.getValue());
                this.rejectWriter.set(w);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.commentToErr(ToolMessages.ERR_LDAPDELETE_WRITE_TO_REJECTS_FAILED.get(StaticUtils.getExceptionMessage(e)));
            return;
        }
        try {
            boolean firstLine = true;
            for (String commentLine : ResultUtils.formatResult(deleteResult, false, 0, WRAP_COLUMN - 2)) {
                w.writeComment(commentLine, firstLine, false);
                firstLine = false;
            }
            w.writeChangeRecord(deleteRequest.toLDIFChangeRecord());
            w.flush();
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.commentToErr(ToolMessages.ERR_LDAPDELETE_WRITE_TO_REJECTS_FAILED.get(StaticUtils.getExceptionMessage(e)));
        }
    }

    @NotNull
    private List<Control> getDeleteControls() {
        ArrayList<Control> controlList = new ArrayList<Control>(10);
        if (this.deleteControl.isPresent()) {
            controlList.addAll(this.deleteControl.getValues());
        }
        controlList.addAll(this.routeToBackendSetRequestControls);
        if (this.serverSideSubtreeDelete.isPresent()) {
            controlList.add(new SubtreeDeleteRequestControl(true));
        }
        if (this.softDelete.isPresent()) {
            controlList.add(new SoftDeleteRequestControl(true, true));
        }
        if (this.hardDelete.isPresent() && !this.clientSideSubtreeDelete.isPresent()) {
            controlList.add(new HardDeleteRequestControl(true));
        }
        if (this.proxyAs.isPresent()) {
            controlList.add(new ProxiedAuthorizationV2RequestControl(this.proxyAs.getValue()));
        }
        if (this.proxyV1As.isPresent()) {
            controlList.add(new ProxiedAuthorizationV1RequestControl(this.proxyV1As.getValue().toString()));
        }
        if (this.manageDsaIT.isPresent() && !this.clientSideSubtreeDelete.isPresent()) {
            controlList.add(new ManageDsaITRequestControl(true));
        }
        if (this.assertionFilter.isPresent()) {
            controlList.add(new AssertionRequestControl(this.assertionFilter.getValue(), true));
        }
        if (this.preReadAttribute.isPresent()) {
            controlList.add(new PreReadRequestControl(true, this.preReadAttribute.getValues().toArray(StaticUtils.NO_STRINGS)));
        }
        if (this.noOperation.isPresent()) {
            controlList.add(new NoOpRequestControl());
        }
        if (this.getBackendSetID.isPresent()) {
            controlList.add(new GetBackendSetIDRequestControl(true));
        }
        if (this.getServerID.isPresent()) {
            controlList.add(new GetServerIDRequestControl(true));
        }
        if (this.routeToServer.isPresent()) {
            controlList.add(new RouteToServerRequestControl(true, this.routeToServer.getValue(), false, false, false));
        }
        if (this.useAssuredReplication.isPresent()) {
            AssuredReplicationLocalLevel localLevel = null;
            if (this.assuredReplicationLocalLevel.isPresent()) {
                String level = this.assuredReplicationLocalLevel.getValue();
                if (level.equalsIgnoreCase("none")) {
                    localLevel = AssuredReplicationLocalLevel.NONE;
                } else if (level.equalsIgnoreCase("received-any-server")) {
                    localLevel = AssuredReplicationLocalLevel.RECEIVED_ANY_SERVER;
                } else if (level.equalsIgnoreCase("processed-all-servers")) {
                    localLevel = AssuredReplicationLocalLevel.PROCESSED_ALL_SERVERS;
                }
            }
            AssuredReplicationRemoteLevel remoteLevel = null;
            if (this.assuredReplicationRemoteLevel.isPresent()) {
                String level = this.assuredReplicationRemoteLevel.getValue();
                if (level.equalsIgnoreCase("none")) {
                    remoteLevel = AssuredReplicationRemoteLevel.NONE;
                } else if (level.equalsIgnoreCase("received-any-remote-location")) {
                    remoteLevel = AssuredReplicationRemoteLevel.RECEIVED_ANY_REMOTE_LOCATION;
                } else if (level.equalsIgnoreCase("received-all-remote-locations")) {
                    remoteLevel = AssuredReplicationRemoteLevel.RECEIVED_ALL_REMOTE_LOCATIONS;
                } else if (level.equalsIgnoreCase("processed-all-remote-servers")) {
                    remoteLevel = AssuredReplicationRemoteLevel.PROCESSED_ALL_REMOTE_SERVERS;
                }
            }
            Long timeoutMillis = null;
            if (this.assuredReplicationTimeout.isPresent()) {
                timeoutMillis = this.assuredReplicationTimeout.getValue(TimeUnit.MILLISECONDS);
            }
            AssuredReplicationRequestControl c = new AssuredReplicationRequestControl(true, localLevel, localLevel, remoteLevel, remoteLevel, timeoutMillis, false);
            controlList.add(c);
        }
        if (this.replicationRepair.isPresent()) {
            controlList.add(new ReplicationRepairRequestControl());
        }
        if (this.suppressReferentialIntegrityUpdates.isPresent()) {
            controlList.add(new SuppressReferentialIntegrityUpdatesRequestControl(true));
        }
        if (this.operationPurpose.isPresent()) {
            controlList.add(new OperationPurposeRequestControl(true, "ldapdelete", "5.1.4", LDAPDelete.class.getName() + ".getDeleteControls", this.operationPurpose.getValue()));
        }
        return Collections.unmodifiableList(controlList);
    }

    @NotNull
    private List<Control> getSearchControls() {
        ArrayList<Control> controlList = new ArrayList<Control>(10);
        controlList.addAll(this.routeToBackendSetRequestControls);
        if (this.manageDsaIT.isPresent()) {
            controlList.add(new ManageDsaITRequestControl(true));
        }
        if (this.proxyV1As.isPresent()) {
            controlList.add(new ProxiedAuthorizationV1RequestControl(this.proxyV1As.getValue().toString()));
        }
        if (this.proxyAs.isPresent()) {
            controlList.add(new ProxiedAuthorizationV2RequestControl(this.proxyAs.getValue()));
        }
        if (this.operationPurpose.isPresent()) {
            controlList.add(new OperationPurposeRequestControl(true, "ldapdelete", "5.1.4", LDAPDelete.class.getName() + ".getSearchControls", this.operationPurpose.getValue()));
        }
        if (this.routeToServer.isPresent()) {
            controlList.add(new RouteToServerRequestControl(true, this.routeToServer.getValue(), false, false, false));
        }
        return Collections.unmodifiableList(controlList);
    }

    @Override
    public void handleUnsolicitedNotification(@NotNull LDAPConnection connection, @NotNull ExtendedResult notification) {
        ArrayList<String> lines = new ArrayList<String>(10);
        ResultUtils.formatUnsolicitedNotification(lines, notification, true, 0, WRAP_COLUMN);
        for (String line : lines) {
            this.err(line);
        }
        this.err(new Object[0]);
    }

    void commentToOut(@NotNull String message) {
        for (String line : StaticUtils.wrapLine(message, WRAP_COLUMN - 2)) {
            this.out("# ", line);
        }
    }

    void commentToErr(@NotNull String message) {
        for (String line : StaticUtils.wrapLine(message, WRAP_COLUMN - 2)) {
            this.err("# ", line);
        }
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(4));
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "636", "--useSSL", "--bindDN", "uid=admin,dc=example,dc=com", "uid=test.user,ou=People,dc=example,dc=com"}, ToolMessages.INFO_LDAPDELETE_EXAMPLE_1.get());
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "636", "--useSSL", "--trustStorePath", "trust-store.jks", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPasswordFile", "admin-password.txt", "--dnFile", "dns-to-delete.txt"}, ToolMessages.INFO_LDAPDELETE_EXAMPLE_2.get());
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "389", "--useStartTLS", "--trustStorePath", "trust-store.jks", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPasswordFile", "admin-password.txt", "--deleteEntriesMatchingFilter", "(description=delete)"}, ToolMessages.INFO_LDAPDELETE_EXAMPLE_3.get());
        examples.put(new String[]{"--hostname", "ds.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com"}, ToolMessages.INFO_LDAPDELETE_EXAMPLE_4.get());
        return examples;
    }
}

