/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BouncyCastleFIPSHelper {
    @NotNull
    private static final AtomicReference<Provider> BOUNCY_CASTLE_FIPS_PROVIDER = new AtomicReference();
    @NotNull
    private static final AtomicReference<Provider> BOUNCY_CASTLE_JSSE_PROVIDER = new AtomicReference();
    @NotNull
    public static final String BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_NAME = "org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider";
    @NotNull
    public static final String BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_NAME = "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider";
    @NotNull
    public static final String FIPS_PROVIDER_NAME = "BCFIPS";
    @NotNull
    public static final String JSSE_PROVIDER_NAME = "BCJSSE";
    @NotNull
    public static final String FIPS_KEY_STORE_TYPE = "BCFKS";
    @NotNull
    public static final String DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM = "X.509";
    @NotNull
    public static final String DEFAULT_SSL_CONTEXT_PROTOCOL = "DEFAULT";
    @NotNull
    public static final String DEFAULT_TRUST_MANAGER_FACTORY_ALGORITHM = "PKIX";
    @NotNull
    public static final String PROPERTY_ALLOW_RSA_MULTI_USE = "org.bouncycastle.rsa.allow_multi_use";
    @NotNull
    public static final String PROPERTY_APPROVED_ONLY = "org.bouncycastle.fips.approved_only";
    @NotNull
    public static final String PROPERTY_ENABLE_JKS = "org.bouncycastle.jca.enable_jks";
    @NotNull
    public static final String PROPERTY_ENABLE_LOGGING = BouncyCastleFIPSHelper.class.getName() + ".ENABLE_LOGGING";
    @NotNull
    public static final String PROPERTY_LOG_LEVEL = BouncyCastleFIPSHelper.class.getName() + ".LOG_LEVEL";
    @NotNull
    private static final String LOGGER_NAME = "org.bouncycastle";
    @NotNull
    private static final Logger LOGGER = Logger.getLogger("org.bouncycastle");

    private BouncyCastleFIPSHelper() {
    }

    @NotNull
    public static Provider getBouncyCastleFIPSProvider() throws NoSuchProviderException {
        Provider provider = BOUNCY_CASTLE_FIPS_PROVIDER.get();
        if (provider == null) {
            return BouncyCastleFIPSHelper.loadBouncyCastleFIPSProvider(false);
        }
        return provider;
    }

    @NotNull
    static synchronized Provider loadBouncyCastleFIPSProvider(boolean makeDefault) throws NoSuchProviderException {
        Class<?> providerClass;
        try {
            Provider existingProvider = Security.getProvider(FIPS_PROVIDER_NAME);
            if (existingProvider != null) {
                BOUNCY_CASTLE_FIPS_PROVIDER.compareAndSet(null, existingProvider);
                return existingProvider;
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            providerClass = Class.forName(BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_NAME);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new NoSuchProviderException(UtilityMessages.ERR_BC_FIPS_HELPER_CANNOT_LOAD_FIPS_PROVIDER_CLASS.get(BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_NAME, StaticUtils.getExceptionMessage(e)));
        }
        try {
            Provider provider = (Provider)providerClass.newInstance();
            if (makeDefault) {
                Security.insertProviderAt(provider, 1);
            } else {
                Security.addProvider(provider);
            }
            BOUNCY_CASTLE_FIPS_PROVIDER.set(provider);
            return provider;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new NoSuchProviderException(UtilityMessages.ERR_BC_FIPS_PROVIDER_CANNOT_INSTANTIATE_FIPS_PROVIDER.get(BOUNCY_CASTLE_FIPS_PROVIDER_CLASS_NAME, StaticUtils.getExceptionMessage(e)));
        }
    }

    @NotNull
    public static Provider getBouncyCastleJSSEProvider() throws NoSuchProviderException {
        Provider provider = BOUNCY_CASTLE_JSSE_PROVIDER.get();
        if (provider == null) {
            return BouncyCastleFIPSHelper.loadBouncyCastleJSSEProvider(false);
        }
        return provider;
    }

    @NotNull
    static synchronized Provider loadBouncyCastleJSSEProvider(boolean makeSecond) throws NoSuchProviderException {
        Class<?> providerClass;
        try {
            Provider existingProvider = Security.getProvider(JSSE_PROVIDER_NAME);
            if (existingProvider != null) {
                BOUNCY_CASTLE_JSSE_PROVIDER.compareAndSet(null, existingProvider);
                return existingProvider;
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            providerClass = Class.forName(BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_NAME);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new NoSuchProviderException(UtilityMessages.ERR_BC_FIPS_HELPER_CANNOT_LOAD_JSSE_PROVIDER_CLASS.get(BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_NAME, StaticUtils.getExceptionMessage(e)));
        }
        try {
            Provider provider = (Provider)providerClass.newInstance();
            if (makeSecond) {
                Security.insertProviderAt(provider, 2);
            } else {
                Security.addProvider(provider);
            }
            BOUNCY_CASTLE_JSSE_PROVIDER.set(provider);
            return provider;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new NoSuchProviderException(UtilityMessages.ERR_BC_FIPS_PROVIDER_CANNOT_INSTANTIATE_JSSE_PROVIDER.get(BOUNCY_CASTLE_JSSE_PROVIDER_CLASS_NAME, StaticUtils.getExceptionMessage(e)));
        }
    }

    public static void disableLogging() {
        StaticUtils.setLoggerLevel(LOGGER, Level.OFF);
        LOGGER.setUseParentHandlers(false);
    }

    @NotNull
    public static Logger enableLogging(@Nullable Level level) {
        StaticUtils.setLoggerLevel(LOGGER, level == null ? Level.INFO : level);
        return LOGGER;
    }

    static {
        LOGGER.setUseParentHandlers(false);
        String enabledPropertyValue = StaticUtils.getSystemProperty(PROPERTY_ENABLE_LOGGING);
        if ("true".equalsIgnoreCase(enabledPropertyValue)) {
            Level level = Level.INFO;
            String levelPropertyValue = StaticUtils.getSystemProperty(PROPERTY_LOG_LEVEL);
            if (levelPropertyValue != null) {
                switch (StaticUtils.toUpperCase(levelPropertyValue)) {
                    case "SEVERE": {
                        level = Level.SEVERE;
                        break;
                    }
                    case "WARNING": {
                        level = Level.WARNING;
                        break;
                    }
                    case "INFO": {
                        level = Level.INFO;
                        break;
                    }
                    case "CONFIG": {
                        level = Level.CONFIG;
                        break;
                    }
                    case "FINE": {
                        level = Level.FINE;
                        break;
                    }
                    case "FINER": {
                        level = Level.FINER;
                        break;
                    }
                    case "FINEST": {
                        level = Level.FINEST;
                        break;
                    }
                    case "ALL": {
                        level = Level.ALL;
                        break;
                    }
                    case "OFF": {
                        level = Level.OFF;
                        break;
                    }
                    default: {
                        Validator.violation("Unsupported " + PROPERTY_LOG_LEVEL + " property value '" + levelPropertyValue + "'.");
                    }
                }
            }
            StaticUtils.setLoggerLevel(LOGGER, level);
        } else {
            StaticUtils.setLoggerLevel(LOGGER, Level.OFF);
        }
    }
}

