/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.BouncyCastleFIPSHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.TLSCipherSuiteSelector;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class CryptoHelper {
    @NotNull
    public static final String PROPERTY_FIPS_MODE = "com.unboundid.crypto.FIPS_MODE";
    @NotNull
    public static final String PROPERTY_REMOVE_NON_NECESSARY_PROVIDERS = "com.unboundid.crypto.REMOVE_NON_ESSENTIAL_PROVIDERS";
    @NotNull
    private static final Set<String> ESSENTIAL_PROVIDERS_TO_PRESERVE = StaticUtils.setOf("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider", "org.bouncycastle.jsse.provider.BouncyCastleJsseProvider", "com.sun.net.ssl.internal.ssl.Provider", "sun.security.provider.Sun", "sun.security.jgss.SunProvider", "com.sun.security.sasl.Provider", "sun.security.provider.certpath.ldap.JdkLDAP", "com.sun.security.sasl.gsskerb.JdkSASL", "sun.security.pkcs11.SunPKCS11", "com.ibm.security.jgss.IBMJGSSProvider", "com.ibm.security.sasl.IBMSASL");
    @NotNull
    private static final AtomicBoolean FIPS_MODE;
    @NotNull
    public static final String KEY_STORE_TYPE_BCFKS = "BCFKS";
    @NotNull
    public static final String KEY_STORE_TYPE_JKS = "JKS";
    @NotNull
    public static final String KEY_STORE_TYPE_PKCS_11 = "PKCS11";
    @NotNull
    public static final String KEY_STORE_TYPE_PKCS_12 = "PKCS12";
    @NotNull
    public static final String PROPERTY_DEFAULT_KEY_STORE_TYPE = "com.unboundid.crypto.DEFAULT_KEY_STORE_TYPE";
    @NotNull
    private static final AtomicReference<String> DEFAULT_KEY_STORE_TYPE;
    @NotNull
    private static final String SECURE_RANDOM_SERVICE_TYPE = "SecureRandom";
    @Nullable
    private static final Provider NULL_PROVIDER;

    private CryptoHelper() {
    }

    public static boolean usingFIPSMode() {
        return FIPS_MODE.get();
    }

    public static void setUseFIPSMode(boolean useFIPSMode) throws NoSuchProviderException {
        if (useFIPSMode) {
            BouncyCastleFIPSHelper.loadBouncyCastleFIPSProvider(true);
            BouncyCastleFIPSHelper.loadBouncyCastleJSSEProvider(true);
        }
        FIPS_MODE.set(useFIPSMode);
        TLSCipherSuiteSelector.recompute();
    }

    public static void removeNonEssentialSecurityProviders() {
        for (Provider provider : Security.getProviders()) {
            if (ESSENTIAL_PROVIDERS_TO_PRESERVE.contains(provider.getClass().getName())) continue;
            Security.removeProvider(provider.getName());
        }
    }

    @NotNull
    public static CertificateFactory getCertificateFactory(@NotNull String type) throws CertificateException {
        return CryptoHelper.getCertificateFactory(type, NULL_PROVIDER);
    }

    @NotNull
    public static CertificateFactory getCertificateFactory(@NotNull String type, @Nullable String providerName) throws CertificateException, NoSuchProviderException {
        return CryptoHelper.getCertificateFactory(type, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static CertificateFactory getCertificateFactory(@NotNull String type, @Nullable Provider provider) throws CertificateException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return CertificateFactory.getInstance(type, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new CertificateException(e.getMessage(), e);
                }
            }
            return CertificateFactory.getInstance(type);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new CertificateException(UtilityMessages.ERR_CRYPTO_HELPER_GET_CERT_FACTORY_WRONG_PROVIDER_FOR_FIPS_MODE.get(type, providerName, "BCFIPS"));
        }
        return CertificateFactory.getInstance(type, provider);
    }

    @NotNull
    public static Cipher getCipher(@NotNull String cipherTransformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        return CryptoHelper.getCipher(cipherTransformation, NULL_PROVIDER);
    }

    @NotNull
    public static Cipher getCipher(@NotNull String cipherTransformation, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        return CryptoHelper.getCipher(cipherTransformation, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static Cipher getCipher(@NotNull String cipherTransformation, @Nullable Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return Cipher.getInstance(cipherTransformation, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return Cipher.getInstance(cipherTransformation);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_CIPHER_WRONG_PROVIDER_FOR_FIPS_MODE.get(cipherTransformation, providerName, "BCFIPS"));
        }
        return Cipher.getInstance(cipherTransformation, provider);
    }

    @NotNull
    public static KeyFactory getKeyFactory(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getKeyFactory(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static KeyFactory getKeyFactory(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getKeyFactory(algorithmName, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static KeyFactory getKeyFactory(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return KeyFactory.getInstance(algorithmName, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return KeyFactory.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KEY_FACTORY_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerName, "BCFIPS"));
        }
        return KeyFactory.getInstance(algorithmName, provider);
    }

    @NotNull
    public static KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException {
        if (CryptoHelper.usingFIPSMode()) {
            try {
                return KeyManagerFactory.getInstance("X.509", BouncyCastleFIPSHelper.getBouncyCastleJSSEProvider());
            }
            catch (NoSuchProviderException e) {
                Debug.debugException(e);
                throw new NoSuchAlgorithmException(e.getMessage(), e);
            }
        }
        return CryptoHelper.getKeyManagerFactory(KeyManagerFactory.getDefaultAlgorithm());
    }

    @NotNull
    public static KeyManagerFactory getKeyManagerFactory(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getKeyManagerFactory(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static KeyManagerFactory getKeyManagerFactory(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getKeyManagerFactory(algorithmName, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static KeyManagerFactory getKeyManagerFactory(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return KeyManagerFactory.getInstance(algorithmName, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return KeyManagerFactory.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KM_FACTORY_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerName, "BCFIPS"));
        }
        return KeyManagerFactory.getInstance(algorithmName, provider);
    }

    @NotNull
    public static KeyPairGenerator getKeyPairGenerator(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getKeyPairGenerator(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static KeyPairGenerator getKeyPairGenerator(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getKeyPairGenerator(algorithmName, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static KeyPairGenerator getKeyPairGenerator(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return KeyPairGenerator.getInstance(algorithmName, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return KeyPairGenerator.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KP_GEN_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerName, "BCFIPS"));
        }
        return KeyPairGenerator.getInstance(algorithmName, provider);
    }

    @NotNull
    public static String getDefaultKeyStoreType() {
        return DEFAULT_KEY_STORE_TYPE.get();
    }

    public static void setDefaultKeyStoreType(@NotNull String defaultKeyStoreType) {
        DEFAULT_KEY_STORE_TYPE.set(defaultKeyStoreType);
    }

    @NotNull
    public static KeyStore getKeyStore(@NotNull String keyStoreType) throws KeyStoreException {
        return CryptoHelper.getKeyStore(keyStoreType, NULL_PROVIDER);
    }

    @NotNull
    public static KeyStore getKeyStore(@NotNull String keyStoreType, @Nullable String providerName) throws KeyStoreException, NoSuchProviderException {
        return CryptoHelper.getKeyStore(keyStoreType, CryptoHelper.getProvider(providerName, false));
    }

    @NotNull
    public static KeyStore getKeyStore(@NotNull String keyStoreType, @Nullable Provider provider) throws KeyStoreException {
        return CryptoHelper.getKeyStore(keyStoreType, provider, false);
    }

    @NotNull
    public static KeyStore getKeyStore(@NotNull String keyStoreType, @Nullable Provider provider, boolean allowNonFIPSInFIPSMode) throws KeyStoreException {
        if (CryptoHelper.usingFIPSMode() && !allowNonFIPSInFIPSMode && !keyStoreType.equals(KEY_STORE_TYPE_BCFKS) && !keyStoreType.equals(KEY_STORE_TYPE_PKCS_11)) {
            throw new KeyStoreException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KEY_STORE_WRONG_STORE_TYPE_FOR_FIPS_MODE.get(keyStoreType, KEY_STORE_TYPE_BCFKS, KEY_STORE_TYPE_PKCS_11));
        }
        if (provider == null) {
            if (keyStoreType.equals(KEY_STORE_TYPE_BCFKS)) {
                try {
                    return KeyStore.getInstance(keyStoreType, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    throw new KeyStoreException(e.getMessage(), e);
                }
            }
            return KeyStore.getInstance(keyStoreType);
        }
        if (keyStoreType.equals(KEY_STORE_TYPE_BCFKS) && !provider.getName().equals("BCFIPS")) {
            throw new KeyStoreException(UtilityMessages.ERR_CRYPTO_HELPER_GET_KEY_STORE_WRONG_PROVIDER_FOR_STORE_TYPE.get(keyStoreType, provider.getName(), KEY_STORE_TYPE_BCFKS, keyStoreType));
        }
        return KeyStore.getInstance(keyStoreType, provider);
    }

    @NotNull
    public static Mac getMAC(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getMAC(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static Mac getMAC(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getMAC(algorithmName, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static Mac getMAC(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return Mac.getInstance(algorithmName, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return Mac.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_MAC_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerName, "BCFIPS"));
        }
        return Mac.getInstance(algorithmName, provider);
    }

    @NotNull
    public static MessageDigest getMessageDigest(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getMessageDigest(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static MessageDigest getMessageDigest(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getMessageDigest(algorithmName, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static MessageDigest getMessageDigest(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return MessageDigest.getInstance(algorithmName, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return MessageDigest.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_DIGEST_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerName, "BCFIPS"));
        }
        return MessageDigest.getInstance(algorithmName, provider);
    }

    @NotNull
    public static SecretKeyFactory getSecretKeyFactory(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getSecretKeyFactory(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static SecretKeyFactory getSecretKeyFactory(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getSecretKeyFactory(algorithmName, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static SecretKeyFactory getSecretKeyFactory(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return SecretKeyFactory.getInstance(algorithmName, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return SecretKeyFactory.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SK_FACTORY_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerName, "BCFIPS"));
        }
        return SecretKeyFactory.getInstance(algorithmName, provider);
    }

    @NotNull
    public static SecureRandom getSecureRandom() {
        try {
            return CryptoHelper.getSecureRandom(null, NULL_PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            Debug.debugException(e);
            throw new LDAPRuntimeException(new LDAPException(ResultCode.LOCAL_ERROR, e.getMessage(), e));
        }
    }

    @NotNull
    public static SecureRandom getSecureRandom(@Nullable String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getSecureRandom(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static SecureRandom getSecureRandom(@Nullable String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getSecureRandom(algorithmName, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static SecureRandom getSecureRandom(@Nullable String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (algorithmName == null) {
            if (provider == null) {
                if (CryptoHelper.usingFIPSMode()) {
                    try {
                        return CryptoHelper.getSecureRandom(BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                    }
                    catch (NoSuchProviderException e) {
                        Debug.debugException(e);
                        throw new NoSuchAlgorithmException(e.getMessage(), e);
                    }
                }
                return new SecureRandom();
            }
            return CryptoHelper.getSecureRandom(provider);
        }
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return CryptoHelper.getSecureRandom(algorithmName, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return SecureRandom.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SEC_RAND_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerName, "BCFIPS"));
        }
        return SecureRandom.getInstance(algorithmName, provider);
    }

    @NotNull
    private static SecureRandom getSecureRandom(@NotNull Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SEC_RAND_WRONG_PROVIDER_FOR_FIPS_MODE_NO_ALG.get(providerName, "BCFIPS"));
        }
        for (Provider.Service service : provider.getServices()) {
            if (!service.getType().equals(SECURE_RANDOM_SERVICE_TYPE)) continue;
            return SecureRandom.getInstance(service.getAlgorithm(), provider);
        }
        throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SEC_RAND_NO_ALG_FOR_PROVIDER.get(provider.getName()));
    }

    @NotNull
    public static Signature getSignature(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getSignature(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static Signature getSignature(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getSignature(algorithmName, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static Signature getSignature(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return Signature.getInstance(algorithmName, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return Signature.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SIGNATURE_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerName, "BCFIPS"));
        }
        return Signature.getInstance(algorithmName, provider);
    }

    @NotNull
    public static SSLContext getDefaultSSLContext() throws NoSuchAlgorithmException {
        if (CryptoHelper.usingFIPSMode()) {
            try {
                return SSLContext.getInstance("DEFAULT", BouncyCastleFIPSHelper.getBouncyCastleJSSEProvider());
            }
            catch (NoSuchProviderException e) {
                Debug.debugException(e);
                throw new NoSuchAlgorithmException(e.getMessage(), e);
            }
        }
        return SSLContext.getDefault();
    }

    @NotNull
    public static SSLContext getSSLContext(@NotNull String protocol) throws NoSuchAlgorithmException {
        return CryptoHelper.getSSLContext(protocol, NULL_PROVIDER);
    }

    @NotNull
    public static SSLContext getSSLContext(@NotNull String protocol, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getSSLContext(protocol, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static SSLContext getSSLContext(@NotNull String protocol, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return SSLContext.getInstance(protocol, BouncyCastleFIPSHelper.getBouncyCastleJSSEProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return SSLContext.getInstance(protocol);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_SSL_CONTEXT_WRONG_PROVIDER_FOR_FIPS_MODE.get(protocol, providerName, "BCFIPS"));
        }
        return SSLContext.getInstance(protocol, provider);
    }

    @NotNull
    public static TrustManagerFactory getTrustManagerFactory() throws NoSuchAlgorithmException {
        if (CryptoHelper.usingFIPSMode()) {
            try {
                return TrustManagerFactory.getInstance("PKIX", BouncyCastleFIPSHelper.getBouncyCastleJSSEProvider());
            }
            catch (NoSuchProviderException e) {
                Debug.debugException(e);
                throw new NoSuchAlgorithmException(e.getMessage(), e);
            }
        }
        return CryptoHelper.getTrustManagerFactory(TrustManagerFactory.getDefaultAlgorithm());
    }

    @NotNull
    public static TrustManagerFactory getTrustManagerFactory(@NotNull String algorithmName) throws NoSuchAlgorithmException {
        return CryptoHelper.getTrustManagerFactory(algorithmName, NULL_PROVIDER);
    }

    @NotNull
    public static TrustManagerFactory getTrustManagerFactory(@NotNull String algorithmName, @Nullable String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return CryptoHelper.getTrustManagerFactory(algorithmName, CryptoHelper.getProvider(providerName, true));
    }

    @NotNull
    public static TrustManagerFactory getTrustManagerFactory(@NotNull String algorithmName, @Nullable Provider provider) throws NoSuchAlgorithmException {
        String providerName;
        if (provider == null) {
            if (CryptoHelper.usingFIPSMode()) {
                try {
                    return TrustManagerFactory.getInstance(algorithmName, BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider());
                }
                catch (NoSuchProviderException e) {
                    Debug.debugException(e);
                    throw new NoSuchAlgorithmException(e.getMessage(), e);
                }
            }
            return TrustManagerFactory.getInstance(algorithmName);
        }
        if (CryptoHelper.usingFIPSMode() && !(providerName = provider.getName()).equals("BCFIPS")) {
            throw new NoSuchAlgorithmException(UtilityMessages.ERR_CRYPTO_HELPER_GET_TM_FACTORY_WRONG_PROVIDER_FOR_FIPS_MODE.get(algorithmName, providerName, "BCFIPS"));
        }
        return TrustManagerFactory.getInstance(algorithmName, provider);
    }

    @Nullable
    private static Provider getProvider(@Nullable String providerName, boolean requireBCInFIPSMode) throws NoSuchProviderException {
        if (providerName == null) {
            return null;
        }
        if (providerName.equals("BCFIPS")) {
            return BouncyCastleFIPSHelper.getBouncyCastleFIPSProvider();
        }
        if (providerName.equals("BCJSSE")) {
            return BouncyCastleFIPSHelper.getBouncyCastleJSSEProvider();
        }
        if (requireBCInFIPSMode && CryptoHelper.usingFIPSMode()) {
            throw new NoSuchProviderException(UtilityMessages.ERR_CRYPTO_HELPER_PROVIDER_NOT_AVAILABLE_IN_FIPS_MODE.get(providerName, "BCFIPS"));
        }
        Provider provider = Security.getProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException(UtilityMessages.ERR_CRYPTO_HELPER_NO_SUCH_PROVIDER.get(providerName));
        }
        return provider;
    }

    static {
        String fipsModePropertyValue = StaticUtils.getSystemProperty(PROPERTY_FIPS_MODE);
        if (fipsModePropertyValue == null) {
            FIPS_MODE = new AtomicBoolean(false);
        } else if (fipsModePropertyValue.equalsIgnoreCase("true")) {
            FIPS_MODE = new AtomicBoolean(true);
            try {
                BouncyCastleFIPSHelper.loadBouncyCastleFIPSProvider(true);
                BouncyCastleFIPSHelper.loadBouncyCastleJSSEProvider(true);
                String prunePropertyValue = StaticUtils.getSystemProperty(PROPERTY_REMOVE_NON_NECESSARY_PROVIDERS);
                if (prunePropertyValue != null) {
                    if (prunePropertyValue.equalsIgnoreCase("true")) {
                        CryptoHelper.removeNonEssentialSecurityProviders();
                    } else if (!prunePropertyValue.equalsIgnoreCase("false")) {
                        Validator.violation(UtilityMessages.ERR_CRYPTO_HELPER_INVALID_FIPS_MODE_PROPERTY_VALUE.get(PROPERTY_REMOVE_NON_NECESSARY_PROVIDERS, prunePropertyValue));
                    }
                }
                TLSCipherSuiteSelector.recompute();
            }
            catch (Exception e) {
                Validator.violation(UtilityMessages.ERR_CRYPTO_HELPER_INSTANTIATION_ERROR_FROM_FIPS_MODE_PROPERTY.get(PROPERTY_FIPS_MODE, StaticUtils.getExceptionMessage(e)), e);
            }
        } else if (fipsModePropertyValue.equalsIgnoreCase("false")) {
            FIPS_MODE = new AtomicBoolean(false);
        } else {
            FIPS_MODE = new AtomicBoolean(false);
            Validator.violation(UtilityMessages.ERR_CRYPTO_HELPER_INVALID_FIPS_MODE_PROPERTY_VALUE.get(PROPERTY_FIPS_MODE, fipsModePropertyValue));
        }
        String propertyValue = StaticUtils.getSystemProperty(PROPERTY_DEFAULT_KEY_STORE_TYPE);
        String defaultKeyStoreType = propertyValue == null ? (FIPS_MODE.get() ? KEY_STORE_TYPE_BCFKS : KeyStore.getDefaultType()) : propertyValue;
        DEFAULT_KEY_STORE_TYPE = new AtomicReference<String>(defaultKeyStoreType);
        NULL_PROVIDER = null;
    }
}

