/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.ssl.SSLMessages;
import com.unboundid.util.ssl.SetEnabledProtocolsAndCipherSuitesSSLServerSocketFactory;
import com.unboundid.util.ssl.SetEnabledProtocolsAndCipherSuitesSSLSocketFactory;
import com.unboundid.util.ssl.TLSCipherSuiteSelector;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SSLUtil {
    @NotNull
    public static final String PROPERTY_DEFAULT_SSL_PROTOCOL = "com.unboundid.util.SSLUtil.defaultSSLProtocol";
    @NotNull
    public static final String PROPERTY_ENABLED_SSL_PROTOCOLS = "com.unboundid.util.SSLUtil.enabledSSLProtocols";
    @NotNull
    public static final String PROPERTY_ENABLED_SSL_CIPHER_SUITES = "com.unboundid.util.SSLUtil.enabledSSLCipherSuites";
    @NotNull
    public static final String SSL_PROTOCOL_TLS_1_3 = "TLSv1.3";
    @NotNull
    public static final String SSL_PROTOCOL_TLS_1_2 = "TLSv1.2";
    @NotNull
    public static final String SSL_PROTOCOL_TLS_1_1 = "TLSv1.1";
    @NotNull
    public static final String SSL_PROTOCOL_TLS_1 = "TLSv1";
    @NotNull
    public static final String SSL_PROTOCOL_SSL_3 = "SSLv3";
    @NotNull
    public static final String SSL_PROTOCOL_SSL_2_HELLO = "SSLv2Hello";
    @NotNull
    private static final AtomicReference<String> DEFAULT_SSL_PROTOCOL = new AtomicReference<String>("TLSv1");
    @NotNull
    private static final AtomicReference<Set<String>> ENABLED_SSL_CIPHER_SUITES = new AtomicReference();
    @NotNull
    private static final AtomicReference<Set<String>> ENABLED_SSL_PROTOCOLS = new AtomicReference();
    @Nullable
    private final KeyManager[] keyManagers;
    @Nullable
    private final TrustManager[] trustManagers;

    public SSLUtil() {
        this.keyManagers = null;
        this.trustManagers = null;
    }

    public SSLUtil(@Nullable TrustManager trustManager) {
        this.keyManagers = null;
        this.trustManagers = trustManager == null ? null : new TrustManager[]{trustManager};
    }

    public SSLUtil(@Nullable TrustManager[] trustManagers) {
        this.keyManagers = null;
        this.trustManagers = trustManagers == null || trustManagers.length == 0 ? null : trustManagers;
    }

    public SSLUtil(@Nullable KeyManager keyManager, @Nullable TrustManager trustManager) {
        this.keyManagers = keyManager == null ? null : new KeyManager[]{keyManager};
        this.trustManagers = trustManager == null ? null : new TrustManager[]{trustManager};
    }

    public SSLUtil(@Nullable KeyManager[] keyManagers, @Nullable TrustManager[] trustManagers) {
        this.keyManagers = keyManagers == null || keyManagers.length == 0 ? null : keyManagers;
        this.trustManagers = trustManagers == null || trustManagers.length == 0 ? null : trustManagers;
    }

    @Nullable
    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    @Nullable
    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    @NotNull
    public SSLContext createSSLContext() throws GeneralSecurityException {
        return this.createSSLContext(DEFAULT_SSL_PROTOCOL.get());
    }

    @NotNull
    public SSLContext createSSLContext(@NotNull String protocol) throws GeneralSecurityException {
        Validator.ensureNotNull(protocol);
        SSLContext sslContext = CryptoHelper.getSSLContext(protocol);
        sslContext.init(this.keyManagers, this.trustManagers, null);
        return sslContext;
    }

    @NotNull
    public SSLContext createSSLContext(@NotNull String protocol, @NotNull String provider) throws GeneralSecurityException {
        Validator.ensureNotNull(protocol, provider);
        SSLContext sslContext = CryptoHelper.getSSLContext(protocol, provider);
        sslContext.init(this.keyManagers, this.trustManagers, null);
        return sslContext;
    }

    @NotNull
    public SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException {
        return new SetEnabledProtocolsAndCipherSuitesSSLSocketFactory(this.createSSLContext().getSocketFactory(), ENABLED_SSL_PROTOCOLS.get(), ENABLED_SSL_CIPHER_SUITES.get());
    }

    @NotNull
    public SSLSocketFactory createSSLSocketFactory(@NotNull String protocol) throws GeneralSecurityException {
        return new SetEnabledProtocolsAndCipherSuitesSSLSocketFactory(this.createSSLContext(protocol).getSocketFactory(), protocol, ENABLED_SSL_CIPHER_SUITES.get());
    }

    @NotNull
    public SSLSocketFactory createSSLSocketFactory(@NotNull String protocol, @NotNull String provider) throws GeneralSecurityException {
        return this.createSSLContext(protocol, provider).getSocketFactory();
    }

    @NotNull
    public SSLServerSocketFactory createSSLServerSocketFactory() throws GeneralSecurityException {
        return new SetEnabledProtocolsAndCipherSuitesSSLServerSocketFactory(this.createSSLContext().getServerSocketFactory(), ENABLED_SSL_PROTOCOLS.get(), ENABLED_SSL_CIPHER_SUITES.get());
    }

    @NotNull
    public SSLServerSocketFactory createSSLServerSocketFactory(@NotNull String protocol) throws GeneralSecurityException {
        return new SetEnabledProtocolsAndCipherSuitesSSLServerSocketFactory(this.createSSLContext(protocol).getServerSocketFactory(), protocol, ENABLED_SSL_CIPHER_SUITES.get());
    }

    @NotNull
    public SSLServerSocketFactory createSSLServerSocketFactory(@NotNull String protocol, @NotNull String provider) throws GeneralSecurityException {
        return this.createSSLContext(protocol, provider).getServerSocketFactory();
    }

    @NotNull
    public static String getDefaultSSLProtocol() {
        return DEFAULT_SSL_PROTOCOL.get();
    }

    public static void setDefaultSSLProtocol(@NotNull String defaultSSLProtocol) {
        Validator.ensureNotNull(defaultSSLProtocol);
        DEFAULT_SSL_PROTOCOL.set(defaultSSLProtocol);
    }

    @NotNull
    public static Set<String> getEnabledSSLProtocols() {
        return ENABLED_SSL_PROTOCOLS.get();
    }

    public static void setEnabledSSLProtocols(@Nullable Collection<String> enabledSSLProtocols) {
        if (enabledSSLProtocols == null) {
            ENABLED_SSL_PROTOCOLS.set(Collections.emptySet());
        } else {
            ENABLED_SSL_PROTOCOLS.set(Collections.unmodifiableSet(new LinkedHashSet<String>(enabledSSLProtocols)));
        }
    }

    public static void applyEnabledSSLProtocols(@NotNull Socket socket) throws LDAPException {
        try {
            SSLUtil.applyEnabledSSLProtocols(socket, ENABLED_SSL_PROTOCOLS.get());
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            throw new LDAPException(ResultCode.CONNECT_ERROR, ioe.getMessage(), ioe);
        }
    }

    static void applyEnabledSSLProtocols(@Nullable Socket socket, @NotNull Set<String> protocols) throws IOException {
        if (socket == null || !(socket instanceof SSLSocket) || protocols.isEmpty()) {
            return;
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        String[] protocolsToEnable = SSLUtil.getSSLProtocolsToEnable(protocols, sslSocket.getSupportedProtocols());
        try {
            sslSocket.setEnabledProtocols(protocolsToEnable);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    static void applyEnabledSSLProtocols(@Nullable ServerSocket serverSocket, @NotNull Set<String> protocols) throws IOException {
        if (serverSocket == null || !(serverSocket instanceof SSLServerSocket) || protocols.isEmpty()) {
            return;
        }
        SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket;
        String[] protocolsToEnable = SSLUtil.getSSLProtocolsToEnable(protocols, sslServerSocket.getSupportedProtocols());
        try {
            sslServerSocket.setEnabledProtocols(protocolsToEnable);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    @NotNull
    private static String[] getSSLProtocolsToEnable(@NotNull Set<String> desiredProtocols, @NotNull String[] supportedProtocols) throws IOException {
        LinkedHashSet<String> lowerProtocols = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(desiredProtocols.size()));
        for (String s : desiredProtocols) {
            lowerProtocols.add(StaticUtils.toLowerCase(s));
        }
        ArrayList<String> enabledList = new ArrayList<String>(supportedProtocols.length);
        for (String supportedProtocol : supportedProtocols) {
            if (!lowerProtocols.contains(StaticUtils.toLowerCase(supportedProtocol))) continue;
            enabledList.add(supportedProtocol);
        }
        if (enabledList.isEmpty()) {
            StringBuilder enabledBuffer = new StringBuilder();
            Iterator<String> enabledIterator = desiredProtocols.iterator();
            while (enabledIterator.hasNext()) {
                enabledBuffer.append('\'');
                enabledBuffer.append(enabledIterator.next());
                enabledBuffer.append('\'');
                if (!enabledIterator.hasNext()) continue;
                enabledBuffer.append(", ");
            }
            StringBuilder supportedBuffer = new StringBuilder();
            for (int i = 0; i < supportedProtocols.length; ++i) {
                if (i > 0) {
                    supportedBuffer.append(", ");
                }
                supportedBuffer.append('\'');
                supportedBuffer.append(supportedProtocols[i]);
                supportedBuffer.append('\'');
            }
            throw new IOException(SSLMessages.ERR_NO_ENABLED_SSL_PROTOCOLS_AVAILABLE_FOR_SOCKET.get(enabledBuffer.toString(), supportedBuffer.toString(), PROPERTY_ENABLED_SSL_PROTOCOLS, SSLUtil.class.getName() + ".setEnabledSSLProtocols"));
        }
        return enabledList.toArray(StaticUtils.NO_STRINGS);
    }

    @NotNull
    public static Set<String> getEnabledSSLCipherSuites() {
        return ENABLED_SSL_CIPHER_SUITES.get();
    }

    public static void setEnabledSSLCipherSuites(@Nullable Collection<String> enabledSSLCipherSuites) {
        if (enabledSSLCipherSuites == null) {
            ENABLED_SSL_CIPHER_SUITES.set(Collections.emptySet());
        } else {
            ENABLED_SSL_CIPHER_SUITES.set(Collections.unmodifiableSet(new LinkedHashSet<String>(enabledSSLCipherSuites)));
        }
    }

    public static void applyEnabledSSLCipherSuites(@NotNull Socket socket) throws LDAPException {
        try {
            SSLUtil.applyEnabledSSLCipherSuites(socket, ENABLED_SSL_CIPHER_SUITES.get());
        }
        catch (IOException ioe) {
            Debug.debugException(ioe);
            throw new LDAPException(ResultCode.CONNECT_ERROR, ioe.getMessage(), ioe);
        }
    }

    static void applyEnabledSSLCipherSuites(@Nullable Socket socket, @NotNull Set<String> cipherSuites) throws IOException {
        if (socket == null || !(socket instanceof SSLSocket) || cipherSuites.isEmpty()) {
            return;
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        String[] cipherSuitesToEnable = SSLUtil.getSSLCipherSuitesToEnable(cipherSuites, sslSocket.getSupportedCipherSuites());
        try {
            sslSocket.setEnabledCipherSuites(cipherSuitesToEnable);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    static void applyEnabledSSLCipherSuites(@Nullable ServerSocket serverSocket, @NotNull Set<String> cipherSuites) throws IOException {
        if (serverSocket == null || !(serverSocket instanceof SSLServerSocket) || cipherSuites.isEmpty()) {
            return;
        }
        SSLServerSocket sslServerSocket = (SSLServerSocket)serverSocket;
        String[] cipherSuitesToEnable = SSLUtil.getSSLCipherSuitesToEnable(cipherSuites, sslServerSocket.getSupportedCipherSuites());
        try {
            sslServerSocket.setEnabledCipherSuites(cipherSuitesToEnable);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
    }

    @NotNull
    private static String[] getSSLCipherSuitesToEnable(@NotNull Set<String> desiredCipherSuites, @NotNull String[] supportedCipherSuites) throws IOException {
        LinkedHashSet<String> upperCipherSuites = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(desiredCipherSuites.size()));
        for (String s : desiredCipherSuites) {
            upperCipherSuites.add(StaticUtils.toUpperCase(s));
        }
        ArrayList<String> enabledList = new ArrayList<String>(supportedCipherSuites.length);
        for (String supportedCipherSuite : supportedCipherSuites) {
            if (!upperCipherSuites.contains(StaticUtils.toUpperCase(supportedCipherSuite))) continue;
            enabledList.add(supportedCipherSuite);
        }
        if (enabledList.isEmpty()) {
            StringBuilder enabledBuffer = new StringBuilder();
            Iterator<String> enabledIterator = desiredCipherSuites.iterator();
            while (enabledIterator.hasNext()) {
                enabledBuffer.append('\'');
                enabledBuffer.append(enabledIterator.next());
                enabledBuffer.append('\'');
                if (!enabledIterator.hasNext()) continue;
                enabledBuffer.append(", ");
            }
            StringBuilder supportedBuffer = new StringBuilder();
            for (int i = 0; i < supportedCipherSuites.length; ++i) {
                if (i > 0) {
                    supportedBuffer.append(", ");
                }
                supportedBuffer.append('\'');
                supportedBuffer.append(supportedCipherSuites[i]);
                supportedBuffer.append('\'');
            }
            throw new IOException(SSLMessages.ERR_NO_ENABLED_SSL_CIPHER_SUITES_AVAILABLE_FOR_SOCKET.get(enabledBuffer.toString(), supportedBuffer.toString(), PROPERTY_ENABLED_SSL_CIPHER_SUITES, SSLUtil.class.getName() + ".setEnabledSSLCipherSuites"));
        }
        return enabledList.toArray(StaticUtils.NO_STRINGS);
    }

    static void configureSSLDefaults() {
        String defaultPropValue = StaticUtils.getSystemProperty(PROPERTY_DEFAULT_SSL_PROTOCOL);
        if (defaultPropValue != null && !defaultPropValue.isEmpty()) {
            DEFAULT_SSL_PROTOCOL.set(defaultPropValue);
        } else {
            try {
                SSLContext defaultContext = CryptoHelper.getDefaultSSLContext();
                String[] supportedProtocols = defaultContext.getSupportedSSLParameters().getProtocols();
                LinkedHashSet<String> protocolMap = new LinkedHashSet<String>(Arrays.asList(supportedProtocols));
                if (protocolMap.contains(SSL_PROTOCOL_TLS_1_3)) {
                    DEFAULT_SSL_PROTOCOL.set(SSL_PROTOCOL_TLS_1_3);
                } else if (protocolMap.contains(SSL_PROTOCOL_TLS_1_2)) {
                    DEFAULT_SSL_PROTOCOL.set(SSL_PROTOCOL_TLS_1_2);
                } else if (protocolMap.contains(SSL_PROTOCOL_TLS_1_1)) {
                    DEFAULT_SSL_PROTOCOL.set(SSL_PROTOCOL_TLS_1_1);
                } else if (protocolMap.contains(SSL_PROTOCOL_TLS_1)) {
                    DEFAULT_SSL_PROTOCOL.set(SSL_PROTOCOL_TLS_1);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        LinkedHashSet<String> enabledProtocols = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(10));
        if (DEFAULT_SSL_PROTOCOL.get().equals(SSL_PROTOCOL_TLS_1_3)) {
            enabledProtocols.add(SSL_PROTOCOL_TLS_1_3);
            enabledProtocols.add(SSL_PROTOCOL_TLS_1_2);
            enabledProtocols.add(SSL_PROTOCOL_TLS_1_1);
        } else if (DEFAULT_SSL_PROTOCOL.get().equals(SSL_PROTOCOL_TLS_1_2)) {
            enabledProtocols.add(SSL_PROTOCOL_TLS_1_2);
            enabledProtocols.add(SSL_PROTOCOL_TLS_1_1);
        } else if (DEFAULT_SSL_PROTOCOL.get().equals(SSL_PROTOCOL_TLS_1_1)) {
            enabledProtocols.add(SSL_PROTOCOL_TLS_1_1);
        }
        enabledProtocols.add(SSL_PROTOCOL_TLS_1);
        String enabledPropValue = StaticUtils.getSystemProperty(PROPERTY_ENABLED_SSL_PROTOCOLS);
        if (enabledPropValue != null && !enabledPropValue.isEmpty()) {
            enabledProtocols.clear();
            StringTokenizer tokenizer = new StringTokenizer(enabledPropValue, ", ", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.isEmpty()) continue;
                enabledProtocols.add(token);
            }
        }
        ENABLED_SSL_PROTOCOLS.set(Collections.unmodifiableSet(enabledProtocols));
        ENABLED_SSL_CIPHER_SUITES.set(TLSCipherSuiteSelector.getRecommendedCipherSuites());
        enabledPropValue = StaticUtils.getSystemProperty(PROPERTY_ENABLED_SSL_CIPHER_SUITES);
        if (enabledPropValue != null && !enabledPropValue.isEmpty()) {
            LinkedHashSet<String> enabledCipherSuites = new LinkedHashSet<String>(StaticUtils.computeMapCapacity(50));
            StringTokenizer tokenizer = new StringTokenizer(enabledPropValue, ", ", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.isEmpty()) continue;
                enabledCipherSuites.add(token);
            }
            if (!enabledCipherSuites.isEmpty()) {
                ENABLED_SSL_CIPHER_SUITES.set(Collections.unmodifiableSet(enabledCipherSuites));
            }
        }
    }

    @NotNull
    public static String certificateToString(@NotNull X509Certificate certificate) {
        StringBuilder buffer = new StringBuilder();
        SSLUtil.certificateToString(certificate, buffer);
        return buffer.toString();
    }

    public static void certificateToString(@NotNull X509Certificate certificate, @NotNull StringBuilder buffer) {
        buffer.append("Certificate(subject='");
        buffer.append(certificate.getSubjectX500Principal().getName("RFC2253"));
        buffer.append("', serialNumber=");
        buffer.append(certificate.getSerialNumber());
        buffer.append(", notBefore=");
        StaticUtils.encodeGeneralizedTime(certificate.getNotBefore());
        buffer.append(", notAfter=");
        StaticUtils.encodeGeneralizedTime(certificate.getNotAfter());
        buffer.append(", signatureAlgorithm='");
        buffer.append(certificate.getSigAlgName());
        buffer.append("', signatureBytes='");
        StaticUtils.toHex(certificate.getSignature(), buffer);
        buffer.append("', issuerSubject='");
        buffer.append(certificate.getIssuerX500Principal().getName("RFC2253"));
        buffer.append("')");
    }

    static {
        SSLUtil.configureSSLDefaults();
    }
}

