/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.controls.AssertionRequestControl;
import com.unboundid.ldap.sdk.controls.ServerSideSortRequestControl;
import com.unboundid.ldap.sdk.controls.SortKey;
import com.unboundid.ldap.sdk.examples.SearchRateThread;
import com.unboundid.util.ColumnFormatter;
import com.unboundid.util.Debug;
import com.unboundid.util.FixedRateBarrier;
import com.unboundid.util.FormattableColumn;
import com.unboundid.util.HorizontalAlignment;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.OutputFormat;
import com.unboundid.util.RateAdjustor;
import com.unboundid.util.ResultCodeCounter;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ValuePattern;
import com.unboundid.util.WakeableSleeper;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.ControlArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.FilterArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.ScopeArgument;
import com.unboundid.util.args.StringArgument;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SearchRate
extends LDAPCommandLineTool
implements Serializable {
    private static final long serialVersionUID = 3345838530404592182L;
    @NotNull
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    @NotNull
    private final AtomicInteger runningThreads = new AtomicInteger(0);
    @Nullable
    private BooleanArgument asynchronousMode;
    @Nullable
    private BooleanArgument csvFormat;
    @Nullable
    private BooleanArgument suppressErrors;
    @Nullable
    private BooleanArgument typesOnly;
    @Nullable
    private ControlArgument control;
    @Nullable
    private FileArgument sampleRateFile;
    @Nullable
    private FileArgument variableRateData;
    @Nullable
    private FilterArgument assertionFilter;
    @Nullable
    private IntegerArgument collectionInterval;
    @Nullable
    private IntegerArgument iterationsBeforeReconnect;
    @Nullable
    private IntegerArgument maxOutstandingRequests;
    @Nullable
    private IntegerArgument numIntervals;
    @Nullable
    private IntegerArgument numThreads;
    @Nullable
    private IntegerArgument randomSeed;
    @Nullable
    private IntegerArgument ratePerSecond;
    @Nullable
    private IntegerArgument simplePageSize;
    @Nullable
    private IntegerArgument sizeLimit;
    @Nullable
    private IntegerArgument timeLimitSeconds;
    @Nullable
    private IntegerArgument warmUpIntervals;
    @Nullable
    private ScopeArgument scope;
    @Nullable
    private StringArgument attributes;
    @Nullable
    private StringArgument baseDN;
    @Nullable
    private StringArgument dereferencePolicy;
    @Nullable
    private StringArgument filter;
    @Nullable
    private StringArgument ldapURL;
    @Nullable
    private StringArgument proxyAs;
    @Nullable
    private StringArgument sortOrder;
    @Nullable
    private StringArgument timestampFormat;
    @NotNull
    private final WakeableSleeper sleeper = new WakeableSleeper();

    public static void main(@NotNull String[] args) {
        ResultCode resultCode = SearchRate.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@NotNull String[] args, @Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        SearchRate searchRate = new SearchRate(outStream, errStream);
        return searchRate.runTool(args);
    }

    public SearchRate(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "searchrate";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return "Perform repeated searches against an LDAP directory server.";
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.1";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        String description = "The base DN to use for the searches.  It may be a simple DN or a value pattern to specify a range of DNs (e.g., \"uid=user.[1-1000],ou=People,dc=example,dc=com\").  See https://docs.ldap.com/ldap-sdk/docs/javadoc/index.html?com/unboundid/util/ValuePattern.html for complete details about the value pattern syntax.  This argument must not be used in conjunction with the --ldapURL argument.";
        this.baseDN = new StringArgument(Character.valueOf('b'), "baseDN", false, 1, "{dn}", description, "");
        this.baseDN.setArgumentGroupName("Search Arguments");
        this.baseDN.addLongIdentifier("base-dn", true);
        parser.addArgument(this.baseDN);
        description = "The scope to use for the searches.  It should be 'base', 'one', 'sub', or 'subord'.  If this is not provided, then a default scope of 'sub' will be used.  This argument must not be used in conjunction with the --ldapURL argument.";
        this.scope = new ScopeArgument(Character.valueOf('s'), "scope", false, "{scope}", description, SearchScope.SUB);
        this.scope.setArgumentGroupName("Search Arguments");
        parser.addArgument(this.scope);
        description = "The filter to use for the searches.  It may be a simple filter or a value pattern to specify a range of filters (e.g., \"(uid=user.[1-1000])\").  See https://docs.ldap.com/ldap-sdk/docs/javadoc/index.html?com/unboundid/util/ValuePattern.html for complete details about the value pattern syntax.  Exactly one of this argument and the --ldapURL arguments must be provided.";
        this.filter = new StringArgument(Character.valueOf('f'), "filter", false, 1, "{filter}", description);
        this.filter.setArgumentGroupName("Search Arguments");
        parser.addArgument(this.filter);
        description = "The name of an attribute to include in entries returned from the searches.  Multiple attributes may be requested by providing this argument multiple times.  If no request attributes are provided, then the entries returned will include all user attributes.  This argument must not be used in conjunction with the --ldapURL argument.";
        this.attributes = new StringArgument(Character.valueOf('A'), "attribute", false, 0, "{name}", description);
        this.attributes.setArgumentGroupName("Search Arguments");
        parser.addArgument(this.attributes);
        description = "An LDAP URL that provides the base DN, scope, filter, and requested attributes to use for the search requests (the address and port components of the URL, if present, will be ignored).  It may be a simple LDAP URL or a value pattern to specify a range of URLs.  See https://docs.ldap.com/ldap-sdk/docs/javadoc/index.html?com/unboundid/util/ValuePattern.html for complete details about the value pattern syntax.  If this argument is provided, then none of the --baseDN, --scope, --filter, or --attribute arguments may be used.";
        this.ldapURL = new StringArgument(null, "ldapURL", false, 1, "{url}", description);
        this.ldapURL.setArgumentGroupName("Search Arguments");
        this.ldapURL.addLongIdentifier("ldap-url", true);
        parser.addArgument(this.ldapURL);
        description = "The maximum number of entries that the server should return in response to each search request.  A value of zero indicates that the client does not wish to impose any limit on the number of entries that are returned (although the server may impose its own limit).  If this is not provided, then a default value of zero will be used.";
        this.sizeLimit = new IntegerArgument(Character.valueOf('z'), "sizeLimit", false, 1, "{num}", description, 0, Integer.MAX_VALUE, 0);
        this.sizeLimit.setArgumentGroupName("Search Arguments");
        this.sizeLimit.addLongIdentifier("size-limit", true);
        parser.addArgument(this.sizeLimit);
        description = "The maximum length of time, in seconds, that the server should spend processing each search request.  A value of zero indicates that the client does not wish to impose any limit on the server's processing time (although the server may impose its own limit).  If this is not provided, then a default value of zero will be used.";
        this.timeLimitSeconds = new IntegerArgument(Character.valueOf('l'), "timeLimitSeconds", false, 1, "{seconds}", description, 0, Integer.MAX_VALUE, 0);
        this.timeLimitSeconds.setArgumentGroupName("Search Arguments");
        this.timeLimitSeconds.addLongIdentifier("time-limit-seconds", true);
        this.timeLimitSeconds.addLongIdentifier("timeLimit", true);
        this.timeLimitSeconds.addLongIdentifier("time-limit", true);
        parser.addArgument(this.timeLimitSeconds);
        Set<String> derefAllowedValues = StaticUtils.setOf("never", "always", "search", "find");
        description = "The alias dereferencing policy to use for search requests.  The value should be one of 'never', 'always', 'search', or 'find'.  If this is not provided, then a default value of 'never' will be used.";
        this.dereferencePolicy = new StringArgument(null, "dereferencePolicy", false, 1, "{never|always|search|find}", description, derefAllowedValues, "never");
        this.dereferencePolicy.setArgumentGroupName("Search Arguments");
        this.dereferencePolicy.addLongIdentifier("dereference-policy", true);
        parser.addArgument(this.dereferencePolicy);
        description = "Indicates that server should only include the names of the attributes contained in matching entries rather than both names and values.";
        this.typesOnly = new BooleanArgument(null, "typesOnly", 1, description);
        this.typesOnly.setArgumentGroupName("Search Arguments");
        this.typesOnly.addLongIdentifier("types-only", true);
        parser.addArgument(this.typesOnly);
        description = "Indicates that search requests should include the assertion request control with the specified filter.";
        this.assertionFilter = new FilterArgument(null, "assertionFilter", false, 1, "{filter}", description);
        this.assertionFilter.setArgumentGroupName("Request Control Arguments");
        this.assertionFilter.addLongIdentifier("assertion-filter", true);
        parser.addArgument(this.assertionFilter);
        description = "Indicates that search requests should include the simple paged results control with the specified page size.";
        this.simplePageSize = new IntegerArgument(null, "simplePageSize", false, 1, "{size}", description, 1, Integer.MAX_VALUE);
        this.simplePageSize.setArgumentGroupName("Request Control Arguments");
        this.simplePageSize.addLongIdentifier("simple-page-size", true);
        parser.addArgument(this.simplePageSize);
        description = "Indicates that search requests should include the server-side sort request control with the specified sort order.  This should be a comma-delimited list in which each item is an attribute name, optionally preceded by a plus or minus sign (to indicate ascending or descending order; where ascending order is the default), and optionally followed by a colon and the name or OID of the desired ordering matching rule (if this is not provided, the the attribute type's default ordering rule will be used).";
        this.sortOrder = new StringArgument(null, "sortOrder", false, 1, "{sortOrder}", description);
        this.sortOrder.setArgumentGroupName("Request Control Arguments");
        this.sortOrder.addLongIdentifier("sort-order", true);
        parser.addArgument(this.sortOrder);
        description = "Indicates that the proxied authorization control (as defined in RFC 4370) should be used to request that operations be processed using an alternate authorization identity.  This may be a simple authorization ID or it may be a value pattern to specify a range of identities.  See https://docs.ldap.com/ldap-sdk/docs/javadoc/index.html?com/unboundid/util/ValuePattern.html for complete details about the value pattern syntax.";
        this.proxyAs = new StringArgument(Character.valueOf('Y'), "proxyAs", false, 1, "{authzID}", description);
        this.proxyAs.setArgumentGroupName("Request Control Arguments");
        this.proxyAs.addLongIdentifier("proxy-as", true);
        parser.addArgument(this.proxyAs);
        description = "Indicates that search requests should include the specified request control.  This may be provided multiple times to include multiple request controls.";
        this.control = new ControlArgument(Character.valueOf('J'), "control", false, 0, null, description);
        this.control.setArgumentGroupName("Request Control Arguments");
        parser.addArgument(this.control);
        description = "The number of threads to use to perform the searches.  If this is not provided, then a default of one thread will be used.";
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 1);
        this.numThreads.setArgumentGroupName("Rate Management Arguments");
        this.numThreads.addLongIdentifier("num-threads", true);
        parser.addArgument(this.numThreads);
        description = "The length of time in seconds between output lines.  If this is not provided, then a default interval of five seconds will be used.";
        this.collectionInterval = new IntegerArgument(Character.valueOf('i'), "intervalDuration", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 5);
        this.collectionInterval.setArgumentGroupName("Rate Management Arguments");
        this.collectionInterval.addLongIdentifier("interval-duration", true);
        parser.addArgument(this.collectionInterval);
        description = "The maximum number of intervals for which to run.  If this is not provided, then the tool will run until it is interrupted.";
        this.numIntervals = new IntegerArgument(Character.valueOf('I'), "numIntervals", true, 1, "{num}", description, 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.numIntervals.setArgumentGroupName("Rate Management Arguments");
        this.numIntervals.addLongIdentifier("num-intervals", true);
        parser.addArgument(this.numIntervals);
        description = "The number of search iterations that should be processed on a connection before that connection is closed and replaced with a newly-established (and authenticated, if appropriate) connection.  If this is not provided, then connections will not be periodically closed and re-established.";
        this.iterationsBeforeReconnect = new IntegerArgument(null, "iterationsBeforeReconnect", false, 1, "{num}", description, 0);
        this.iterationsBeforeReconnect.setArgumentGroupName("Rate Management Arguments");
        this.iterationsBeforeReconnect.addLongIdentifier("iterations-before-reconnect", true);
        parser.addArgument(this.iterationsBeforeReconnect);
        description = "The target number of searches to perform per second.  It is still necessary to specify a sufficient number of threads for achieving this rate.  If neither this option nor --variableRateData is provided, then the tool will run at the maximum rate for the specified number of threads.";
        this.ratePerSecond = new IntegerArgument(Character.valueOf('r'), "ratePerSecond", false, 1, "{searches-per-second}", description, 1, Integer.MAX_VALUE);
        this.ratePerSecond.setArgumentGroupName("Rate Management Arguments");
        this.ratePerSecond.addLongIdentifier("rate-per-second", true);
        parser.addArgument(this.ratePerSecond);
        String variableRateDataArgName = "variableRateData";
        String generateSampleRateFileArgName = "generateSampleRateFile";
        description = RateAdjustor.getVariableRateDataArgumentDescription("generateSampleRateFile");
        this.variableRateData = new FileArgument(null, "variableRateData", false, 1, "{path}", description, true, true, true, false);
        this.variableRateData.setArgumentGroupName("Rate Management Arguments");
        this.variableRateData.addLongIdentifier("variable-rate-data", true);
        parser.addArgument(this.variableRateData);
        description = RateAdjustor.getGenerateSampleVariableRateFileDescription("variableRateData");
        this.sampleRateFile = new FileArgument(null, "generateSampleRateFile", false, 1, "{path}", description, false, true, true, false);
        this.sampleRateFile.setArgumentGroupName("Rate Management Arguments");
        this.sampleRateFile.addLongIdentifier("generate-sample-rate-file", true);
        this.sampleRateFile.setUsageArgument(true);
        parser.addArgument(this.sampleRateFile);
        parser.addExclusiveArgumentSet(this.variableRateData, this.sampleRateFile, new Argument[0]);
        description = "The number of intervals to complete before beginning overall statistics collection.  Specifying a nonzero number of warm-up intervals gives the client and server a chance to warm up without skewing performance results.";
        this.warmUpIntervals = new IntegerArgument(null, "warmUpIntervals", true, 1, "{num}", description, 0, Integer.MAX_VALUE, 0);
        this.warmUpIntervals.setArgumentGroupName("Rate Management Arguments");
        this.warmUpIntervals.addLongIdentifier("warm-up-intervals", true);
        parser.addArgument(this.warmUpIntervals);
        description = "Indicates the format to use for timestamps included in the output.  A value of 'none' indicates that no timestamps should be included.  A value of 'with-date' indicates that both the date and the time should be included.  A value of 'without-date' indicates that only the time should be included.";
        Set<String> allowedFormats = StaticUtils.setOf("none", "with-date", "without-date");
        this.timestampFormat = new StringArgument(null, "timestampFormat", true, 1, "{format}", description, allowedFormats, "none");
        this.timestampFormat.addLongIdentifier("timestamp-format", true);
        parser.addArgument(this.timestampFormat);
        description = "Indicates that the client should operate in asynchronous mode, in which it will not be necessary to wait for a response to a previous request before sending the next request.  Either the '--ratePerSecond' or the '--maxOutstandingRequests' argument must be provided to limit the number of outstanding requests.";
        this.asynchronousMode = new BooleanArgument(Character.valueOf('a'), "asynchronous", description);
        parser.addArgument(this.asynchronousMode);
        description = "Specifies the maximum number of outstanding requests that should be allowed when operating in asynchronous mode.";
        this.maxOutstandingRequests = new IntegerArgument(Character.valueOf('O'), "maxOutstandingRequests", false, 1, "{num}", description, 1, Integer.MAX_VALUE, (Integer)null);
        this.maxOutstandingRequests.addLongIdentifier("max-outstanding-requests", true);
        parser.addArgument(this.maxOutstandingRequests);
        description = "Indicates that information about the result codes for failed operations should not be displayed.";
        this.suppressErrors = new BooleanArgument(null, "suppressErrorResultCodes", 1, description);
        this.suppressErrors.addLongIdentifier("suppress-error-result-codes", true);
        parser.addArgument(this.suppressErrors);
        description = "Generate output in CSV format rather than a display-friendly format";
        this.csvFormat = new BooleanArgument(Character.valueOf('c'), "csv", 1, description);
        parser.addArgument(this.csvFormat);
        description = "Specifies the seed to use for the random number generator.";
        this.randomSeed = new IntegerArgument(Character.valueOf('R'), "randomSeed", false, 1, "{value}", description);
        this.randomSeed.addLongIdentifier("random-seed", true);
        parser.addArgument(this.randomSeed);
        parser.addExclusiveArgumentSet(this.baseDN, this.ldapURL, new Argument[0]);
        parser.addExclusiveArgumentSet(this.scope, this.ldapURL, new Argument[0]);
        parser.addExclusiveArgumentSet(this.filter, this.ldapURL, new Argument[0]);
        parser.addExclusiveArgumentSet(this.attributes, this.ldapURL, new Argument[0]);
        parser.addRequiredArgumentSet(this.filter, this.ldapURL, new Argument[0]);
        parser.addDependentArgumentSet(this.asynchronousMode, this.ratePerSecond, this.maxOutstandingRequests);
        parser.addDependentArgumentSet(this.maxOutstandingRequests, this.asynchronousMode, new Argument[0]);
        parser.addExclusiveArgumentSet(this.asynchronousMode, this.simplePageSize, new Argument[0]);
    }

    @Override
    protected boolean supportsMultipleServers() {
        return true;
    }

    @Override
    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUseSynchronousMode(!this.asynchronousMode.isPresent());
        return options;
    }

    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        long totalIntervals;
        boolean warmUp;
        String timeFormat;
        boolean includeTimestamp;
        String[] attrs;
        ValuePattern authzIDPattern;
        ValuePattern ldapURLPattern;
        ValuePattern filterPattern;
        ValuePattern dnPattern;
        if (this.sampleRateFile.isPresent()) {
            try {
                RateAdjustor.writeSampleVariableRateFile(this.sampleRateFile.getValue());
                return ResultCode.SUCCESS;
            }
            catch (Exception e) {
                Debug.debugException(e);
                this.err("An error occurred while trying to write sample variable data rate file '", this.sampleRateFile.getValue().getAbsolutePath(), "':  ", StaticUtils.getExceptionMessage(e));
                return ResultCode.LOCAL_ERROR;
            }
        }
        Long seed = this.randomSeed.isPresent() ? Long.valueOf(this.randomSeed.getValue().intValue()) : null;
        try {
            dnPattern = this.baseDN.getNumOccurrences() > 0 ? new ValuePattern(this.baseDN.getValue(), seed) : (this.ldapURL.isPresent() ? null : new ValuePattern("", seed));
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            this.err("Unable to parse the base DN value pattern:  ", pe.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        try {
            filterPattern = this.filter.isPresent() ? new ValuePattern(this.filter.getValue(), seed) : null;
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            this.err("Unable to parse the filter pattern:  ", pe.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        try {
            ldapURLPattern = this.ldapURL.isPresent() ? new ValuePattern(this.ldapURL.getValue(), seed) : null;
        }
        catch (ParseException pe) {
            Debug.debugException(pe);
            this.err("Unable to parse the LDAP URL pattern:  ", pe.getMessage());
            return ResultCode.PARAM_ERROR;
        }
        if (this.proxyAs.isPresent()) {
            try {
                authzIDPattern = new ValuePattern(this.proxyAs.getValue(), seed);
            }
            catch (ParseException pe) {
                Debug.debugException(pe);
                this.err("Unable to parse the proxied authorization pattern:  ", pe.getMessage());
                return ResultCode.PARAM_ERROR;
            }
        } else {
            authzIDPattern = null;
        }
        String derefValue = StaticUtils.toLowerCase(this.dereferencePolicy.getValue());
        DereferencePolicy derefPolicy = derefValue.equals("always") ? DereferencePolicy.ALWAYS : (derefValue.equals("search") ? DereferencePolicy.SEARCHING : (derefValue.equals("find") ? DereferencePolicy.FINDING : DereferencePolicy.NEVER));
        ArrayList<Control> controlList = new ArrayList<Control>(5);
        if (this.assertionFilter.isPresent()) {
            controlList.add(new AssertionRequestControl(this.assertionFilter.getValue()));
        }
        if (this.sortOrder.isPresent()) {
            ArrayList<SortKey> sortKeys = new ArrayList<SortKey>(5);
            StringTokenizer tokenizer = new StringTokenizer(this.sortOrder.getValue(), ",");
            while (tokenizer.hasMoreTokens()) {
                String matchingRuleID;
                String attributeName;
                boolean ascending;
                String token = tokenizer.nextToken().trim();
                if (token.startsWith("+")) {
                    ascending = true;
                    token = token.substring(1);
                } else if (token.startsWith("-")) {
                    ascending = false;
                    token = token.substring(1);
                } else {
                    ascending = true;
                }
                int colonPos = token.indexOf(58);
                if (colonPos < 0) {
                    attributeName = token;
                    matchingRuleID = null;
                } else {
                    attributeName = token.substring(0, colonPos);
                    matchingRuleID = token.substring(colonPos + 1);
                }
                sortKeys.add(new SortKey(attributeName, matchingRuleID, !ascending));
            }
            controlList.add(new ServerSideSortRequestControl(sortKeys));
        }
        if (this.control.isPresent()) {
            controlList.addAll(this.control.getValues());
        }
        if (this.attributes.isPresent()) {
            List<String> attrList = this.attributes.getValues();
            attrs = new String[attrList.size()];
            attrList.toArray(attrs);
        } else {
            attrs = StaticUtils.NO_STRINGS;
        }
        FixedRateBarrier fixedRateBarrier = null;
        if (this.ratePerSecond.isPresent() || this.variableRateData.isPresent()) {
            int intervalSeconds = this.collectionInterval.getValue();
            int ratePerInterval = this.ratePerSecond.getValue() == null ? Integer.MAX_VALUE : this.ratePerSecond.getValue() * intervalSeconds;
            fixedRateBarrier = new FixedRateBarrier(1000L * (long)intervalSeconds, ratePerInterval);
        }
        RateAdjustor rateAdjustor = null;
        if (this.variableRateData.isPresent()) {
            try {
                rateAdjustor = RateAdjustor.newInstance(fixedRateBarrier, this.ratePerSecond.getValue(), this.variableRateData.getValue());
            }
            catch (IOException | IllegalArgumentException e) {
                Debug.debugException(e);
                this.err("Initializing the variable rates failed: " + e.getMessage());
                return ResultCode.PARAM_ERROR;
            }
        }
        Semaphore asyncSemaphore = this.maxOutstandingRequests.isPresent() ? new Semaphore(this.maxOutstandingRequests.getValue()) : null;
        if (this.timestampFormat.getValue().equalsIgnoreCase("with-date")) {
            includeTimestamp = true;
            timeFormat = "dd/MM/yyyy HH:mm:ss";
        } else if (this.timestampFormat.getValue().equalsIgnoreCase("without-date")) {
            includeTimestamp = true;
            timeFormat = "HH:mm:ss";
        } else {
            includeTimestamp = false;
            timeFormat = null;
        }
        int remainingWarmUpIntervals = this.warmUpIntervals.getValue();
        if (remainingWarmUpIntervals > 0) {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue() + (long)remainingWarmUpIntervals;
        } else {
            warmUp = true;
            totalIntervals = 0L + (long)this.numIntervals.getValue().intValue();
        }
        OutputFormat outputFormat = this.csvFormat.isPresent() ? OutputFormat.CSV : OutputFormat.COLUMNS;
        ColumnFormatter formatter = new ColumnFormatter(includeTimestamp, timeFormat, outputFormat, " ", new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Searches/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Avg Dur ms"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Entries/Srch"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Recent", "Errors/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Overall", "Searches/Sec"), new FormattableColumn(12, HorizontalAlignment.RIGHT, "Overall", "Avg Dur ms"));
        AtomicLong searchCounter = new AtomicLong(0L);
        AtomicLong entryCounter = new AtomicLong(0L);
        AtomicLong errorCounter = new AtomicLong(0L);
        AtomicLong searchDurations = new AtomicLong(0L);
        ResultCodeCounter rcCounter = new ResultCodeCounter();
        long intervalMillis = 1000L * (long)this.collectionInterval.getValue().intValue();
        CyclicBarrier barrier = new CyclicBarrier(this.numThreads.getValue() + 1);
        SearchRateThread[] threads = new SearchRateThread[this.numThreads.getValue().intValue()];
        for (int i = 0; i < threads.length; ++i) {
            LDAPConnection connection;
            try {
                connection = this.getConnection();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.err("Unable to connect to the directory server:  ", StaticUtils.getExceptionMessage(le));
                return le.getResultCode();
            }
            threads[i] = new SearchRateThread(this, i, connection, this.asynchronousMode.isPresent(), dnPattern, this.scope.getValue(), derefPolicy, this.sizeLimit.getValue(), this.timeLimitSeconds.getValue(), this.typesOnly.isPresent(), filterPattern, attrs, ldapURLPattern, authzIDPattern, this.simplePageSize.getValue(), controlList, this.iterationsBeforeReconnect.getValue().intValue(), this.runningThreads, barrier, searchCounter, entryCounter, searchDurations, errorCounter, rcCounter, fixedRateBarrier, asyncSemaphore);
            threads[i].start();
        }
        for (String headerLine : formatter.getHeaderLines(true)) {
            this.out(headerLine);
        }
        if (rateAdjustor != null && remainingWarmUpIntervals <= 0) {
            rateAdjustor.start();
        }
        try {
            barrier.await();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        long overallStartTime = System.nanoTime();
        long nextIntervalStartTime = System.currentTimeMillis() + intervalMillis;
        boolean setOverallStartTime = false;
        long lastDuration = 0L;
        long lastNumEntries = 0L;
        long lastNumErrors = 0L;
        long lastNumSearches = 0L;
        long lastEndTime = System.nanoTime();
        for (long i = 0L; i < totalIntervals; ++i) {
            double recentAvgDuration;
            double recentEntriesPerSearch;
            long totalDuration;
            long numErrors;
            long numEntries;
            long numSearches;
            if (rateAdjustor != null && !rateAdjustor.isAlive()) {
                this.out("All of the rates in " + this.variableRateData.getValue().getName() + " have been completed.");
                break;
            }
            long startTimeMillis = System.currentTimeMillis();
            long sleepTimeMillis = nextIntervalStartTime - startTimeMillis;
            nextIntervalStartTime += intervalMillis;
            if (sleepTimeMillis > 0L) {
                this.sleeper.sleep(sleepTimeMillis);
            }
            if (this.stopRequested.get()) break;
            long endTime = System.nanoTime();
            long intervalDuration = endTime - lastEndTime;
            if (warmUp && remainingWarmUpIntervals > 0) {
                numSearches = searchCounter.getAndSet(0L);
                numEntries = entryCounter.getAndSet(0L);
                numErrors = errorCounter.getAndSet(0L);
                totalDuration = searchDurations.getAndSet(0L);
            } else {
                numSearches = searchCounter.get();
                numEntries = entryCounter.get();
                numErrors = errorCounter.get();
                totalDuration = searchDurations.get();
            }
            long recentNumSearches = numSearches - lastNumSearches;
            long recentNumEntries = numEntries - lastNumEntries;
            long recentNumErrors = numErrors - lastNumErrors;
            long recentDuration = totalDuration - lastDuration;
            double numSeconds = (double)intervalDuration / 1.0E9;
            double recentSearchRate = (double)recentNumSearches / numSeconds;
            double recentErrorRate = (double)recentNumErrors / numSeconds;
            if (recentNumSearches > 0L) {
                recentEntriesPerSearch = 1.0 * (double)recentNumEntries / (double)recentNumSearches;
                recentAvgDuration = 1.0 * (double)recentDuration / (double)recentNumSearches / 1000000.0;
            } else {
                recentEntriesPerSearch = 0.0;
                recentAvgDuration = 0.0;
            }
            if (warmUp && remainingWarmUpIntervals > 0) {
                this.out(formatter.formatRow(recentSearchRate, recentAvgDuration, recentEntriesPerSearch, recentErrorRate, "warming up", "warming up"));
                if (--remainingWarmUpIntervals == 0) {
                    this.out("Warm-up completed.  Beginning overall statistics collection.");
                    setOverallStartTime = true;
                    if (rateAdjustor != null) {
                        rateAdjustor.start();
                    }
                }
            } else {
                if (setOverallStartTime) {
                    overallStartTime = lastEndTime;
                    setOverallStartTime = false;
                }
                double numOverallSeconds = (double)(endTime - overallStartTime) / 1.0E9;
                double overallSearchRate = (double)numSearches / numOverallSeconds;
                double overallAvgDuration = numSearches > 0L ? 1.0 * (double)totalDuration / (double)numSearches / 1000000.0 : 0.0;
                this.out(formatter.formatRow(recentSearchRate, recentAvgDuration, recentEntriesPerSearch, recentErrorRate, overallSearchRate, overallAvgDuration));
                lastNumSearches = numSearches;
                lastNumEntries = numEntries;
                lastNumErrors = numErrors;
                lastDuration = totalDuration;
            }
            List<ObjectPair<ResultCode, Long>> rcCounts = rcCounter.getCounts(true);
            if (!this.suppressErrors.isPresent() && !rcCounts.isEmpty()) {
                this.err("\tError Results:");
                for (ObjectPair<ResultCode, Long> p : rcCounts) {
                    this.err("\t", p.getFirst().getName(), ":  ", p.getSecond());
                }
            }
            lastEndTime = endTime;
        }
        if (rateAdjustor != null) {
            rateAdjustor.shutDown();
        }
        ResultCode resultCode = ResultCode.SUCCESS;
        for (SearchRateThread t : threads) {
            t.signalShutdown();
        }
        for (SearchRateThread t : threads) {
            ResultCode r = t.waitForShutdown();
            if (resultCode != ResultCode.SUCCESS) continue;
            resultCode = r;
        }
        return resultCode;
    }

    public void stopRunning() {
        int stillRunning;
        this.stopRequested.set(true);
        this.sleeper.wakeup();
        while ((stillRunning = this.runningThreads.get()) > 0) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    int getMaxOutstandingRequests() {
        if (this.maxOutstandingRequests.isPresent()) {
            return this.maxOutstandingRequests.getValue();
        }
        return -1;
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--bindDN", "uid=admin,dc=example,dc=com", "--bindPassword", "password", "--baseDN", "dc=example,dc=com", "--scope", "sub", "--filter", "(uid=user.[1-1000000])", "--attribute", "givenName", "--attribute", "sn", "--attribute", "mail", "--numThreads", "10"};
        String description = "Test search performance by searching randomly across a set of one million users located below 'dc=example,dc=com' with ten concurrent threads.  The entries returned to the client will include the givenName, sn, and mail attributes.";
        examples.put(args, description);
        args = new String[]{"--generateSampleRateFile", "variable-rate-data.txt"};
        description = "Generate a sample variable rate definition file that may be used in conjunction with the --variableRateData argument.  The sample file will include comments that describe the format for data to be included in this file.";
        examples.put(args, description);
        return examples;
    }
}

