/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.StartTLSPostConnectProcessor;
import com.unboundid.ldap.sdk.extensions.StartTLSExtendedRequest;
import com.unboundid.util.CommandLineTool;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.SASLUtils;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import com.unboundid.util.ssl.AggregateTrustManager;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustAllTrustManager;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

@Extensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class MultiServerLDAPCommandLineTool
extends CommandLineTool {
    private final int numServers;
    @Nullable
    private final String[] serverNamePrefixes;
    @Nullable
    private final String[] serverNameSuffixes;
    @NotNull
    private final BooleanArgument[] trustAll;
    @NotNull
    private final BooleanArgument[] useSSL;
    @NotNull
    private final BooleanArgument[] useStartTLS;
    @NotNull
    private final DNArgument[] bindDN;
    @NotNull
    private final FileArgument[] bindPasswordFile;
    @NotNull
    private final FileArgument[] keyStorePasswordFile;
    @NotNull
    private final FileArgument[] trustStorePasswordFile;
    @NotNull
    private final IntegerArgument[] port;
    @NotNull
    private final StringArgument[] bindPassword;
    @NotNull
    private final StringArgument[] certificateNickname;
    @NotNull
    private final StringArgument[] host;
    @NotNull
    private final StringArgument[] keyStoreFormat;
    @NotNull
    private final StringArgument[] keyStorePath;
    @NotNull
    private final StringArgument[] keyStorePassword;
    @NotNull
    private final StringArgument[] saslOption;
    @NotNull
    private final StringArgument[] trustStoreFormat;
    @NotNull
    private final StringArgument[] trustStorePath;
    @NotNull
    private final StringArgument[] trustStorePassword;
    @NotNull
    private final BindRequest[] bindRequest;
    @NotNull
    private final ServerSet[] serverSet;
    @NotNull
    private final SSLSocketFactory[] startTLSSocketFactory;
    @NotNull
    private final AtomicReference<AggregateTrustManager> promptTrustManager = new AtomicReference();

    public MultiServerLDAPCommandLineTool(@Nullable OutputStream outStream, @Nullable OutputStream errStream, @Nullable String[] serverNamePrefixes, @Nullable String[] serverNameSuffixes) throws LDAPSDKUsageException {
        super(outStream, errStream);
        this.serverNamePrefixes = serverNamePrefixes;
        this.serverNameSuffixes = serverNameSuffixes;
        if (serverNamePrefixes == null) {
            if (serverNameSuffixes == null) {
                throw new LDAPSDKUsageException(UtilityMessages.ERR_MULTI_LDAP_TOOL_PREFIXES_AND_SUFFIXES_NULL.get());
            }
            this.numServers = serverNameSuffixes.length;
        } else {
            this.numServers = serverNamePrefixes.length;
            if (serverNameSuffixes != null && serverNamePrefixes.length != serverNameSuffixes.length) {
                throw new LDAPSDKUsageException(UtilityMessages.ERR_MULTI_LDAP_TOOL_PREFIXES_AND_SUFFIXES_MISMATCH.get());
            }
        }
        if (this.numServers == 0) {
            throw new LDAPSDKUsageException(UtilityMessages.ERR_MULTI_LDAP_TOOL_PREFIXES_AND_SUFFIXES_EMPTY.get());
        }
        this.trustAll = new BooleanArgument[this.numServers];
        this.useSSL = new BooleanArgument[this.numServers];
        this.useStartTLS = new BooleanArgument[this.numServers];
        this.bindDN = new DNArgument[this.numServers];
        this.bindPasswordFile = new FileArgument[this.numServers];
        this.keyStorePasswordFile = new FileArgument[this.numServers];
        this.trustStorePasswordFile = new FileArgument[this.numServers];
        this.port = new IntegerArgument[this.numServers];
        this.bindPassword = new StringArgument[this.numServers];
        this.certificateNickname = new StringArgument[this.numServers];
        this.host = new StringArgument[this.numServers];
        this.keyStoreFormat = new StringArgument[this.numServers];
        this.keyStorePath = new StringArgument[this.numServers];
        this.keyStorePassword = new StringArgument[this.numServers];
        this.saslOption = new StringArgument[this.numServers];
        this.trustStoreFormat = new StringArgument[this.numServers];
        this.trustStorePath = new StringArgument[this.numServers];
        this.trustStorePassword = new StringArgument[this.numServers];
        this.bindRequest = new BindRequest[this.numServers];
        this.serverSet = new ServerSet[this.numServers];
        this.startTLSSocketFactory = new SSLSocketFactory[this.numServers];
    }

    @Override
    public final void addToolArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        for (int i = 0; i < this.numServers; ++i) {
            StringBuilder groupNameBuffer = new StringBuilder();
            if (this.serverNamePrefixes != null) {
                String prefix = this.serverNamePrefixes[i].replace('-', ' ').trim();
                groupNameBuffer.append(StaticUtils.capitalize(prefix, true));
            }
            if (this.serverNameSuffixes != null) {
                if (groupNameBuffer.length() > 0) {
                    groupNameBuffer.append(' ');
                }
                String suffix = this.serverNameSuffixes[i].replace('-', ' ').trim();
                groupNameBuffer.append(StaticUtils.capitalize(suffix, true));
            }
            groupNameBuffer.append(' ');
            groupNameBuffer.append(UtilityMessages.INFO_MULTI_LDAP_TOOL_GROUP_CONN_AND_AUTH.get());
            String groupName = groupNameBuffer.toString();
            this.host[i] = new StringArgument(null, this.genArgName(i, "hostname"), true, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_HOST.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_HOST.get(), "localhost");
            if (this.includeAlternateLongIdentifiers()) {
                this.host[i].addLongIdentifier(this.genDashedArgName(i, "hostname"), true);
                this.host[i].addLongIdentifier(this.genArgName(i, "host"), true);
                this.host[i].addLongIdentifier(this.genDashedArgName(i, "host"), true);
                this.host[i].addLongIdentifier(this.genArgName(i, "address"), true);
                this.host[i].addLongIdentifier(this.genDashedArgName(i, "address"), true);
            }
            this.host[i].setArgumentGroupName(groupName);
            parser.addArgument(this.host[i]);
            this.port[i] = new IntegerArgument(null, this.genArgName(i, "port"), true, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PORT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_PORT.get(), 1, 65535, 389);
            this.port[i].setArgumentGroupName(groupName);
            if (this.includeAlternateLongIdentifiers()) {
                this.port[i].addLongIdentifier(this.genDashedArgName(i, "port"), true);
            }
            parser.addArgument(this.port[i]);
            this.bindDN[i] = new DNArgument(null, this.genArgName(i, "bindDN"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_DN.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_DN.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.bindDN[i].addLongIdentifier(this.genDashedArgName(i, "bind-dn"), true);
            }
            this.bindDN[i].setArgumentGroupName(groupName);
            parser.addArgument(this.bindDN[i]);
            this.bindPassword[i] = new StringArgument(null, this.genArgName(i, "bindPassword"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_PW.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.bindPassword[i].addLongIdentifier(this.genDashedArgName(i, "bind-password"), true);
            }
            this.bindPassword[i].setSensitive(true);
            this.bindPassword[i].setArgumentGroupName(groupName);
            parser.addArgument(this.bindPassword[i]);
            this.bindPasswordFile[i] = new FileArgument(null, this.genArgName(i, "bindPasswordFile"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_BIND_PW_FILE.get(), true, true, true, false);
            if (this.includeAlternateLongIdentifiers()) {
                this.bindPasswordFile[i].addLongIdentifier(this.genDashedArgName(i, "bind-password-file"), true);
            }
            this.bindPasswordFile[i].setArgumentGroupName(groupName);
            parser.addArgument(this.bindPasswordFile[i]);
            this.useSSL[i] = new BooleanArgument(null, this.genArgName(i, "useSSL"), 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_USE_SSL.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.useSSL[i].addLongIdentifier(this.genDashedArgName(i, "use-ssl"), true);
            }
            this.useSSL[i].setArgumentGroupName(groupName);
            parser.addArgument(this.useSSL[i]);
            this.useStartTLS[i] = new BooleanArgument(null, this.genArgName(i, "useStartTLS"), 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_USE_START_TLS.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.useStartTLS[i].addLongIdentifier(this.genDashedArgName(i, "use-start-tls"), true);
            }
            this.useStartTLS[i].setArgumentGroupName(groupName);
            parser.addArgument(this.useStartTLS[i]);
            this.trustAll[i] = new BooleanArgument(null, this.genArgName(i, "trustAll"), 1, UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_ALL.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.trustAll[i].addLongIdentifier(this.genDashedArgName(i, "trust-all"), true);
            }
            this.trustAll[i].setArgumentGroupName(groupName);
            parser.addArgument(this.trustAll[i]);
            this.keyStorePath[i] = new StringArgument(null, this.genArgName(i, "keyStorePath"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PATH.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.keyStorePath[i].addLongIdentifier(this.genDashedArgName(i, "key-store-path"), true);
            }
            this.keyStorePath[i].setArgumentGroupName(groupName);
            parser.addArgument(this.keyStorePath[i]);
            this.keyStorePassword[i] = new StringArgument(null, this.genArgName(i, "keyStorePassword"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.keyStorePassword[i].addLongIdentifier(this.genDashedArgName(i, "key-store-password"), true);
            }
            this.keyStorePassword[i].setSensitive(true);
            this.keyStorePassword[i].setArgumentGroupName(groupName);
            parser.addArgument(this.keyStorePassword[i]);
            this.keyStorePasswordFile[i] = new FileArgument(null, this.genArgName(i, "keyStorePasswordFile"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_FILE.get(), true, true, true, false);
            if (this.includeAlternateLongIdentifiers()) {
                this.keyStorePasswordFile[i].addLongIdentifier(this.genDashedArgName(i, "key-store-password-file"), true);
            }
            this.keyStorePasswordFile[i].setArgumentGroupName(groupName);
            parser.addArgument(this.keyStorePasswordFile[i]);
            this.keyStoreFormat[i] = new StringArgument(null, this.genArgName(i, "keyStoreFormat"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_FORMAT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_KEY_STORE_FORMAT.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.keyStoreFormat[i].addLongIdentifier(this.genDashedArgName(i, "key-store-format"), true);
                this.keyStoreFormat[i].addLongIdentifier(this.genArgName(i, "keyStoreType"), true);
                this.keyStoreFormat[i].addLongIdentifier(this.genDashedArgName(i, "key-store-type"), true);
            }
            this.keyStoreFormat[i].setArgumentGroupName(groupName);
            parser.addArgument(this.keyStoreFormat[i]);
            this.trustStorePath[i] = new StringArgument(null, this.genArgName(i, "trustStorePath"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PATH.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.trustStorePath[i].addLongIdentifier(this.genDashedArgName(i, "trust-store-path"), true);
            }
            this.trustStorePath[i].setArgumentGroupName(groupName);
            parser.addArgument(this.trustStorePath[i]);
            this.trustStorePassword[i] = new StringArgument(null, this.genArgName(i, "trustStorePassword"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PASSWORD.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.trustStorePassword[i].addLongIdentifier(this.genDashedArgName(i, "trust-store-password"), true);
            }
            this.trustStorePassword[i].setSensitive(true);
            this.trustStorePassword[i].setArgumentGroupName(groupName);
            parser.addArgument(this.trustStorePassword[i]);
            this.trustStorePasswordFile[i] = new FileArgument(null, this.genArgName(i, "trustStorePasswordFile"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_PATH.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_FILE.get(), true, true, true, false);
            if (this.includeAlternateLongIdentifiers()) {
                this.trustStorePasswordFile[i].addLongIdentifier(this.genDashedArgName(i, "trust-store-password-file"), true);
            }
            this.trustStorePasswordFile[i].setArgumentGroupName(groupName);
            parser.addArgument(this.trustStorePasswordFile[i]);
            this.trustStoreFormat[i] = new StringArgument(null, this.genArgName(i, "trustStoreFormat"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_FORMAT.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_TRUST_STORE_FORMAT.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.trustStoreFormat[i].addLongIdentifier(this.genDashedArgName(i, "trust-store-format"), true);
                this.trustStoreFormat[i].addLongIdentifier(this.genArgName(i, "trustStoreType"), true);
                this.trustStoreFormat[i].addLongIdentifier(this.genDashedArgName(i, "trust-store-type"), true);
            }
            this.trustStoreFormat[i].setArgumentGroupName(groupName);
            parser.addArgument(this.trustStoreFormat[i]);
            this.certificateNickname[i] = new StringArgument(null, this.genArgName(i, "certNickname"), false, 1, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_CERT_NICKNAME.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_CERT_NICKNAME.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.certificateNickname[i].addLongIdentifier(this.genDashedArgName(i, "cert-nickname"), true);
                this.certificateNickname[i].addLongIdentifier(this.genArgName(i, "certificateNickname"), true);
                this.certificateNickname[i].addLongIdentifier(this.genDashedArgName(i, "certificate-nickname"), true);
            }
            this.certificateNickname[i].setArgumentGroupName(groupName);
            parser.addArgument(this.certificateNickname[i]);
            this.saslOption[i] = new StringArgument(null, this.genArgName(i, "saslOption"), false, 0, UtilityMessages.INFO_LDAP_TOOL_PLACEHOLDER_SASL_OPTION.get(), UtilityMessages.INFO_LDAP_TOOL_DESCRIPTION_SASL_OPTION.get());
            if (this.includeAlternateLongIdentifiers()) {
                this.saslOption[i].addLongIdentifier(this.genDashedArgName(i, "sasl-option"), true);
            }
            this.saslOption[i].setArgumentGroupName(groupName);
            parser.addArgument(this.saslOption[i]);
            parser.addDependentArgumentSet(this.bindDN[i], this.bindPassword[i], this.bindPasswordFile[i]);
            parser.addExclusiveArgumentSet(this.useSSL[i], this.useStartTLS[i], new Argument[0]);
            parser.addExclusiveArgumentSet(this.bindPassword[i], this.bindPasswordFile[i], new Argument[0]);
            parser.addExclusiveArgumentSet(this.keyStorePassword[i], this.keyStorePasswordFile[i], new Argument[0]);
            parser.addExclusiveArgumentSet(this.trustStorePassword[i], this.trustStorePasswordFile[i], new Argument[0]);
            parser.addExclusiveArgumentSet(this.trustAll[i], this.trustStorePath[i], new Argument[0]);
        }
        this.addNonLDAPArguments(parser);
    }

    @NotNull
    private String genArgName(int index, @NotNull String base) {
        StringBuilder buffer = new StringBuilder();
        if (this.serverNamePrefixes != null) {
            buffer.append(this.serverNamePrefixes[index]);
            if (base.equals("saslOption")) {
                buffer.append("SASLOption");
            } else {
                buffer.append(StaticUtils.capitalize(base));
            }
        } else {
            buffer.append(base);
        }
        if (this.serverNameSuffixes != null) {
            buffer.append(this.serverNameSuffixes[index]);
        }
        return buffer.toString();
    }

    @NotNull
    private String genDashedArgName(int index, @NotNull String base) {
        StringBuilder buffer = new StringBuilder();
        if (this.serverNamePrefixes != null) {
            buffer.append(this.serverNamePrefixes[index]);
            buffer.append('-');
        }
        buffer.append(base);
        if (this.serverNameSuffixes != null) {
            buffer.append('-');
            buffer.append(this.serverNameSuffixes[index]);
        }
        return buffer.toString();
    }

    protected boolean includeAlternateLongIdentifiers() {
        return false;
    }

    public abstract void addNonLDAPArguments(@NotNull ArgumentParser var1) throws ArgumentException;

    @Override
    public final void doExtendedArgumentValidation() throws ArgumentException {
        this.doExtendedNonLDAPArgumentValidation();
    }

    public void doExtendedNonLDAPArgumentValidation() throws ArgumentException {
    }

    @NotNull
    public LDAPConnectionOptions getConnectionOptions() {
        return new LDAPConnectionOptions();
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    @NotNull
    public final LDAPConnection getConnection(int serverIndex) throws LDAPException {
        LDAPConnection connection = this.getUnauthenticatedConnection(serverIndex);
        try {
            if (this.bindRequest[serverIndex] != null) {
                connection.bind(this.bindRequest[serverIndex]);
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            connection.close();
            throw le;
        }
        return connection;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    @NotNull
    public final LDAPConnection getUnauthenticatedConnection(int serverIndex) throws LDAPException {
        if (this.serverSet[serverIndex] == null) {
            this.serverSet[serverIndex] = this.createServerSet(serverIndex);
            this.bindRequest[serverIndex] = this.createBindRequest(serverIndex);
        }
        LDAPConnection connection = this.serverSet[serverIndex].getConnection();
        if (this.useStartTLS[serverIndex].isPresent()) {
            try {
                ExtendedResult extendedResult = connection.processExtendedOperation(new StartTLSExtendedRequest(this.startTLSSocketFactory[serverIndex]));
                if (!extendedResult.getResultCode().equals(ResultCode.SUCCESS)) {
                    throw new LDAPException(extendedResult.getResultCode(), UtilityMessages.ERR_LDAP_TOOL_START_TLS_FAILED.get(extendedResult.getDiagnosticMessage()));
                }
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                connection.close();
                throw le;
            }
        }
        return connection;
    }

    @ThreadSafety(level=ThreadSafetyLevel.METHOD_THREADSAFE)
    @NotNull
    public final LDAPConnectionPool getConnectionPool(int serverIndex, int initialConnections, int maxConnections) throws LDAPException {
        if (this.serverSet[serverIndex] == null) {
            this.serverSet[serverIndex] = this.createServerSet(serverIndex);
            this.bindRequest[serverIndex] = this.createBindRequest(serverIndex);
        }
        StartTLSPostConnectProcessor postConnectProcessor = null;
        if (this.useStartTLS[serverIndex].isPresent()) {
            postConnectProcessor = new StartTLSPostConnectProcessor(this.startTLSSocketFactory[serverIndex]);
        }
        return new LDAPConnectionPool(this.serverSet[serverIndex], this.bindRequest[serverIndex], initialConnections, maxConnections, postConnectProcessor);
    }

    @NotNull
    public final ServerSet createServerSet(int serverIndex) throws LDAPException {
        SSLUtil sslUtil = this.createSSLUtil(serverIndex);
        SSLSocketFactory socketFactory = null;
        if (this.useSSL[serverIndex].isPresent()) {
            try {
                socketFactory = sslUtil.createSSLSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        if (this.useStartTLS[serverIndex].isPresent()) {
            try {
                this.startTLSSocketFactory[serverIndex] = sslUtil.createSSLSocketFactory();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_SSL_SOCKET_FACTORY.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        return new SingleServerSet(this.host[serverIndex].getValue(), this.port[serverIndex].getValue(), socketFactory, this.getConnectionOptions());
    }

    @Nullable
    public final SSLUtil createSSLUtil(int serverIndex) throws LDAPException {
        if (this.useSSL[serverIndex].isPresent() || this.useStartTLS[serverIndex].isPresent()) {
            TrustManager tm;
            KeyStoreKeyManager keyManager = null;
            if (this.keyStorePath[serverIndex].isPresent()) {
                char[] pw = null;
                if (this.keyStorePassword[serverIndex].isPresent()) {
                    pw = this.keyStorePassword[serverIndex].getValue().toCharArray();
                } else if (this.keyStorePasswordFile[serverIndex].isPresent()) {
                    try {
                        pw = this.getPasswordFileReader().readPassword(this.keyStorePasswordFile[serverIndex].getValue());
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_KEY_STORE_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                try {
                    keyManager = new KeyStoreKeyManager(this.keyStorePath[serverIndex].getValue(), pw, this.keyStoreFormat[serverIndex].getValue(), this.certificateNickname[serverIndex].getValue(), true);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_CREATE_KEY_MANAGER.get(StaticUtils.getExceptionMessage(e)), e);
                }
            }
            if (this.trustAll[serverIndex].isPresent()) {
                tm = new TrustAllTrustManager(false);
            } else if (this.trustStorePath[serverIndex].isPresent()) {
                char[] pw = null;
                if (this.trustStorePassword[serverIndex].isPresent()) {
                    pw = this.trustStorePassword[serverIndex].getValue().toCharArray();
                } else if (this.trustStorePasswordFile[serverIndex].isPresent()) {
                    try {
                        pw = this.getPasswordFileReader().readPassword(this.trustStorePasswordFile[serverIndex].getValue());
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
                    }
                }
                tm = new TrustStoreTrustManager(this.trustStorePath[serverIndex].getValue(), pw, this.trustStoreFormat[serverIndex].getValue(), true);
            } else {
                tm = this.promptTrustManager.get();
                if (tm == null) {
                    AggregateTrustManager atm = InternalSDKHelper.getPreferredPromptTrustManagerChain(null);
                    tm = this.promptTrustManager.compareAndSet(null, atm) ? atm : (TrustManager)this.promptTrustManager.get();
                }
            }
            return new SSLUtil(keyManager, tm);
        }
        return null;
    }

    @Nullable
    public final BindRequest createBindRequest(int serverIndex) throws LDAPException {
        String pw;
        if (this.bindPassword[serverIndex].isPresent()) {
            pw = this.bindPassword[serverIndex].getValue();
        } else if (this.bindPasswordFile[serverIndex].isPresent()) {
            try {
                pw = new String(this.getPasswordFileReader().readPassword(this.bindPasswordFile[serverIndex].getValue()));
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, UtilityMessages.ERR_LDAP_TOOL_CANNOT_READ_BIND_PASSWORD.get(StaticUtils.getExceptionMessage(e)), e);
            }
        } else {
            pw = null;
        }
        if (this.saslOption[serverIndex].isPresent()) {
            String dnStr = this.bindDN[serverIndex].isPresent() ? this.bindDN[serverIndex].getValue().toString() : null;
            return SASLUtils.createBindRequest(dnStr, pw, null, this.saslOption[serverIndex].getValues(), new Control[0]);
        }
        if (this.bindDN[serverIndex].isPresent()) {
            return new SimpleBindRequest(this.bindDN[serverIndex].getValue(), pw);
        }
        return null;
    }
}

