/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.ssl.cert;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.OID;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.ssl.cert.CertMessages;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum ExtendedKeyUsageID {
    TLS_SERVER_AUTHENTICATION("1.3.6.1.5.5.7.3.1", CertMessages.INFO_EXTENDED_KEY_USAGE_ID_TLS_SERVER_AUTHENTICATION.get()),
    TLS_CLIENT_AUTHENTICATION("1.3.6.1.5.5.7.3.2", CertMessages.INFO_EXTENDED_KEY_USAGE_ID_TLS_CLIENT_AUTHENTICATION.get()),
    CODE_SIGNING("1.3.6.1.5.5.7.3.3", CertMessages.INFO_EXTENDED_KEY_USAGE_ID_CODE_SIGNING.get()),
    EMAIL_PROTECTION("1.3.6.1.5.5.7.3.4", CertMessages.INFO_EXTENDED_KEY_USAGE_ID_EMAIL_PROTECTION.get()),
    TIME_STAMPING("1.3.6.1.5.5.7.3.8", CertMessages.INFO_EXTENDED_KEY_USAGE_ID_TIME_STAMPING.get()),
    OCSP_SIGNING("1.3.6.1.5.5.7.3.9", CertMessages.INFO_EXTENDED_KEY_USAGE_ID_OCSP_SIGNING.get());

    @NotNull
    private final OID oid;
    @NotNull
    private final String name;

    private ExtendedKeyUsageID(String oidString, String name) {
        this.name = name;
        this.oid = new OID(oidString);
    }

    @NotNull
    public OID getOID() {
        return this.oid;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static ExtendedKeyUsageID forOID(@NotNull OID oid) {
        for (ExtendedKeyUsageID id : ExtendedKeyUsageID.values()) {
            if (!id.oid.equals(oid)) continue;
            return id;
        }
        return null;
    }

    @NotNull
    public static String getNameOrOID(@NotNull OID oid) {
        ExtendedKeyUsageID id = ExtendedKeyUsageID.forOID(oid);
        if (id == null) {
            return oid.toString();
        }
        return id.name;
    }

    @Nullable
    public static ExtendedKeyUsageID forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "tlsserverauthentication": 
            case "tls-server-authentication": 
            case "tls_server_authentication": 
            case "tls server authentication": 
            case "serverauth": 
            case "server-auth": 
            case "server_auth": 
            case "server auth": {
                return TLS_SERVER_AUTHENTICATION;
            }
            case "tlsclientauthentication": 
            case "tls-client-authentication": 
            case "tls_client_authentication": 
            case "tls client authentication": 
            case "clientauth": 
            case "client-auth": 
            case "client_auth": 
            case "client auth": {
                return TLS_CLIENT_AUTHENTICATION;
            }
            case "codesigning": 
            case "code-signing": 
            case "code_signing": 
            case "code signing": {
                return CODE_SIGNING;
            }
            case "emailprotection": 
            case "email-protection": 
            case "email_protection": 
            case "email protection": {
                return EMAIL_PROTECTION;
            }
            case "timestamping": 
            case "time-stamping": 
            case "time_stamping": 
            case "time stamping": {
                return TIME_STAMPING;
            }
            case "ocspsigning": 
            case "ocsp-signing": 
            case "ocsp_signing": 
            case "ocsp signing": {
                return OCSP_SIGNING;
            }
        }
        return null;
    }
}

