/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class LDAPDiffProcessorResult
implements Serializable {
    private static final long serialVersionUID = -1461317955346577315L;
    private final boolean entryMissing;
    @Nullable
    private final ChangeType changeType;
    @Nullable
    private final List<Modification> modifications;
    @Nullable
    private final ReadOnlyEntry entry;
    @NotNull
    private final String dn;

    private LDAPDiffProcessorResult(@NotNull String dn, boolean entryMissing, @Nullable ChangeType changeType, @Nullable ReadOnlyEntry entry, @Nullable List<Modification> modifications) {
        this.dn = dn;
        this.entryMissing = entryMissing;
        this.changeType = changeType;
        this.entry = entry;
        this.modifications = modifications;
    }

    @NotNull
    static LDAPDiffProcessorResult createEntryMissingResult(@NotNull String dn) {
        return new LDAPDiffProcessorResult(dn, true, null, null, null);
    }

    @NotNull
    static LDAPDiffProcessorResult createNoChangesResult(@NotNull String dn) {
        return new LDAPDiffProcessorResult(dn, false, null, null, null);
    }

    @NotNull
    static LDAPDiffProcessorResult createAddResult(@NotNull ReadOnlyEntry entry) {
        return new LDAPDiffProcessorResult(entry.getDN(), false, ChangeType.ADD, entry, null);
    }

    @NotNull
    static LDAPDiffProcessorResult createDeleteResult(@NotNull ReadOnlyEntry entry) {
        return new LDAPDiffProcessorResult(entry.getDN(), false, ChangeType.DELETE, entry, null);
    }

    @NotNull
    static LDAPDiffProcessorResult createModifyResult(@NotNull String dn, @NotNull List<Modification> modifications) {
        return new LDAPDiffProcessorResult(dn, false, ChangeType.MODIFY, null, Collections.unmodifiableList(modifications));
    }

    @NotNull
    String getDN() {
        return this.dn;
    }

    public boolean isEntryMissing() {
        return this.entryMissing;
    }

    @Nullable
    ChangeType getChangeType() {
        return this.changeType;
    }

    @Nullable
    ReadOnlyEntry getEntry() {
        return this.entry;
    }

    @Nullable
    List<Modification> getModifications() {
        return this.modifications;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    void toString(@NotNull StringBuilder buffer) {
        buffer.append("LDAPDiffProcessorResult(dn='");
        buffer.append(this.dn);
        buffer.append("', entryMissing=");
        buffer.append(this.entryMissing);
        buffer.append(", changeType=");
        buffer.append((Object)this.changeType);
        buffer.append(')');
    }
}

