/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlyAddRequest;
import com.unboundid.ldap.sdk.ReadOnlyCompareRequest;
import com.unboundid.ldap.sdk.ReadOnlyDeleteRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyDNRequest;
import com.unboundid.ldap.sdk.ReadOnlyModifyRequest;
import com.unboundid.ldap.sdk.ReadOnlySearchRequest;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFException;
import com.unboundid.util.Debug;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPReadWriteConnectionPool
implements LDAPInterface {
    private final LDAPConnectionPool readPool;
    private final LDAPConnectionPool writePool;

    public LDAPReadWriteConnectionPool(LDAPConnection readConnection, int initialReadConnections, int maxReadConnections, LDAPConnection writeConnection, int initialWriteConnections, int maxWriteConnections) throws LDAPException {
        Validator.ensureNotNull(readConnection, writeConnection);
        Validator.ensureTrue(initialReadConnections >= 1, "LDAPReadWriteConnectionPool.initialReadConnections must be at least 1.");
        Validator.ensureTrue(maxReadConnections >= initialReadConnections, "LDAPReadWriteConnectionPool.initialReadConnections must not be greater than maxReadConnections.");
        Validator.ensureTrue(initialWriteConnections >= 1, "LDAPReadWriteConnectionPool.initialWriteConnections must be at least 1.");
        Validator.ensureTrue(maxWriteConnections >= initialWriteConnections, "LDAPReadWriteConnectionPool.initialWriteConnections must not be greater than maxWriteConnections.");
        this.readPool = new LDAPConnectionPool(readConnection, initialReadConnections, maxReadConnections);
        try {
            this.writePool = new LDAPConnectionPool(writeConnection, initialWriteConnections, maxWriteConnections);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.readPool.close();
            throw le;
        }
    }

    public LDAPReadWriteConnectionPool(LDAPConnectionPool readPool, LDAPConnectionPool writePool) {
        Validator.ensureNotNull(readPool, writePool);
        this.readPool = readPool;
        this.writePool = writePool;
    }

    public void close() {
        this.readPool.close();
        this.writePool.close();
    }

    public boolean isClosed() {
        return this.readPool.isClosed() || this.writePool.isClosed();
    }

    public LDAPConnection getReadConnection() throws LDAPException {
        return this.readPool.getConnection();
    }

    public void releaseReadConnection(LDAPConnection connection) {
        this.readPool.releaseConnection(connection);
    }

    public void releaseDefunctReadConnection(LDAPConnection connection) {
        this.readPool.releaseDefunctConnection(connection);
    }

    public LDAPConnection getWriteConnection() throws LDAPException {
        return this.writePool.getConnection();
    }

    public void releaseWriteConnection(LDAPConnection connection) {
        this.writePool.releaseConnection(connection);
    }

    public void releaseDefunctWriteConnection(LDAPConnection connection) {
        this.writePool.releaseDefunctConnection(connection);
    }

    public LDAPConnectionPoolStatistics getReadPoolStatistics() {
        return this.readPool.getConnectionPoolStatistics();
    }

    public LDAPConnectionPoolStatistics getWritePoolStatistics() {
        return this.writePool.getConnectionPoolStatistics();
    }

    public LDAPConnectionPool getReadPool() {
        return this.readPool;
    }

    public LDAPConnectionPool getWritePool() {
        return this.writePool;
    }

    @Override
    public RootDSE getRootDSE() throws LDAPException {
        return this.readPool.getRootDSE();
    }

    @Override
    public Schema getSchema() throws LDAPException {
        return this.readPool.getSchema();
    }

    @Override
    public Schema getSchema(String entryDN) throws LDAPException {
        return this.readPool.getSchema(entryDN);
    }

    @Override
    public SearchResultEntry getEntry(String dn) throws LDAPException {
        return this.readPool.getEntry(dn);
    }

    @Override
    public SearchResultEntry getEntry(String dn, String ... attributes) throws LDAPException {
        return this.readPool.getEntry(dn, attributes);
    }

    @Override
    public LDAPResult add(String dn, Attribute ... attributes) throws LDAPException {
        return this.writePool.add(dn, attributes);
    }

    @Override
    public LDAPResult add(String dn, Collection<Attribute> attributes) throws LDAPException {
        return this.writePool.add(dn, attributes);
    }

    @Override
    public LDAPResult add(Entry entry) throws LDAPException {
        return this.writePool.add(entry);
    }

    @Override
    public LDAPResult add(String ... ldifLines) throws LDIFException, LDAPException {
        return this.writePool.add(ldifLines);
    }

    @Override
    public LDAPResult add(AddRequest addRequest) throws LDAPException {
        return this.writePool.add(addRequest);
    }

    @Override
    public LDAPResult add(ReadOnlyAddRequest addRequest) throws LDAPException {
        return this.writePool.add((AddRequest)addRequest);
    }

    public BindResult bind(String bindDN, String password) throws LDAPException {
        return this.readPool.bind(bindDN, password);
    }

    public BindResult bind(BindRequest bindRequest) throws LDAPException {
        return this.readPool.bind(bindRequest);
    }

    @Override
    public CompareResult compare(String dn, String attributeName, String assertionValue) throws LDAPException {
        return this.readPool.compare(dn, attributeName, assertionValue);
    }

    @Override
    public CompareResult compare(CompareRequest compareRequest) throws LDAPException {
        return this.readPool.compare(compareRequest);
    }

    @Override
    public CompareResult compare(ReadOnlyCompareRequest compareRequest) throws LDAPException {
        return this.readPool.compare(compareRequest);
    }

    @Override
    public LDAPResult delete(String dn) throws LDAPException {
        return this.writePool.delete(dn);
    }

    @Override
    public LDAPResult delete(DeleteRequest deleteRequest) throws LDAPException {
        return this.writePool.delete(deleteRequest);
    }

    @Override
    public LDAPResult delete(ReadOnlyDeleteRequest deleteRequest) throws LDAPException {
        return this.writePool.delete(deleteRequest);
    }

    @Override
    public LDAPResult modify(String dn, Modification mod) throws LDAPException {
        return this.writePool.modify(dn, mod);
    }

    @Override
    public LDAPResult modify(String dn, Modification ... mods) throws LDAPException {
        return this.writePool.modify(dn, mods);
    }

    @Override
    public LDAPResult modify(String dn, List<Modification> mods) throws LDAPException {
        return this.writePool.modify(dn, mods);
    }

    @Override
    public LDAPResult modify(String ... ldifModificationLines) throws LDIFException, LDAPException {
        return this.writePool.modify(ldifModificationLines);
    }

    @Override
    public LDAPResult modify(ModifyRequest modifyRequest) throws LDAPException {
        return this.writePool.modify(modifyRequest);
    }

    @Override
    public LDAPResult modify(ReadOnlyModifyRequest modifyRequest) throws LDAPException {
        return this.writePool.modify(modifyRequest);
    }

    @Override
    public LDAPResult modifyDN(String dn, String newRDN, boolean deleteOldRDN) throws LDAPException {
        return this.writePool.modifyDN(dn, newRDN, deleteOldRDN);
    }

    @Override
    public LDAPResult modifyDN(String dn, String newRDN, boolean deleteOldRDN, String newSuperiorDN) throws LDAPException {
        return this.writePool.modifyDN(dn, newRDN, deleteOldRDN, newSuperiorDN);
    }

    @Override
    public LDAPResult modifyDN(ModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.writePool.modifyDN(modifyDNRequest);
    }

    @Override
    public LDAPResult modifyDN(ReadOnlyModifyDNRequest modifyDNRequest) throws LDAPException {
        return this.writePool.modifyDN(modifyDNRequest);
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(searchResultListener, baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(searchResultListener, baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResult search(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResult search(SearchResultListener searchResultListener, String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int sizeLimit, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.search(searchResultListener, baseDN, scope, derefPolicy, sizeLimit, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResult search(SearchRequest searchRequest) throws LDAPSearchException {
        return this.readPool.search(searchRequest);
    }

    @Override
    public SearchResult search(ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.readPool.search(searchRequest);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.searchForEntry(baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.searchForEntry(baseDN, scope, filter, attributes);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, String filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.searchForEntry(baseDN, scope, derefPolicy, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResultEntry searchForEntry(String baseDN, SearchScope scope, DereferencePolicy derefPolicy, int timeLimit, boolean typesOnly, Filter filter, String ... attributes) throws LDAPSearchException {
        return this.readPool.searchForEntry(baseDN, scope, derefPolicy, timeLimit, typesOnly, filter, attributes);
    }

    @Override
    public SearchResultEntry searchForEntry(SearchRequest searchRequest) throws LDAPSearchException {
        return this.readPool.searchForEntry(searchRequest);
    }

    @Override
    public SearchResultEntry searchForEntry(ReadOnlySearchRequest searchRequest) throws LDAPSearchException {
        return this.readPool.searchForEntry(searchRequest);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

