/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.ldap.sdk.controls.ManageDsaITRequestControl;
import com.unboundid.ldap.sdk.controls.SubentriesRequestControl;
import com.unboundid.ldap.sdk.extensions.WhoAmIExtendedRequest;
import com.unboundid.ldap.sdk.extensions.WhoAmIExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.MoveSubtreeAccessibilitySearchListener;
import com.unboundid.ldap.sdk.unboundidds.MoveSubtreeListener;
import com.unboundid.ldap.sdk.unboundidds.MoveSubtreeResult;
import com.unboundid.ldap.sdk.unboundidds.MoveSubtreeTxnSearchListener;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.InteractiveTransactionSpecificationRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.InteractiveTransactionSpecificationResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RealAttributesOnlyRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.ReturnConflictEntriesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeletedEntryAccessRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressReferentialIntegrityUpdatesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.extensions.EndInteractiveTransactionExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetSubtreeAccessibilityExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetSubtreeAccessibilityExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.SetSubtreeAccessibilityExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartInteractiveTransactionExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.StartInteractiveTransactionExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.SubtreeAccessibilityRestriction;
import com.unboundid.ldap.sdk.unboundidds.extensions.SubtreeAccessibilityState;
import com.unboundid.util.Debug;
import com.unboundid.util.MultiServerLDAPCommandLineTool;
import com.unboundid.util.ReverseComparator;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.DNArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class MoveSubtree
extends MultiServerLDAPCommandLineTool
implements UnsolicitedNotificationHandler,
MoveSubtreeListener {
    private static final String ATTR_STARTUP_UUID = "startupUUID";
    private BooleanArgument verbose = null;
    private DNArgument baseDN = null;
    private FileArgument baseDNFile = null;
    private IntegerArgument sizeLimit = null;
    private volatile String interruptMessage = null;
    private StringArgument purpose = null;

    public static void main(String ... args) {
        ResultCode rc = MoveSubtree.main(args, System.out, System.err);
        if (rc != ResultCode.SUCCESS) {
            System.exit(Math.max(rc.intValue(), 255));
        }
    }

    public static ResultCode main(String[] args, OutputStream out, OutputStream err) {
        MoveSubtree moveSubtree = new MoveSubtree(out, err);
        return moveSubtree.runTool(args);
    }

    public MoveSubtree(OutputStream out, OutputStream err) {
        super(out, err, new String[]{"source", "target"}, null);
    }

    @Override
    public String getToolName() {
        return "move-subtree";
    }

    @Override
    public String getToolDescription() {
        return UnboundIDDSMessages.INFO_MOVE_SUBTREE_TOOL_DESCRIPTION.get();
    }

    @Override
    public String getToolVersion() {
        return "3.0.0";
    }

    @Override
    public void addNonLDAPArguments(ArgumentParser parser) throws ArgumentException {
        this.baseDN = new DNArgument(Character.valueOf('b'), "baseDN", false, 0, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_BASE_DN_PLACEHOLDER.get(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_BASE_DN_DESCRIPTION.get());
        this.baseDN.addLongIdentifier("entryDN");
        parser.addArgument(this.baseDN);
        this.baseDNFile = new FileArgument(Character.valueOf('f'), "baseDNFile", false, 1, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_BASE_DN_FILE_PLACEHOLDER.get(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_BASE_DN_FILE_DESCRIPTION.get(), true, true, true, false);
        this.baseDNFile.addLongIdentifier("entryDNFile");
        parser.addArgument(this.baseDNFile);
        this.sizeLimit = new IntegerArgument(Character.valueOf('z'), "sizeLimit", false, 1, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_SIZE_LIMIT_PLACEHOLDER.get(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_SIZE_LIMIT_DESCRIPTION.get(), 0, Integer.MAX_VALUE, 0);
        parser.addArgument(this.sizeLimit);
        this.purpose = new StringArgument(null, "purpose", false, 1, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_PURPOSE_PLACEHOLDER.get(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_PURPOSE_DESCRIPTION.get());
        parser.addArgument(this.purpose);
        this.verbose = new BooleanArgument(Character.valueOf('v'), "verbose", 1, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ARG_VERBOSE_DESCRIPTION.get());
        parser.addArgument(this.verbose);
        parser.addRequiredArgumentSet(this.baseDN, this.baseDNFile, new Argument[0]);
        parser.addExclusiveArgumentSet(this.baseDN, this.baseDNFile, new Argument[0]);
    }

    @Override
    public LDAPConnectionOptions getConnectionOptions() {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setUnsolicitedNotificationHandler(this);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultCode doToolProcessing() {
        ResultCode resultCode2;
        LDAPConnection targetConnection;
        LDAPConnection sourceConnection;
        block33: {
            ResultCode resultCode;
            block31: {
                List<String> baseDNs;
                if (this.baseDN.isPresent()) {
                    List<DN> dnList = this.baseDN.getValues();
                    baseDNs = new ArrayList<String>(dnList.size());
                    for (DN dn : dnList) {
                        baseDNs.add(dn.toString());
                    }
                } else {
                    try {
                        baseDNs = this.baseDNFile.getNonBlankFileLines();
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_ERROR_READING_BASE_DN_FILE.get(this.baseDNFile.getValue().getAbsolutePath(), StaticUtils.getExceptionMessage(e)));
                        return ResultCode.LOCAL_ERROR;
                    }
                    if (baseDNs.isEmpty()) {
                        this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_BASE_DN_FILE_EMPTY.get(this.baseDNFile.getValue().getAbsolutePath()));
                        return ResultCode.PARAM_ERROR;
                    }
                }
                sourceConnection = null;
                targetConnection = null;
                try {
                    boolean suppressReferentialIntegrityUpdates;
                    block32: {
                        RootDSE sourceRootDSE;
                        try {
                            sourceConnection = this.getConnection(0);
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_CONNECT_TO_SOURCE.get(StaticUtils.getExceptionMessage(le)));
                            ResultCode resultCode3 = le.getResultCode();
                            Object var12_14 = null;
                            if (sourceConnection != null) {
                                sourceConnection.close();
                            }
                            if (targetConnection == null) return resultCode3;
                            targetConnection.close();
                            return resultCode3;
                        }
                        try {
                            targetConnection = this.getConnection(1);
                        }
                        catch (LDAPException le) {
                            Debug.debugException(le);
                            this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_CONNECT_TO_TARGET.get(StaticUtils.getExceptionMessage(le)));
                            ResultCode resultCode4 = le.getResultCode();
                            Object var12_15 = null;
                            if (sourceConnection != null) {
                                sourceConnection.close();
                            }
                            if (targetConnection == null) return resultCode4;
                            targetConnection.close();
                            return resultCode4;
                        }
                        sourceConnection.setConnectionName(UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get());
                        targetConnection.setConnectionName(UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get());
                        if (sourceConnection.getConnectedAddress().equals(targetConnection.getConnectedAddress()) && sourceConnection.getConnectedPort() == targetConnection.getConnectedPort()) {
                            this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SAME_SOURCE_AND_TARGET_SERVERS.get());
                            ResultCode le = ResultCode.PARAM_ERROR;
                            Object var12_16 = null;
                            if (sourceConnection != null) {
                                sourceConnection.close();
                            }
                            if (targetConnection == null) return le;
                            targetConnection.close();
                            return le;
                        }
                        suppressReferentialIntegrityUpdates = false;
                        try {
                            sourceRootDSE = sourceConnection.getRootDSE();
                            RootDSE targetRootDSE = targetConnection.getRootDSE();
                            if (sourceRootDSE != null && targetRootDSE != null) {
                                String sourceStartupUUID = sourceRootDSE.getAttributeValue(ATTR_STARTUP_UUID);
                                String targetStartupUUID = targetRootDSE.getAttributeValue(ATTR_STARTUP_UUID);
                                if (sourceStartupUUID != null && sourceStartupUUID.equals(targetStartupUUID)) {
                                    this.err(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SAME_SOURCE_AND_TARGET_SERVERS.get());
                                    resultCode = ResultCode.PARAM_ERROR;
                                    break block31;
                                }
                            }
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            break block32;
                        }
                        {
                            if (sourceRootDSE == null) break block32;
                            suppressReferentialIntegrityUpdates = sourceRootDSE.supportsControl("1.3.6.1.4.1.30221.2.5.30");
                        }
                    }
                    boolean first = true;
                    ResultCode resultCode5 = ResultCode.SUCCESS;
                    for (String dn : baseDNs) {
                        if (first) {
                            first = false;
                        } else {
                            this.out(new Object[0]);
                        }
                        OperationPurposeRequestControl operationPurpose = this.purpose.isPresent() ? new OperationPurposeRequestControl(this.getToolName(), this.getToolVersion(), 20, this.purpose.getValue()) : null;
                        MoveSubtreeResult result = MoveSubtree.moveSubtreeWithRestrictedAccessibility(this, sourceConnection, targetConnection, dn, this.sizeLimit.getValue(), operationPurpose, suppressReferentialIntegrityUpdates, this.verbose.isPresent() ? this : null);
                        if (result.getResultCode() == ResultCode.SUCCESS) {
                            this.wrapOut(0, 79, UnboundIDDSMessages.INFO_MOVE_SUBTREE_RESULT_SUCCESSFUL.get(result.getEntriesAddedToTarget(), dn));
                            continue;
                        }
                        if (resultCode5 == ResultCode.SUCCESS) {
                            resultCode5 = result.getResultCode();
                        }
                        this.wrapErr(0, 79, UnboundIDDSMessages.ERR_MOVE_SUBTREE_RESULT_UNSUCCESSFUL.get());
                        if (result.getErrorMessage() != null) {
                            this.wrapErr(0, 79, UnboundIDDSMessages.ERR_MOVE_SUBTREE_ERROR_MESSAGE.get(result.getErrorMessage()));
                        }
                        if (result.getAdminActionRequired() == null) continue;
                        this.wrapErr(0, 79, UnboundIDDSMessages.ERR_MOVE_SUBTREE_ADMIN_ACTION.get(result.getAdminActionRequired()));
                    }
                    resultCode2 = resultCode5;
                    break block33;
                }
                catch (Throwable throwable) {
                    Object var12_19 = null;
                    if (sourceConnection != null) {
                        sourceConnection.close();
                    }
                    if (targetConnection == null) throw throwable;
                    targetConnection.close();
                    throw throwable;
                }
            }
            Object var12_17 = null;
            if (sourceConnection != null) {
                sourceConnection.close();
            }
            if (targetConnection == null) return resultCode;
            targetConnection.close();
            return resultCode;
        }
        Object var12_18 = null;
        if (sourceConnection != null) {
            sourceConnection.close();
        }
        if (targetConnection == null) return resultCode2;
        targetConnection.close();
        return resultCode2;
    }

    public static MoveSubtreeResult moveEntryWithInteractiveTransaction(LDAPConnection sourceConnection, LDAPConnection targetConnection, String entryDN, OperationPurposeRequestControl opPurposeControl, MoveSubtreeListener listener) {
        return MoveSubtree.moveEntryWithInteractiveTransaction(sourceConnection, targetConnection, entryDN, opPurposeControl, false, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MoveSubtreeResult moveEntryWithInteractiveTransaction(LDAPConnection sourceConnection, LDAPConnection targetConnection, String entryDN, OperationPurposeRequestControl opPurposeControl, boolean suppressRefInt, MoveSubtreeListener listener) {
        block171: {
            errorMsg = new StringBuilder();
            adminMsg = new StringBuilder();
            reverseComparator = new ReverseComparator<T>();
            sourceEntryDNs = new TreeSet<DN>(reverseComparator);
            entriesReadFromSource = new AtomicInteger(0);
            entriesAddedToTarget = new AtomicInteger(0);
            entriesDeletedFromSource = new AtomicInteger(0);
            resultCode = new AtomicReference<ResultCode>();
            sourceTxnID = null;
            targetTxnID = null;
            sourceServerAltered = false;
            targetServerAltered = false;
            try {
                block193: {
                    block190: {
                        block191: {
                            block187: {
                                block188: {
                                    block197: {
                                        block198: {
                                            block180: {
                                                block196: {
                                                    block176: {
                                                        block179: {
                                                            block195: {
                                                                block177: {
                                                                    block173: {
                                                                        block174: {
                                                                            block169: {
                                                                                try {
                                                                                    startTxnRequest = opPurposeControl == null ? new StartInteractiveTransactionExtendedRequest(entryDN) : new StartInteractiveTransactionExtendedRequest(entryDN, new Control[]{opPurposeControl});
                                                                                    startTxnResult = (StartInteractiveTransactionExtendedResult)sourceConnection.processExtendedOperation(startTxnRequest);
                                                                                    if (startTxnResult.getResultCode() == ResultCode.SUCCESS) {
                                                                                        sourceTxnID = startTxnResult.getTransactionID();
                                                                                        sourceTxnControl = new InteractiveTransactionSpecificationRequestControl(sourceTxnID, true, true);
                                                                                        break block169;
                                                                                    }
                                                                                    resultCode.compareAndSet(null, startTxnResult.getResultCode());
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_CANNOT_START_SOURCE_TXN.get(new Object[]{startTxnResult.getDiagnosticMessage()}), errorMsg);
                                                                                }
                                                                                catch (LDAPException le) {
                                                                                    block172: {
                                                                                        Debug.debugException(le);
                                                                                        resultCode.compareAndSet(null, le.getResultCode());
                                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_CANNOT_START_SOURCE_TXN.get(new Object[]{StaticUtils.getExceptionMessage(le)}), errorMsg);
                                                                                        var31_24 = null;
                                                                                        if (targetTxnID != null) {
                                                                                            ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl33:
                                                                                            // 1 sources

                                                                                            abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                                                            abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                                                            if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                                                targetServerAltered = false;
                                                                                                entriesAddedToTarget.set(0);
                                                                                                MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                                                                break block172;
                                                                                            } else {
                                                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                            }
                                                                                            break block172;
lbl43:
                                                                                            // 1 sources

                                                                                            catch (Exception e) {
                                                                                                Debug.debugException(e);
                                                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    if (sourceTxnID == null) break block171;
                                                                                    ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl50:
                                                                                    // 1 sources

                                                                                    abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                                                                    abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                                                                    if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                                        sourceServerAltered = false;
                                                                                        entriesDeletedFromSource.set(0);
                                                                                        MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                                                        break block171;
                                                                                    } else {
                                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                    }
lbl60:
                                                                                    // 1 sources

                                                                                    catch (Exception e) {
                                                                                        Debug.debugException(e);
                                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                    }
                                                                                    break block171;
                                                                                }
                                                                                var31_23 = null;
                                                                                if (targetTxnID != null) {
                                                                                    try {
                                                                                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                                                        abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                                                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                                            targetServerAltered = false;
                                                                                            entriesAddedToTarget.set(0);
                                                                                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                                                        } else {
                                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                        }
                                                                                    }
                                                                                    catch (Exception e) {
                                                                                        Debug.debugException(e);
                                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                    }
                                                                                }
                                                                                if (sourceTxnID == null) break block171;
                                                                                try {
                                                                                    abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                                                                    abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                                                                    if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                                        sourceServerAltered = false;
                                                                                        entriesDeletedFromSource.set(0);
                                                                                        MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                                                        break block171;
                                                                                    }
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                }
                                                                                catch (Exception e) {
                                                                                    Debug.debugException(e);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                }
                                                                                break block171;
                                                                            }
                                                                            try {
                                                                                startTxnRequest = opPurposeControl == null ? new StartInteractiveTransactionExtendedRequest(entryDN) : new StartInteractiveTransactionExtendedRequest(entryDN, new Control[]{opPurposeControl});
                                                                                startTxnResult = (StartInteractiveTransactionExtendedResult)targetConnection.processExtendedOperation(startTxnRequest);
                                                                                if (startTxnResult.getResultCode() == ResultCode.SUCCESS) {
                                                                                    targetTxnID = startTxnResult.getTransactionID();
                                                                                    targetTxnControl = new InteractiveTransactionSpecificationRequestControl(targetTxnID, true, true);
                                                                                    break block173;
                                                                                }
                                                                                resultCode.compareAndSet(null, startTxnResult.getResultCode());
                                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_CANNOT_START_TARGET_TXN.get(new Object[]{startTxnResult.getDiagnosticMessage()}), errorMsg);
                                                                            }
                                                                            catch (LDAPException le) {
                                                                                block175: {
                                                                                    Debug.debugException(le);
                                                                                    resultCode.compareAndSet(null, le.getResultCode());
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_CANNOT_START_TARGET_TXN.get(new Object[]{StaticUtils.getExceptionMessage(le)}), errorMsg);
                                                                                    var31_26 = null;
                                                                                    if (targetTxnID != null) {
                                                                                        ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl121:
                                                                                        // 1 sources

                                                                                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                                                        abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                                                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                                            targetServerAltered = false;
                                                                                            entriesAddedToTarget.set(0);
                                                                                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                                                            break block175;
                                                                                        } else {
                                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                        }
                                                                                        break block175;
lbl131:
                                                                                        // 1 sources

                                                                                        catch (Exception e) {
                                                                                            Debug.debugException(e);
                                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                        }
                                                                                    }
                                                                                }
                                                                                if (sourceTxnID == null) break block171;
                                                                                ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl138:
                                                                                // 1 sources

                                                                                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                                                                abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                                                                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                                    sourceServerAltered = false;
                                                                                    entriesDeletedFromSource.set(0);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                                                    break block171;
                                                                                } else {
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                }
lbl148:
                                                                                // 1 sources

                                                                                catch (Exception e) {
                                                                                    Debug.debugException(e);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                }
                                                                                break block171;
                                                                            }
                                                                            var31_25 = null;
                                                                            if (targetTxnID != null) {
                                                                                ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl157:
                                                                                // 1 sources

                                                                                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                                                abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                                                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                                    targetServerAltered = false;
                                                                                    entriesAddedToTarget.set(0);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                                                    break block174;
                                                                                } else {
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                }
                                                                                break block174;
lbl167:
                                                                                // 1 sources

                                                                                catch (Exception e) {
                                                                                    Debug.debugException(e);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                }
                                                                            }
                                                                        }
                                                                        if (sourceTxnID == null) break block171;
                                                                        ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl174:
                                                                        // 1 sources

                                                                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                                                        abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                                                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                            sourceServerAltered = false;
                                                                            entriesDeletedFromSource.set(0);
                                                                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                                            break block171;
                                                                        } else {
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                        }
lbl184:
                                                                        // 1 sources

                                                                        catch (Exception e) {
                                                                            Debug.debugException(e);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                        }
                                                                        break block171;
                                                                    }
                                                                    searchControls = opPurposeControl == null ? new Control[]{sourceTxnControl, new ManageDsaITRequestControl(true), new SubentriesRequestControl(true), new ReturnConflictEntriesRequestControl(true), new SoftDeletedEntryAccessRequestControl(true, true, false), new RealAttributesOnlyRequestControl(true)} : new Control[]{sourceTxnControl, new ManageDsaITRequestControl(true), new SubentriesRequestControl(true), new ReturnConflictEntriesRequestControl(true), new SoftDeletedEntryAccessRequestControl(true, true, false), new RealAttributesOnlyRequestControl(true), opPurposeControl};
                                                                    searchListener = new MoveSubtreeTxnSearchListener(targetConnection, resultCode, errorMsg, entriesReadFromSource, entriesAddedToTarget, sourceEntryDNs, targetTxnControl, opPurposeControl, listener);
                                                                    searchRequest = new SearchRequest((SearchResultListener)searchListener, searchControls, entryDN, SearchScope.SUB, DereferencePolicy.NEVER, 1, 0, false, Filter.createPresenceFilter("objectClass"), new String[]{"*", "+"});
                                                                    try {
                                                                        searchResult = sourceConnection.search(searchRequest);
                                                                    }
                                                                    catch (LDAPSearchException lse) {
                                                                        Debug.debugException(lse);
                                                                        searchResult = lse.getSearchResult();
                                                                    }
                                                                    if (searchResult.getResultCode() != ResultCode.SUCCESS) break block195;
                                                                    try {
                                                                        txnResult = InteractiveTransactionSpecificationResponseControl.get(searchResult);
                                                                        if (txnResult != null && txnResult.transactionValid()) break block176;
                                                                        resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SEARCH_TXN_NO_LONGER_VALID.get(), errorMsg);
                                                                    }
                                                                    catch (LDAPException le) {
                                                                        block178: {
                                                                            Debug.debugException(le);
                                                                            resultCode.compareAndSet(null, le.getResultCode());
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_CANNOT_DECODE_SEARCH_TXN_CONTROL.get(new Object[]{StaticUtils.getExceptionMessage(le)}), errorMsg);
                                                                            var31_28 = null;
                                                                            if (targetTxnID != null) {
                                                                                ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl215:
                                                                                // 1 sources

                                                                                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                                                abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                                                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                                    targetServerAltered = false;
                                                                                    entriesAddedToTarget.set(0);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                                                    break block178;
                                                                                } else {
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                }
                                                                                break block178;
lbl225:
                                                                                // 1 sources

                                                                                catch (Exception e) {
                                                                                    Debug.debugException(e);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                                }
                                                                            }
                                                                        }
                                                                        if (sourceTxnID == null) break block171;
                                                                        ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl232:
                                                                        // 1 sources

                                                                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                                                        abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                                                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                            sourceServerAltered = false;
                                                                            entriesDeletedFromSource.set(0);
                                                                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                                            break block171;
                                                                        } else {
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                        }
lbl242:
                                                                        // 1 sources

                                                                        catch (Exception e) {
                                                                            Debug.debugException(e);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                        }
                                                                        break block171;
                                                                    }
                                                                    var31_27 = null;
                                                                    if (targetTxnID != null) {
                                                                        ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl251:
                                                                        // 1 sources

                                                                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                                        abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                            targetServerAltered = false;
                                                                            entriesAddedToTarget.set(0);
                                                                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                                            break block177;
                                                                        } else {
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                        }
                                                                        break block177;
lbl261:
                                                                        // 1 sources

                                                                        catch (Exception e) {
                                                                            Debug.debugException(e);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                        }
                                                                    }
                                                                }
                                                                if (sourceTxnID == null) break block171;
                                                                ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl268:
                                                                // 1 sources

                                                                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                                                abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                                                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                    sourceServerAltered = false;
                                                                    entriesDeletedFromSource.set(0);
                                                                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                                    break block171;
                                                                } else {
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                }
lbl278:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    Debug.debugException(e);
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                }
                                                                break block171;
                                                            }
                                                            resultCode.compareAndSet(null, searchResult.getResultCode());
                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SEARCH_FAILED.get(new Object[]{entryDN, searchResult.getDiagnosticMessage()}), errorMsg);
                                                            try {
                                                                txnResult = InteractiveTransactionSpecificationResponseControl.get(searchResult);
                                                                if (txnResult != null && !txnResult.transactionValid()) {
                                                                    sourceTxnID = null;
                                                                }
                                                            }
                                                            catch (LDAPException le) {
                                                                Debug.debugException(le);
                                                            }
                                                            if (!searchListener.targetTransactionValid()) {
                                                                targetTxnID = null;
                                                            }
                                                            var31_29 = null;
                                                            if (targetTxnID != null) {
                                                                ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl300:
                                                                // 1 sources

                                                                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                                abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                    targetServerAltered = false;
                                                                    entriesAddedToTarget.set(0);
                                                                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                                    break block179;
                                                                } else {
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                }
                                                                break block179;
lbl310:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    Debug.debugException(e);
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                }
                                                            }
                                                        }
                                                        if (sourceTxnID == null) break block171;
                                                        ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl317:
                                                        // 1 sources

                                                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                                        abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                            sourceServerAltered = false;
                                                            entriesDeletedFromSource.set(0);
                                                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                            break block171;
                                                        } else {
                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                        }
lbl327:
                                                        // 1 sources

                                                        catch (Exception e) {
                                                            Debug.debugException(e);
                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                        }
                                                        break block171;
                                                    }
                                                    if (resultCode.get() != null) break block196;
                                                    targetServerAltered = true;
                                                    deleteControlList = new ArrayList<Control>(4);
                                                    deleteControlList.add(sourceTxnControl);
                                                    deleteControlList.add(new ManageDsaITRequestControl(true));
                                                    if (opPurposeControl == null) break block197;
                                                    break block198;
                                                }
                                                var31_30 = null;
                                                if (targetTxnID != null) {
                                                    ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl346:
                                                    // 1 sources

                                                    abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                    abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                    if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                        targetServerAltered = false;
                                                        entriesAddedToTarget.set(0);
                                                        MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                        break block180;
                                                    } else {
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                    }
                                                    break block180;
lbl356:
                                                    // 1 sources

                                                    catch (Exception e) {
                                                        Debug.debugException(e);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                    }
                                                }
                                            }
                                            if (sourceTxnID == null) break block171;
                                            ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl363:
                                            // 1 sources

                                            abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                            abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                            if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                sourceServerAltered = false;
                                                entriesDeletedFromSource.set(0);
                                                MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                break block171;
                                            } else {
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                            }
lbl373:
                                            // 1 sources

                                            catch (Exception e) {
                                                Debug.debugException(e);
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                            }
                                            break block171;
                                        }
                                        deleteControlList.add(opPurposeControl);
                                    }
                                    if (suppressRefInt) {
                                        deleteControlList.add(new SuppressReferentialIntegrityUpdatesRequestControl(false));
                                    }
                                    deleteControls = new Control[deleteControlList.size()];
                                    deleteControlList.toArray(deleteControls);
                                    for (DN dn : sourceEntryDNs) {
                                        block182: {
                                            block185: {
                                                block200: {
                                                    block183: {
                                                        block199: {
                                                            if (listener == null) break block199;
                                                            try {
                                                                listener.doPreDeleteProcessing(dn);
                                                            }
                                                            catch (Exception e) {
                                                                block181: {
                                                                    Debug.debugException(e);
                                                                    resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_PRE_DELETE_FAILURE.get(new Object[]{dn.toString(), StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                    var31_31 = null;
                                                                    if (targetTxnID != null) {
                                                                        ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl402:
                                                                        // 1 sources

                                                                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                                        abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                            targetServerAltered = false;
                                                                            entriesAddedToTarget.set(0);
                                                                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                                            break block181;
                                                                        } else {
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                        }
                                                                        break block181;
lbl412:
                                                                        // 1 sources

                                                                        catch (Exception e) {
                                                                            Debug.debugException(e);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                        }
                                                                    }
                                                                }
                                                                if (sourceTxnID == null) break block171;
                                                                ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl419:
                                                                // 1 sources

                                                                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                                                abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                                                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                    sourceServerAltered = false;
                                                                    entriesDeletedFromSource.set(0);
                                                                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                                    break block171;
                                                                } else {
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                }
lbl429:
                                                                // 1 sources

                                                                catch (Exception e) {
                                                                    Debug.debugException(e);
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                }
                                                                break block171;
                                                            }
                                                        }
                                                        try {
                                                            deleteResult = sourceConnection.delete(new DeleteRequest(dn, deleteControls));
                                                        }
                                                        catch (LDAPException le) {
                                                            Debug.debugException(le);
                                                            deleteResult = le.toLDAPResult();
                                                        }
                                                        if (deleteResult.getResultCode() != ResultCode.SUCCESS) break block200;
                                                        sourceServerAltered = true;
                                                        entriesDeletedFromSource.incrementAndGet();
                                                        try {
                                                            txnResult = InteractiveTransactionSpecificationResponseControl.get(deleteResult);
                                                            if (txnResult != null && txnResult.transactionValid()) break block182;
                                                            resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_DELETE_TXN_NO_LONGER_VALID.get(new Object[]{dn.toString()}), errorMsg);
                                                        }
                                                        catch (LDAPException le) {
                                                            block184: {
                                                                Debug.debugException(le);
                                                                resultCode.compareAndSet(null, le.getResultCode());
                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_CANNOT_DECODE_DELETE_TXN_CONTROL.get(new Object[]{dn.toString(), StaticUtils.getExceptionMessage(le)}), errorMsg);
                                                                var31_33 = null;
                                                                if (targetTxnID != null) {
                                                                    ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl460:
                                                                    // 1 sources

                                                                    abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                                    abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                                    if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                        targetServerAltered = false;
                                                                        entriesAddedToTarget.set(0);
                                                                        MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                                        break block184;
                                                                    } else {
                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                    }
                                                                    break block184;
lbl470:
                                                                    // 1 sources

                                                                    catch (Exception e) {
                                                                        Debug.debugException(e);
                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                                    }
                                                                }
                                                            }
                                                            if (sourceTxnID == null) break block171;
                                                            ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl477:
                                                            // 1 sources

                                                            abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                                            abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                                            if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                sourceServerAltered = false;
                                                                entriesDeletedFromSource.set(0);
                                                                MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                                break block171;
                                                            } else {
                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                            }
lbl487:
                                                            // 1 sources

                                                            catch (Exception e) {
                                                                Debug.debugException(e);
                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                            }
                                                            break block171;
                                                        }
                                                        var31_32 = null;
                                                        if (targetTxnID != null) {
                                                            ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl496:
                                                            // 1 sources

                                                            abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                            abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                            if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                                targetServerAltered = false;
                                                                entriesAddedToTarget.set(0);
                                                                MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                                break block183;
                                                            } else {
                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                            }
                                                            break block183;
lbl506:
                                                            // 1 sources

                                                            catch (Exception e) {
                                                                Debug.debugException(e);
                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                            }
                                                        }
                                                    }
                                                    if (sourceTxnID == null) break block171;
                                                    ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl513:
                                                    // 1 sources

                                                    abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                                    abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                                    if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                        sourceServerAltered = false;
                                                        entriesDeletedFromSource.set(0);
                                                        MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                        break block171;
                                                    } else {
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                    }
lbl523:
                                                    // 1 sources

                                                    catch (Exception e) {
                                                        Debug.debugException(e);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                    }
                                                    break block171;
                                                }
                                                resultCode.compareAndSet(null, deleteResult.getResultCode());
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_DELETE_FAILURE.get(new Object[]{dn.toString(), deleteResult.getDiagnosticMessage()}), errorMsg);
                                                try {
                                                    txnResult = InteractiveTransactionSpecificationResponseControl.get(deleteResult);
                                                    if (txnResult != null && !txnResult.transactionValid()) {
                                                        sourceTxnID = null;
                                                    }
                                                }
                                                catch (LDAPException le) {
                                                    Debug.debugException(le);
                                                }
                                                var31_34 = null;
                                                if (targetTxnID != null) {
                                                    ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl543:
                                                    // 1 sources

                                                    abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                    abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                    if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                        targetServerAltered = false;
                                                        entriesAddedToTarget.set(0);
                                                        MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                        break block185;
                                                    } else {
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                    }
                                                    break block185;
lbl553:
                                                    // 1 sources

                                                    catch (Exception e) {
                                                        Debug.debugException(e);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                    }
                                                }
                                            }
                                            if (sourceTxnID == null) break block171;
                                            ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl560:
                                            // 1 sources

                                            abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                            abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                            if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                sourceServerAltered = false;
                                                entriesDeletedFromSource.set(0);
                                                MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                break block171;
                                            } else {
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                            }
lbl570:
                                            // 1 sources

                                            catch (Exception e) {
                                                Debug.debugException(e);
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                            }
                                            break block171;
                                        }
                                        if (listener == null) continue;
                                        try {
                                            listener.doPostDeleteProcessing(dn);
                                        }
                                        catch (Exception e) {
                                            block186: {
                                                Debug.debugException(e);
                                                resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_POST_DELETE_FAILURE.get(new Object[]{dn.toString(), StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                var31_35 = null;
                                                if (targetTxnID != null) {
                                                    ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl589:
                                                    // 1 sources

                                                    abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                    abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                    if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                        targetServerAltered = false;
                                                        entriesAddedToTarget.set(0);
                                                        MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                        break block186;
                                                    } else {
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                    }
                                                    break block186;
lbl599:
                                                    // 1 sources

                                                    catch (Exception e) {
                                                        Debug.debugException(e);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                    }
                                                }
                                            }
                                            if (sourceTxnID == null) break block171;
                                            ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl606:
                                            // 1 sources

                                            abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                            abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                            if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                sourceServerAltered = false;
                                                entriesDeletedFromSource.set(0);
                                                MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                                break block171;
                                            } else {
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                            }
lbl616:
                                            // 1 sources

                                            catch (Exception e) {
                                                Debug.debugException(e);
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                            }
                                            break block171;
                                        }
                                    }
                                    try {
                                        commitRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, true) : new EndInteractiveTransactionExtendedRequest(targetTxnID, true, new Control[]{opPurposeControl});
                                        commitResult = targetConnection.processExtendedOperation(commitRequest);
                                        if (commitResult.getResultCode() == ResultCode.SUCCESS) {
                                            targetTxnID = null;
                                            break block187;
                                        }
                                        resultCode.compareAndSet(null, commitResult.getResultCode());
                                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_CANNOT_COMMIT_TARGET_TXN.get(new Object[]{commitResult.getDiagnosticMessage()}), errorMsg);
                                    }
                                    catch (LDAPException le) {
                                        block189: {
                                            Debug.debugException(le);
                                            resultCode.compareAndSet(null, le.getResultCode());
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_CANNOT_COMMIT_TARGET_TXN.get(new Object[]{StaticUtils.getExceptionMessage(le)}), errorMsg);
                                            var31_37 = null;
                                            if (targetTxnID != null) {
                                                ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl639:
                                                // 1 sources

                                                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                                abortResult = targetConnection.processExtendedOperation(abortRequest);
                                                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                                    targetServerAltered = false;
                                                    entriesAddedToTarget.set(0);
                                                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                                    break block189;
                                                } else {
                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                }
                                                break block189;
lbl649:
                                                // 1 sources

                                                catch (Exception e) {
                                                    Debug.debugException(e);
                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                                }
                                            }
                                        }
                                        if (sourceTxnID == null) break block171;
                                        ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl656:
                                        // 1 sources

                                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                        abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                            sourceServerAltered = false;
                                            entriesDeletedFromSource.set(0);
                                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                            break block171;
                                        } else {
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                        }
lbl666:
                                        // 1 sources

                                        catch (Exception e) {
                                            Debug.debugException(e);
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                        }
                                        break block171;
                                    }
                                    var31_36 = null;
                                    if (targetTxnID != null) {
                                        ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl675:
                                        // 1 sources

                                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                        abortResult = targetConnection.processExtendedOperation(abortRequest);
                                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                            targetServerAltered = false;
                                            entriesAddedToTarget.set(0);
                                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                            break block188;
                                        } else {
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                        }
                                        break block188;
lbl685:
                                        // 1 sources

                                        catch (Exception e) {
                                            Debug.debugException(e);
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                        }
                                    }
                                }
                                if (sourceTxnID == null) break block171;
                                ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl692:
                                // 1 sources

                                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                    sourceServerAltered = false;
                                    entriesDeletedFromSource.set(0);
                                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                    break block171;
                                } else {
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                }
lbl702:
                                // 1 sources

                                catch (Exception e) {
                                    Debug.debugException(e);
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                }
                                break block171;
                            }
                            try {
                                commitRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, true) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, true, new Control[]{opPurposeControl});
                                commitResult = sourceConnection.processExtendedOperation(commitRequest);
                                if (commitResult.getResultCode() == ResultCode.SUCCESS) {
                                    sourceTxnID = null;
                                    break block190;
                                }
                                resultCode.compareAndSet(null, commitResult.getResultCode());
                                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_CANNOT_COMMIT_SOURCE_TXN.get(new Object[]{commitResult.getDiagnosticMessage()}), errorMsg);
                            }
                            catch (LDAPException le) {
                                block192: {
                                    Debug.debugException(le);
                                    resultCode.compareAndSet(null, le.getResultCode());
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_CANNOT_COMMIT_SOURCE_TXN.get(new Object[]{StaticUtils.getExceptionMessage(le)}), errorMsg);
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_EXISTS_IN_BOTH_SERVERS.get(new Object[]{entryDN}), adminMsg);
                                    var31_39 = null;
                                    if (targetTxnID != null) {
                                        ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl727:
                                        // 1 sources

                                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                        abortResult = targetConnection.processExtendedOperation(abortRequest);
                                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                            targetServerAltered = false;
                                            entriesAddedToTarget.set(0);
                                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                            break block192;
                                        } else {
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                        }
                                        break block192;
lbl737:
                                        // 1 sources

                                        catch (Exception e) {
                                            Debug.debugException(e);
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                        }
                                    }
                                }
                                if (sourceTxnID == null) break block171;
                                ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl744:
                                // 1 sources

                                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                                abortResult = sourceConnection.processExtendedOperation(abortRequest);
                                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                    sourceServerAltered = false;
                                    entriesDeletedFromSource.set(0);
                                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                                    break block171;
                                } else {
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                }
lbl754:
                                // 1 sources

                                catch (Exception e) {
                                    Debug.debugException(e);
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                }
                                break block171;
                            }
                            var31_38 = null;
                            if (targetTxnID != null) {
                                ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl763:
                                // 1 sources

                                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                                abortResult = targetConnection.processExtendedOperation(abortRequest);
                                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                                    targetServerAltered = false;
                                    entriesAddedToTarget.set(0);
                                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                                    break block191;
                                } else {
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                }
                                break block191;
lbl773:
                                // 1 sources

                                catch (Exception e) {
                                    Debug.debugException(e);
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                                }
                            }
                        }
                        if (sourceTxnID == null) break block171;
                        ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl780:
                        // 1 sources

                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                        abortResult = sourceConnection.processExtendedOperation(abortRequest);
                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                            sourceServerAltered = false;
                            entriesDeletedFromSource.set(0);
                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                            break block171;
                        } else {
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                        }
lbl790:
                        // 1 sources

                        catch (Exception e) {
                            Debug.debugException(e);
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                        }
                        break block171;
                    }
                    var31_40 = null;
                    if (targetTxnID != null) {
                        ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl799:
                        // 1 sources

                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                        abortResult = targetConnection.processExtendedOperation(abortRequest);
                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                            targetServerAltered = false;
                            entriesAddedToTarget.set(0);
                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                            break block193;
                        } else {
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                        }
                        break block193;
lbl809:
                        // 1 sources

                        catch (Exception e) {
                            Debug.debugException(e);
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                        }
                    }
                }
                if (sourceTxnID == null) break block171;
                ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl816:
                // 1 sources

                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                abortResult = sourceConnection.processExtendedOperation(abortRequest);
                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                    sourceServerAltered = false;
                    entriesDeletedFromSource.set(0);
                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                    break block171;
                } else {
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                }
lbl826:
                // 1 sources

                catch (Exception e) {
                    Debug.debugException(e);
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                }
            }
            catch (Throwable var30_100) {
                block194: {
                    var31_41 = null;
                    if (targetTxnID != null) {
                        ** try [egrp 13[TRYBLOCK] [31 : 1753->1879)] { 
lbl836:
                        // 1 sources

                        abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(targetTxnID, false) : new EndInteractiveTransactionExtendedRequest(targetTxnID, false, new Control[]{opPurposeControl});
                        abortResult = targetConnection.processExtendedOperation(abortRequest);
                        if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                            targetServerAltered = false;
                            entriesAddedToTarget.set(0);
                            MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_TARGET_ABORT_SUCCEEDED.get(), errorMsg);
                            break block194;
                        } else {
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                        }
                        break block194;
lbl846:
                        // 1 sources

                        catch (Exception e) {
                            Debug.debugException(e);
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                            MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_TARGET_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                        }
                    }
                }
                if (sourceTxnID == null) throw var30_100;
                ** try [egrp 14[TRYBLOCK] [32 : 1933->2059)] { 
lbl853:
                // 1 sources

                abortRequest = opPurposeControl == null ? new EndInteractiveTransactionExtendedRequest(sourceTxnID, false) : new EndInteractiveTransactionExtendedRequest(sourceTxnID, false, new Control[]{opPurposeControl});
                abortResult = sourceConnection.processExtendedOperation(abortRequest);
                if (abortResult.getResultCode() == ResultCode.INTERACTIVE_TRANSACTION_ABORTED) {
                    sourceServerAltered = false;
                    entriesDeletedFromSource.set(0);
                    MoveSubtree.append(UnboundIDDSMessages.INFO_MOVE_ENTRY_SOURCE_ABORT_SUCCEEDED.get(), errorMsg);
                    throw var30_100;
                }
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{abortResult.getDiagnosticMessage()}), errorMsg);
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                throw var30_100;
lbl863:
                // 1 sources

                catch (Exception e) {
                    Debug.debugException(e);
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE.get(new Object[]{StaticUtils.getExceptionMessage(e)}), errorMsg);
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_ENTRY_SOURCE_ABORT_FAILURE_ADMIN_ACTTION.get(new Object[]{entryDN}), adminMsg);
                }
                throw var30_100;
            }
        }
        resultCode.compareAndSet(null, ResultCode.SUCCESS);
        errorMessage = errorMsg.length() > 0 ? errorMsg.toString() : null;
        if (adminMsg.length() > 0) {
            adminActionRequired = adminMsg.toString();
            return new MoveSubtreeResult(resultCode.get(), errorMessage, adminActionRequired, sourceServerAltered, targetServerAltered, entriesReadFromSource.get(), entriesAddedToTarget.get(), entriesDeletedFromSource.get());
        }
        adminActionRequired = null;
        return new MoveSubtreeResult((ResultCode)resultCode.get(), errorMessage, adminActionRequired, sourceServerAltered, targetServerAltered, entriesReadFromSource.get(), entriesAddedToTarget.get(), entriesDeletedFromSource.get());
    }

    public static MoveSubtreeResult moveSubtreeWithRestrictedAccessibility(LDAPConnection sourceConnection, LDAPConnection targetConnection, String baseDN, int sizeLimit, OperationPurposeRequestControl opPurposeControl, MoveSubtreeListener listener) {
        return MoveSubtree.moveSubtreeWithRestrictedAccessibility(sourceConnection, targetConnection, baseDN, sizeLimit, opPurposeControl, false, listener);
    }

    public static MoveSubtreeResult moveSubtreeWithRestrictedAccessibility(LDAPConnection sourceConnection, LDAPConnection targetConnection, String baseDN, int sizeLimit, OperationPurposeRequestControl opPurposeControl, boolean suppressRefInt, MoveSubtreeListener listener) {
        return MoveSubtree.moveSubtreeWithRestrictedAccessibility(null, sourceConnection, targetConnection, baseDN, sizeLimit, opPurposeControl, suppressRefInt, listener);
    }

    private static MoveSubtreeResult moveSubtreeWithRestrictedAccessibility(MoveSubtree tool, LDAPConnection sourceConnection, LDAPConnection targetConnection, String baseDN, int sizeLimit, OperationPurposeRequestControl opPurposeControl, boolean suppressRefInt, MoveSubtreeListener listener) {
        SubtreeAccessibilityState currentTargetState;
        SubtreeAccessibilityState currentSourceState;
        boolean targetServerAltered;
        boolean sourceServerAltered;
        AtomicReference<ResultCode> resultCode;
        AtomicInteger entriesDeletedFromSource;
        AtomicInteger entriesAddedToTarget;
        AtomicInteger entriesReadFromSource;
        StringBuilder adminMsg;
        StringBuilder errorMsg;
        block40: {
            SearchResult searchResult;
            String targetUserDN;
            String sourceUserDN;
            MoveSubtreeResult initialAccessibilityResult = MoveSubtree.checkInitialAccessibility(sourceConnection, targetConnection, baseDN, opPurposeControl);
            if (initialAccessibilityResult != null) {
                return initialAccessibilityResult;
            }
            errorMsg = new StringBuilder();
            adminMsg = new StringBuilder();
            ReverseComparator reverseComparator = new ReverseComparator();
            TreeSet<DN> sourceEntryDNs = new TreeSet<DN>(reverseComparator);
            entriesReadFromSource = new AtomicInteger(0);
            entriesAddedToTarget = new AtomicInteger(0);
            entriesDeletedFromSource = new AtomicInteger(0);
            resultCode = new AtomicReference<ResultCode>();
            sourceServerAltered = false;
            targetServerAltered = false;
            currentSourceState = SubtreeAccessibilityState.ACCESSIBLE;
            currentTargetState = SubtreeAccessibilityState.ACCESSIBLE;
            try {
                sourceUserDN = MoveSubtree.getAuthenticatedUserDN(sourceConnection, true, opPurposeControl);
                targetUserDN = MoveSubtree.getAuthenticatedUserDN(targetConnection, false, opPurposeControl);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                resultCode.compareAndSet(null, le.getResultCode());
                MoveSubtree.append(le.getMessage(), errorMsg);
                break block40;
            }
            try {
                MoveSubtree.setAccessibility(targetConnection, false, baseDN, SubtreeAccessibilityState.HIDDEN, targetUserDN, opPurposeControl);
                currentTargetState = SubtreeAccessibilityState.HIDDEN;
                MoveSubtree.setInterruptMessage(tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_TARGET_HIDDEN.get(baseDN, targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                resultCode.compareAndSet(null, le.getResultCode());
                MoveSubtree.append(le.getMessage(), errorMsg);
                break block40;
            }
            try {
                MoveSubtree.setAccessibility(sourceConnection, true, baseDN, SubtreeAccessibilityState.READ_ONLY_BIND_ALLOWED, sourceUserDN, opPurposeControl);
                currentSourceState = SubtreeAccessibilityState.READ_ONLY_BIND_ALLOWED;
                MoveSubtree.setInterruptMessage(tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_SOURCE_READ_ONLY.get(baseDN, targetConnection.getConnectedAddress(), targetConnection.getConnectedPort(), sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort()));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                resultCode.compareAndSet(null, le.getResultCode());
                MoveSubtree.append(le.getMessage(), errorMsg);
                break block40;
            }
            Control[] searchControls = opPurposeControl == null ? new Control[]{new ManageDsaITRequestControl(true), new SubentriesRequestControl(true), new ReturnConflictEntriesRequestControl(true), new SoftDeletedEntryAccessRequestControl(true, true, false), new RealAttributesOnlyRequestControl(true)} : new Control[]{new ManageDsaITRequestControl(true), new SubentriesRequestControl(true), new ReturnConflictEntriesRequestControl(true), new SoftDeletedEntryAccessRequestControl(true, true, false), new RealAttributesOnlyRequestControl(true), opPurposeControl};
            MoveSubtreeAccessibilitySearchListener searchListener = new MoveSubtreeAccessibilitySearchListener(tool, baseDN, sourceConnection, targetConnection, resultCode, errorMsg, entriesReadFromSource, entriesAddedToTarget, sourceEntryDNs, opPurposeControl, listener);
            SearchRequest searchRequest = new SearchRequest((SearchResultListener)searchListener, searchControls, baseDN, SearchScope.SUB, DereferencePolicy.NEVER, sizeLimit, 0, false, Filter.createPresenceFilter("objectClass"), "*", "+");
            try {
                searchResult = sourceConnection.search(searchRequest);
            }
            catch (LDAPSearchException lse) {
                Debug.debugException(lse);
                searchResult = lse.getSearchResult();
            }
            if (entriesAddedToTarget.get() > 0) {
                targetServerAltered = true;
            }
            if (searchResult.getResultCode() != ResultCode.SUCCESS) {
                resultCode.compareAndSet(null, searchResult.getResultCode());
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SEARCH_FAILED.get(baseDN, searchResult.getDiagnosticMessage()), errorMsg);
                AtomicInteger deleteCount = new AtomicInteger(0);
                if (targetServerAltered) {
                    MoveSubtree.deleteEntries(targetConnection, false, sourceEntryDNs, opPurposeControl, false, null, deleteCount, resultCode, errorMsg);
                    entriesAddedToTarget.addAndGet(0 - deleteCount.get());
                    if (entriesAddedToTarget.get() == 0) {
                        targetServerAltered = false;
                    } else {
                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_TARGET_NOT_DELETED_ADMIN_ACTION.get(baseDN), adminMsg);
                    }
                }
            } else if (resultCode.get() != null) {
                AtomicInteger deleteCount = new AtomicInteger(0);
                if (targetServerAltered) {
                    MoveSubtree.deleteEntries(targetConnection, false, sourceEntryDNs, opPurposeControl, false, null, deleteCount, resultCode, errorMsg);
                    entriesAddedToTarget.addAndGet(0 - deleteCount.get());
                    if (entriesAddedToTarget.get() == 0) {
                        targetServerAltered = false;
                    } else {
                        MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_TARGET_NOT_DELETED_ADMIN_ACTION.get(baseDN), adminMsg);
                    }
                }
            } else {
                try {
                    MoveSubtree.setAccessibility(targetConnection, true, baseDN, SubtreeAccessibilityState.READ_ONLY_BIND_ALLOWED, targetUserDN, opPurposeControl);
                    currentTargetState = SubtreeAccessibilityState.READ_ONLY_BIND_ALLOWED;
                    MoveSubtree.setInterruptMessage(tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_TARGET_READ_ONLY.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    resultCode.compareAndSet(null, le.getResultCode());
                    MoveSubtree.append(le.getMessage(), errorMsg);
                    break block40;
                }
                try {
                    MoveSubtree.setAccessibility(sourceConnection, true, baseDN, SubtreeAccessibilityState.HIDDEN, sourceUserDN, opPurposeControl);
                    currentSourceState = SubtreeAccessibilityState.HIDDEN;
                    MoveSubtree.setInterruptMessage(tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_SOURCE_HIDDEN.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    resultCode.compareAndSet(null, le.getResultCode());
                    MoveSubtree.append(le.getMessage(), errorMsg);
                    break block40;
                }
                try {
                    MoveSubtree.setAccessibility(targetConnection, true, baseDN, SubtreeAccessibilityState.ACCESSIBLE, targetUserDN, opPurposeControl);
                    currentTargetState = SubtreeAccessibilityState.ACCESSIBLE;
                    MoveSubtree.setInterruptMessage(tool, UnboundIDDSMessages.WARN_MOVE_SUBTREE_INTERRUPT_MSG_TARGET_ACCESSIBLE.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()));
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    resultCode.compareAndSet(null, le.getResultCode());
                    MoveSubtree.append(le.getMessage(), errorMsg);
                    break block40;
                }
                boolean deleteSuccessful = MoveSubtree.deleteEntries(sourceConnection, true, sourceEntryDNs, opPurposeControl, suppressRefInt, listener, entriesDeletedFromSource, resultCode, errorMsg);
                boolean bl = sourceServerAltered = entriesDeletedFromSource.get() != 0;
                if (!deleteSuccessful) {
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SOURCE_NOT_DELETED_ADMIN_ACTION.get(baseDN), adminMsg);
                } else {
                    try {
                        MoveSubtree.setAccessibility(sourceConnection, true, baseDN, SubtreeAccessibilityState.ACCESSIBLE, sourceUserDN, opPurposeControl);
                        currentSourceState = SubtreeAccessibilityState.ACCESSIBLE;
                        MoveSubtree.setInterruptMessage(tool, null);
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        resultCode.compareAndSet(null, le.getResultCode());
                        MoveSubtree.append(le.getMessage(), errorMsg);
                    }
                }
            }
        }
        if (currentSourceState != SubtreeAccessibilityState.ACCESSIBLE) {
            if (!sourceServerAltered) {
                try {
                    MoveSubtree.setAccessibility(sourceConnection, true, baseDN, SubtreeAccessibilityState.ACCESSIBLE, null, opPurposeControl);
                    currentSourceState = SubtreeAccessibilityState.ACCESSIBLE;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            if (currentSourceState != SubtreeAccessibilityState.ACCESSIBLE) {
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_SOURCE_LEFT_INACCESSIBLE.get(new Object[]{currentSourceState, baseDN}), adminMsg);
            }
        }
        if (currentTargetState != SubtreeAccessibilityState.ACCESSIBLE) {
            if (!targetServerAltered) {
                try {
                    MoveSubtree.setAccessibility(targetConnection, false, baseDN, SubtreeAccessibilityState.ACCESSIBLE, null, opPurposeControl);
                    currentTargetState = SubtreeAccessibilityState.ACCESSIBLE;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            if (currentTargetState != SubtreeAccessibilityState.ACCESSIBLE) {
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_TARGET_LEFT_INACCESSIBLE.get(new Object[]{currentTargetState, baseDN}), adminMsg);
            }
        }
        resultCode.compareAndSet(null, ResultCode.SUCCESS);
        String errorMessage = errorMsg.length() > 0 ? errorMsg.toString() : null;
        String adminActionRequired = adminMsg.length() > 0 ? adminMsg.toString() : null;
        return new MoveSubtreeResult((ResultCode)resultCode.get(), errorMessage, adminActionRequired, sourceServerAltered, targetServerAltered, entriesReadFromSource.get(), entriesAddedToTarget.get(), entriesDeletedFromSource.get());
    }

    private static String getAuthenticatedUserDN(LDAPConnection connection, boolean isSource, OperationPurposeRequestControl opPurposeControl) throws LDAPException {
        WhoAmIExtendedResult whoAmIResult;
        BindRequest bindRequest = InternalSDKHelper.getLastBindRequest(connection);
        if (bindRequest != null && bindRequest instanceof SimpleBindRequest) {
            SimpleBindRequest r = (SimpleBindRequest)bindRequest;
            return r.getBindDN();
        }
        Control[] controls = opPurposeControl == null ? StaticUtils.NO_CONTROLS : new Control[]{opPurposeControl};
        String connectionName = isSource ? UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get() : UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get();
        try {
            whoAmIResult = (WhoAmIExtendedResult)connection.processExtendedOperation(new WhoAmIExtendedRequest(controls));
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new LDAPException(le.getResultCode(), UnboundIDDSMessages.ERR_MOVE_SUBTREE_ERROR_INVOKING_WHO_AM_I.get(connectionName, StaticUtils.getExceptionMessage(le)), le);
        }
        if (whoAmIResult.getResultCode() != ResultCode.SUCCESS) {
            throw new LDAPException(whoAmIResult.getResultCode(), UnboundIDDSMessages.ERR_MOVE_SUBTREE_ERROR_INVOKING_WHO_AM_I.get(connectionName, whoAmIResult.getDiagnosticMessage()));
        }
        String authzID = whoAmIResult.getAuthorizationID();
        if (authzID != null && authzID.startsWith("dn:")) {
            return authzID.substring(3);
        }
        throw new LDAPException(ResultCode.UNWILLING_TO_PERFORM, UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_IDENTIFY_CONNECTED_USER.get(connectionName));
    }

    private static MoveSubtreeResult checkInitialAccessibility(LDAPConnection sourceConnection, LDAPConnection targetConnection, String baseDN, OperationPurposeRequestControl opPurposeControl) {
        GetSubtreeAccessibilityExtendedResult targetResult;
        GetSubtreeAccessibilityExtendedResult sourceResult;
        DN parsedBaseDN;
        try {
            parsedBaseDN = new DN(baseDN);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new MoveSubtreeResult(ResultCode.INVALID_DN_SYNTAX, UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_PARSE_BASE_DN.get(baseDN, StaticUtils.getExceptionMessage(e)), null, false, false, 0, 0, 0);
        }
        Control[] controls = opPurposeControl == null ? StaticUtils.NO_CONTROLS : new Control[]{opPurposeControl};
        try {
            sourceResult = (GetSubtreeAccessibilityExtendedResult)sourceConnection.processExtendedOperation(new GetSubtreeAccessibilityExtendedRequest(controls));
            if (sourceResult.getResultCode() != ResultCode.SUCCESS) {
                throw new LDAPException(sourceResult);
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new MoveSubtreeResult(le.getResultCode(), UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_GET_ACCESSIBILITY_STATE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get(), le.getMessage()), null, false, false, 0, 0, 0);
        }
        boolean sourceMatch = false;
        String sourceMessage = null;
        SubtreeAccessibilityRestriction sourceRestriction = null;
        List<SubtreeAccessibilityRestriction> sourceRestrictions = sourceResult.getAccessibilityRestrictions();
        if (sourceRestrictions != null) {
            for (SubtreeAccessibilityRestriction r : sourceRestrictions) {
                DN restrictionDN;
                if (r.getAccessibilityState() == SubtreeAccessibilityState.ACCESSIBLE) continue;
                try {
                    restrictionDN = new DN(r.getSubtreeBaseDN());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    return new MoveSubtreeResult(ResultCode.INVALID_DN_SYNTAX, UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_PARSE_RESTRICTION_BASE_DN.get(r.getSubtreeBaseDN(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get(), r.toString(), StaticUtils.getExceptionMessage(e)), null, false, false, 0, 0, 0);
                }
                if (restrictionDN.equals(parsedBaseDN)) {
                    sourceMatch = true;
                    sourceRestriction = r;
                    sourceMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_NOT_ACCESSIBLE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get(), r.getAccessibilityState().getStateName());
                    break;
                }
                if (restrictionDN.isAncestorOf(parsedBaseDN, false)) {
                    sourceRestriction = r;
                    sourceMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_WITHIN_UNACCESSIBLE_TREE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get(), r.getSubtreeBaseDN(), r.getAccessibilityState().getStateName());
                    break;
                }
                if (!restrictionDN.isDescendantOf(parsedBaseDN, false)) continue;
                sourceRestriction = r;
                sourceMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_CONTAINS_UNACCESSIBLE_TREE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get(), r.getSubtreeBaseDN(), r.getAccessibilityState().getStateName());
                break;
            }
        }
        try {
            targetResult = (GetSubtreeAccessibilityExtendedResult)targetConnection.processExtendedOperation(new GetSubtreeAccessibilityExtendedRequest(controls));
            if (targetResult.getResultCode() != ResultCode.SUCCESS) {
                throw new LDAPException(targetResult);
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            return new MoveSubtreeResult(le.getResultCode(), UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_GET_ACCESSIBILITY_STATE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get(), le.getMessage()), null, false, false, 0, 0, 0);
        }
        boolean targetMatch = false;
        String targetMessage = null;
        SubtreeAccessibilityRestriction targetRestriction = null;
        List<SubtreeAccessibilityRestriction> targetRestrictions = targetResult.getAccessibilityRestrictions();
        if (targetRestrictions != null) {
            for (SubtreeAccessibilityRestriction r : targetRestrictions) {
                DN restrictionDN;
                if (r.getAccessibilityState() == SubtreeAccessibilityState.ACCESSIBLE) continue;
                try {
                    restrictionDN = new DN(r.getSubtreeBaseDN());
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    return new MoveSubtreeResult(ResultCode.INVALID_DN_SYNTAX, UnboundIDDSMessages.ERR_MOVE_SUBTREE_CANNOT_PARSE_RESTRICTION_BASE_DN.get(r.getSubtreeBaseDN(), UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get(), r.toString(), StaticUtils.getExceptionMessage(e)), null, false, false, 0, 0, 0);
                }
                if (restrictionDN.equals(parsedBaseDN)) {
                    targetMatch = true;
                    targetRestriction = r;
                    targetMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_NOT_ACCESSIBLE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get(), r.getAccessibilityState().getStateName());
                    break;
                }
                if (restrictionDN.isAncestorOf(parsedBaseDN, false)) {
                    targetRestriction = r;
                    targetMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_WITHIN_UNACCESSIBLE_TREE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get(), r.getSubtreeBaseDN(), r.getAccessibilityState().getStateName());
                    break;
                }
                if (!restrictionDN.isDescendantOf(parsedBaseDN, false)) continue;
                targetRestriction = r;
                targetMessage = UnboundIDDSMessages.ERR_MOVE_SUBTREE_CONTAINS_UNACCESSIBLE_TREE.get(baseDN, UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get(), r.getSubtreeBaseDN(), r.getAccessibilityState().getStateName());
                break;
            }
        }
        if (sourceRestriction == null && targetRestriction == null) {
            return null;
        }
        if (sourceMatch || targetMatch) {
            if (sourceRestriction != null && sourceRestriction.getAccessibilityState().isReadOnly() && targetRestriction != null && targetRestriction.getAccessibilityState().isHidden()) {
                return new MoveSubtreeResult(ResultCode.UNWILLING_TO_PERFORM, UnboundIDDSMessages.ERR_MOVE_SUBTREE_POSSIBLY_INTERRUPTED_IN_ADDS.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()), UnboundIDDSMessages.ERR_MOVE_SUBTREE_POSSIBLY_INTERRUPTED_IN_ADDS_ADMIN_MSG.get(), false, false, 0, 0, 0);
            }
            if (sourceRestriction != null && sourceRestriction.getAccessibilityState().isHidden() && targetRestriction == null) {
                return new MoveSubtreeResult(ResultCode.UNWILLING_TO_PERFORM, UnboundIDDSMessages.ERR_MOVE_SUBTREE_POSSIBLY_INTERRUPTED_IN_DELETES.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort()), UnboundIDDSMessages.ERR_MOVE_SUBTREE_POSSIBLY_INTERRUPTED_IN_DELETES_ADMIN_MSG.get(), false, false, 0, 0, 0);
            }
        }
        StringBuilder details = new StringBuilder();
        if (sourceMessage != null) {
            details.append(sourceMessage);
        }
        if (targetMessage != null) {
            MoveSubtree.append(targetMessage, details);
        }
        return new MoveSubtreeResult(ResultCode.UNWILLING_TO_PERFORM, UnboundIDDSMessages.ERR_MOVE_SUBTREE_POSSIBLY_INTERRUPTED.get(baseDN, sourceConnection.getConnectedAddress(), sourceConnection.getConnectedPort(), targetConnection.getConnectedAddress(), targetConnection.getConnectedPort(), details.toString()), null, false, false, 0, 0, 0);
    }

    private static void setAccessibility(LDAPConnection connection, boolean isSource, String baseDN, SubtreeAccessibilityState state, String bypassDN, OperationPurposeRequestControl opPurposeControl) throws LDAPException {
        LDAPResult result;
        SetSubtreeAccessibilityExtendedRequest request;
        String connectionName = isSource ? UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_SOURCE.get() : UnboundIDDSMessages.INFO_MOVE_SUBTREE_CONNECTION_NAME_TARGET.get();
        Control[] controls = opPurposeControl == null ? StaticUtils.NO_CONTROLS : new Control[]{opPurposeControl};
        switch (state) {
            case ACCESSIBLE: {
                request = SetSubtreeAccessibilityExtendedRequest.createSetAccessibleRequest(baseDN, controls);
                break;
            }
            case READ_ONLY_BIND_ALLOWED: {
                request = SetSubtreeAccessibilityExtendedRequest.createSetReadOnlyRequest(baseDN, true, bypassDN, controls);
                break;
            }
            case READ_ONLY_BIND_DENIED: {
                request = SetSubtreeAccessibilityExtendedRequest.createSetReadOnlyRequest(baseDN, false, bypassDN, controls);
                break;
            }
            case HIDDEN: {
                request = SetSubtreeAccessibilityExtendedRequest.createSetHiddenRequest(baseDN, bypassDN, controls);
                break;
            }
            default: {
                throw new LDAPException(ResultCode.PARAM_ERROR, UnboundIDDSMessages.ERR_MOVE_SUBTREE_UNSUPPORTED_ACCESSIBILITY_STATE.get(state.getStateName(), baseDN, connectionName));
            }
        }
        try {
            result = connection.processExtendedOperation(request);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            result = le.toLDAPResult();
        }
        if (result.getResultCode() != ResultCode.SUCCESS) {
            throw new LDAPException(result.getResultCode(), UnboundIDDSMessages.ERR_MOVE_SUBTREE_ERROR_SETTING_ACCESSIBILITY.get(state.getStateName(), baseDN, connectionName, result.getDiagnosticMessage()));
        }
    }

    static void setInterruptMessage(MoveSubtree tool, String message) {
        if (tool != null) {
            tool.interruptMessage = message;
        }
    }

    private static boolean deleteEntries(LDAPConnection connection, boolean isSource, TreeSet<DN> entryDNs, OperationPurposeRequestControl opPurposeControl, boolean suppressRefInt, MoveSubtreeListener listener, AtomicInteger deleteCount, AtomicReference<ResultCode> resultCode, StringBuilder errorMsg) {
        ArrayList<Control> deleteControlList = new ArrayList<Control>(3);
        deleteControlList.add(new ManageDsaITRequestControl(true));
        if (opPurposeControl != null) {
            deleteControlList.add(opPurposeControl);
        }
        if (suppressRefInt) {
            deleteControlList.add(new SuppressReferentialIntegrityUpdatesRequestControl(false));
        }
        Control[] deleteControls = new Control[deleteControlList.size()];
        deleteControlList.toArray(deleteControls);
        boolean successful = true;
        for (DN dn : entryDNs) {
            LDAPResult deleteResult;
            if (isSource && listener != null) {
                try {
                    listener.doPreDeleteProcessing(dn);
                }
                catch (Exception e) {
                    Debug.debugException(e);
                    resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                    MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_PRE_DELETE_FAILURE.get(dn.toString(), StaticUtils.getExceptionMessage(e)), errorMsg);
                    successful = false;
                    continue;
                }
            }
            try {
                deleteResult = connection.delete(new DeleteRequest(dn, deleteControls));
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                deleteResult = le.toLDAPResult();
            }
            if (deleteResult.getResultCode() != ResultCode.SUCCESS) {
                resultCode.compareAndSet(null, deleteResult.getResultCode());
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_DELETE_FAILURE.get(dn.toString(), deleteResult.getDiagnosticMessage()), errorMsg);
                successful = false;
                continue;
            }
            deleteCount.incrementAndGet();
            if (!isSource || listener == null) continue;
            try {
                listener.doPostDeleteProcessing(dn);
            }
            catch (Exception e) {
                Debug.debugException(e);
                resultCode.compareAndSet(null, ResultCode.LOCAL_ERROR);
                MoveSubtree.append(UnboundIDDSMessages.ERR_MOVE_SUBTREE_POST_DELETE_FAILURE.get(dn.toString(), StaticUtils.getExceptionMessage(e)), errorMsg);
                successful = false;
            }
        }
        return successful;
    }

    static void append(String message, StringBuilder buffer) {
        if (message != null) {
            if (buffer.length() > 0) {
                buffer.append("  ");
            }
            buffer.append(message);
        }
    }

    @Override
    public void handleUnsolicitedNotification(LDAPConnection connection, ExtendedResult notification) {
        this.wrapOut(0, 79, UnboundIDDSMessages.INFO_MOVE_SUBTREE_UNSOLICITED_NOTIFICATION.get(notification.getOID(), connection.getConnectionName(), notification.getResultCode(), notification.getDiagnosticMessage()));
    }

    @Override
    public ReadOnlyEntry doPreAddProcessing(ReadOnlyEntry entry) {
        return entry;
    }

    @Override
    public void doPostAddProcessing(ReadOnlyEntry entry) {
        this.wrapOut(0, 79, UnboundIDDSMessages.INFO_MOVE_SUBTREE_ADD_SUCCESSFUL.get(entry.getDN()));
    }

    @Override
    public void doPreDeleteProcessing(DN entryDN) {
    }

    @Override
    public void doPostDeleteProcessing(DN entryDN) {
        this.wrapOut(0, 79, UnboundIDDSMessages.INFO_MOVE_SUBTREE_DELETE_SUCCESSFUL.get(entryDN.toString()));
    }

    @Override
    protected boolean registerShutdownHook() {
        return true;
    }

    @Override
    protected void doShutdownHookProcessing(ResultCode resultCode) {
        if (resultCode != null) {
            return;
        }
        this.wrapErr(0, 79, this.interruptMessage);
    }

    @Override
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> exampleMap = new LinkedHashMap<String[], String>(1);
        String[] args = new String[]{"--sourceHostname", "ds1.example.com", "--sourcePort", "389", "--sourceBindDN", "uid=admin,dc=example,dc=com", "--sourceBindPassword", "password", "--targetHostname", "ds2.example.com", "--targetPort", "389", "--targetBindDN", "uid=admin,dc=example,dc=com", "--targetBindPassword", "password", "--baseDN", "cn=small subtree,dc=example,dc=com", "--sizeLimit", "100", "--purpose", "Migrate a small subtree from ds1 to ds2"};
        exampleMap.put(args, UnboundIDDSMessages.INFO_MOVE_SUBTREE_EXAMPLE_DESCRIPTION.get());
        return exampleMap;
    }
}

