/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.unboundidds.OneTimePassword;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDTOTPBindRequest;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ReusableTOTPBindRequest
extends UnboundIDTOTPBindRequest {
    private static final long serialVersionUID = -8283436883838802510L;
    private final byte[] sharedSecret;
    private final int totpIntervalDurationSeconds;
    private final int totpNumDigits;

    public ReusableTOTPBindRequest(String authenticationID, String authorizationID, byte[] sharedSecret, String staticPassword, Control ... controls) {
        this(authenticationID, authorizationID, sharedSecret, staticPassword, 30, 6, new Control[0]);
    }

    public ReusableTOTPBindRequest(String authenticationID, String authorizationID, byte[] sharedSecret, byte[] staticPassword, Control ... controls) {
        this(authenticationID, authorizationID, sharedSecret, staticPassword, 30, 6, controls);
    }

    public ReusableTOTPBindRequest(String authenticationID, String authorizationID, byte[] sharedSecret, String staticPassword, int totpIntervalDurationSeconds, int totpNumDigits, Control ... controls) {
        super(authenticationID, authorizationID, staticPassword, controls);
        Validator.ensureTrue(totpIntervalDurationSeconds > 0);
        Validator.ensureTrue(totpNumDigits >= 6 && totpNumDigits <= 8);
        this.sharedSecret = sharedSecret;
        this.totpIntervalDurationSeconds = totpIntervalDurationSeconds;
        this.totpNumDigits = totpNumDigits;
    }

    public ReusableTOTPBindRequest(String authenticationID, String authorizationID, byte[] sharedSecret, byte[] staticPassword, int totpIntervalDurationSeconds, int totpNumDigits, Control ... controls) {
        super(authenticationID, authorizationID, staticPassword, controls);
        Validator.ensureTrue(totpIntervalDurationSeconds > 0);
        Validator.ensureTrue(totpNumDigits >= 6 && totpNumDigits <= 8);
        this.sharedSecret = sharedSecret;
        this.totpIntervalDurationSeconds = totpIntervalDurationSeconds;
        this.totpNumDigits = totpNumDigits;
    }

    private ReusableTOTPBindRequest(String authenticationID, String authorizationID, byte[] sharedSecret, ASN1OctetString staticPassword, int totpIntervalDurationSeconds, int totpNumDigits, Control ... controls) {
        super(authenticationID, authorizationID, staticPassword, controls);
        this.sharedSecret = sharedSecret;
        this.totpIntervalDurationSeconds = totpIntervalDurationSeconds;
        this.totpNumDigits = totpNumDigits;
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    public int getTOTPIntervalDurationSeconds() {
        return this.totpIntervalDurationSeconds;
    }

    public int getTOTPNumDigits() {
        return this.totpNumDigits;
    }

    protected ASN1OctetString getSASLCredentials() throws LDAPException {
        String totpPassword = OneTimePassword.totp(this.sharedSecret, System.currentTimeMillis(), this.totpIntervalDurationSeconds, this.totpNumDigits);
        return ReusableTOTPBindRequest.encodeCredentials(this.getAuthenticationID(), this.getAuthorizationID(), totpPassword, this.getStaticPassword());
    }

    public ReusableTOTPBindRequest getRebindRequest(String host, int port) {
        return this.duplicate();
    }

    public ReusableTOTPBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public ReusableTOTPBindRequest duplicate(Control[] controls) {
        ReusableTOTPBindRequest bindRequest = new ReusableTOTPBindRequest(this.getAuthenticationID(), this.getAuthorizationID(), this.sharedSecret, this.getStaticPassword(), this.totpIntervalDurationSeconds, this.totpNumDigits, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return bindRequest;
    }
}

