/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.InternalSDKHelper;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class UnboundIDCertificatePlusPasswordBindRequest
extends SASLBindRequest {
    public static final String UNBOUNDID_CERT_PLUS_PW_MECHANISM_NAME = "UNBOUNDID-CERTIFICATE-PLUS-PASSWORD";
    private static final long serialVersionUID = 8863298749835036708L;
    private final ASN1OctetString password;
    private volatile int messageID = -1;

    public UnboundIDCertificatePlusPasswordBindRequest(String password, Control ... controls) {
        this(new ASN1OctetString(-93, password), controls);
    }

    public UnboundIDCertificatePlusPasswordBindRequest(byte[] password, Control ... controls) {
        this(new ASN1OctetString(-93, password), controls);
    }

    private UnboundIDCertificatePlusPasswordBindRequest(ASN1OctetString password, Control ... controls) {
        super(controls);
        Validator.ensureFalse(password.getValueLength() == 0, "The bind password must not be empty");
        this.password = password;
    }

    public ASN1OctetString getPassword() {
        return this.password;
    }

    public String getSASLMechanismName() {
        return UNBOUNDID_CERT_PLUS_PW_MECHANISM_NAME;
    }

    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        this.messageID = InternalSDKHelper.nextMessageID(connection);
        return this.sendBindRequest(connection, "", this.password, this.getControls(), this.getResponseTimeoutMillis(connection));
    }

    public int getLastMessageID() {
        return this.messageID;
    }

    public UnboundIDCertificatePlusPasswordBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public UnboundIDCertificatePlusPasswordBindRequest duplicate(Control[] controls) {
        UnboundIDCertificatePlusPasswordBindRequest bindRequest = new UnboundIDCertificatePlusPasswordBindRequest(this.password, controls);
        bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return bindRequest;
    }

    public UnboundIDCertificatePlusPasswordBindRequest getRebindRequest(String host, int port) {
        return this.duplicate();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("UnboundIDCertificatePlusPasswordBindRequest(");
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

