/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.ChangeLogEntry;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.unboundidds.ChangeLogEntryAttributeExceededMaxValuesCount;
import com.unboundid.ldap.sdk.unboundidds.ChangeLogEntryAttributeExceededMaxValuesException;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UnboundIDChangeLogEntry
extends ChangeLogEntry {
    public static final String ATTR_BEFORE_VALUES = "ds-changelog-before-values";
    public static final String ATTR_AFTER_VALUES = "ds-changelog-after-values";
    public static final String ATTR_CHANGE_TO_SOFT_DELETED_ENTRY = "ds-change-to-soft-deleted-entry";
    public static final String ATTR_KEY_VALUES = "ds-changelog-entry-key-attr-values";
    public static final String ATTR_EXCEEDED_MAX_VALUES = "ds-changelog-attr-exceeded-max-values-count";
    public static final String ATTR_EXCLUDED_USER_ATTR_COUNT = "ds-changelog-num-excluded-user-attributes";
    public static final String ATTR_EXCLUDED_OPERATIONAL_ATTR_COUNT = "ds-changelog-num-excluded-operational-attributes";
    public static final String ATTR_EXCLUDED_USER_ATTR_NAME = "ds-changelog-excluded-user-attribute";
    public static final String ATTR_EXCLUDED_OPERATIONAL_ATTR_NAME = "ds-changelog-excluded-operational-attribute";
    public static final String ATTR_TARGET_UNIQUE_ID = "targetUniqueID";
    public static final String ATTR_CHANGE_TIME = "changeTime";
    public static final String ATTR_LOCAL_CSN = "localCSN";
    public static final String ATTR_SOFT_DELETE_TO_DN = "ds-soft-delete-entry-dn";
    public static final String ATTR_TARGET_ATTRIBUTE = "ds-changelog-target-attribute";
    public static final String ATTR_UNDELETE_FROM_DN = "ds-undelete-from-dn";
    public static final String ATTR_VIRTUAL_ATTRS = "ds-changelog-virtual-attributes";
    public static final String ATTR_BEFORE_VIRTUAL_VALUES = "ds-changelog-before-virtual-values";
    public static final String ATTR_AFTER_VIRTUAL_VALUES = "ds-changelog-after-virtual-values";
    public static final String ATTR_KEY_VIRTUAL_VALUES = "ds-changelog-entry-key-virtual-values";
    public static final String ATTR_VIRTUAL_EXCEEDED_MAX_VALUES = "ds-changelog-virtual-attr-exceeded-max-values-count";
    public static final String ATTR_NOTIFICATION_DESTINATION_ENTRY_UUID = "ds-notification-destination-entry-uuid";
    public static final String ATTR_NOTIFICATION_PROPERTIES = "ds-changelog-notification-properties";
    private static final long serialVersionUID = -6127912254495185946L;
    private final Boolean changeToSoftDeletedEntry;
    private final Date changeTime;
    private final Integer numExcludedUserAttributes;
    private final Integer numExcludedOperationalAttributes;
    private final List<Attribute> entryVirtualAttributes;
    private final List<Attribute> keyEntryAttributes;
    private final List<Attribute> keyEntryVirtualAttributes;
    private final List<Attribute> updatedAttributesAfterChange;
    private final List<Attribute> updatedAttributesBeforeChange;
    private final List<Attribute> updatedVirtualAttributesAfterChange;
    private final List<Attribute> updatedVirtualAttributesBeforeChange;
    private final List<ChangeLogEntryAttributeExceededMaxValuesCount> attributesThatExceededMaxValuesCount;
    private final List<ChangeLogEntryAttributeExceededMaxValuesCount> virtualAttributesThatExceededMaxValuesCount;
    private final List<String> excludedUserAttributeNames;
    private final List<String> excludedOperationalAttributeNames;
    private final List<String> notificationDestinationEntryUUIDs;
    private final List<String> notificationProperties;
    private final List<String> targetAttributeNames;
    private final String localCSN;
    private final String softDeleteToDN;
    private final String targetUniqueID;
    private final String undeleteFromDN;

    public UnboundIDChangeLogEntry(Entry entry) throws LDAPException {
        super(entry);
        String targetDN = entry.getAttributeValue("targetDN");
        this.targetUniqueID = entry.getAttributeValue(ATTR_TARGET_UNIQUE_ID);
        this.localCSN = entry.getAttributeValue(ATTR_LOCAL_CSN);
        this.changeTime = entry.getAttributeValueAsDate(ATTR_CHANGE_TIME);
        this.softDeleteToDN = entry.getAttributeValue(ATTR_SOFT_DELETE_TO_DN);
        this.undeleteFromDN = entry.getAttributeValue(ATTR_UNDELETE_FROM_DN);
        this.changeToSoftDeletedEntry = entry.getAttributeValueAsBoolean(ATTR_CHANGE_TO_SOFT_DELETED_ENTRY);
        this.entryVirtualAttributes = entry.hasAttribute(ATTR_VIRTUAL_ATTRS) ? UnboundIDChangeLogEntry.parseAddAttributeList(entry, ATTR_VIRTUAL_ATTRS, targetDN) : Collections.emptyList();
        this.updatedAttributesBeforeChange = entry.hasAttribute(ATTR_BEFORE_VALUES) ? UnboundIDChangeLogEntry.parseAddAttributeList(entry, ATTR_BEFORE_VALUES, targetDN) : Collections.emptyList();
        this.updatedVirtualAttributesBeforeChange = entry.hasAttribute(ATTR_BEFORE_VIRTUAL_VALUES) ? UnboundIDChangeLogEntry.parseAddAttributeList(entry, ATTR_BEFORE_VIRTUAL_VALUES, targetDN) : Collections.emptyList();
        this.updatedAttributesAfterChange = entry.hasAttribute(ATTR_AFTER_VALUES) ? UnboundIDChangeLogEntry.parseAddAttributeList(entry, ATTR_AFTER_VALUES, targetDN) : Collections.emptyList();
        this.updatedVirtualAttributesAfterChange = entry.hasAttribute(ATTR_AFTER_VIRTUAL_VALUES) ? UnboundIDChangeLogEntry.parseAddAttributeList(entry, ATTR_AFTER_VIRTUAL_VALUES, targetDN) : Collections.emptyList();
        this.keyEntryAttributes = entry.hasAttribute(ATTR_KEY_VALUES) ? UnboundIDChangeLogEntry.parseAddAttributeList(entry, ATTR_KEY_VALUES, targetDN) : Collections.emptyList();
        this.keyEntryVirtualAttributes = entry.hasAttribute(ATTR_KEY_VIRTUAL_VALUES) ? UnboundIDChangeLogEntry.parseAddAttributeList(entry, ATTR_KEY_VIRTUAL_VALUES, targetDN) : Collections.emptyList();
        Attribute exceededMaxValues = entry.getAttribute(ATTR_EXCEEDED_MAX_VALUES);
        if (exceededMaxValues == null) {
            this.attributesThatExceededMaxValuesCount = Collections.emptyList();
        } else {
            String[] values = exceededMaxValues.getValues();
            ArrayList<ChangeLogEntryAttributeExceededMaxValuesCount> l = new ArrayList<ChangeLogEntryAttributeExceededMaxValuesCount>(values.length);
            for (String value : values) {
                l.add(new ChangeLogEntryAttributeExceededMaxValuesCount(value));
            }
            this.attributesThatExceededMaxValuesCount = Collections.unmodifiableList(l);
        }
        Attribute virtualExceededMaxValues = entry.getAttribute(ATTR_VIRTUAL_EXCEEDED_MAX_VALUES);
        if (virtualExceededMaxValues == null) {
            this.virtualAttributesThatExceededMaxValuesCount = Collections.emptyList();
        } else {
            String[] values = virtualExceededMaxValues.getValues();
            ArrayList<ChangeLogEntryAttributeExceededMaxValuesCount> l = new ArrayList<ChangeLogEntryAttributeExceededMaxValuesCount>(values.length);
            for (String value : values) {
                l.add(new ChangeLogEntryAttributeExceededMaxValuesCount(value));
            }
            this.virtualAttributesThatExceededMaxValuesCount = Collections.unmodifiableList(l);
        }
        this.numExcludedUserAttributes = entry.getAttributeValueAsInteger(ATTR_EXCLUDED_USER_ATTR_COUNT);
        this.numExcludedOperationalAttributes = entry.getAttributeValueAsInteger(ATTR_EXCLUDED_OPERATIONAL_ATTR_COUNT);
        String[] excludedUserAttrNames = entry.getAttributeValues(ATTR_EXCLUDED_USER_ATTR_NAME);
        this.excludedUserAttributeNames = excludedUserAttrNames == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(excludedUserAttrNames)));
        String[] excludedOpAttrNames = entry.getAttributeValues(ATTR_EXCLUDED_OPERATIONAL_ATTR_NAME);
        this.excludedOperationalAttributeNames = excludedOpAttrNames == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(excludedOpAttrNames)));
        String[] targetAttrNames = entry.getAttributeValues(ATTR_TARGET_ATTRIBUTE);
        this.targetAttributeNames = targetAttrNames == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(targetAttrNames)));
        String[] notificationUUIDValues = entry.getAttributeValues(ATTR_NOTIFICATION_DESTINATION_ENTRY_UUID);
        this.notificationDestinationEntryUUIDs = notificationUUIDValues == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(notificationUUIDValues)));
        String[] notificationPropertyValues = entry.getAttributeValues(ATTR_NOTIFICATION_PROPERTIES);
        this.notificationProperties = notificationPropertyValues == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(notificationPropertyValues)));
    }

    public String getTargetUniqueID() {
        return this.targetUniqueID;
    }

    public String getLocalCSN() {
        return this.localCSN;
    }

    public Date getChangeTime() {
        return this.changeTime;
    }

    public List<Attribute> getAddAttributes(boolean includeVirtual) {
        if (includeVirtual && this.getChangeType() == ChangeType.ADD && !this.entryVirtualAttributes.isEmpty()) {
            Entry e = new Entry(this.getTargetDN(), this.getAddAttributes());
            for (Attribute a : this.entryVirtualAttributes) {
                e.addAttribute(a);
            }
            return Collections.unmodifiableList(new ArrayList<Attribute>(e.getAttributes()));
        }
        return this.getAddAttributes();
    }

    public List<Attribute> getAddVirtualAttributes() {
        if (this.getChangeType() == ChangeType.ADD) {
            return this.entryVirtualAttributes;
        }
        return null;
    }

    public List<Attribute> getDeletedEntryAttributes(boolean includeVirtual) {
        if (includeVirtual && this.getChangeType() == ChangeType.DELETE && !this.entryVirtualAttributes.isEmpty()) {
            Entry e;
            List<Attribute> realAttrs = this.getDeletedEntryAttributes();
            if (realAttrs != null) {
                e = new Entry(this.getTargetDN(), realAttrs);
                for (Attribute a : this.entryVirtualAttributes) {
                    e.addAttribute(a);
                }
            } else {
                e = new Entry(this.getTargetDN(), this.entryVirtualAttributes);
            }
            return Collections.unmodifiableList(new ArrayList<Attribute>(e.getAttributes()));
        }
        return this.getDeletedEntryAttributes();
    }

    public List<Attribute> getDeletedEntryVirtualAttributes() {
        if (this.getChangeType() == ChangeType.DELETE) {
            return this.entryVirtualAttributes;
        }
        return null;
    }

    public List<Attribute> getUpdatedAttributesBeforeChange() {
        return this.updatedAttributesBeforeChange;
    }

    public List<Attribute> getUpdatedAttributesBeforeChange(boolean includeVirtual) {
        if (includeVirtual && !this.updatedVirtualAttributesBeforeChange.isEmpty()) {
            Entry e = new Entry(this.getTargetDN(), this.updatedAttributesBeforeChange);
            for (Attribute a : this.updatedVirtualAttributesBeforeChange) {
                e.addAttribute(a);
            }
            return Collections.unmodifiableList(new ArrayList<Attribute>(e.getAttributes()));
        }
        return this.updatedAttributesBeforeChange;
    }

    public List<Attribute> getUpdatedVirtualAttributesBeforeChange() {
        return this.updatedVirtualAttributesBeforeChange;
    }

    public List<Attribute> getUpdatedAttributesAfterChange() {
        return this.updatedAttributesAfterChange;
    }

    public List<Attribute> getUpdatedAttributesAfterChange(boolean includeVirtual) {
        if (includeVirtual && !this.updatedVirtualAttributesAfterChange.isEmpty()) {
            Entry e = new Entry(this.getTargetDN(), this.updatedAttributesAfterChange);
            for (Attribute a : this.updatedVirtualAttributesAfterChange) {
                e.addAttribute(a);
            }
            return Collections.unmodifiableList(new ArrayList<Attribute>(e.getAttributes()));
        }
        return this.updatedAttributesAfterChange;
    }

    public List<Attribute> getUpdatedVirtualAttributesAfterChange() {
        return this.updatedVirtualAttributesAfterChange;
    }

    public List<ChangeLogEntryAttributeExceededMaxValuesCount> getAttributesThatExceededMaxValuesCount() {
        return this.attributesThatExceededMaxValuesCount;
    }

    public List<ChangeLogEntryAttributeExceededMaxValuesCount> getVirtualAttributesThatExceededMaxValuesCount() {
        return this.virtualAttributesThatExceededMaxValuesCount;
    }

    public List<Attribute> getKeyEntryAttributes() {
        return this.keyEntryAttributes;
    }

    public List<Attribute> getKeyEntryAttributes(boolean includeVirtual) {
        if (includeVirtual && !this.keyEntryVirtualAttributes.isEmpty()) {
            Entry e = new Entry(this.getTargetDN(), this.keyEntryAttributes);
            for (Attribute a : this.keyEntryVirtualAttributes) {
                e.addAttribute(a);
            }
            return Collections.unmodifiableList(new ArrayList<Attribute>(e.getAttributes()));
        }
        return this.keyEntryAttributes;
    }

    public List<Attribute> getKeyEntryVirtualAttributes() {
        return this.keyEntryVirtualAttributes;
    }

    public int getNumExcludedUserAttributes() {
        if (this.numExcludedUserAttributes == null) {
            return -1;
        }
        return this.numExcludedUserAttributes;
    }

    public int getNumExcludedOperationalAttributes() {
        if (this.numExcludedOperationalAttributes == null) {
            return -1;
        }
        return this.numExcludedOperationalAttributes;
    }

    public List<String> getExcludedUserAttributeNames() {
        return this.excludedUserAttributeNames;
    }

    public List<String> getExcludedOperationalAttributeNames() {
        return this.excludedOperationalAttributeNames;
    }

    public Boolean getChangeToSoftDeletedEntry() {
        return this.changeToSoftDeletedEntry;
    }

    public String getSoftDeleteToDN() {
        return this.softDeleteToDN;
    }

    public String getUndeleteFromDN() {
        return this.undeleteFromDN;
    }

    public List<String> getTargetAttributeNames() {
        return this.targetAttributeNames;
    }

    public List<String> getNotificationDestinationEntryUUIDs() {
        return this.notificationDestinationEntryUUIDs;
    }

    public List<String> getNotificationProperties() {
        return this.notificationProperties;
    }

    public Attribute getAttributeBeforeChange(String name) throws ChangeLogEntryAttributeExceededMaxValuesException {
        return this.getAttributeBeforeChange(name, false);
    }

    public Attribute getAttributeBeforeChange(String name, boolean includeVirtual) throws ChangeLogEntryAttributeExceededMaxValuesException {
        if (this.getChangeType() == ChangeType.ADD) {
            return null;
        }
        for (Attribute attribute : this.getUpdatedAttributesBeforeChange(includeVirtual)) {
            if (!attribute.getName().equalsIgnoreCase(name)) continue;
            return attribute;
        }
        for (ChangeLogEntryAttributeExceededMaxValuesCount changeLogEntryAttributeExceededMaxValuesCount : this.attributesThatExceededMaxValuesCount) {
            if (!changeLogEntryAttributeExceededMaxValuesCount.getAttributeName().equalsIgnoreCase(name)) continue;
            throw new ChangeLogEntryAttributeExceededMaxValuesException(UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_BEFORE_VALUE_COUNT.get(name, this.getTargetDN(), changeLogEntryAttributeExceededMaxValuesCount.getBeforeCount()), changeLogEntryAttributeExceededMaxValuesCount);
        }
        if (includeVirtual) {
            for (ChangeLogEntryAttributeExceededMaxValuesCount changeLogEntryAttributeExceededMaxValuesCount : this.virtualAttributesThatExceededMaxValuesCount) {
                if (!changeLogEntryAttributeExceededMaxValuesCount.getAttributeName().equalsIgnoreCase(name)) continue;
                throw new ChangeLogEntryAttributeExceededMaxValuesException(UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VIRTUAL_BEFORE_VALUE_COUNT.get(name, this.getTargetDN(), changeLogEntryAttributeExceededMaxValuesCount.getBeforeCount()), changeLogEntryAttributeExceededMaxValuesCount);
            }
        }
        for (Attribute attribute : this.getKeyEntryAttributes(includeVirtual)) {
            if (!attribute.getName().equalsIgnoreCase(name)) continue;
            return attribute;
        }
        List<Attribute> deletedAttrs = this.getDeletedEntryAttributes(includeVirtual);
        if (deletedAttrs != null) {
            for (Attribute a : deletedAttrs) {
                if (!a.getName().equalsIgnoreCase(name)) continue;
                return a;
            }
        }
        return null;
    }

    public Attribute getAttributeAfterChange(String name) throws ChangeLogEntryAttributeExceededMaxValuesException {
        return this.getAttributeAfterChange(name, false);
    }

    public Attribute getAttributeAfterChange(String name, boolean includeVirtual) throws ChangeLogEntryAttributeExceededMaxValuesException {
        List<Modification> list;
        List<Attribute> addAttrs;
        if (this.getChangeType() == ChangeType.DELETE) {
            return null;
        }
        for (Attribute attribute : this.getUpdatedAttributesAfterChange(includeVirtual)) {
            if (!attribute.getName().equalsIgnoreCase(name)) continue;
            return attribute;
        }
        for (Attribute attribute : this.getKeyEntryAttributes(includeVirtual)) {
            if (!attribute.getName().equalsIgnoreCase(name)) continue;
            return attribute;
        }
        for (ChangeLogEntryAttributeExceededMaxValuesCount changeLogEntryAttributeExceededMaxValuesCount : this.attributesThatExceededMaxValuesCount) {
            if (!changeLogEntryAttributeExceededMaxValuesCount.getAttributeName().equalsIgnoreCase(name)) continue;
            throw new ChangeLogEntryAttributeExceededMaxValuesException(UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_AFTER_VALUE_COUNT.get(name, this.getTargetDN(), changeLogEntryAttributeExceededMaxValuesCount.getAfterCount()), changeLogEntryAttributeExceededMaxValuesCount);
        }
        if (includeVirtual) {
            for (ChangeLogEntryAttributeExceededMaxValuesCount changeLogEntryAttributeExceededMaxValuesCount : this.virtualAttributesThatExceededMaxValuesCount) {
                if (!changeLogEntryAttributeExceededMaxValuesCount.getAttributeName().equalsIgnoreCase(name)) continue;
                throw new ChangeLogEntryAttributeExceededMaxValuesException(UnboundIDDSMessages.ERR_CHANGELOG_EXCEEDED_VIRTUAL_AFTER_VALUE_COUNT.get(name, this.getTargetDN(), changeLogEntryAttributeExceededMaxValuesCount.getAfterCount()), changeLogEntryAttributeExceededMaxValuesCount);
            }
        }
        if ((addAttrs = this.getAddAttributes(includeVirtual)) != null) {
            for (Attribute a : addAttrs) {
                if (!a.getName().equalsIgnoreCase(name)) continue;
                return a;
            }
        }
        if ((list = this.getModifications()) != null) {
            for (Modification m : list) {
                if (!m.getAttributeName().equalsIgnoreCase(name)) continue;
                byte[][] values = m.getValueByteArrays();
                if (m.getModificationType() != ModificationType.REPLACE || values.length <= 0) continue;
                return new Attribute(name, values);
            }
        }
        return null;
    }

    public ReadOnlyEntry constructPartialEntryBeforeChange() {
        return this.constructPartialEntryBeforeChange(false);
    }

    public ReadOnlyEntry constructPartialEntryBeforeChange(boolean includeVirtual) {
        if (this.getChangeType() == ChangeType.ADD) {
            return null;
        }
        Entry e = new Entry(this.getTargetDN());
        List<Attribute> deletedEntryAttrs = this.getDeletedEntryAttributes(includeVirtual);
        if (deletedEntryAttrs != null) {
            for (Attribute a : deletedEntryAttrs) {
                e.addAttribute(a);
            }
        }
        for (Attribute a : this.getUpdatedAttributesBeforeChange(includeVirtual)) {
            e.addAttribute(a);
        }
        for (Attribute a : this.getKeyEntryAttributes(includeVirtual)) {
            boolean shouldExclude = e.hasAttribute(a.getName());
            for (Attribute ba : this.getUpdatedAttributesAfterChange(includeVirtual)) {
                if (!ba.getName().equalsIgnoreCase(a.getName())) continue;
                shouldExclude = true;
            }
            for (ChangeLogEntryAttributeExceededMaxValuesCount ea : this.attributesThatExceededMaxValuesCount) {
                if (!ea.getAttributeName().equalsIgnoreCase(a.getName())) continue;
                shouldExclude = true;
            }
            if (includeVirtual) {
                for (ChangeLogEntryAttributeExceededMaxValuesCount ea : this.virtualAttributesThatExceededMaxValuesCount) {
                    if (!ea.getAttributeName().equalsIgnoreCase(a.getName())) continue;
                    shouldExclude = true;
                }
            }
            if (shouldExclude) continue;
            e.addAttribute(a);
        }
        return new ReadOnlyEntry(e);
    }

    public ReadOnlyEntry constructPartialEntryAfterChange() {
        return this.constructPartialEntryAfterChange(false);
    }

    public ReadOnlyEntry constructPartialEntryAfterChange(boolean includeVirtual) {
        List<Modification> mods;
        Entry e;
        switch (this.getChangeType()) {
            case ADD: 
            case MODIFY: {
                e = new Entry(this.getTargetDN());
                break;
            }
            case MODIFY_DN: {
                e = new Entry(this.getNewDN());
                break;
            }
            default: {
                return null;
            }
        }
        List<Attribute> addAttrs = this.getAddAttributes(includeVirtual);
        if (addAttrs != null) {
            for (Attribute a : addAttrs) {
                e.addAttribute(a);
            }
        }
        if ((mods = this.getModifications()) != null) {
            for (Modification m : mods) {
                byte[][] values = m.getValueByteArrays();
                if (m.getModificationType() != ModificationType.REPLACE || values.length <= 0) continue;
                e.addAttribute(m.getAttributeName(), values);
            }
        }
        for (Attribute a : this.getUpdatedAttributesAfterChange(includeVirtual)) {
            e.addAttribute(a);
        }
        for (Attribute a : this.getKeyEntryAttributes(includeVirtual)) {
            e.addAttribute(a);
        }
        return new ReadOnlyEntry(e);
    }
}

