/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinRequestValue;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JoinRequestControl
extends Control {
    public static final String JOIN_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.9";
    private static final long serialVersionUID = -1321645105838145996L;
    private final JoinRequestValue joinRequestValue;

    public JoinRequestControl(JoinRequestValue joinRequestValue) {
        super(JOIN_REQUEST_OID, true, new ASN1OctetString(joinRequestValue.encode().encode()));
        this.joinRequestValue = joinRequestValue;
    }

    public JoinRequestControl(Control control) throws LDAPException {
        super(control);
        ASN1Element valueElement;
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_CONTROL_NO_VALUE.get());
        }
        try {
            valueElement = ASN1Element.decode(value.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_JOIN_REQUEST_VALUE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.joinRequestValue = JoinRequestValue.decode(valueElement);
    }

    public JoinRequestValue getJoinRequestValue() {
        return this.joinRequestValue;
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_JOIN_REQUEST.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("JoinRequestControl(value=");
        this.joinRequestValue.toString(buffer);
        buffer.append(')');
    }
}

