/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class OperationPurposeRequestControl
extends Control {
    public static final String OPERATION_PURPOSE_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.19";
    private static final byte TYPE_APP_NAME = -128;
    private static final byte TYPE_APP_VERSION = -127;
    private static final byte TYPE_CODE_LOCATION = -126;
    private static final byte TYPE_REQUEST_PURPOSE = -125;
    private static final long serialVersionUID = -5552051862785419833L;
    private final String applicationName;
    private final String applicationVersion;
    private final String codeLocation;
    private final String requestPurpose;

    public OperationPurposeRequestControl(String applicationName, String applicationVersion, int codeLocationFrames, String requestPurpose) {
        this(false, applicationName, applicationVersion, OperationPurposeRequestControl.generateStackTrace(codeLocationFrames), requestPurpose);
    }

    public OperationPurposeRequestControl(boolean isCritical, String applicationName, String applicationVersion, String codeLocation, String requestPurpose) {
        super(OPERATION_PURPOSE_REQUEST_OID, isCritical, OperationPurposeRequestControl.encodeValue(applicationName, applicationVersion, codeLocation, requestPurpose));
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.codeLocation = codeLocation;
        this.requestPurpose = requestPurpose;
    }

    public OperationPurposeRequestControl(Control control) throws LDAPException {
        super(control);
        ASN1Element[] valueElements;
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_OP_PURPOSE_NO_VALUE.get());
        }
        try {
            valueElements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_OP_PURPOSE_VALUE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (valueElements.length == 0) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_OP_PURPOSE_VALUE_SEQUENCE_EMPTY.get());
        }
        String appName = null;
        String appVersion = null;
        String codeLoc = null;
        String reqPurpose = null;
        block8: for (ASN1Element e : valueElements) {
            switch (e.getType()) {
                case -128: {
                    appName = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block8;
                }
                case -127: {
                    appVersion = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block8;
                }
                case -126: {
                    codeLoc = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block8;
                }
                case -125: {
                    reqPurpose = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block8;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_OP_PURPOSE_VALUE_UNSUPPORTED_ELEMENT.get(StaticUtils.toHex(e.getType())));
                }
            }
        }
        this.applicationName = appName;
        this.applicationVersion = appVersion;
        this.codeLocation = codeLoc;
        this.requestPurpose = reqPurpose;
    }

    private static String generateStackTrace(int numFrames) {
        StringBuilder buffer = new StringBuilder();
        int n = numFrames > 0 ? numFrames : Integer.MAX_VALUE;
        int c = 0;
        boolean skip = true;
        for (StackTraceElement e : Thread.currentThread().getStackTrace()) {
            int lastPeriodPos;
            String className = e.getClassName();
            if (className.equals(OperationPurposeRequestControl.class.getName())) {
                skip = false;
                continue;
            }
            if (skip) continue;
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            if ((lastPeriodPos = className.lastIndexOf(46)) > 0) {
                buffer.append(className.substring(lastPeriodPos + 1));
            } else {
                buffer.append(className);
            }
            buffer.append('.');
            buffer.append(e.getMethodName());
            buffer.append(':');
            buffer.append(e.getLineNumber());
            if (++c >= n) break;
        }
        return buffer.toString();
    }

    private static ASN1OctetString encodeValue(String applicationName, String applicationVersion, String codeLocation, String requestPurpose) {
        Validator.ensureFalse(applicationName == null && applicationVersion == null && codeLocation == null && requestPurpose == null);
        ArrayList<ASN1OctetString> elements = new ArrayList<ASN1OctetString>(4);
        if (applicationName != null) {
            elements.add(new ASN1OctetString(-128, applicationName));
        }
        if (applicationVersion != null) {
            elements.add(new ASN1OctetString(-127, applicationVersion));
        }
        if (codeLocation != null) {
            elements.add(new ASN1OctetString(-126, codeLocation));
        }
        if (requestPurpose != null) {
            elements.add(new ASN1OctetString(-125, requestPurpose));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public String getCodeLocation() {
        return this.codeLocation;
    }

    public String getRequestPurpose() {
        return this.requestPurpose;
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_OP_PURPOSE.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("OperationPurposeRequestControl(isCritical=");
        buffer.append(this.isCritical());
        if (this.applicationName != null) {
            buffer.append(", appName='");
            buffer.append(this.applicationName);
            buffer.append('\'');
        }
        if (this.applicationVersion != null) {
            buffer.append(", appVersion='");
            buffer.append(this.applicationVersion);
            buffer.append('\'');
        }
        if (this.codeLocation != null) {
            buffer.append(", codeLocation='");
            buffer.append(this.codeLocation);
            buffer.append('\'');
        }
        if (this.requestPurpose != null) {
            buffer.append(", purpose='");
            buffer.append(this.requestPurpose);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

