/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.EndBatchedTransactionExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class EndBatchedTransactionExtendedRequest
extends ExtendedRequest {
    public static final String END_BATCHED_TRANSACTION_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.2";
    private static final long serialVersionUID = -8569129721687583552L;
    private final ASN1OctetString transactionID;
    private final boolean commit;

    public EndBatchedTransactionExtendedRequest(ASN1OctetString transactionID, boolean commit) {
        this(transactionID, commit, null);
    }

    public EndBatchedTransactionExtendedRequest(ASN1OctetString transactionID, boolean commit, Control[] controls) {
        super(END_BATCHED_TRANSACTION_REQUEST_OID, EndBatchedTransactionExtendedRequest.encodeValue(transactionID, commit), controls);
        this.transactionID = transactionID;
        this.commit = commit;
    }

    public EndBatchedTransactionExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest);
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            if (elements.length == 1) {
                this.commit = true;
                this.transactionID = ASN1OctetString.decodeAsOctetString(elements[0]);
            } else {
                this.commit = ASN1Boolean.decodeAsBoolean(elements[0]).booleanValue();
                this.transactionID = ASN1OctetString.decodeAsOctetString(elements[1]);
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_END_TXN_REQUEST_CANNOT_DECODE.get(e), e);
        }
    }

    private static ASN1OctetString encodeValue(ASN1OctetString transactionID, boolean commit) {
        Validator.ensureNotNull(transactionID);
        ASN1Element[] valueElements = commit ? new ASN1Element[]{transactionID} : new ASN1Element[]{new ASN1Boolean(commit), transactionID};
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    public boolean commit() {
        return this.commit;
    }

    public EndBatchedTransactionExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new EndBatchedTransactionExtendedResult(extendedResponse);
    }

    public EndBatchedTransactionExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    public EndBatchedTransactionExtendedRequest duplicate(Control[] controls) {
        EndBatchedTransactionExtendedRequest r = new EndBatchedTransactionExtendedRequest(this.transactionID, this.commit, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_EXTENDED_REQUEST_NAME_END_BATCHED_TXN.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("EndBatchedTransactionExtendedRequest(transactionID='");
        buffer.append(this.transactionID.stringValue());
        buffer.append("', commit=");
        buffer.append(this.commit);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

