/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetBackupCompatibilityDescriptorExtendedResult
extends ExtendedResult {
    public static final String GET_BACKUP_COMPATIBILITY_DESCRIPTOR_RESULT_OID = "1.3.6.1.4.1.30221.2.6.31";
    private static final byte TYPE_DESCRIPTOR = -128;
    private static final byte TYPE_PROPERTIES = -95;
    private static final long serialVersionUID = -2493658329210480765L;
    private final ASN1OctetString descriptor;
    private final List<String> properties;

    public GetBackupCompatibilityDescriptorExtendedResult(ExtendedResult result) throws LDAPException {
        super(result);
        ASN1OctetString value = result.getValue();
        if (value == null) {
            this.descriptor = null;
            this.properties = Collections.emptyList();
            return;
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.descriptor = elements[0].decodeAsOctetString();
            if (elements.length > 1) {
                ASN1Element[] propElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
                ArrayList<String> propList = new ArrayList<String>(propElements.length);
                for (ASN1Element e : propElements) {
                    propList.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                }
                this.properties = Collections.unmodifiableList(propList);
            } else {
                this.properties = Collections.emptyList();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_BACKUP_COMPAT_RESULT_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public GetBackupCompatibilityDescriptorExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, ASN1OctetString descriptor, Collection<String> properties, Control ... responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, descriptor == null ? null : GET_BACKUP_COMPATIBILITY_DESCRIPTOR_RESULT_OID, GetBackupCompatibilityDescriptorExtendedResult.encodeValue(descriptor, properties), responseControls);
        this.descriptor = descriptor == null ? null : new ASN1OctetString(-128, descriptor.getValue());
        this.properties = properties == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(properties));
    }

    public static ASN1OctetString encodeValue(ASN1OctetString descriptor, Collection<String> properties) {
        if (descriptor == null) {
            Validator.ensureTrue(properties == null || properties.isEmpty(), "The properties must be null or empty if the descriptor is null.");
            return null;
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        elements.add(new ASN1OctetString(-128, descriptor.getValue()));
        if (properties != null && !properties.isEmpty()) {
            ArrayList<ASN1OctetString> propElements = new ArrayList<ASN1OctetString>(properties.size());
            for (String property : properties) {
                propElements.add(new ASN1OctetString(property));
            }
            elements.add(new ASN1Sequence(-95, propElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public ASN1OctetString getDescriptor() {
        return this.descriptor;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_GET_BACKUP_COMPAT.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("GetBackupCompatibilityDescriptorExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if (this.descriptor != null) {
            buffer.append(", descriptorLength=");
            buffer.append(this.descriptor.getValueLength());
        }
        if (!this.properties.isEmpty()) {
            buffer.append(", descriptorProperties={");
            Iterator<String> iterator = this.properties.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

