/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1Long;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1Set;
import com.unboundid.ldap.sdk.ChangeType;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ChangelogBatchChangeSelectionCriteria;
import com.unboundid.ldap.sdk.unboundidds.extensions.ChangelogBatchStartingPoint;
import com.unboundid.ldap.sdk.unboundidds.extensions.ChangelogEntryListener;
import com.unboundid.ldap.sdk.unboundidds.extensions.DefaultChangelogEntryListener;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetChangelogBatchExtendedResult;
import com.unboundid.ldap.sdk.unboundidds.extensions.GetChangelogBatchIntermediateResponseListener;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetChangelogBatchExtendedRequest
extends ExtendedRequest {
    public static final String GET_CHANGELOG_BATCH_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.10";
    private static final byte TYPE_MAX_TIME = -128;
    private static final byte TYPE_WAIT_FOR_MAX_CHANGES = -127;
    private static final byte TYPE_INCLUDE_BASE = -94;
    private static final byte TYPE_EXCLUDE_BASE = -93;
    private static final byte TYPE_CHANGE_TYPES = -92;
    private static final byte TYPE_CONTINUE_ON_MISSING_CHANGES = -123;
    private static final byte TYPE_PARE_ENTRIES_FOR_USER_DN = -122;
    private static final byte TYPE_INCLUDE_SOFT_DELETED_ENTRY_MODS = -120;
    private static final byte TYPE_INCLUDE_SOFT_DELETED_ENTRY_DELETES = -119;
    private static final int CHANGE_TYPE_ADD = 0;
    private static final int CHANGE_TYPE_DELETE = 1;
    private static final int CHANGE_TYPE_MODIFY = 2;
    private static final int CHANGE_TYPE_MODIFY_DN = 3;
    private static final long serialVersionUID = 3270898150012821635L;
    private final boolean continueOnMissingChanges;
    private final boolean includeSoftDeletedEntryDeletes;
    private final boolean includeSoftDeletedEntryMods;
    private final boolean waitForMaxChanges;
    private final ChangelogBatchChangeSelectionCriteria changeSelectionCriteria;
    private final ChangelogBatchStartingPoint startingPoint;
    private final ChangelogEntryListener entryListener;
    private final int maxChanges;
    private final List<String> excludeBaseDNs;
    private final List<String> includeBaseDNs;
    private final long maxWaitTimeMillis;
    private final Set<ChangeType> changeTypes;
    private final String pareEntriesForUserDN;

    public GetChangelogBatchExtendedRequest(ChangelogBatchStartingPoint startingPoint, int maxChanges, long maxWaitTimeMillis, Control ... controls) {
        this(null, startingPoint, maxChanges, maxWaitTimeMillis, false, null, null, null, false, null, null, false, false, controls);
    }

    public GetChangelogBatchExtendedRequest(ChangelogEntryListener entryListener, ChangelogBatchStartingPoint startingPoint, int maxChanges, long maxWaitTimeMillis, Control ... controls) {
        this(entryListener, startingPoint, maxChanges, maxWaitTimeMillis, false, null, null, null, false, null, null, false, false, controls);
    }

    public GetChangelogBatchExtendedRequest(ChangelogBatchStartingPoint startingPoint, int maxChanges, long maxWaitTimeMillis, boolean waitForMaxChanges, List<String> includeBaseDNs, List<String> excludeBaseDNs, Set<ChangeType> changeTypes, boolean continueOnMissingChanges, Control ... controls) {
        this(null, startingPoint, maxChanges, maxWaitTimeMillis, waitForMaxChanges, includeBaseDNs, excludeBaseDNs, changeTypes, continueOnMissingChanges, null, null, false, false, controls);
    }

    public GetChangelogBatchExtendedRequest(ChangelogEntryListener entryListener, ChangelogBatchStartingPoint startingPoint, int maxChanges, long maxWaitTimeMillis, boolean waitForMaxChanges, List<String> includeBaseDNs, List<String> excludeBaseDNs, Set<ChangeType> changeTypes, boolean continueOnMissingChanges, Control ... controls) {
        this(entryListener, startingPoint, maxChanges, maxWaitTimeMillis, waitForMaxChanges, includeBaseDNs, excludeBaseDNs, changeTypes, continueOnMissingChanges, null, null, false, false, controls);
    }

    public GetChangelogBatchExtendedRequest(ChangelogEntryListener entryListener, ChangelogBatchStartingPoint startingPoint, int maxChanges, long maxWaitTimeMillis, boolean waitForMaxChanges, List<String> includeBaseDNs, List<String> excludeBaseDNs, Set<ChangeType> changeTypes, boolean continueOnMissingChanges, String pareEntriesForUserDN, ChangelogBatchChangeSelectionCriteria changeSelectionCriteria, Control ... controls) {
        this(entryListener, startingPoint, maxChanges, maxWaitTimeMillis, waitForMaxChanges, includeBaseDNs, excludeBaseDNs, changeTypes, continueOnMissingChanges, pareEntriesForUserDN, changeSelectionCriteria, false, false, controls);
    }

    public GetChangelogBatchExtendedRequest(ChangelogEntryListener entryListener, ChangelogBatchStartingPoint startingPoint, int maxChanges, long maxWaitTimeMillis, boolean waitForMaxChanges, List<String> includeBaseDNs, List<String> excludeBaseDNs, Set<ChangeType> changeTypes, boolean continueOnMissingChanges, String pareEntriesForUserDN, ChangelogBatchChangeSelectionCriteria changeSelectionCriteria, boolean includeSoftDeletedEntryMods, boolean includeSoftDeletedEntryDeletes, Control ... controls) {
        super(GET_CHANGELOG_BATCH_REQUEST_OID, GetChangelogBatchExtendedRequest.encodeValue(startingPoint, maxChanges, maxWaitTimeMillis, waitForMaxChanges, includeBaseDNs, excludeBaseDNs, changeTypes, continueOnMissingChanges, pareEntriesForUserDN, changeSelectionCriteria, includeSoftDeletedEntryMods, includeSoftDeletedEntryDeletes), controls);
        this.entryListener = entryListener;
        this.startingPoint = startingPoint;
        this.maxWaitTimeMillis = maxWaitTimeMillis;
        this.waitForMaxChanges = waitForMaxChanges;
        this.continueOnMissingChanges = continueOnMissingChanges;
        this.pareEntriesForUserDN = pareEntriesForUserDN;
        this.changeSelectionCriteria = changeSelectionCriteria;
        this.includeSoftDeletedEntryMods = includeSoftDeletedEntryMods;
        this.includeSoftDeletedEntryDeletes = includeSoftDeletedEntryDeletes;
        this.maxChanges = maxChanges <= 0 ? 0 : maxChanges;
        this.includeBaseDNs = includeBaseDNs == null ? Collections.emptyList() : Collections.unmodifiableList(includeBaseDNs);
        this.excludeBaseDNs = excludeBaseDNs == null ? Collections.emptyList() : Collections.unmodifiableList(excludeBaseDNs);
        this.changeTypes = changeTypes == null || changeTypes.isEmpty() ? Collections.unmodifiableSet(EnumSet.allOf(ChangeType.class)) : Collections.unmodifiableSet(changeTypes);
    }

    public GetChangelogBatchExtendedRequest(ExtendedRequest extendedRequest) throws LDAPException {
        super(extendedRequest.getOID(), extendedRequest.getValue(), extendedRequest.getControls());
        ASN1Sequence valueSequence;
        ASN1OctetString value = extendedRequest.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_REQ_NO_VALUE.get());
        }
        try {
            valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_REQ_VALUE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        ASN1Element[] elements = valueSequence.elements();
        if (elements.length < 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_REQ_TOO_FEW_ELEMENTS.get());
        }
        try {
            this.startingPoint = ChangelogBatchStartingPoint.decode(elements[0]);
            int mc = ASN1Integer.decodeAsInteger(elements[1]).intValue();
            this.maxChanges = mc > 0 ? mc : 0;
            boolean waitForMax = false;
            long maxTime = 0L;
            List<Object> includeBase = Collections.emptyList();
            List<Object> excludeBase = Collections.emptyList();
            Set<ChangeType> types = Collections.unmodifiableSet(EnumSet.allOf(ChangeType.class));
            boolean continueOnMissing = false;
            String pareForDN = null;
            ChangelogBatchChangeSelectionCriteria changeCriteria = null;
            boolean includeSDMods = false;
            boolean includeSDDeletes = false;
            block23: for (int i = 2; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -128: {
                        maxTime = ASN1Long.decodeAsLong(elements[i]).longValue();
                        if (maxTime >= 0L) continue block23;
                        maxTime = 0L;
                        continue block23;
                    }
                    case -127: {
                        waitForMax = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block23;
                    }
                    case -94: {
                        ASN1Element[] includeElements = ASN1Sequence.decodeAsSequence(elements[i]).elements();
                        ArrayList<String> includeList = new ArrayList<String>(includeElements.length);
                        for (ASN1Element e : includeElements) {
                            includeList.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                        }
                        includeBase = Collections.unmodifiableList(includeList);
                        continue block23;
                    }
                    case -93: {
                        ASN1Element[] excludeElements = ASN1Sequence.decodeAsSequence(elements[i]).elements();
                        ArrayList<String> excludeList = new ArrayList<String>(excludeElements.length);
                        for (ASN1Element e : excludeElements) {
                            excludeList.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                        }
                        excludeBase = Collections.unmodifiableList(excludeList);
                        continue block23;
                    }
                    case -92: {
                        EnumSet<ChangeType> ctSet = EnumSet.noneOf(ChangeType.class);
                        block26: for (ASN1Element e : ASN1Set.decodeAsSet(elements[i]).elements()) {
                            int v = ASN1Enumerated.decodeAsEnumerated(e).intValue();
                            switch (v) {
                                case 0: {
                                    ctSet.add(ChangeType.ADD);
                                    continue block26;
                                }
                                case 1: {
                                    ctSet.add(ChangeType.DELETE);
                                    continue block26;
                                }
                                case 2: {
                                    ctSet.add(ChangeType.MODIFY);
                                    continue block26;
                                }
                                case 3: {
                                    ctSet.add(ChangeType.MODIFY_DN);
                                    continue block26;
                                }
                                default: {
                                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_REQ_VALUE_UNRECOGNIZED_CT.get(v));
                                }
                            }
                        }
                        types = Collections.unmodifiableSet(ctSet);
                        continue block23;
                    }
                    case -123: {
                        continueOnMissing = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block23;
                    }
                    case -122: {
                        pareForDN = ASN1OctetString.decodeAsOctetString(elements[i]).stringValue();
                        continue block23;
                    }
                    case -89: {
                        changeCriteria = ChangelogBatchChangeSelectionCriteria.decode(elements[i]);
                        continue block23;
                    }
                    case -120: {
                        includeSDMods = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block23;
                    }
                    case -119: {
                        includeSDDeletes = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block23;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_REQ_VALUE_UNRECOGNIZED_TYPE.get(StaticUtils.toHex(elements[i].getType())));
                    }
                }
            }
            this.entryListener = null;
            this.maxWaitTimeMillis = maxTime;
            this.waitForMaxChanges = waitForMax;
            this.includeBaseDNs = includeBase;
            this.excludeBaseDNs = excludeBase;
            this.changeTypes = types;
            this.continueOnMissingChanges = continueOnMissing;
            this.pareEntriesForUserDN = pareForDN;
            this.changeSelectionCriteria = changeCriteria;
            this.includeSoftDeletedEntryMods = includeSDMods;
            this.includeSoftDeletedEntryDeletes = includeSDDeletes;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_REQ_ERROR_DECODING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static ASN1OctetString encodeValue(ChangelogBatchStartingPoint startingPoint, int maxChanges, long maxWaitTimeMillis, boolean waitForMaxChanges, List<String> includeBaseDNs, List<String> excludeBaseDNs, Set<ChangeType> changeTypes, boolean continueOnMissingChanges, String pareEntriesForUserDN, ChangelogBatchChangeSelectionCriteria changeSelectionCriteria, boolean includeSoftDeletedEntryMods, boolean includeSoftDeletedEntryDeletes) {
        ArrayList<ASN1Element> l;
        Validator.ensureNotNull(startingPoint);
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(12);
        elements.add(startingPoint.encode());
        if (maxChanges > 0) {
            elements.add(new ASN1Integer(maxChanges));
        } else {
            elements.add(new ASN1Integer(0));
        }
        if (maxWaitTimeMillis > 0L) {
            elements.add(new ASN1Long(-128, maxWaitTimeMillis));
        }
        if (waitForMaxChanges) {
            elements.add(new ASN1Boolean(-127, true));
        }
        if (includeBaseDNs != null && !includeBaseDNs.isEmpty()) {
            l = new ArrayList<ASN1Element>(includeBaseDNs.size());
            for (String s : includeBaseDNs) {
                l.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-94, l));
        }
        if (excludeBaseDNs != null && !excludeBaseDNs.isEmpty()) {
            l = new ArrayList(excludeBaseDNs.size());
            for (String s : excludeBaseDNs) {
                l.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-93, l));
        }
        if (changeTypes != null && !changeTypes.isEmpty() && !((Object)changeTypes).equals(EnumSet.allOf(ChangeType.class))) {
            l = new ArrayList(changeTypes.size());
            for (ChangeType t : changeTypes) {
                switch (t) {
                    case ADD: {
                        l.add(new ASN1Enumerated(0));
                        break;
                    }
                    case DELETE: {
                        l.add(new ASN1Enumerated(1));
                        break;
                    }
                    case MODIFY: {
                        l.add(new ASN1Enumerated(2));
                        break;
                    }
                    case MODIFY_DN: {
                        l.add(new ASN1Enumerated(3));
                    }
                }
            }
            elements.add(new ASN1Set(-92, l));
        }
        if (continueOnMissingChanges) {
            elements.add(new ASN1Boolean(-123, true));
        }
        if (pareEntriesForUserDN != null) {
            elements.add(new ASN1OctetString(-122, pareEntriesForUserDN));
        }
        if (changeSelectionCriteria != null) {
            elements.add(changeSelectionCriteria.encode());
        }
        if (includeSoftDeletedEntryMods) {
            elements.add(new ASN1Boolean(-120, true));
        }
        if (includeSoftDeletedEntryDeletes) {
            elements.add(new ASN1Boolean(-119, true));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public ChangelogBatchStartingPoint getStartingPoint() {
        return this.startingPoint;
    }

    public int getMaxChanges() {
        return this.maxChanges;
    }

    public long getMaxWaitTimeMillis() {
        return this.maxWaitTimeMillis;
    }

    public boolean waitForMaxChanges() {
        return this.waitForMaxChanges;
    }

    public List<String> getIncludeBaseDNs() {
        return this.includeBaseDNs;
    }

    public List<String> getExcludeBaseDNs() {
        return this.excludeBaseDNs;
    }

    public Set<ChangeType> getChangeTypes() {
        return this.changeTypes;
    }

    public boolean continueOnMissingChanges() {
        return this.continueOnMissingChanges;
    }

    public String getPareEntriesForUserDN() {
        return this.pareEntriesForUserDN;
    }

    public ChangelogBatchChangeSelectionCriteria getChangeSelectionCriteria() {
        return this.changeSelectionCriteria;
    }

    public boolean includeSoftDeletedEntryMods() {
        return this.includeSoftDeletedEntryMods;
    }

    public boolean includeSoftDeletedEntryDeletes() {
        return this.includeSoftDeletedEntryDeletes;
    }

    public ChangelogEntryListener getEntryListener() {
        return this.entryListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public GetChangelogBatchExtendedResult process(LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult r;
        GetChangelogBatchIntermediateResponseListener listener;
        block6: {
            IntermediateResponseListener l = this.getIntermediateResponseListener();
            if (l != null) {
                throw new LDAPException(ResultCode.PARAM_ERROR, ExtOpMessages.ERR_GET_CHANGELOG_BATCH_REQ_IR_LISTENER_NOT_ALLOWED.get());
            }
            listener = this.entryListener == null ? new GetChangelogBatchIntermediateResponseListener(new DefaultChangelogEntryListener(this)) : new GetChangelogBatchIntermediateResponseListener(this.entryListener);
            this.setIntermediateResponseListener(listener);
            try {
                try {
                    r = super.process(connection, depth);
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    r = new ExtendedResult(this.getLastMessageID(), le.getResultCode(), le.getDiagnosticMessage(), le.getMatchedDN(), le.getReferralURLs(), null, null, le.getResponseControls());
                    Object var8_7 = null;
                    this.setIntermediateResponseListener(null);
                    break block6;
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                this.setIntermediateResponseListener(null);
                throw throwable;
            }
            this.setIntermediateResponseListener(null);
        }
        if (this.entryListener == null) {
            DefaultChangelogEntryListener defaultEntryListener = (DefaultChangelogEntryListener)listener.getEntryListener();
            return new GetChangelogBatchExtendedResult(r, defaultEntryListener.getEntryList());
        }
        return new GetChangelogBatchExtendedResult(r, listener.getEntryCount());
    }

    @Override
    public GetChangelogBatchExtendedRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public GetChangelogBatchExtendedRequest duplicate(Control[] controls) {
        GetChangelogBatchExtendedRequest r = new GetChangelogBatchExtendedRequest(this.entryListener, this.startingPoint, this.maxChanges, this.maxWaitTimeMillis, this.waitForMaxChanges, this.includeBaseDNs, this.excludeBaseDNs, this.changeTypes, this.continueOnMissingChanges, this.pareEntriesForUserDN, this.changeSelectionCriteria, this.includeSoftDeletedEntryMods, this.includeSoftDeletedEntryDeletes, controls);
        r.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
        return r;
    }

    @Override
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_GET_CHANGELOG_BATCH_REQ_NAME.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("GetChangelogBatchExtendedRequest(startingPoint=");
        this.startingPoint.toString(buffer);
        buffer.append(", maxChanges=");
        buffer.append(this.maxChanges);
        buffer.append(", maxWaitTimeMillis=");
        buffer.append(this.maxWaitTimeMillis);
        buffer.append(", waitForMaxChanges=");
        buffer.append(this.waitForMaxChanges);
        buffer.append(", includeBase={");
        Iterator<String> includeIterator = this.includeBaseDNs.iterator();
        while (includeIterator.hasNext()) {
            buffer.append('\"');
            buffer.append(includeIterator.next());
            buffer.append('\"');
            if (!includeIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, excludeBase={");
        Iterator<String> excludeIterator = this.excludeBaseDNs.iterator();
        while (excludeIterator.hasNext()) {
            buffer.append('\"');
            buffer.append(excludeIterator.next());
            buffer.append('\"');
            if (!excludeIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, changeTypes={");
        Iterator<ChangeType> typeIterator = this.changeTypes.iterator();
        while (typeIterator.hasNext()) {
            buffer.append(typeIterator.next().getName());
            if (!typeIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("}, continueOnMissingChanges=");
        buffer.append(this.continueOnMissingChanges);
        if (this.pareEntriesForUserDN != null) {
            buffer.append(", pareEntriesForUserDN='");
            buffer.append(this.pareEntriesForUserDN);
            buffer.append('\'');
        }
        if (this.changeSelectionCriteria != null) {
            buffer.append(", changeSelectionCriteria=");
            this.changeSelectionCriteria.toString(buffer);
        }
        buffer.append(", includeSoftDeletedEntryMods=");
        buffer.append(this.includeSoftDeletedEntryMods);
        buffer.append(", includeSoftDeletedEntryDeletes=");
        buffer.append(this.includeSoftDeletedEntryDeletes);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

