/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Integer;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.PasswordQualityRequirement;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetPasswordQualityRequirementsExtendedResult
extends ExtendedResult {
    public static final String OID_GET_PASSWORD_QUALITY_REQUIREMENTS_RESULT = "1.3.6.1.4.1.30221.2.6.44";
    private static final byte TYPE_CURRENT_PW_REQUIRED = -128;
    private static final byte TYPE_MUST_CHANGE_PW = -127;
    private static final byte TYPE_SECONDS_UNTIL_EXPIRATION = -126;
    private static final long serialVersionUID = -4990045432443188148L;
    private final Boolean currentPasswordRequired;
    private final Boolean mustChangePassword;
    private final Integer secondsUntilExpiration;
    private final List<PasswordQualityRequirement> passwordRequirements;

    public GetPasswordQualityRequirementsExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Collection<PasswordQualityRequirement> passwordRequirements, Boolean currentPasswordRequired, Boolean mustChangePassword, Integer secondsUntilExpiration, Control ... controls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, resultCode == ResultCode.SUCCESS ? OID_GET_PASSWORD_QUALITY_REQUIREMENTS_RESULT : null, GetPasswordQualityRequirementsExtendedResult.encodeValue(resultCode, passwordRequirements, currentPasswordRequired, mustChangePassword, secondsUntilExpiration), controls);
        this.passwordRequirements = passwordRequirements == null || passwordRequirements.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<PasswordQualityRequirement>(passwordRequirements));
        this.currentPasswordRequired = currentPasswordRequired;
        this.mustChangePassword = mustChangePassword;
        this.secondsUntilExpiration = secondsUntilExpiration;
    }

    public GetPasswordQualityRequirementsExtendedResult(ExtendedResult r) throws LDAPException {
        super(r);
        ASN1OctetString value = r.getValue();
        if (value == null) {
            this.passwordRequirements = Collections.emptyList();
            this.currentPasswordRequired = null;
            this.mustChangePassword = null;
            this.secondsUntilExpiration = null;
            return;
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            ASN1Element[] requirementElements = ASN1Sequence.decodeAsSequence(elements[0]).elements();
            ArrayList<PasswordQualityRequirement> requirementList = new ArrayList<PasswordQualityRequirement>(requirementElements.length);
            for (ASN1Element e : requirementElements) {
                requirementList.add(PasswordQualityRequirement.decode(e));
            }
            this.passwordRequirements = Collections.unmodifiableList(requirementList);
            Boolean cpr = null;
            Boolean mcp = null;
            Integer sue = null;
            block8: for (int i = 1; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -128: {
                        cpr = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block8;
                    }
                    case -127: {
                        mcp = ASN1Boolean.decodeAsBoolean(elements[i]).booleanValue();
                        continue block8;
                    }
                    case -126: {
                        sue = ASN1Integer.decodeAsInteger(elements[i]).intValue();
                        continue block8;
                    }
                }
            }
            this.currentPasswordRequired = cpr;
            this.mustChangePassword = mcp;
            this.secondsUntilExpiration = sue;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_PW_QUALITY_REQS_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static ASN1OctetString encodeValue(ResultCode resultCode, Collection<PasswordQualityRequirement> passwordRequirements, Boolean currentPasswordRequired, Boolean mustChangePassword, Integer secondsUntilExpiration) {
        if (resultCode != ResultCode.SUCCESS) {
            Validator.ensureTrue(passwordRequirements == null || passwordRequirements.isEmpty());
            Validator.ensureTrue(currentPasswordRequired == null);
            Validator.ensureTrue(mustChangePassword == null);
            Validator.ensureTrue(secondsUntilExpiration == null);
            return null;
        }
        ArrayList<ASN1Element> valueSequence = new ArrayList<ASN1Element>(4);
        if (passwordRequirements == null) {
            valueSequence.add(new ASN1Sequence());
        } else {
            ArrayList<ASN1Element> requirementElements = new ArrayList<ASN1Element>(passwordRequirements.size());
            for (PasswordQualityRequirement r : passwordRequirements) {
                requirementElements.add(r.encode());
            }
            valueSequence.add(new ASN1Sequence(requirementElements));
        }
        if (currentPasswordRequired != null) {
            valueSequence.add(new ASN1Boolean(-128, currentPasswordRequired));
        }
        if (mustChangePassword != null) {
            valueSequence.add(new ASN1Boolean(-127, mustChangePassword));
        }
        if (secondsUntilExpiration != null) {
            valueSequence.add(new ASN1Integer(-126, secondsUntilExpiration));
        }
        return new ASN1OctetString(new ASN1Sequence(valueSequence).encode());
    }

    public List<PasswordQualityRequirement> getPasswordRequirements() {
        return this.passwordRequirements;
    }

    public Boolean getCurrentPasswordRequired() {
        return this.currentPasswordRequired;
    }

    public Boolean getMustChangePassword() {
        return this.mustChangePassword;
    }

    public Integer getSecondsUntilExpiration() {
        return this.secondsUntilExpiration;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_GET_PW_QUALITY_REQS.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("GetPasswordQualityRequirementsExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        buffer.append(", requirements{");
        Iterator<PasswordQualityRequirement> requirementsIterator = this.passwordRequirements.iterator();
        while (requirementsIterator.hasNext()) {
            requirementsIterator.next().toString(buffer);
            if (!requirementsIterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append('}');
        if (this.currentPasswordRequired != null) {
            buffer.append(", currentPasswordRequired=");
            buffer.append(this.currentPasswordRequired);
        }
        if (this.mustChangePassword != null) {
            buffer.append(", mustChangePassword=");
            buffer.append(this.mustChangePassword);
        }
        if (this.secondsUntilExpiration != null) {
            buffer.append(", secondsUntilExpiration=");
            buffer.append(this.secondsUntilExpiration);
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

