/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.SupportedOTPDeliveryMechanismInfo;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class GetSupportedOTPDeliveryMechanismsExtendedResult
extends ExtendedResult {
    public static final String GET_SUPPORTED_OTP_DELIVERY_MECHANISMS_RESULT_OID = "1.3.6.1.4.1.30221.2.6.48";
    private static final byte TYPE_DELIVERY_MECHANISM = -128;
    private static final byte TYPE_IS_SUPPORTED = -127;
    private static final byte TYPE_RECIPIENT_ID = -126;
    private static final long serialVersionUID = -1811121368502797059L;
    private final List<SupportedOTPDeliveryMechanismInfo> deliveryMechanismInfo;

    public GetSupportedOTPDeliveryMechanismsExtendedResult(ExtendedResult result) throws LDAPException {
        super(result);
        ASN1OctetString value = result.getValue();
        if (value == null) {
            this.deliveryMechanismInfo = Collections.emptyList();
        } else {
            try {
                ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
                ArrayList<SupportedOTPDeliveryMechanismInfo> mechInfo = new ArrayList<SupportedOTPDeliveryMechanismInfo>(elements.length);
                for (ASN1Element e : elements) {
                    ASN1Element[] infoElements = ASN1Sequence.decodeAsSequence(e).elements();
                    String name = ASN1OctetString.decodeAsOctetString(infoElements[0]).stringValue();
                    Boolean isSupported = null;
                    String recipientID = null;
                    block8: for (int i = 1; i < infoElements.length; ++i) {
                        switch (infoElements[i].getType()) {
                            case -127: {
                                isSupported = ASN1Boolean.decodeAsBoolean(infoElements[i]).booleanValue();
                                continue block8;
                            }
                            case -126: {
                                recipientID = ASN1OctetString.decodeAsOctetString(infoElements[i]).stringValue();
                                continue block8;
                            }
                            default: {
                                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_SUPPORTED_OTP_MECH_RESULT_UNKNOWN_ELEMENT.get(StaticUtils.toHex(infoElements[i].getType())));
                            }
                        }
                    }
                    mechInfo.add(new SupportedOTPDeliveryMechanismInfo(name, isSupported, recipientID));
                }
                this.deliveryMechanismInfo = Collections.unmodifiableList(mechInfo);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                throw le;
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_GET_SUPPORTED_OTP_MECH_RESULT_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
    }

    public GetSupportedOTPDeliveryMechanismsExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Collection<SupportedOTPDeliveryMechanismInfo> deliveryMechanismInfo, Control ... controls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, resultCode == ResultCode.SUCCESS ? GET_SUPPORTED_OTP_DELIVERY_MECHANISMS_RESULT_OID : null, GetSupportedOTPDeliveryMechanismsExtendedResult.encodeValue(resultCode, deliveryMechanismInfo), controls);
        this.deliveryMechanismInfo = deliveryMechanismInfo == null || deliveryMechanismInfo.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<SupportedOTPDeliveryMechanismInfo>(deliveryMechanismInfo));
    }

    private static ASN1OctetString encodeValue(ResultCode resultCode, Collection<SupportedOTPDeliveryMechanismInfo> deliveryMechanismInfo) {
        if (resultCode != ResultCode.SUCCESS) {
            return null;
        }
        if (deliveryMechanismInfo == null || deliveryMechanismInfo.isEmpty()) {
            return new ASN1OctetString(new ASN1Sequence().encode());
        }
        ArrayList<ASN1Sequence> elements = new ArrayList<ASN1Sequence>(deliveryMechanismInfo.size());
        for (SupportedOTPDeliveryMechanismInfo i : deliveryMechanismInfo) {
            ArrayList<ASN1Element> infoElements = new ArrayList<ASN1Element>(3);
            infoElements.add(new ASN1OctetString(-128, i.getDeliveryMechanism()));
            if (i.isSupported() != null) {
                infoElements.add(new ASN1Boolean(-127, i.isSupported()));
            }
            if (i.getRecipientID() != null) {
                infoElements.add(new ASN1OctetString(-126, i.getRecipientID()));
            }
            elements.add(new ASN1Sequence(infoElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public List<SupportedOTPDeliveryMechanismInfo> getDeliveryMechanismInfo() {
        return this.deliveryMechanismInfo;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_GET_SUPPORTED_OTP_MECH_RES_NAME.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        buffer.append("GetSupportedOTPDeliveryMechanismsExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        buffer.append("mechanismInfo={");
        Iterator<SupportedOTPDeliveryMechanismInfo> mechIterator = this.deliveryMechanismInfo.iterator();
        while (mechIterator.hasNext()) {
            mechIterator.next().toString(buffer);
            if (!mechIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        String diagnosticMessage = this.getDiagnosticMessage();
        if (diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

