/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ListConfigurationsExtendedResult
extends ExtendedResult {
    public static final String LIST_CONFIGS_RESULT_OID = "1.3.6.1.4.1.30221.2.6.27";
    private static final byte TYPE_ACTIVE_CONFIG_FILE_NAME = -128;
    private static final byte TYPE_BASELINE_CONFIG_FILE_NAMES = -95;
    private static final byte TYPE_ARCHIVED_CONFIG_FILE_NAMES = -94;
    private static final long serialVersionUID = -466738484294922561L;
    private final List<String> archivedFileNames;
    private final List<String> baselineFileNames;
    private final String activeFileName;

    public ListConfigurationsExtendedResult(ExtendedResult result) throws LDAPException {
        super(result);
        ASN1OctetString value = result.getValue();
        if (value == null) {
            this.activeFileName = null;
            this.baselineFileNames = Collections.emptyList();
            this.archivedFileNames = Collections.emptyList();
            return;
        }
        try {
            ASN1Element[] elements;
            String activeName = null;
            List<Object> archivedNames = Collections.emptyList();
            ArrayList<String> baselineNames = null;
            block8: for (ASN1Element e : elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements()) {
                switch (e.getType()) {
                    case -128: {
                        activeName = ASN1OctetString.decodeAsOctetString(e).stringValue();
                        continue block8;
                    }
                    case -95: {
                        ASN1Element[] baselineNameElements = ASN1Sequence.decodeAsSequence(e).elements();
                        baselineNames = new ArrayList<String>(baselineNameElements.length);
                        for (ASN1Element el : baselineNameElements) {
                            baselineNames.add(ASN1OctetString.decodeAsOctetString(el).stringValue());
                        }
                        archivedNames = Collections.unmodifiableList(baselineNames);
                        continue block8;
                    }
                    case -94: {
                        ASN1Element[] archivedNameElements = ASN1Sequence.decodeAsSequence(e).elements();
                        archivedNames = new ArrayList(archivedNameElements.length);
                        for (ASN1Element el : archivedNameElements) {
                            archivedNames.add(ASN1OctetString.decodeAsOctetString(el).stringValue());
                        }
                        archivedNames = Collections.unmodifiableList(archivedNames);
                        continue block8;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_LIST_CONFIGS_RESULT_UNEXPECTED_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
            this.activeFileName = activeName;
            this.archivedFileNames = archivedNames;
            this.baselineFileNames = baselineNames;
            if (this.activeFileName == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_LIST_CONFIGS_RESULT_NO_ACTIVE_CONFIG.get());
            }
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_LIST_CONFIGS_RESULT_ERROR_PARSING_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public ListConfigurationsExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, String activeFileName, Collection<String> baselineFileNames, Collection<String> archivedFileNames, Control ... responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, activeFileName == null ? null : LIST_CONFIGS_RESULT_OID, ListConfigurationsExtendedResult.encodeValue(activeFileName, baselineFileNames, archivedFileNames), responseControls);
        this.activeFileName = activeFileName;
        this.baselineFileNames = baselineFileNames == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(baselineFileNames));
        this.archivedFileNames = archivedFileNames == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<String>(archivedFileNames));
    }

    public static ASN1OctetString encodeValue(String activeFileName, Collection<String> baselineFileNames, Collection<String> archivedFileNames) {
        if (activeFileName == null) {
            Validator.ensureTrue(baselineFileNames == null || baselineFileNames.isEmpty(), "The baseline filename must be null if the active filename is null");
            Validator.ensureTrue(archivedFileNames == null || archivedFileNames.isEmpty(), "The archived filenames must be null or empty if the active filename is null");
            return null;
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(3);
        elements.add(new ASN1OctetString(-128, activeFileName));
        if (baselineFileNames != null && !baselineFileNames.isEmpty()) {
            TreeSet<String> sortedBaselineNames = new TreeSet<String>(baselineFileNames);
            ArrayList<ASN1OctetString> baselineNameElements = new ArrayList<ASN1OctetString>(sortedBaselineNames.size());
            for (String s : sortedBaselineNames) {
                baselineNameElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-95, baselineNameElements));
        }
        if (archivedFileNames != null && !archivedFileNames.isEmpty()) {
            TreeSet<String> sortedArchivedNames = new TreeSet<String>(archivedFileNames);
            ArrayList<ASN1OctetString> archivedNameElements = new ArrayList<ASN1OctetString>(sortedArchivedNames.size());
            for (String s : sortedArchivedNames) {
                archivedNameElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-94, archivedNameElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public String getActiveFileName() {
        return this.activeFileName;
    }

    public List<String> getBaselineFileNames() {
        return this.baselineFileNames;
    }

    public List<String> getArchivedFileNames() {
        return this.archivedFileNames;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_LIST_CONFIGS.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        Iterator<String> iterator;
        buffer.append("ListConfigurationsExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if (this.activeFileName != null) {
            buffer.append(", activeFileName='");
            buffer.append(this.activeFileName);
            buffer.append('\'');
        }
        if (!this.baselineFileNames.isEmpty()) {
            buffer.append(", baselineFileNames={");
            iterator = this.baselineFileNames.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        if (!this.archivedFileNames.isEmpty()) {
            buffer.append(", archivedFileNames={");
            iterator = this.archivedFileNames.iterator();
            while (iterator.hasNext()) {
                buffer.append('\'');
                buffer.append(iterator.next());
                buffer.append('\'');
                if (!iterator.hasNext()) continue;
                buffer.append(',');
            }
            buffer.append('}');
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

