/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.NotificationDestinationDetails;
import com.unboundid.ldap.sdk.unboundidds.extensions.NotificationSubscriptionDetails;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ListNotificationSubscriptionsExtendedResult
extends ExtendedResult {
    public static final String LIST_NOTIFICATION_SUBSCRIPTIONS_RESULT_OID = "1.3.6.1.4.1.30221.2.6.41";
    private static final long serialVersionUID = 8876370324325619149L;
    private final List<NotificationDestinationDetails> destinations;

    public ListNotificationSubscriptionsExtendedResult(ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1OctetString value = extendedResult.getValue();
        if (value == null) {
            this.destinations = Collections.emptyList();
            return;
        }
        try {
            ASN1Element[] destsElements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            ArrayList<NotificationDestinationDetails> destList = new ArrayList<NotificationDestinationDetails>(destsElements.length);
            for (ASN1Element destElement : destsElements) {
                ASN1Element[] destElements = ASN1Sequence.decodeAsSequence(destElement).elements();
                String destID = ASN1OctetString.decodeAsOctetString(destElements[0]).stringValue();
                ASN1Element[] destDetailsElements = ASN1Sequence.decodeAsSequence(destElements[1]).elements();
                ArrayList<ASN1OctetString> destDetailsList = new ArrayList<ASN1OctetString>(destDetailsElements.length);
                for (ASN1Element e : destDetailsElements) {
                    destDetailsList.add(ASN1OctetString.decodeAsOctetString(e));
                }
                ASN1Element[] subElements = ASN1Sequence.decodeAsSequence(destElements[2]).elements();
                ArrayList<NotificationSubscriptionDetails> subscriptions = new ArrayList<NotificationSubscriptionDetails>(subElements.length);
                for (ASN1Element e : subElements) {
                    ASN1Element[] sElements = ASN1Sequence.decodeAsSequence(e).elements();
                    String subID = ASN1OctetString.decodeAsOctetString(sElements[0]).stringValue();
                    ASN1Element[] subDetailsElements = ASN1Sequence.decodeAsSequence(sElements[1]).elements();
                    ArrayList<ASN1OctetString> subDetails = new ArrayList<ASN1OctetString>(subDetailsElements.length);
                    for (ASN1Element sde : subDetailsElements) {
                        subDetails.add(ASN1OctetString.decodeAsOctetString(sde));
                    }
                    subscriptions.add(new NotificationSubscriptionDetails(subID, subDetails));
                }
                destList.add(new NotificationDestinationDetails(destID, destDetailsList, subscriptions));
            }
            this.destinations = Collections.unmodifiableList(destList);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_LIST_NOTIFICATION_SUBS_RESULT_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public ListNotificationSubscriptionsExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, Collection<NotificationDestinationDetails> destinations, Control ... controls) throws LDAPException {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, LIST_NOTIFICATION_SUBSCRIPTIONS_RESULT_OID, ListNotificationSubscriptionsExtendedResult.encodeValue(destinations), controls);
        this.destinations = destinations == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<NotificationDestinationDetails>(destinations));
    }

    private static ASN1OctetString encodeValue(Collection<NotificationDestinationDetails> destinations) {
        if (destinations == null || destinations.isEmpty()) {
            return null;
        }
        ArrayList<ASN1Sequence> elements = new ArrayList<ASN1Sequence>(destinations.size());
        for (NotificationDestinationDetails destDetails : destinations) {
            ArrayList<ASN1Element> destElements = new ArrayList<ASN1Element>(3);
            destElements.add(new ASN1OctetString(destDetails.getID()));
            destElements.add(new ASN1Sequence(destDetails.getDetails()));
            ArrayList<ASN1Sequence> subElements = new ArrayList<ASN1Sequence>(destDetails.getSubscriptions().size());
            for (NotificationSubscriptionDetails subDetails : destDetails.getSubscriptions()) {
                subElements.add(new ASN1Sequence(new ASN1OctetString(subDetails.getID()), new ASN1Sequence(subDetails.getDetails())));
            }
            destElements.add(new ASN1Sequence(subElements));
            elements.add(new ASN1Sequence(destElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public List<NotificationDestinationDetails> getDestinations() {
        return this.destinations;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_LIST_NOTIFICATION_SUBS.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        buffer.append("ListNotificationSubscriptionsExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        buffer.append(", notificationDestinations={");
        Iterator<NotificationDestinationDetails> destIterator = this.destinations.iterator();
        while (destIterator.hasNext()) {
            destIterator.next().toString(buffer);
            if (!destIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append('}');
        String diagnosticMessage = this.getDiagnosticMessage();
        if (diagnosticMessage != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

