/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MissingChangelogEntriesIntermediateResponse
extends IntermediateResponse {
    public static final String MISSING_CHANGELOG_ENTRIES_INTERMEDIATE_RESPONSE_OID = "1.3.6.1.4.1.30221.2.6.12";
    private static final byte TYPE_MESSAGE = -128;
    private static final long serialVersionUID = -4961560327295588578L;
    private final String message;

    public MissingChangelogEntriesIntermediateResponse(String message, Control ... controls) {
        super(MISSING_CHANGELOG_ENTRIES_INTERMEDIATE_RESPONSE_OID, MissingChangelogEntriesIntermediateResponse.encodeValue(message), controls);
        this.message = message;
    }

    public MissingChangelogEntriesIntermediateResponse(IntermediateResponse r) throws LDAPException {
        super(r);
        ASN1Sequence valueSequence;
        ASN1OctetString value = r.getValue();
        if (value == null) {
            this.message = null;
            return;
        }
        try {
            valueSequence = ASN1Sequence.decodeAsSequence(value.getValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_MISSING_CHANGELOG_ENTRIES_IR_VALUE_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        String msg = null;
        block5: for (ASN1Element e : valueSequence.elements()) {
            byte type = e.getType();
            switch (type) {
                case -128: {
                    msg = ASN1OctetString.decodeAsOctetString(e).stringValue();
                    continue block5;
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_MISSING_CHANGELOG_ENTRIES_IR_UNEXPECTED_VALUE_TYPE.get(StaticUtils.toHex(type)));
                }
            }
        }
        this.message = msg;
    }

    private static ASN1OctetString encodeValue(String message) {
        if (message == null) {
            return null;
        }
        ASN1Sequence valueSequence = new ASN1Sequence(new ASN1OctetString(-128, message));
        return new ASN1OctetString(valueSequence.encode());
    }

    public String getMessage() {
        return this.message;
    }

    public String getIntermediateResponseName() {
        return ExtOpMessages.INFO_MISSING_CHANGELOG_ENTRIES_IR_NAME.get();
    }

    public String valueToString() {
        if (this.message == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("message='");
        buffer.append(this.message);
        buffer.append('\'');
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        Control[] controls;
        buffer.append("MissingChangelogEntriesIntermediateResponse(");
        boolean appended = false;
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append("messageID=");
            buffer.append(messageID);
            appended = true;
        }
        if (this.message != null) {
            if (appended) {
                buffer.append(", ");
            }
            buffer.append("message='");
            buffer.append(this.message);
            buffer.append('\'');
            appended = true;
        }
        if ((controls = this.getControls()).length > 0) {
            if (appended) {
                buffer.append(", ");
            }
            buffer.append("controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

