/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ChangelogBatchChangeSelectionCriteria;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NotificationDestinationChangeSelectionCriteria
extends ChangelogBatchChangeSelectionCriteria {
    static final byte TYPE_SELECTION_CRITERIA_NOTIFICATION_DESTINATION = -124;
    private final String destinationEntryUUID;

    public NotificationDestinationChangeSelectionCriteria(String destinationEntryUUID) {
        Validator.ensureNotNull(destinationEntryUUID);
        this.destinationEntryUUID = destinationEntryUUID;
    }

    static NotificationDestinationChangeSelectionCriteria decodeInnerElement(ASN1Element innerElement) throws LDAPException {
        try {
            return new NotificationDestinationChangeSelectionCriteria(ASN1OctetString.decodeAsOctetString(innerElement).stringValue());
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_NOT_DEST_CHANGE_SELECTION_CRITERIA_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getDestinationEntryUUID() {
        return this.destinationEntryUUID;
    }

    public ASN1Element encodeInnerElement() {
        return new ASN1OctetString(-124, this.destinationEntryUUID);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("NotificationDestinationChangeSelectionCriteria(destinationEntryUUID='");
        buffer.append(this.destinationEntryUUID);
        buffer.append("')");
    }
}

