/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class NotificationSubscriptionDetails
implements Serializable {
    private static final long serialVersionUID = 7883889980556267057L;
    private final List<ASN1OctetString> details;
    private final String id;

    public NotificationSubscriptionDetails(String id, Collection<ASN1OctetString> details) {
        Validator.ensureNotNull(id);
        Validator.ensureNotNull(details);
        Validator.ensureFalse(details.isEmpty());
        this.id = id;
        this.details = Collections.unmodifiableList(new ArrayList<ASN1OctetString>(details));
    }

    public String getID() {
        return this.id;
    }

    public List<ASN1OctetString> getDetails() {
        return this.details;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("NotificationSubscription(id='");
        buffer.append(this.id);
        buffer.append("')");
    }
}

