/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class StartInteractiveTransactionExtendedResult
extends ExtendedResult {
    private static final byte TYPE_TXN_ID = -128;
    private static final byte TYPE_BASE_DNS = -95;
    private static final long serialVersionUID = 4010094216900393866L;
    private final ASN1OctetString transactionID;
    private final List<String> baseDNs;

    public StartInteractiveTransactionExtendedResult(ExtendedResult extendedResult) throws LDAPException {
        super(extendedResult);
        ASN1Sequence valueSequence;
        if (!extendedResult.hasValue()) {
            this.transactionID = null;
            this.baseDNs = null;
            return;
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(extendedResult.getValue().getValue());
            valueSequence = ASN1Sequence.decodeAsSequence(valueElement);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_INT_TXN_RESULT_VALUE_NOT_SEQUENCE.get(e.getMessage()), e);
        }
        ASN1OctetString txnID = null;
        List baseDNList = null;
        block8: for (ASN1Element element : valueSequence.elements()) {
            switch (element.getType()) {
                case -128: {
                    txnID = ASN1OctetString.decodeAsOctetString(element);
                    continue block8;
                }
                case -95: {
                    try {
                        ASN1Sequence baseDNsSequence = ASN1Sequence.decodeAsSequence(element);
                        ArrayList<String> dnList = new ArrayList<String>(baseDNsSequence.elements().length);
                        for (ASN1Element e : baseDNsSequence.elements()) {
                            dnList.add(ASN1OctetString.decodeAsOctetString(e).stringValue());
                        }
                        baseDNList = Collections.unmodifiableList(dnList);
                        continue block8;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_INT_TXN_RESULT_BASE_DNS_NOT_SEQUENCE.get(e.getMessage()), e);
                    }
                }
                default: {
                    throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_INT_TXN_RESULT_INVALID_ELEMENT.get(StaticUtils.toHex(element.getType())));
                }
            }
        }
        this.transactionID = txnID;
        this.baseDNs = baseDNList;
        if (this.transactionID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_START_INT_TXN_RESULT_NO_TXN_ID.get());
        }
    }

    public StartInteractiveTransactionExtendedResult(int messageID, ResultCode resultCode, String diagnosticMessage, String matchedDN, String[] referralURLs, ASN1OctetString transactionID, List<String> baseDNs, Control[] responseControls) {
        super(messageID, resultCode, diagnosticMessage, matchedDN, referralURLs, null, StartInteractiveTransactionExtendedResult.encodeValue(transactionID, baseDNs), responseControls);
        this.transactionID = transactionID;
        this.baseDNs = baseDNs == null ? null : Collections.unmodifiableList(new ArrayList<String>(baseDNs));
    }

    private static ASN1OctetString encodeValue(ASN1OctetString transactionID, List<String> baseDNs) {
        if (transactionID == null && baseDNs == null) {
            return null;
        }
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        if (transactionID != null) {
            elements.add(new ASN1OctetString(-128, transactionID.getValue()));
        }
        if (baseDNs != null && !baseDNs.isEmpty()) {
            ArrayList<ASN1OctetString> baseDNElements = new ArrayList<ASN1OctetString>(baseDNs.size());
            for (String s : baseDNs) {
                baseDNElements.add(new ASN1OctetString(s));
            }
            elements.add(new ASN1Sequence(-95, baseDNElements));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    public List<String> getBaseDNs() {
        return this.baseDNs;
    }

    @Override
    public String getExtendedResultName() {
        return ExtOpMessages.INFO_EXTENDED_RESULT_NAME_START_INTERACTIVE_TXN.get();
    }

    @Override
    public void toString(StringBuilder buffer) {
        Control[] responseControls;
        String[] referralURLs;
        String matchedDN;
        String diagnosticMessage;
        buffer.append("StartInteractiveTransactionExtendedResult(resultCode=");
        buffer.append(this.getResultCode());
        int messageID = this.getMessageID();
        if (messageID >= 0) {
            buffer.append(", messageID=");
            buffer.append(messageID);
        }
        if (this.transactionID != null) {
            buffer.append(", transactionID='");
            buffer.append(this.transactionID.stringValue());
            buffer.append('\'');
        }
        if (this.baseDNs != null) {
            buffer.append(", baseDNs={");
            for (int i = 0; i < this.baseDNs.size(); ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(this.baseDNs.get(i));
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((diagnosticMessage = this.getDiagnosticMessage()) != null) {
            buffer.append(", diagnosticMessage='");
            buffer.append(diagnosticMessage);
            buffer.append('\'');
        }
        if ((matchedDN = this.getMatchedDN()) != null) {
            buffer.append(", matchedDN='");
            buffer.append(matchedDN);
            buffer.append('\'');
        }
        if ((referralURLs = this.getReferralURLs()).length > 0) {
            buffer.append(", referralURLs={");
            for (int i = 0; i < referralURLs.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(referralURLs[i]);
                buffer.append('\'');
            }
            buffer.append('}');
        }
        if ((responseControls = this.getResponseControls()).length > 0) {
            buffer.append(", responseControls={");
            for (int i = 0; i < responseControls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(responseControls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

