/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.ANDJSONObjectFilter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.ContainsFieldJSONObjectFilter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.EqualsAnyJSONObjectFilter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.EqualsJSONObjectFilter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.GreaterThanJSONObjectFilter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JFMessages;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.LessThanJSONObjectFilter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.NegateJSONObjectFilter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.ORJSONObjectFilter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.ObjectMatchesJSONObjectFilter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.RegularExpressionJSONObjectFilter;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.SubstringJSONObjectFilter;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_NOT_THREADSAFE)
public abstract class JSONObjectFilter
implements Serializable {
    public static final String JSON_OBJECT_FILTER_MATCHING_RULE_NAME = "jsonObjectFilterExtensibleMatch";
    public static final String JSON_OBJECT_FILTER_MATCHING_RULE_OID = "1.3.6.1.4.1.30221.2.4.13";
    public static final String FIELD_FILTER_TYPE = "filterType";
    private static final ConcurrentHashMap<String, JSONObjectFilter> FILTER_TYPES = new ConcurrentHashMap(10);
    private static final long serialVersionUID = -551616596693584562L;

    public abstract String getFilterType();

    protected abstract Set<String> getRequiredFieldNames();

    protected abstract Set<String> getOptionalFieldNames();

    public abstract boolean matchesJSONObject(JSONObject var1);

    public abstract JSONObject toJSONObject();

    protected List<String> getStrings(JSONObject o, String fieldName, boolean allowEmpty, List<String> defaultValues) throws JSONException {
        JSONValue v = o.getField(fieldName);
        if (v == null) {
            if (defaultValues == null) {
                throw new JSONException(JFMessages.ERR_OBJECT_FILTER_MISSING_REQUIRED_FIELD.get(String.valueOf(o), this.getFilterType(), fieldName));
            }
            return defaultValues;
        }
        if (v instanceof JSONString) {
            return Arrays.asList(((JSONString)v).stringValue());
        }
        if (v instanceof JSONArray) {
            List<JSONValue> values = ((JSONArray)v).getValues();
            if (values.isEmpty()) {
                if (allowEmpty) {
                    return Collections.emptyList();
                }
                throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_EMPTY_ARRAY.get(String.valueOf(o), this.getFilterType(), fieldName));
            }
            ArrayList<String> valueList = new ArrayList<String>(values.size());
            for (JSONValue av : values) {
                if (av instanceof JSONString) {
                    valueList.add(((JSONString)av).stringValue());
                    continue;
                }
                throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_NOT_STRINGS.get(String.valueOf(o), this.getFilterType(), fieldName));
            }
            return valueList;
        }
        throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_NOT_STRINGS.get(String.valueOf(o), this.getFilterType(), fieldName));
    }

    protected String getString(JSONObject o, String fieldName, String defaultValue, boolean required) throws JSONException {
        JSONValue v = o.getField(fieldName);
        if (v == null) {
            if (required && defaultValue == null) {
                throw new JSONException(JFMessages.ERR_OBJECT_FILTER_MISSING_REQUIRED_FIELD.get(String.valueOf(o), this.getFilterType(), fieldName));
            }
            return defaultValue;
        }
        if (v instanceof JSONString) {
            return ((JSONString)v).stringValue();
        }
        throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_NOT_STRING.get(String.valueOf(o), this.getFilterType(), fieldName));
    }

    protected boolean getBoolean(JSONObject o, String fieldName, Boolean defaultValue) throws JSONException {
        JSONValue v = o.getField(fieldName);
        if (v == null) {
            if (defaultValue == null) {
                throw new JSONException(JFMessages.ERR_OBJECT_FILTER_MISSING_REQUIRED_FIELD.get(String.valueOf(o), this.getFilterType(), fieldName));
            }
            return defaultValue;
        }
        if (v instanceof JSONBoolean) {
            return ((JSONBoolean)v).booleanValue();
        }
        throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_NOT_BOOLEAN.get(String.valueOf(o), this.getFilterType(), fieldName));
    }

    protected List<JSONObjectFilter> getFilters(JSONObject o, String fieldName) throws JSONException {
        JSONValue value = o.getField(fieldName);
        if (value == null) {
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_MISSING_REQUIRED_FIELD.get(String.valueOf(o), this.getFilterType(), fieldName));
        }
        if (!(value instanceof JSONArray)) {
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_VALUE_NOT_ARRAY.get(String.valueOf(o), this.getFilterType(), fieldName));
        }
        List<JSONValue> values = ((JSONArray)value).getValues();
        ArrayList<JSONObjectFilter> filterList = new ArrayList<JSONObjectFilter>(values.size());
        for (JSONValue arrayValue : values) {
            if (!(arrayValue instanceof JSONObject)) {
                throw new JSONException(JFMessages.ERR_OBJECT_FILTER_ARRAY_ELEMENT_NOT_OBJECT.get(String.valueOf(o), this.getFilterType(), fieldName));
            }
            JSONObject filterObject = (JSONObject)arrayValue;
            try {
                filterList.add(JSONObjectFilter.decode(filterObject));
            }
            catch (JSONException e) {
                Debug.debugException(e);
                throw new JSONException(JFMessages.ERR_OBJECT_FILTER_ARRAY_ELEMENT_NOT_FILTER.get(String.valueOf(o), this.getFilterType(), String.valueOf(filterObject), fieldName, e.getMessage()), e);
            }
        }
        return filterList;
    }

    protected static List<JSONValue> getValues(JSONObject o, List<String> fieldName) {
        ArrayList<JSONValue> values = new ArrayList<JSONValue>(10);
        JSONObjectFilter.getValues(o, fieldName, 0, values);
        return values;
    }

    private static void getValues(JSONObject o, List<String> fieldName, int fieldNameIndex, List<JSONValue> values) {
        JSONValue v = o.getField(fieldName.get(fieldNameIndex));
        if (v == null) {
            return;
        }
        int nextIndex = fieldNameIndex + 1;
        if (nextIndex < fieldName.size()) {
            if (v instanceof JSONObject) {
                JSONObjectFilter.getValues((JSONObject)v, fieldName, nextIndex, values);
            } else if (v instanceof JSONArray) {
                JSONObjectFilter.getValuesFromArray((JSONArray)v, fieldName, nextIndex, values);
            }
            return;
        }
        values.add(v);
    }

    private static void getValuesFromArray(JSONArray a, List<String> fieldName, int fieldNameIndex, List<JSONValue> values) {
        for (JSONValue v : a.getValues()) {
            if (v instanceof JSONObject) {
                JSONObjectFilter.getValues((JSONObject)v, fieldName, fieldNameIndex, values);
                continue;
            }
            if (!(v instanceof JSONArray)) continue;
            JSONObjectFilter.getValuesFromArray((JSONArray)v, fieldName, fieldNameIndex, values);
        }
    }

    public static JSONObjectFilter decode(JSONObject o) throws JSONException {
        JSONValue filterTypeValue = o.getField(FIELD_FILTER_TYPE);
        if (filterTypeValue == null) {
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_MISSING_FILTER_TYPE.get(String.valueOf(o), FIELD_FILTER_TYPE));
        }
        if (!(filterTypeValue instanceof JSONString)) {
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_INVALID_FILTER_TYPE.get(String.valueOf(o), FIELD_FILTER_TYPE));
        }
        String filterType = StaticUtils.toLowerCase(((JSONString)filterTypeValue).stringValue());
        JSONObjectFilter decoder = FILTER_TYPES.get(filterType);
        if (decoder == null) {
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_INVALID_FILTER_TYPE.get(String.valueOf(o), FIELD_FILTER_TYPE));
        }
        HashSet<String> objectFields = new HashSet<String>(o.getFields().keySet());
        objectFields.remove(FIELD_FILTER_TYPE);
        for (String requiredField : decoder.getRequiredFieldNames()) {
            if (objectFields.remove(requiredField)) continue;
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_MISSING_REQUIRED_FIELD.get(String.valueOf(o), decoder.getFilterType(), requiredField));
        }
        for (String remainingField : objectFields) {
            if (decoder.getOptionalFieldNames().contains(remainingField)) continue;
            throw new JSONException(JFMessages.ERR_OBJECT_FILTER_UNRECOGNIZED_FIELD.get(String.valueOf(o), decoder.getFilterType(), remainingField));
        }
        return decoder.decodeFilter(o);
    }

    protected abstract JSONObjectFilter decodeFilter(JSONObject var1) throws JSONException;

    protected static void registerFilterType(JSONObjectFilter ... impl) {
        for (JSONObjectFilter f : impl) {
            String filterTypeName = StaticUtils.toLowerCase(f.getFilterType());
            FILTER_TYPES.put(filterTypeName, f);
        }
    }

    public final Filter toLDAPFilter(String attributeDescription) {
        return Filter.createExtensibleMatchFilter(attributeDescription, JSON_OBJECT_FILTER_MATCHING_RULE_NAME, false, this.toString());
    }

    public final int hashCode() {
        return this.toJSONObject().hashCode();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JSONObjectFilter) {
            JSONObjectFilter f = (JSONObjectFilter)o;
            return this.toJSONObject().equals(f.toJSONObject());
        }
        return false;
    }

    public final String toString() {
        return this.toJSONObject().toString();
    }

    public final void toString(StringBuilder buffer) {
        this.toJSONObject().toString(buffer);
    }

    static {
        JSONObjectFilter.registerFilterType(new ContainsFieldJSONObjectFilter(), new EqualsJSONObjectFilter(), new EqualsAnyJSONObjectFilter(), new ObjectMatchesJSONObjectFilter(), new SubstringJSONObjectFilter(), new GreaterThanJSONObjectFilter(), new LessThanJSONObjectFilter(), new RegularExpressionJSONObjectFilter(), new ANDJSONObjectFilter(new JSONObjectFilter[0]), new ORJSONObjectFilter(new JSONObjectFilter[0]), new NegateJSONObjectFilter());
    }
}

