/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JFMessages;
import com.unboundid.ldap.sdk.unboundidds.jsonfilter.JSONObjectFilter;
import com.unboundid.util.Mutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class SubstringJSONObjectFilter
extends JSONObjectFilter {
    public static final String FILTER_TYPE = "substring";
    public static final String FIELD_FIELD_PATH = "field";
    public static final String FIELD_STARTS_WITH = "startsWith";
    public static final String FIELD_CONTAINS = "contains";
    public static final String FIELD_ENDS_WITH = "endsWith";
    public static final String FIELD_CASE_SENSITIVE = "caseSensitive";
    private static final Set<String> REQUIRED_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("field")));
    private static final Set<String> OPTIONAL_FIELD_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("startsWith", "contains", "endsWith", "caseSensitive")));
    private static final long serialVersionUID = 811514243548895420L;
    private volatile boolean caseSensitive;
    private volatile int minLength;
    private volatile List<String> contains;
    private volatile List<String> matchContains;
    private volatile List<String> field;
    private volatile String endsWith;
    private volatile String matchEndsWith;
    private volatile String matchStartsWith;
    private volatile String startsWith;

    SubstringJSONObjectFilter() {
        this.field = null;
        this.startsWith = null;
        this.contains = null;
        this.endsWith = null;
        this.caseSensitive = false;
        this.minLength = 0;
        this.matchStartsWith = null;
        this.matchContains = null;
        this.matchEndsWith = null;
    }

    private SubstringJSONObjectFilter(List<String> field, String startsWith, List<String> contains, String endsWith, boolean caseSensitive) {
        this.field = field;
        this.caseSensitive = caseSensitive;
        this.setSubstringComponents(startsWith, contains, endsWith);
    }

    public SubstringJSONObjectFilter(String field, String startsWith, String contains, String endsWith) {
        this(Collections.singletonList(field), startsWith, contains == null ? null : Collections.singletonList(contains), endsWith);
    }

    public SubstringJSONObjectFilter(List<String> field, String startsWith, List<String> contains, String endsWith) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
        this.caseSensitive = false;
        this.setSubstringComponents(startsWith, contains, endsWith);
    }

    public List<String> getField() {
        return this.field;
    }

    public void setField(String ... field) {
        this.setField(StaticUtils.toList(field));
    }

    public void setField(List<String> field) {
        Validator.ensureNotNull(field);
        Validator.ensureFalse(field.isEmpty());
        this.field = Collections.unmodifiableList(new ArrayList<String>(field));
    }

    public String getStartsWith() {
        return this.startsWith;
    }

    public List<String> getContains() {
        return this.contains;
    }

    public String getEndsWith() {
        return this.endsWith;
    }

    public void setSubstringComponents(String startsWith, String contains, String endsWith) {
        this.setSubstringComponents(startsWith, contains == null ? null : Collections.singletonList(contains), endsWith);
    }

    public void setSubstringComponents(String startsWith, List<String> contains, String endsWith) {
        Validator.ensureFalse(startsWith == null && contains == null && endsWith == null);
        this.minLength = 0;
        this.startsWith = startsWith;
        if (startsWith != null) {
            this.minLength += startsWith.length();
            this.matchStartsWith = this.caseSensitive ? startsWith : StaticUtils.toLowerCase(startsWith);
        }
        if (contains == null) {
            this.contains = Collections.emptyList();
            this.matchContains = this.contains;
        } else {
            this.contains = Collections.unmodifiableList(new ArrayList<String>(contains));
            ArrayList<String> mcList = new ArrayList<String>(contains.size());
            for (String s : contains) {
                this.minLength += s.length();
                if (this.caseSensitive) {
                    mcList.add(s);
                    continue;
                }
                mcList.add(StaticUtils.toLowerCase(s));
            }
            this.matchContains = Collections.unmodifiableList(mcList);
        }
        this.endsWith = endsWith;
        if (endsWith != null) {
            this.minLength += endsWith.length();
            this.matchEndsWith = this.caseSensitive ? endsWith : StaticUtils.toLowerCase(endsWith);
        }
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.setSubstringComponents(this.startsWith, this.contains, this.endsWith);
    }

    @Override
    public String getFilterType() {
        return FILTER_TYPE;
    }

    @Override
    protected Set<String> getRequiredFieldNames() {
        return REQUIRED_FIELD_NAMES;
    }

    @Override
    protected Set<String> getOptionalFieldNames() {
        return OPTIONAL_FIELD_NAMES;
    }

    @Override
    public boolean matchesJSONObject(JSONObject o) {
        List<JSONValue> candidates = SubstringJSONObjectFilter.getValues(o, this.field);
        if (candidates.isEmpty()) {
            return false;
        }
        for (JSONValue v : candidates) {
            if (v instanceof JSONString) {
                if (!this.matchesSubstring(v)) continue;
                return true;
            }
            if (!(v instanceof JSONArray)) continue;
            for (JSONValue arrayValue : ((JSONArray)v).getValues()) {
                if (!this.matchesSubstring(arrayValue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesSubstring(JSONValue v) {
        if (!(v instanceof JSONString)) {
            return false;
        }
        String stringValue = this.caseSensitive ? ((JSONString)v).stringValue() : StaticUtils.toLowerCase(((JSONString)v).stringValue());
        if (stringValue.length() < this.minLength) {
            return false;
        }
        StringBuilder buffer = new StringBuilder(stringValue);
        if (this.matchStartsWith != null) {
            if (buffer.indexOf(this.matchStartsWith) != 0) {
                return false;
            }
            buffer.delete(0, this.matchStartsWith.length());
        }
        if (this.matchEndsWith != null) {
            int lengthMinusEndsWith = buffer.length() - this.matchEndsWith.length();
            if (buffer.lastIndexOf(this.matchEndsWith) != lengthMinusEndsWith) {
                return false;
            }
            buffer.setLength(lengthMinusEndsWith);
        }
        for (String s : this.matchContains) {
            int index = buffer.indexOf(s);
            if (index < 0) {
                return false;
            }
            buffer.delete(0, index + s.length());
        }
        return true;
    }

    @Override
    public JSONObject toJSONObject() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(6);
        fields.put("filterType", new JSONString(FILTER_TYPE));
        if (this.field.size() == 1) {
            fields.put(FIELD_FIELD_PATH, new JSONString(this.field.get(0)));
        } else {
            ArrayList<JSONString> fieldNameValues = new ArrayList<JSONString>(this.field.size());
            for (String s : this.field) {
                fieldNameValues.add(new JSONString(s));
            }
            fields.put(FIELD_FIELD_PATH, new JSONArray(fieldNameValues));
        }
        if (this.startsWith != null) {
            fields.put(FIELD_STARTS_WITH, new JSONString(this.startsWith));
        }
        if (!this.contains.isEmpty()) {
            if (this.contains.size() == 1) {
                fields.put(FIELD_CONTAINS, new JSONString(this.contains.get(0)));
            } else {
                ArrayList<JSONString> containsValues = new ArrayList<JSONString>(this.contains.size());
                for (String s : this.contains) {
                    containsValues.add(new JSONString(s));
                }
                fields.put(FIELD_CONTAINS, new JSONArray(containsValues));
            }
        }
        if (this.endsWith != null) {
            fields.put(FIELD_ENDS_WITH, new JSONString(this.endsWith));
        }
        if (this.caseSensitive) {
            fields.put(FIELD_CASE_SENSITIVE, JSONBoolean.TRUE);
        }
        return new JSONObject(fields);
    }

    @Override
    protected SubstringJSONObjectFilter decodeFilter(JSONObject filterObject) throws JSONException {
        List<String> fieldPath = this.getStrings(filterObject, FIELD_FIELD_PATH, false, null);
        String subInitial = this.getString(filterObject, FIELD_STARTS_WITH, null, false);
        List<String> subAny = this.getStrings(filterObject, FIELD_CONTAINS, true, Collections.<String>emptyList());
        String subFinal = this.getString(filterObject, FIELD_ENDS_WITH, null, false);
        if (subInitial == null && subFinal == null && subAny.isEmpty()) {
            throw new JSONException(JFMessages.ERR_SUBSTRING_FILTER_NO_COMPONENTS.get(String.valueOf(filterObject), FILTER_TYPE, FIELD_STARTS_WITH, FIELD_CONTAINS, FIELD_ENDS_WITH));
        }
        boolean isCaseSensitive = this.getBoolean(filterObject, FIELD_CASE_SENSITIVE, false);
        return new SubstringJSONObjectFilter(fieldPath, subInitial, subAny, subFinal, isCaseSensitive);
    }
}

