/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.AccessLogMessageType;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.ldap.sdk.unboundidds.logs.LogMessage;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ConnectAccessLogMessage
extends AccessLogMessage {
    private static final long serialVersionUID = 4254346309071273212L;
    private final String clientConnectionPolicy;
    private final String protocolName;
    private final String sourceAddress = this.getNamedValue("from");
    private final String targetAddress = this.getNamedValue("to");

    public ConnectAccessLogMessage(String s) throws LogException {
        this(new LogMessage(s));
    }

    public ConnectAccessLogMessage(LogMessage m) {
        super(m);
        this.protocolName = this.getNamedValue("protocol");
        this.clientConnectionPolicy = this.getNamedValue("clientConnectionPolicy");
    }

    public String getSourceAddress() {
        return this.sourceAddress;
    }

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getClientConnectionPolicy() {
        return this.clientConnectionPolicy;
    }

    public AccessLogMessageType getMessageType() {
        return AccessLogMessageType.CONNECT;
    }
}

