/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs;

import com.unboundid.ldap.sdk.unboundidds.logs.ErrorLogMessage;
import com.unboundid.ldap.sdk.unboundidds.logs.LogException;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ErrorLogReader {
    private final BufferedReader reader;

    public ErrorLogReader(String path) throws IOException {
        this.reader = new BufferedReader(new FileReader(path));
    }

    public ErrorLogReader(File file) throws IOException {
        this.reader = new BufferedReader(new FileReader(file));
    }

    public ErrorLogReader(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public ErrorLogMessage read() throws IOException, LogException {
        String line;
        do {
            if ((line = this.reader.readLine()) != null) continue;
            return null;
        } while (line.length() == 0 || line.charAt(0) == '#');
        return new ErrorLogMessage(line);
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

