/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class BackendMonitorEntry
extends MonitorEntry {
    static final String BACKEND_MONITOR_OC = "ds-backend-monitor-entry";
    private static final String ATTR_BACKEND_ID = "ds-backend-id";
    private static final String ATTR_BASE_DN = "ds-backend-base-dn";
    private static final String ATTR_ENTRIES_PER_BASE_DN = "ds-base-dn-entry-count";
    private static final String ATTR_IS_PRIVATE = "ds-backend-is-private";
    private static final String ATTR_SOFT_DELETE_COUNT = "ds-soft-delete-operations-count";
    private static final String ATTR_TOTAL_ENTRIES = "ds-backend-entry-count";
    private static final String ATTR_UNDELETE_COUNT = "ds-undelete-operations-count";
    private static final String ATTR_WRITABILITY_MODE = "ds-backend-writability-mode";
    private static final long serialVersionUID = -4256944695436807547L;
    private final Boolean isPrivate;
    private final List<String> baseDNs;
    private final Long softDeleteCount;
    private final Long totalEntries;
    private final Long undeleteCount;
    private final Map<String, Long> entriesPerBaseDN;
    private final String backendID = this.getString("ds-backend-id");
    private final String writabilityMode;

    public BackendMonitorEntry(Entry entry) {
        super(entry);
        this.baseDNs = this.getStrings(ATTR_BASE_DN);
        this.isPrivate = this.getBoolean(ATTR_IS_PRIVATE);
        this.softDeleteCount = this.getLong(ATTR_SOFT_DELETE_COUNT);
        this.totalEntries = this.getLong(ATTR_TOTAL_ENTRIES);
        this.undeleteCount = this.getLong(ATTR_UNDELETE_COUNT);
        this.writabilityMode = this.getString(ATTR_WRITABILITY_MODE);
        List<String> entriesPerBase = this.getStrings(ATTR_ENTRIES_PER_BASE_DN);
        LinkedHashMap<String, Long> countMap = new LinkedHashMap<String, Long>(entriesPerBase.size());
        for (String s : entriesPerBase) {
            try {
                int spacePos = s.indexOf(32);
                Long l = Long.parseLong(s.substring(0, spacePos));
                String dn = s.substring(spacePos + 1).trim();
                countMap.put(dn, l);
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (!Debug.debugEnabled(DebugType.MONITOR)) continue;
                Debug.debugMonitor(entry, "Cannot parse value '" + s + "' for attribute " + ATTR_ENTRIES_PER_BASE_DN);
            }
        }
        this.entriesPerBaseDN = Collections.unmodifiableMap(countMap);
    }

    public String getBackendID() {
        return this.backendID;
    }

    public List<String> getBaseDNs() {
        return this.baseDNs;
    }

    public Boolean isPrivate() {
        return this.isPrivate;
    }

    public String getWritabilityMode() {
        return this.writabilityMode;
    }

    public Long getTotalEntries() {
        return this.totalEntries;
    }

    public Map<String, Long> getEntriesPerBaseDN() {
        return this.entriesPerBaseDN;
    }

    public Long getSoftDeleteCount() {
        return this.softDeleteCount;
    }

    public Long getUndeleteCount() {
        return this.undeleteCount;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_BACKEND_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_BACKEND_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>();
        if (this.backendID != null) {
            BackendMonitorEntry.addMonitorAttribute(attrs, ATTR_BACKEND_ID, MonitorMessages.INFO_BACKEND_DISPNAME_BACKEND_ID.get(), MonitorMessages.INFO_BACKEND_DESC_BACKEND_ID.get(), this.backendID);
        }
        if (!this.baseDNs.isEmpty()) {
            BackendMonitorEntry.addMonitorAttribute(attrs, ATTR_BASE_DN, MonitorMessages.INFO_BACKEND_DISPNAME_BASE_DN.get(), MonitorMessages.INFO_BACKEND_DESC_BASE_DN.get(), this.baseDNs);
        }
        if (this.totalEntries != null) {
            BackendMonitorEntry.addMonitorAttribute(attrs, ATTR_TOTAL_ENTRIES, MonitorMessages.INFO_BACKEND_DISPNAME_TOTAL_ENTRIES.get(), MonitorMessages.INFO_BACKEND_DESC_TOTAL_ENTRIES.get(), this.totalEntries);
        }
        for (String baseDN : this.entriesPerBaseDN.keySet()) {
            Long count = this.entriesPerBaseDN.get(baseDN);
            BackendMonitorEntry.addMonitorAttribute(attrs, "ds-base-dn-entry-count-" + baseDN, MonitorMessages.INFO_BACKEND_DISPNAME_ENTRY_COUNT.get(baseDN), MonitorMessages.INFO_BACKEND_DESC_ENTRY_COUNT.get(baseDN), count);
        }
        if (this.softDeleteCount != null) {
            BackendMonitorEntry.addMonitorAttribute(attrs, ATTR_SOFT_DELETE_COUNT, MonitorMessages.INFO_BACKEND_DISPNAME_SOFT_DELETE_COUNT.get(), MonitorMessages.INFO_BACKEND_DESC_SOFT_DELETE_COUNT.get(), this.softDeleteCount);
        }
        if (this.undeleteCount != null) {
            BackendMonitorEntry.addMonitorAttribute(attrs, ATTR_UNDELETE_COUNT, MonitorMessages.INFO_BACKEND_DISPNAME_UNDELETE_COUNT.get(), MonitorMessages.INFO_BACKEND_DESC_UNDELETE_COUNT.get(), this.undeleteCount);
        }
        if (this.writabilityMode != null) {
            BackendMonitorEntry.addMonitorAttribute(attrs, ATTR_WRITABILITY_MODE, MonitorMessages.INFO_BACKEND_DISPNAME_WRITABILITY_MODE.get(), MonitorMessages.INFO_BACKEND_DESC_WRITABILITY_MODE.get(), this.writabilityMode);
        }
        if (this.isPrivate != null) {
            BackendMonitorEntry.addMonitorAttribute(attrs, ATTR_IS_PRIVATE, MonitorMessages.INFO_BACKEND_DISPNAME_IS_PRIVATE.get(), MonitorMessages.INFO_BACKEND_DESC_IS_PRIVATE.get(), this.isPrivate);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

