/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class ProcessingTimeHistogramMonitorEntry
extends MonitorEntry {
    static final String PROCESSING_TIME_HISTOGRAM_MONITOR_OC = "ds-processing-time-histogram-monitor-entry";
    private static final String ATTR_ADD_TOTAL_COUNT = "addOpsTotalCount";
    private static final String ATTR_ADD_AVERAGE_RESPONSE_TIME_MS = "addOpsAverageResponseTimeMillis";
    private static final String ATTR_ADD_AGGREGATE_PERCENT = "addOpsAggregatePercent";
    private static final String ATTR_ADD_COUNT = "addOpsCount";
    private static final String ATTR_ADD_PERCENT = "addOpsPercent";
    private static final String ATTR_ALL_TOTAL_COUNT = "allOpsTotalCount";
    private static final String ATTR_ALL_AVERAGE_RESPONSE_TIME_MS = "allOpsAverageResponseTimeMillis";
    private static final String ATTR_ALL_AGGREGATE_PERCENT = "allOpsAggregatePercent";
    private static final String ATTR_ALL_COUNT = "allOpsCount";
    private static final String ATTR_ALL_PERCENT = "allOpsPercent";
    private static final String ATTR_BIND_TOTAL_COUNT = "bindOpsTotalCount";
    private static final String ATTR_BIND_AVERAGE_RESPONSE_TIME_MS = "bindOpsAverageResponseTimeMillis";
    private static final String ATTR_BIND_AGGREGATE_PERCENT = "bindOpsAggregatePercent";
    private static final String ATTR_BIND_COUNT = "bindOpsCount";
    private static final String ATTR_BIND_PERCENT = "bindOpsPercent";
    private static final String ATTR_COMPARE_TOTAL_COUNT = "compareOpsTotalCount";
    private static final String ATTR_COMPARE_AVERAGE_RESPONSE_TIME_MS = "compareOpsAverageResponseTimeMillis";
    private static final String ATTR_COMPARE_AGGREGATE_PERCENT = "compareOpsAggregatePercent";
    private static final String ATTR_COMPARE_COUNT = "compareOpsCount";
    private static final String ATTR_COMPARE_PERCENT = "compareOpsPercent";
    private static final String ATTR_DELETE_TOTAL_COUNT = "deleteOpsTotalCount";
    private static final String ATTR_DELETE_AVERAGE_RESPONSE_TIME_MS = "deleteOpsAverageResponseTimeMillis";
    private static final String ATTR_DELETE_AGGREGATE_PERCENT = "deleteOpsAggregatePercent";
    private static final String ATTR_DELETE_COUNT = "deleteOpsCount";
    private static final String ATTR_DELETE_PERCENT = "deleteOpsPercent";
    private static final String ATTR_EXTENDED_TOTAL_COUNT = "extendedOpsTotalCount";
    private static final String ATTR_EXTENDED_AVERAGE_RESPONSE_TIME_MS = "extendedOpsAverageResponseTimeMillis";
    private static final String ATTR_EXTENDED_AGGREGATE_PERCENT = "extendedOpsAggregatePercent";
    private static final String ATTR_EXTENDED_COUNT = "extendedOpsCount";
    private static final String ATTR_EXTENDED_PERCENT = "extendedOpsPercent";
    private static final String ATTR_MODIFY_TOTAL_COUNT = "modifyOpsTotalCount";
    private static final String ATTR_MODIFY_AVERAGE_RESPONSE_TIME_MS = "modifyOpsAverageResponseTimeMillis";
    private static final String ATTR_MODIFY_AGGREGATE_PERCENT = "modifyOpsAggregatePercent";
    private static final String ATTR_MODIFY_COUNT = "modifyOpsCount";
    private static final String ATTR_MODIFY_PERCENT = "modifyOpsPercent";
    private static final String ATTR_MODIFY_DN_TOTAL_COUNT = "modifyDNOpsTotalCount";
    private static final String ATTR_MODIFY_DN_AVERAGE_RESPONSE_TIME_MS = "modifyDNOpsAverageResponseTimeMillis";
    private static final String ATTR_MODIFY_DN_AGGREGATE_PERCENT = "modifyDNOpsAggregatePercent";
    private static final String ATTR_MODIFY_DN_COUNT = "modifyDNOpsCount";
    private static final String ATTR_MODIFY_DN_PERCENT = "modifyDNOpsPercent";
    private static final String ATTR_SEARCH_TOTAL_COUNT = "searchOpsTotalCount";
    private static final String ATTR_SEARCH_AVERAGE_RESPONSE_TIME_MS = "searchOpsAverageResponseTimeMillis";
    private static final String ATTR_SEARCH_AGGREGATE_PERCENT = "searchOpsAggregatePercent";
    private static final String ATTR_SEARCH_COUNT = "searchOpsCount";
    private static final String ATTR_SEARCH_PERCENT = "searchOpsPercent";
    private static final long serialVersionUID = -2498009928344820276L;
    private final Map<Long, Double> addOpsPercent;
    private final Map<Long, Double> addOpsAggregatePercent;
    private final Map<Long, Double> allOpsPercent;
    private final Map<Long, Double> allOpsAggregatePercent;
    private final Map<Long, Double> bindOpsPercent;
    private final Map<Long, Double> bindOpsAggregatePercent;
    private final Map<Long, Double> compareOpsPercent;
    private final Map<Long, Double> compareOpsAggregatePercent;
    private final Map<Long, Double> deleteOpsPercent;
    private final Map<Long, Double> deleteOpsAggregatePercent;
    private final Map<Long, Double> extendedOpsPercent;
    private final Map<Long, Double> extendedOpsAggregatePercent;
    private final Map<Long, Double> modifyOpsPercent;
    private final Map<Long, Double> modifyOpsAggregatePercent;
    private final Map<Long, Double> modifyDNOpsPercent;
    private final Map<Long, Double> modifyDNOpsAggregatePercent;
    private final Map<Long, Double> searchOpsPercent;
    private final Map<Long, Double> searchOpsAggregatePercent;
    private final Map<Long, Long> addOpsCount;
    private final Map<Long, Long> allOpsCount;
    private final Map<Long, Long> bindOpsCount;
    private final Map<Long, Long> compareOpsCount;
    private final Map<Long, Long> deleteOpsCount;
    private final Map<Long, Long> extendedOpsCount;
    private final Map<Long, Long> modifyOpsCount;
    private final Map<Long, Long> modifyDNOpsCount;
    private final Map<Long, Long> searchOpsCount;
    private final Long addOpsTotalCount;
    private final Long allOpsTotalCount = this.getLong("allOpsTotalCount");
    private final Long bindOpsTotalCount;
    private final Long compareOpsTotalCount;
    private final Long deleteOpsTotalCount;
    private final Long extendedOpsTotalCount;
    private final Long modifyOpsTotalCount;
    private final Long modifyDNOpsTotalCount;
    private final Long searchOpsTotalCount;
    private final Double addOpsAvgResponseTimeMillis;
    private final Double allOpsAvgResponseTimeMillis = this.getDouble("allOpsAverageResponseTimeMillis");
    private final Double bindOpsAvgResponseTimeMillis;
    private final Double compareOpsAvgResponseTimeMillis;
    private final Double deleteOpsAvgResponseTimeMillis;
    private final Double extendedOpsAvgResponseTimeMillis;
    private final Double modifyOpsAvgResponseTimeMillis;
    private final Double modifyDNOpsAvgResponseTimeMillis;
    private final Double searchOpsAvgResponseTimeMillis;

    public ProcessingTimeHistogramMonitorEntry(Entry entry) {
        super(entry);
        this.allOpsCount = ProcessingTimeHistogramMonitorEntry.parseCountAttribute(entry, ATTR_ALL_COUNT);
        this.allOpsPercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_ALL_PERCENT);
        this.allOpsAggregatePercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_ALL_AGGREGATE_PERCENT);
        this.addOpsTotalCount = this.getLong(ATTR_ADD_TOTAL_COUNT);
        this.addOpsAvgResponseTimeMillis = this.getDouble(ATTR_ADD_AVERAGE_RESPONSE_TIME_MS);
        this.addOpsCount = ProcessingTimeHistogramMonitorEntry.parseCountAttribute(entry, ATTR_ADD_COUNT);
        this.addOpsPercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_ADD_PERCENT);
        this.addOpsAggregatePercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_ADD_AGGREGATE_PERCENT);
        this.bindOpsTotalCount = this.getLong(ATTR_BIND_TOTAL_COUNT);
        this.bindOpsAvgResponseTimeMillis = this.getDouble(ATTR_BIND_AVERAGE_RESPONSE_TIME_MS);
        this.bindOpsCount = ProcessingTimeHistogramMonitorEntry.parseCountAttribute(entry, ATTR_BIND_COUNT);
        this.bindOpsPercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_BIND_PERCENT);
        this.bindOpsAggregatePercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_BIND_AGGREGATE_PERCENT);
        this.compareOpsTotalCount = this.getLong(ATTR_COMPARE_TOTAL_COUNT);
        this.compareOpsAvgResponseTimeMillis = this.getDouble(ATTR_COMPARE_AVERAGE_RESPONSE_TIME_MS);
        this.compareOpsCount = ProcessingTimeHistogramMonitorEntry.parseCountAttribute(entry, ATTR_COMPARE_COUNT);
        this.compareOpsPercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_COMPARE_PERCENT);
        this.compareOpsAggregatePercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_COMPARE_AGGREGATE_PERCENT);
        this.deleteOpsTotalCount = this.getLong(ATTR_DELETE_TOTAL_COUNT);
        this.deleteOpsAvgResponseTimeMillis = this.getDouble(ATTR_DELETE_AVERAGE_RESPONSE_TIME_MS);
        this.deleteOpsCount = ProcessingTimeHistogramMonitorEntry.parseCountAttribute(entry, ATTR_DELETE_COUNT);
        this.deleteOpsPercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_DELETE_PERCENT);
        this.deleteOpsAggregatePercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_DELETE_AGGREGATE_PERCENT);
        this.extendedOpsTotalCount = this.getLong(ATTR_EXTENDED_TOTAL_COUNT);
        this.extendedOpsAvgResponseTimeMillis = this.getDouble(ATTR_EXTENDED_AVERAGE_RESPONSE_TIME_MS);
        this.extendedOpsCount = ProcessingTimeHistogramMonitorEntry.parseCountAttribute(entry, ATTR_EXTENDED_COUNT);
        this.extendedOpsPercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_EXTENDED_PERCENT);
        this.extendedOpsAggregatePercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_EXTENDED_AGGREGATE_PERCENT);
        this.modifyOpsTotalCount = this.getLong(ATTR_MODIFY_TOTAL_COUNT);
        this.modifyOpsAvgResponseTimeMillis = this.getDouble(ATTR_MODIFY_AVERAGE_RESPONSE_TIME_MS);
        this.modifyOpsCount = ProcessingTimeHistogramMonitorEntry.parseCountAttribute(entry, ATTR_MODIFY_COUNT);
        this.modifyOpsPercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_MODIFY_PERCENT);
        this.modifyOpsAggregatePercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_MODIFY_AGGREGATE_PERCENT);
        this.modifyDNOpsTotalCount = this.getLong(ATTR_MODIFY_DN_TOTAL_COUNT);
        this.modifyDNOpsAvgResponseTimeMillis = this.getDouble(ATTR_MODIFY_DN_AVERAGE_RESPONSE_TIME_MS);
        this.modifyDNOpsCount = ProcessingTimeHistogramMonitorEntry.parseCountAttribute(entry, ATTR_MODIFY_DN_COUNT);
        this.modifyDNOpsPercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_MODIFY_DN_PERCENT);
        this.modifyDNOpsAggregatePercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_MODIFY_DN_AGGREGATE_PERCENT);
        this.searchOpsTotalCount = this.getLong(ATTR_SEARCH_TOTAL_COUNT);
        this.searchOpsAvgResponseTimeMillis = this.getDouble(ATTR_SEARCH_AVERAGE_RESPONSE_TIME_MS);
        this.searchOpsCount = ProcessingTimeHistogramMonitorEntry.parseCountAttribute(entry, ATTR_SEARCH_COUNT);
        this.searchOpsPercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_SEARCH_PERCENT);
        this.searchOpsAggregatePercent = ProcessingTimeHistogramMonitorEntry.parsePercentAttribute(entry, ATTR_SEARCH_AGGREGATE_PERCENT);
    }

    private static Map<Long, Long> parseCountAttribute(Entry entry, String name) {
        String[] values = entry.getAttributeValues(name);
        if (values == null || values.length == 0) {
            return Collections.emptyMap();
        }
        try {
            LinkedHashMap<Long, Long> map = new LinkedHashMap<Long, Long>();
            int colonPos = values[0].indexOf(58);
            map.put(0L, Long.parseLong(values[0].substring(colonPos + 1).trim()));
            for (int i = 1; i < values.length; ++i) {
                long lowerBound;
                int msPos = values[i].indexOf("ms ");
                if (msPos < 0) {
                    msPos = values[i].indexOf("ms:");
                    lowerBound = Long.parseLong(values[i].substring(9, msPos));
                } else {
                    lowerBound = Long.parseLong(values[i].substring(8, msPos));
                }
                colonPos = values[i].indexOf(58, msPos);
                map.put(lowerBound, Long.parseLong(values[i].substring(colonPos + 1).trim()));
            }
            return Collections.unmodifiableMap(map);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return Collections.emptyMap();
        }
    }

    private static Map<Long, Double> parsePercentAttribute(Entry entry, String name) {
        String[] values = entry.getAttributeValues(name);
        if (values == null || values.length == 0) {
            return Collections.emptyMap();
        }
        try {
            LinkedHashMap<Long, Double> map = new LinkedHashMap<Long, Double>();
            boolean atLeastFound = false;
            long lastUpperBound = 0L;
            for (String s : values) {
                long lowerBound;
                int colonPos = s.indexOf(58);
                int pctPos = s.indexOf(37, colonPos);
                double percent = Double.parseDouble(s.substring(colonPos + 1, pctPos));
                int msPos = s.indexOf("ms");
                if (s.startsWith("Less than ")) {
                    map.put(lastUpperBound, percent);
                    lastUpperBound = Long.parseLong(s.substring(10, msPos));
                    continue;
                }
                if (s.startsWith("Between ")) {
                    lowerBound = Long.parseLong(s.substring(8, msPos));
                    map.put(lowerBound, percent);
                    int secondMSPos = s.indexOf("ms:", msPos + 1);
                    lastUpperBound = Long.parseLong(s.substring(msPos + 7, secondMSPos));
                    continue;
                }
                atLeastFound = true;
                lowerBound = Long.parseLong(s.substring(9, msPos));
                map.put(lowerBound, percent);
            }
            if (!atLeastFound) {
                map.put(lastUpperBound, 100.0);
            }
            return Collections.unmodifiableMap(map);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return Collections.emptyMap();
        }
    }

    public final Long getAllOpsTotalCount() {
        return this.allOpsTotalCount;
    }

    public final Double getAllOpsAverageResponseTimeMillis() {
        return this.allOpsAvgResponseTimeMillis;
    }

    public final Map<Long, Long> getAllOpsCount() {
        return this.allOpsCount;
    }

    public final Map<Long, Double> getAllOpsPercent() {
        return this.allOpsPercent;
    }

    public final Map<Long, Double> getAllOpsAggregatePercent() {
        return this.allOpsAggregatePercent;
    }

    public final Long getAddOpsTotalCount() {
        return this.addOpsTotalCount;
    }

    public final Double getAddOpsAverageResponseTimeMillis() {
        return this.addOpsAvgResponseTimeMillis;
    }

    public final Map<Long, Long> getAddOpsCount() {
        return this.addOpsCount;
    }

    public final Map<Long, Double> getAddOpsPercent() {
        return this.addOpsPercent;
    }

    public final Map<Long, Double> getAddOpsAggregatePercent() {
        return this.addOpsAggregatePercent;
    }

    public final Long getBindOpsTotalCount() {
        return this.bindOpsTotalCount;
    }

    public final Double getBindOpsAverageResponseTimeMillis() {
        return this.bindOpsAvgResponseTimeMillis;
    }

    public final Map<Long, Long> getBindOpsCount() {
        return this.bindOpsCount;
    }

    public final Map<Long, Double> getBindOpsPercent() {
        return this.bindOpsPercent;
    }

    public final Map<Long, Double> getBindOpsAggregatePercent() {
        return this.bindOpsAggregatePercent;
    }

    public final Long getCompareOpsTotalCount() {
        return this.compareOpsTotalCount;
    }

    public final Double getCompareOpsAverageResponseTimeMillis() {
        return this.compareOpsAvgResponseTimeMillis;
    }

    public final Map<Long, Long> getCompareOpsCount() {
        return this.compareOpsCount;
    }

    public final Map<Long, Double> getCompareOpsPercent() {
        return this.compareOpsPercent;
    }

    public final Map<Long, Double> getCompareOpsAggregatePercent() {
        return this.compareOpsAggregatePercent;
    }

    public final Long getDeleteOpsTotalCount() {
        return this.deleteOpsTotalCount;
    }

    public final Double getDeleteOpsAverageResponseTimeMillis() {
        return this.deleteOpsAvgResponseTimeMillis;
    }

    public final Map<Long, Long> getDeleteOpsCount() {
        return this.deleteOpsCount;
    }

    public final Map<Long, Double> getDeleteOpsPercent() {
        return this.deleteOpsPercent;
    }

    public final Map<Long, Double> getDeleteOpsAggregatePercent() {
        return this.deleteOpsAggregatePercent;
    }

    public final Long getExtendedOpsTotalCount() {
        return this.extendedOpsTotalCount;
    }

    public final Double getExtendedOpsAverageResponseTimeMillis() {
        return this.extendedOpsAvgResponseTimeMillis;
    }

    public final Map<Long, Long> getExtendedOpsCount() {
        return this.extendedOpsCount;
    }

    public final Map<Long, Double> getExtendedOpsPercent() {
        return this.extendedOpsPercent;
    }

    public final Map<Long, Double> getExtendedOpsAggregatePercent() {
        return this.extendedOpsAggregatePercent;
    }

    public final Long getModifyOpsTotalCount() {
        return this.modifyOpsTotalCount;
    }

    public final Double getModifyOpsAverageResponseTimeMillis() {
        return this.modifyOpsAvgResponseTimeMillis;
    }

    public final Map<Long, Long> getModifyOpsCount() {
        return this.modifyOpsCount;
    }

    public final Map<Long, Double> getModifyOpsPercent() {
        return this.modifyOpsPercent;
    }

    public final Map<Long, Double> getModifyOpsAggregatePercent() {
        return this.modifyOpsAggregatePercent;
    }

    public final Map<Long, Long> getModifyDNOpsCount() {
        return this.modifyDNOpsCount;
    }

    public final Long getModifyDNOpsTotalCount() {
        return this.modifyDNOpsTotalCount;
    }

    public final Double getModifyDNOpsAverageResponseTimeMillis() {
        return this.modifyDNOpsAvgResponseTimeMillis;
    }

    public final Map<Long, Double> getModifyDNOpsPercent() {
        return this.modifyDNOpsPercent;
    }

    public final Map<Long, Double> getModifyDNOpsAggregatePercent() {
        return this.modifyDNOpsAggregatePercent;
    }

    public final Long getSearchOpsTotalCount() {
        return this.searchOpsTotalCount;
    }

    public final Double getSearchOpsAverageResponseTimeMillis() {
        return this.searchOpsAvgResponseTimeMillis;
    }

    public final Map<Long, Long> getSearchOpsCount() {
        return this.searchOpsCount;
    }

    public final Map<Long, Double> getSearchOpsPercent() {
        return this.searchOpsPercent;
    }

    public final Map<Long, Double> getSearchOpsAggregatePercent() {
        return this.searchOpsAggregatePercent;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_PROCESSING_TIME_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_PROCESSING_TIME_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        Long value;
        Long lastValue;
        Iterator<Long> iterator;
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>();
        if (this.allOpsTotalCount != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_ALL_TOTAL_COUNT, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ALL_TOTAL_COUNT.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_ALL_TOTAL_COUNT.get(), this.allOpsTotalCount);
        }
        if (this.allOpsAvgResponseTimeMillis != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_ALL_AVERAGE_RESPONSE_TIME_MS, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ALL_TOTAL_TIME.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_ALL_TOTAL_TIME.get(), this.allOpsAvgResponseTimeMillis);
        }
        if (!this.allOpsCount.isEmpty()) {
            iterator = this.allOpsCount.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "allOpsCount-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ALL_COUNT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_ALL_COUNT.get(lastValue, value), this.allOpsCount.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "allOpsCount-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ALL_COUNT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_ALL_COUNT_LAST.get(lastValue), this.allOpsCount.get(lastValue));
            }
        }
        if (!this.allOpsPercent.isEmpty()) {
            iterator = this.allOpsPercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "allOpsPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ALL_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_ALL_PCT.get(lastValue, value), this.allOpsPercent.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "allOpsPct-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ALL_PCT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_ALL_PCT_LAST.get(lastValue), this.allOpsPercent.get(lastValue));
            }
        }
        if (!this.allOpsAggregatePercent.isEmpty()) {
            iterator = this.allOpsAggregatePercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "allOpsAggrPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ALL_AGGR_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_ALL_AGGR_PCT.get(lastValue, value), this.allOpsAggregatePercent.get(lastValue));
                lastValue = value;
            }
        }
        if (this.addOpsTotalCount != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_ADD_TOTAL_COUNT, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ADD_TOTAL_COUNT.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_ADD_TOTAL_COUNT.get(), this.addOpsTotalCount);
        }
        if (this.addOpsAvgResponseTimeMillis != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_ADD_AVERAGE_RESPONSE_TIME_MS, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ADD_TOTAL_TIME.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_ADD_TOTAL_TIME.get(), this.addOpsAvgResponseTimeMillis);
        }
        if (!this.addOpsCount.isEmpty()) {
            iterator = this.addOpsCount.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "addOpsCount-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ADD_COUNT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_ADD_COUNT.get(lastValue, value), this.addOpsCount.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "addOpsCount-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ADD_COUNT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_ADD_COUNT_LAST.get(lastValue), this.addOpsCount.get(lastValue));
            }
        }
        if (!this.addOpsPercent.isEmpty()) {
            iterator = this.addOpsPercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "addOpsPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ADD_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_ADD_PCT.get(lastValue, value), this.addOpsPercent.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "addOpsPct-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ADD_PCT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_ADD_PCT_LAST.get(lastValue), this.addOpsPercent.get(lastValue));
            }
        }
        if (!this.addOpsAggregatePercent.isEmpty()) {
            iterator = this.addOpsAggregatePercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "addOpsAggrPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_ADD_AGGR_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_ADD_AGGR_PCT.get(lastValue, value), this.addOpsAggregatePercent.get(lastValue));
                lastValue = value;
            }
        }
        if (this.bindOpsTotalCount != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_BIND_TOTAL_COUNT, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_BIND_TOTAL_COUNT.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_BIND_TOTAL_COUNT.get(), this.bindOpsTotalCount);
        }
        if (this.bindOpsAvgResponseTimeMillis != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_BIND_AVERAGE_RESPONSE_TIME_MS, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_BIND_TOTAL_TIME.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_BIND_TOTAL_TIME.get(), this.bindOpsAvgResponseTimeMillis);
        }
        if (!this.bindOpsCount.isEmpty()) {
            iterator = this.bindOpsCount.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "bindOpsCount-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_BIND_COUNT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_BIND_COUNT.get(lastValue, value), this.bindOpsCount.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "bindOpsCount-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_BIND_COUNT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_BIND_COUNT_LAST.get(lastValue), this.bindOpsCount.get(lastValue));
            }
        }
        if (!this.bindOpsPercent.isEmpty()) {
            iterator = this.bindOpsPercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "bindOpsPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_BIND_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_BIND_PCT.get(lastValue, value), this.bindOpsPercent.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "bindOpsPct-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_BIND_PCT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_BIND_PCT_LAST.get(lastValue), this.bindOpsPercent.get(lastValue));
            }
        }
        if (!this.bindOpsAggregatePercent.isEmpty()) {
            iterator = this.bindOpsAggregatePercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "bindOpsAggrPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_BIND_AGGR_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_BIND_AGGR_PCT.get(lastValue, value), this.bindOpsAggregatePercent.get(lastValue));
                lastValue = value;
            }
        }
        if (this.compareOpsTotalCount != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPARE_TOTAL_COUNT, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_COMPARE_TOTAL_COUNT.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_COMPARE_TOTAL_COUNT.get(), this.compareOpsTotalCount);
        }
        if (this.compareOpsAvgResponseTimeMillis != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_COMPARE_AVERAGE_RESPONSE_TIME_MS, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_COMPARE_TOTAL_TIME.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_COMPARE_TOTAL_TIME.get(), this.compareOpsAvgResponseTimeMillis);
        }
        if (!this.compareOpsCount.isEmpty()) {
            iterator = this.compareOpsCount.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "compareOpsCount-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_COMPARE_COUNT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_COMPARE_COUNT.get(lastValue, value), this.compareOpsCount.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "compareOpsCount-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_COMPARE_COUNT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_COMPARE_COUNT_LAST.get(lastValue), this.compareOpsCount.get(lastValue));
            }
        }
        if (!this.compareOpsPercent.isEmpty()) {
            iterator = this.compareOpsPercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "compareOpsPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_COMPARE_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_COMPARE_PCT.get(lastValue, value), this.compareOpsPercent.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "compareOpsPct-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_COMPARE_PCT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_COMPARE_PCT_LAST.get(lastValue), this.compareOpsPercent.get(lastValue));
            }
        }
        if (!this.compareOpsAggregatePercent.isEmpty()) {
            iterator = this.compareOpsAggregatePercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "compareOpsAggrPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_COMPARE_AGGR_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_COMPARE_AGGR_PCT.get(lastValue, value), this.compareOpsAggregatePercent.get(lastValue));
                lastValue = value;
            }
        }
        if (this.deleteOpsTotalCount != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_DELETE_TOTAL_COUNT, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_DELETE_TOTAL_COUNT.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_DELETE_TOTAL_COUNT.get(), this.deleteOpsTotalCount);
        }
        if (this.deleteOpsAvgResponseTimeMillis != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_DELETE_AVERAGE_RESPONSE_TIME_MS, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_DELETE_TOTAL_TIME.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_DELETE_TOTAL_TIME.get(), this.deleteOpsAvgResponseTimeMillis);
        }
        if (!this.deleteOpsCount.isEmpty()) {
            iterator = this.deleteOpsCount.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "deleteOpsCount-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_DELETE_COUNT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_DELETE_COUNT.get(lastValue, value), this.deleteOpsCount.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "deleteOpsCount-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_DELETE_COUNT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_DELETE_COUNT_LAST.get(lastValue), this.deleteOpsCount.get(lastValue));
            }
        }
        if (!this.deleteOpsPercent.isEmpty()) {
            iterator = this.deleteOpsPercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "deleteOpsPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_DELETE_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_DELETE_PCT.get(lastValue, value), this.deleteOpsPercent.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "deleteOpsPct-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_DELETE_PCT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_DELETE_PCT_LAST.get(lastValue), this.deleteOpsPercent.get(lastValue));
            }
        }
        if (!this.deleteOpsAggregatePercent.isEmpty()) {
            iterator = this.deleteOpsAggregatePercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "deleteOpsAggrPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_DELETE_AGGR_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_DELETE_AGGR_PCT.get(lastValue, value), this.deleteOpsAggregatePercent.get(lastValue));
                lastValue = value;
            }
        }
        if (this.extendedOpsTotalCount != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_EXTENDED_TOTAL_COUNT, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_EXTENDED_TOTAL_COUNT.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_EXTENDED_TOTAL_COUNT.get(), this.extendedOpsTotalCount);
        }
        if (this.extendedOpsAvgResponseTimeMillis != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_EXTENDED_AVERAGE_RESPONSE_TIME_MS, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_EXTENDED_TOTAL_TIME.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_EXTENDED_TOTAL_TIME.get(), this.extendedOpsAvgResponseTimeMillis);
        }
        if (!this.extendedOpsCount.isEmpty()) {
            iterator = this.extendedOpsCount.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "extendedOpsCount-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_EXTENDED_COUNT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_EXTENDED_COUNT.get(lastValue, value), this.extendedOpsCount.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "extendedOpsCount-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_EXTENDED_COUNT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_EXTENDED_COUNT_LAST.get(lastValue), this.extendedOpsCount.get(lastValue));
            }
        }
        if (!this.extendedOpsPercent.isEmpty()) {
            iterator = this.extendedOpsPercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "extendedOpsPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_EXTENDED_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_EXTENDED_PCT.get(lastValue, value), this.extendedOpsPercent.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "extendedOpsPct-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_EXTENDED_PCT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_EXTENDED_PCT_LAST.get(lastValue), this.extendedOpsPercent.get(lastValue));
            }
        }
        if (!this.extendedOpsAggregatePercent.isEmpty()) {
            iterator = this.extendedOpsAggregatePercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "extendedOpsAggrPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_EXTENDED_AGGR_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_EXTENDED_AGGR_PCT.get(lastValue, value), this.extendedOpsAggregatePercent.get(lastValue));
                lastValue = value;
            }
        }
        if (this.modifyOpsTotalCount != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_TOTAL_COUNT, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_TOTAL_COUNT.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_TOTAL_COUNT.get(), this.modifyOpsTotalCount);
        }
        if (this.modifyOpsAvgResponseTimeMillis != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_AVERAGE_RESPONSE_TIME_MS, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_TOTAL_TIME.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_TOTAL_TIME.get(), this.modifyOpsAvgResponseTimeMillis);
        }
        if (!this.modifyOpsCount.isEmpty()) {
            iterator = this.modifyOpsCount.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "modifyOpsCount-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_COUNT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_COUNT.get(lastValue, value), this.modifyOpsCount.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "modifyOpsCount-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_COUNT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_COUNT_LAST.get(lastValue), this.modifyOpsCount.get(lastValue));
            }
        }
        if (!this.modifyOpsPercent.isEmpty()) {
            iterator = this.modifyOpsPercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "modifyOpsPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_PCT.get(lastValue, value), this.modifyOpsPercent.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "modifyOpsPct-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_PCT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_PCT_LAST.get(lastValue), this.modifyOpsPercent.get(lastValue));
            }
        }
        if (!this.modifyOpsAggregatePercent.isEmpty()) {
            iterator = this.modifyOpsAggregatePercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "modifyOpsAggrPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_AGGR_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_AGGR_PCT.get(lastValue, value), this.modifyOpsAggregatePercent.get(lastValue));
                lastValue = value;
            }
        }
        if (this.modifyDNOpsTotalCount != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_DN_TOTAL_COUNT, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_DN_TOTAL_COUNT.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_DN_TOTAL_COUNT.get(), this.modifyDNOpsTotalCount);
        }
        if (this.modifyDNOpsAvgResponseTimeMillis != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_MODIFY_DN_AVERAGE_RESPONSE_TIME_MS, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_DN_TOTAL_TIME.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_DN_TOTAL_TIME.get(), this.modifyDNOpsAvgResponseTimeMillis);
        }
        if (!this.modifyDNOpsCount.isEmpty()) {
            iterator = this.modifyDNOpsCount.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "modifyDNOpsCount-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_DN_COUNT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_DN_COUNT.get(lastValue, value), this.modifyDNOpsCount.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "modifyDNOpsCount-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_DN_COUNT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_DN_COUNT_LAST.get(lastValue), this.modifyDNOpsCount.get(lastValue));
            }
        }
        if (!this.modifyDNOpsPercent.isEmpty()) {
            iterator = this.modifyDNOpsPercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "modifyDNOpsPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_DN_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_DN_PCT.get(lastValue, value), this.modifyDNOpsPercent.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "modifyDNOpsPct-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_DN_PCT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_DN_PCT_LAST.get(lastValue), this.modifyDNOpsPercent.get(lastValue));
            }
        }
        if (!this.modifyDNOpsAggregatePercent.isEmpty()) {
            iterator = this.modifyDNOpsAggregatePercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "modifyDNOpsAggrPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_MODIFY_DN_AGGR_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_MODIFY_DN_AGGR_PCT.get(lastValue, value), this.modifyDNOpsAggregatePercent.get(lastValue));
                lastValue = value;
            }
        }
        if (this.searchOpsTotalCount != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_TOTAL_COUNT, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_SEARCH_TOTAL_COUNT.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_SEARCH_TOTAL_COUNT.get(), this.searchOpsTotalCount);
        }
        if (this.searchOpsAvgResponseTimeMillis != null) {
            ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, ATTR_SEARCH_AVERAGE_RESPONSE_TIME_MS, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_SEARCH_TOTAL_TIME.get(), MonitorMessages.INFO_PROCESSING_TIME_DESC_SEARCH_TOTAL_TIME.get(), this.searchOpsAvgResponseTimeMillis);
        }
        if (!this.searchOpsCount.isEmpty()) {
            iterator = this.searchOpsCount.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "searchOpsCount-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_SEARCH_COUNT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_SEARCH_COUNT.get(lastValue, value), this.searchOpsCount.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "searchOpsCount-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_SEARCH_COUNT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_SEARCH_COUNT_LAST.get(lastValue), this.searchOpsCount.get(lastValue));
            }
        }
        if (!this.searchOpsPercent.isEmpty()) {
            iterator = this.searchOpsPercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "searchOpsPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_SEARCH_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_SEARCH_PCT.get(lastValue, value), this.searchOpsPercent.get(lastValue));
                lastValue = value;
                if (iterator.hasNext()) continue;
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "searchOpsPct-" + lastValue, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_SEARCH_PCT_LAST.get(lastValue), MonitorMessages.INFO_PROCESSING_TIME_DESC_SEARCH_PCT_LAST.get(lastValue), this.searchOpsPercent.get(lastValue));
            }
        }
        if (!this.searchOpsAggregatePercent.isEmpty()) {
            iterator = this.searchOpsAggregatePercent.keySet().iterator();
            lastValue = iterator.next();
            while (iterator.hasNext()) {
                value = iterator.next();
                ProcessingTimeHistogramMonitorEntry.addMonitorAttribute(attrs, "searchOpsAggrPct-" + lastValue + '-' + value, MonitorMessages.INFO_PROCESSING_TIME_DISPNAME_SEARCH_AGGR_PCT.get(lastValue, value), MonitorMessages.INFO_PROCESSING_TIME_DESC_SEARCH_AGGR_PCT.get(lastValue, value), this.searchOpsAggregatePercent.get(lastValue));
                lastValue = value;
            }
        }
        return Collections.unmodifiableMap(attrs);
    }
}

