/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.monitors;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorAttribute;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorEntry;
import com.unboundid.ldap.sdk.unboundidds.monitors.MonitorMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class UnboundIDWorkQueueMonitorEntry
extends MonitorEntry {
    static final String UNBOUNDID_WORK_QUEUE_MONITOR_OC = "ds-unboundid-work-queue-monitor-entry";
    private static final String ATTR_AVERAGE_QUEUE_TIME_MILLIS = "average-operation-queue-time-millis";
    private static final String ATTR_AVERAGE_PCT_BUSY = "average-worker-thread-percent-busy";
    private static final String ATTR_AVERAGE_SIZE = "average-queue-size";
    private static final String ATTR_CURRENT_PCT_BUSY = "current-worker-thread-percent-busy";
    private static final String ATTR_CURRENT_SIZE = "current-queue-size";
    private static final String ATTR_MAX_SIZE = "max-queue-size";
    private static final String ATTR_MAX_PCT_BUSY = "max-worker-thread-percent-busy";
    private static final String ATTR_NUM_BUSY_WORKER_THREADS = "num-busy-worker-threads";
    private static final String ATTR_NUM_WORKER_THREADS = "num-worker-threads";
    private static final String ATTR_RECENT_AVERAGE_SIZE = "recent-average-queue-size";
    private static final String ATTR_RECENT_QUEUE_TIME_MILLIS = "recent-operation-queue-time-millis";
    private static final String ATTR_RECENT_PCT_BUSY = "recent-worker-thread-percent-busy";
    private static final String ATTR_REQUESTS_REJECTED = "rejected-count";
    private static final String ATTR_CURRENT_ADMIN_QUEUE_SIZE = "current-administrative-session-queue-size";
    private static final String ATTR_MAX_ADMIN_SESSION_QUEUE_SIZE = "max-administrative-session-queue-size";
    private static final String ATTR_NUM_ADMIN_WORKER_THREADS = "num-administrative-session-worker-threads";
    private static final String ATTR_NUM_BUSY_ADMIN_WORKER_THREADS = "num-busy-administrative-session-worker-threads";
    private static final long serialVersionUID = -304216058351812232L;
    private final Long averageQueueTimeMillis;
    private final Long averagePercentBusy;
    private final Long averageSize = this.getLong("average-queue-size");
    private final Long currentAdminSize;
    private final Long currentSize = this.getLong("current-queue-size");
    private final Long currentPercentBusy;
    private final Long maxAdminSize;
    private final Long maxPercentBusy;
    private final Long maxSize;
    private final Long numAdminWorkerThreads;
    private final Long numBusyWorkerThreads;
    private final Long numBusyAdminWorkerThreads;
    private final Long numWorkerThreads;
    private final Long recentAverageSize = this.getLong("recent-average-queue-size");
    private final Long recentQueueTimeMillis;
    private final Long recentPercentBusy;
    private final Long requestsRejected;

    public UnboundIDWorkQueueMonitorEntry(Entry entry) {
        super(entry);
        this.maxSize = this.getLong(ATTR_MAX_SIZE);
        this.requestsRejected = this.getLong(ATTR_REQUESTS_REJECTED);
        this.numBusyWorkerThreads = this.getLong(ATTR_NUM_BUSY_WORKER_THREADS);
        this.numWorkerThreads = this.getLong(ATTR_NUM_WORKER_THREADS);
        this.currentPercentBusy = this.getLong(ATTR_CURRENT_PCT_BUSY);
        this.averagePercentBusy = this.getLong(ATTR_AVERAGE_PCT_BUSY);
        this.recentPercentBusy = this.getLong(ATTR_RECENT_PCT_BUSY);
        this.maxPercentBusy = this.getLong(ATTR_MAX_PCT_BUSY);
        this.averageQueueTimeMillis = this.getLong(ATTR_AVERAGE_QUEUE_TIME_MILLIS);
        this.recentQueueTimeMillis = this.getLong(ATTR_RECENT_QUEUE_TIME_MILLIS);
        this.currentAdminSize = this.getLong(ATTR_CURRENT_ADMIN_QUEUE_SIZE);
        this.maxAdminSize = this.getLong(ATTR_MAX_ADMIN_SESSION_QUEUE_SIZE);
        this.numAdminWorkerThreads = this.getLong(ATTR_NUM_ADMIN_WORKER_THREADS);
        this.numBusyAdminWorkerThreads = this.getLong(ATTR_NUM_BUSY_ADMIN_WORKER_THREADS);
    }

    public Long getAverageSize() {
        return this.averageSize;
    }

    public Long getRecentAverageSize() {
        return this.recentAverageSize;
    }

    public Long getCurrentSize() {
        return this.currentSize;
    }

    public Long getMaxSize() {
        return this.maxSize;
    }

    public Long getRequestsRejectedDueToQueueFull() {
        return this.requestsRejected;
    }

    public Long getNumWorkerThreads() {
        return this.numWorkerThreads;
    }

    public Long getNumBusyWorkerThreads() {
        return this.numBusyWorkerThreads;
    }

    public Long getCurrentWorkerThreadPercentBusy() {
        return this.currentPercentBusy;
    }

    public Long getAverageWorkerThreadPercentBusy() {
        return this.averagePercentBusy;
    }

    public Long getRecentWorkerThreadPercentBusy() {
        return this.recentPercentBusy;
    }

    public Long getMaxWorkerThreadPercentBusy() {
        return this.maxPercentBusy;
    }

    public Long getAverageOperationQueueTimeMillis() {
        return this.averageQueueTimeMillis;
    }

    public Long getRecentOperationQueueTimeMillis() {
        return this.recentQueueTimeMillis;
    }

    public Long getCurrentAdministrativeSessionQueueSize() {
        return this.currentAdminSize;
    }

    public Long getMaxAdministrativeSessionQueueSize() {
        return this.maxAdminSize;
    }

    public Long getNumAdministrativeSessionWorkerThreads() {
        return this.numAdminWorkerThreads;
    }

    public Long getNumBusyAdministrativeSessionWorkerThreads() {
        return this.numBusyAdminWorkerThreads;
    }

    @Override
    public String getMonitorDisplayName() {
        return MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_MONITOR_DISPNAME.get();
    }

    @Override
    public String getMonitorDescription() {
        return MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_MONITOR_DESC.get();
    }

    @Override
    public Map<String, MonitorAttribute> getMonitorAttributes() {
        LinkedHashMap<String, MonitorAttribute> attrs = new LinkedHashMap<String, MonitorAttribute>();
        if (this.requestsRejected != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_REQUESTS_REJECTED, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_REQUESTS_REJECTED.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_REQUESTS_REJECTED.get(), this.requestsRejected);
        }
        if (this.currentSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_CURRENT_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_CURRENT_SIZE.get(), this.currentSize);
        }
        if (this.recentAverageSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_AVERAGE_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_RECENT_AVERAGE_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_RECENT_AVERAGE_SIZE.get(), this.recentAverageSize);
        }
        if (this.averageSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_AVERAGE_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_AVERAGE_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_AVERAGE_SIZE.get(), this.averageSize);
        }
        if (this.maxSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_MAX_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_MAX_SIZE.get(), this.maxSize);
        }
        if (this.numWorkerThreads != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_WORKER_THREADS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_NUM_THREADS.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_NUM_THREADS.get(), this.numWorkerThreads);
        }
        if (this.numBusyWorkerThreads != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_BUSY_WORKER_THREADS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_NUM_BUSY_THREADS.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_NUM_BUSY_THREADS.get(), this.numBusyWorkerThreads);
        }
        if (this.currentPercentBusy != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_PCT_BUSY, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_CURRENT_PCT_BUSY.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_CURRENT_PCT_BUSY.get(), this.currentPercentBusy);
        }
        if (this.averagePercentBusy != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_AVERAGE_PCT_BUSY, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_AVG_PCT_BUSY.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_AVG_PCT_BUSY.get(), this.averagePercentBusy);
        }
        if (this.recentPercentBusy != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_PCT_BUSY, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_RECENT_PCT_BUSY.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_RECENT_PCT_BUSY.get(), this.recentPercentBusy);
        }
        if (this.maxPercentBusy != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_PCT_BUSY, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_MAX_PCT_BUSY.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_MAX_PCT_BUSY.get(), this.maxPercentBusy);
        }
        if (this.averageQueueTimeMillis != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_AVERAGE_QUEUE_TIME_MILLIS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_AVG_QUEUE_TIME.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_AVG_QUEUE_TIME.get(), this.averageQueueTimeMillis);
        }
        if (this.recentQueueTimeMillis != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_RECENT_QUEUE_TIME_MILLIS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_RECENT_QUEUE_TIME.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_RECENT_QUEUE_TIME.get(), this.recentQueueTimeMillis);
        }
        if (this.currentAdminSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_CURRENT_ADMIN_QUEUE_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_CURRENT_ADMIN_QUEUE_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_CURRENT_ADMIN_QUEUE_SIZE.get(), this.currentAdminSize);
        }
        if (this.maxAdminSize != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_MAX_ADMIN_SESSION_QUEUE_SIZE, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_MAX_ADMIN_QUEUE_SIZE.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_MAX_ADMIN_QUEUE_SIZE.get(), this.maxAdminSize);
        }
        if (this.numAdminWorkerThreads != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_ADMIN_WORKER_THREADS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_NUM_ADMIN_THREADS.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_NUM_ADMIN_THREADS.get(), this.numAdminWorkerThreads);
        }
        if (this.numBusyAdminWorkerThreads != null) {
            UnboundIDWorkQueueMonitorEntry.addMonitorAttribute(attrs, ATTR_NUM_BUSY_ADMIN_WORKER_THREADS, MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DISPNAME_NUM_BUSY_ADMIN_THREADS.get(), MonitorMessages.INFO_UNBOUNDID_WORK_QUEUE_DESC_NUM_BUSY_ADMIN_THREADS.get(), this.numBusyAdminWorkerThreads);
        }
        return Collections.unmodifiableMap(attrs);
    }
}

