/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AlertTask
extends Task {
    static final String ALERT_TASK_CLASS = "com.unboundid.directory.server.tasks.AlertTask";
    private static final String ATTR_ALERT_TYPE = "ds-task-alert-type";
    private static final String ATTR_ALERT_MESSAGE = "ds-task-alert-message";
    private static final String ATTR_ADD_DEGRADED_TYPE = "ds-task-alert-add-degraded-type";
    private static final String ATTR_REMOVE_DEGRADED_TYPE = "ds-task-alert-remove-degraded-type";
    private static final String ATTR_ADD_UNAVAILABLE_TYPE = "ds-task-alert-add-unavailable-type";
    private static final String ATTR_REMOVE_UNAVAILABLE_TYPE = "ds-task-alert-remove-unavailable-type";
    private static final String OC_ALERT_TASK = "ds-task-alert";
    private static final TaskProperty PROPERTY_ALERT_TYPE = new TaskProperty("ds-task-alert-type", TaskMessages.INFO_ALERT_DISPLAY_NAME_TYPE.get(), TaskMessages.INFO_ALERT_DESCRIPTION_TYPE.get(), String.class, false, false, false);
    private static final TaskProperty PROPERTY_ALERT_MESSAGE = new TaskProperty("ds-task-alert-message", TaskMessages.INFO_ALERT_DISPLAY_NAME_MESSAGE.get(), TaskMessages.INFO_ALERT_DESCRIPTION_MESSAGE.get(), String.class, false, false, false);
    private static final TaskProperty PROPERTY_ADD_DEGRADED_TYPE = new TaskProperty("ds-task-alert-add-degraded-type", TaskMessages.INFO_ALERT_DISPLAY_NAME_ADD_DEGRADED.get(), TaskMessages.INFO_ALERT_DESCRIPTION_ADD_DEGRADED.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_REMOVE_DEGRADED_TYPE = new TaskProperty("ds-task-alert-remove-degraded-type", TaskMessages.INFO_ALERT_DISPLAY_NAME_REMOVE_DEGRADED.get(), TaskMessages.INFO_ALERT_DESCRIPTION_REMOVE_DEGRADED.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_ADD_UNAVAILABLE_TYPE = new TaskProperty("ds-task-alert-add-unavailable-type", TaskMessages.INFO_ALERT_DISPLAY_NAME_ADD_UNAVAILABLE.get(), TaskMessages.INFO_ALERT_DESCRIPTION_ADD_UNAVAILABLE.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_REMOVE_UNAVAILABLE_TYPE = new TaskProperty("ds-task-alert-remove-unavailable-type", TaskMessages.INFO_ALERT_DISPLAY_NAME_REMOVE_UNAVAILABLE.get(), TaskMessages.INFO_ALERT_DESCRIPTION_REMOVE_UNAVAILABLE.get(), String.class, false, true, false);
    private static final long serialVersionUID = 8253375533166941221L;
    private final List<String> addDegradedTypes;
    private final List<String> addUnavailableTypes;
    private final List<String> removeDegradedTypes;
    private final List<String> removeUnavailableTypes;
    private final String alertMessage;
    private final String alertType;

    public AlertTask() {
        this.alertType = null;
        this.alertMessage = null;
        this.addDegradedTypes = null;
        this.addUnavailableTypes = null;
        this.removeDegradedTypes = null;
        this.removeUnavailableTypes = null;
    }

    public AlertTask(String alertType, String alertMessage) {
        this(null, alertType, alertMessage, null, null, null, null, null, null, null, null, null);
    }

    public AlertTask(String alertType, String alertMessage, List<String> addDegradedTypes, List<String> removeDegradedTypes, List<String> addUnavailableTypes, List<String> removeUnavailableTypes) {
        this(null, alertType, alertMessage, addDegradedTypes, removeDegradedTypes, addUnavailableTypes, removeUnavailableTypes, null, null, null, null, null);
    }

    public AlertTask(String taskID, String alertType, String alertMessage, List<String> addDegradedTypes, List<String> removeDegradedTypes, List<String> addUnavailableTypes, List<String> removeUnavailableTypes, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        super(taskID, ALERT_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
        this.alertType = alertType;
        this.alertMessage = alertMessage;
        Validator.ensureTrue(alertType == null == (alertMessage == null));
        this.addDegradedTypes = AlertTask.getStringList(addDegradedTypes);
        this.removeDegradedTypes = AlertTask.getStringList(removeDegradedTypes);
        this.addUnavailableTypes = AlertTask.getStringList(addUnavailableTypes);
        this.removeUnavailableTypes = AlertTask.getStringList(removeUnavailableTypes);
        if (alertType == null) {
            Validator.ensureFalse(this.addDegradedTypes.isEmpty() && this.removeDegradedTypes.isEmpty() && this.addUnavailableTypes.isEmpty() && this.removeUnavailableTypes.isEmpty());
        }
    }

    public AlertTask(Entry entry) throws TaskException {
        super(entry);
        this.alertType = entry.getAttributeValue(ATTR_ALERT_TYPE);
        this.alertMessage = entry.getAttributeValue(ATTR_ALERT_MESSAGE);
        if (this.alertType == null != (this.alertMessage == null)) {
            throw new TaskException(TaskMessages.ERR_ALERT_TYPE_AND_MESSAGE_INTERDEPENDENT.get());
        }
        this.addDegradedTypes = AlertTask.parseStringList(entry, ATTR_ADD_DEGRADED_TYPE);
        this.removeDegradedTypes = AlertTask.parseStringList(entry, ATTR_REMOVE_DEGRADED_TYPE);
        this.addUnavailableTypes = AlertTask.parseStringList(entry, ATTR_ADD_UNAVAILABLE_TYPE);
        this.removeUnavailableTypes = AlertTask.parseStringList(entry, ATTR_REMOVE_UNAVAILABLE_TYPE);
        if (this.alertType == null && this.addDegradedTypes.isEmpty() && this.removeDegradedTypes.isEmpty() && this.addUnavailableTypes.isEmpty() && this.removeUnavailableTypes.isEmpty()) {
            throw new TaskException(TaskMessages.ERR_ALERT_ENTRY_NO_ELEMENTS.get());
        }
    }

    public AlertTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(ALERT_TASK_CLASS, properties);
        String type = null;
        String message = null;
        LinkedList<String> addDegraded = new LinkedList<String>();
        LinkedList<String> removeDegraded = new LinkedList<String>();
        LinkedList<String> addUnavailable = new LinkedList<String>();
        LinkedList<String> removeUnavailable = new LinkedList<String>();
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            String[] s;
            TaskProperty p = entry.getKey();
            String attrName = StaticUtils.toLowerCase(p.getAttributeName());
            List<Object> values = entry.getValue();
            if (attrName.equals(ATTR_ALERT_TYPE)) {
                type = AlertTask.parseString(p, values, type);
                continue;
            }
            if (attrName.equals(ATTR_ALERT_MESSAGE)) {
                message = AlertTask.parseString(p, values, message);
                continue;
            }
            if (attrName.equals(ATTR_ADD_DEGRADED_TYPE)) {
                s = AlertTask.parseStrings(p, values, null);
                if (s == null) continue;
                addDegraded.addAll(Arrays.asList(s));
                continue;
            }
            if (attrName.equals(ATTR_REMOVE_DEGRADED_TYPE)) {
                s = AlertTask.parseStrings(p, values, null);
                if (s == null) continue;
                removeDegraded.addAll(Arrays.asList(s));
                continue;
            }
            if (attrName.equals(ATTR_ADD_UNAVAILABLE_TYPE)) {
                s = AlertTask.parseStrings(p, values, null);
                if (s == null) continue;
                addUnavailable.addAll(Arrays.asList(s));
                continue;
            }
            if (!attrName.equals(ATTR_REMOVE_UNAVAILABLE_TYPE) || (s = AlertTask.parseStrings(p, values, null)) == null) continue;
            removeUnavailable.addAll(Arrays.asList(s));
        }
        this.alertType = type;
        this.alertMessage = message;
        this.addDegradedTypes = Collections.unmodifiableList(addDegraded);
        this.removeDegradedTypes = Collections.unmodifiableList(removeDegraded);
        this.addUnavailableTypes = Collections.unmodifiableList(addUnavailable);
        this.removeUnavailableTypes = Collections.unmodifiableList(removeUnavailable);
        if (this.alertType == null != (this.alertMessage == null)) {
            throw new TaskException(TaskMessages.ERR_ALERT_TYPE_AND_MESSAGE_INTERDEPENDENT.get());
        }
        if (this.alertType == null && this.addDegradedTypes.isEmpty() && this.removeDegradedTypes.isEmpty() && this.addUnavailableTypes.isEmpty() && this.removeUnavailableTypes.isEmpty()) {
            throw new TaskException(TaskMessages.ERR_ALERT_PROPERTIES_NO_ELEMENTS.get());
        }
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_ALERT.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_ALERT.get();
    }

    public String getAlertType() {
        return this.alertType;
    }

    public String getAlertMessage() {
        return this.alertMessage;
    }

    public List<String> getAddDegradedAlertTypes() {
        return this.addDegradedTypes;
    }

    public List<String> getRemoveDegradedAlertTypes() {
        return this.removeDegradedTypes;
    }

    public List<String> getAddUnavailableAlertTypes() {
        return this.addUnavailableTypes;
    }

    public List<String> getRemoveUnavailableAlertTypes() {
        return this.removeUnavailableTypes;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Arrays.asList(OC_ALERT_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        LinkedList<Attribute> attrList = new LinkedList<Attribute>();
        if (this.alertType != null) {
            attrList.add(new Attribute(ATTR_ALERT_TYPE, this.alertType));
            attrList.add(new Attribute(ATTR_ALERT_MESSAGE, this.alertMessage));
        }
        if (!this.addDegradedTypes.isEmpty()) {
            attrList.add(new Attribute(ATTR_ADD_DEGRADED_TYPE, this.addDegradedTypes));
        }
        if (!this.removeDegradedTypes.isEmpty()) {
            attrList.add(new Attribute(ATTR_REMOVE_DEGRADED_TYPE, this.removeDegradedTypes));
        }
        if (!this.addUnavailableTypes.isEmpty()) {
            attrList.add(new Attribute(ATTR_ADD_UNAVAILABLE_TYPE, this.addUnavailableTypes));
        }
        if (!this.removeUnavailableTypes.isEmpty()) {
            attrList.add(new Attribute(ATTR_REMOVE_UNAVAILABLE_TYPE, this.removeUnavailableTypes));
        }
        return attrList;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_ALERT_TYPE, PROPERTY_ALERT_MESSAGE, PROPERTY_ADD_DEGRADED_TYPE, PROPERTY_REMOVE_DEGRADED_TYPE, PROPERTY_ADD_UNAVAILABLE_TYPE, PROPERTY_REMOVE_UNAVAILABLE_TYPE));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<String>> props = new LinkedHashMap<TaskProperty, List<String>>(6);
        if (this.alertType != null) {
            props.put(PROPERTY_ALERT_TYPE, Collections.unmodifiableList(Arrays.asList(this.alertType)));
            props.put(PROPERTY_ALERT_MESSAGE, Collections.unmodifiableList(Arrays.asList(this.alertMessage)));
        }
        if (!this.addDegradedTypes.isEmpty()) {
            props.put(PROPERTY_ADD_DEGRADED_TYPE, Collections.unmodifiableList(this.addDegradedTypes));
        }
        if (!this.removeDegradedTypes.isEmpty()) {
            props.put(PROPERTY_REMOVE_DEGRADED_TYPE, Collections.unmodifiableList(this.removeDegradedTypes));
        }
        if (!this.addUnavailableTypes.isEmpty()) {
            props.put(PROPERTY_ADD_UNAVAILABLE_TYPE, Collections.unmodifiableList(this.addUnavailableTypes));
        }
        if (!this.removeUnavailableTypes.isEmpty()) {
            props.put(PROPERTY_REMOVE_UNAVAILABLE_TYPE, Collections.unmodifiableList(this.removeUnavailableTypes));
        }
        return Collections.unmodifiableMap(props);
    }

    private static List<String> getStringList(List<String> l) {
        if (l == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }
}

