/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum TaskState {
    CANCELED_BEFORE_STARTING("canceled_before_starting"),
    COMPLETED_SUCCESSFULLY("completed_successfully"),
    COMPLETED_WITH_ERRORS("completed_with_errors"),
    DISABLED("disabled"),
    RUNNING("running"),
    STOPPED_BY_ADMINISTRATOR("stopped_by_administrator"),
    STOPPED_BY_ERROR("stopped_by_error"),
    STOPPED_BY_SHUTDOWN("stopped_by_shutdown"),
    UNSCHEDULED("unscheduled"),
    WAITING_ON_DEPENDENCY("waiting_on_dependency"),
    WAITING_ON_START_TIME("waiting_on_start_time");

    private final String name;

    private TaskState(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static TaskState forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        if (lowerName.equals("canceled_before_starting")) {
            return CANCELED_BEFORE_STARTING;
        }
        if (lowerName.equals("completed_successfully")) {
            return COMPLETED_SUCCESSFULLY;
        }
        if (lowerName.equals("completed_with_errors")) {
            return COMPLETED_WITH_ERRORS;
        }
        if (lowerName.equals("disabled")) {
            return DISABLED;
        }
        if (lowerName.equals("running")) {
            return RUNNING;
        }
        if (lowerName.equals("stopped_by_administrator")) {
            return STOPPED_BY_ADMINISTRATOR;
        }
        if (lowerName.equals("stopped_by_error")) {
            return STOPPED_BY_ERROR;
        }
        if (lowerName.equals("stopped_by_shutdown")) {
            return STOPPED_BY_SHUTDOWN;
        }
        if (lowerName.equals("unscheduled")) {
            return UNSCHEDULED;
        }
        if (lowerName.equals("waiting_on_dependency")) {
            return WAITING_ON_DEPENDENCY;
        }
        if (lowerName.equals("waiting_on_start_time")) {
            return WAITING_ON_START_TIME;
        }
        return null;
    }

    public boolean isPending() {
        switch (this) {
            case DISABLED: 
            case UNSCHEDULED: 
            case WAITING_ON_DEPENDENCY: 
            case WAITING_ON_START_TIME: {
                return true;
            }
        }
        return false;
    }

    public boolean isRunning() {
        return this == RUNNING;
    }

    public boolean isCompleted() {
        return !this.isPending() && !this.isRunning();
    }

    public String toString() {
        return this.name;
    }
}

