/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ThirdPartyTask
extends Task {
    static final String THIRD_PARTY_TASK_CLASS = "com.unboundid.directory.sdk.extensions.ThirdPartyTask";
    private static final String ATTR_THIRD_PARTY_TASK_CLASS = "ds-third-party-task-java-class";
    private static final String ATTR_THIRD_PARTY_TASK_ARGUMENT = "ds-third-party-task-argument";
    private static final String OC_THIRD_PARTY_TASK = "ds-third-party-task";
    static final TaskProperty PROPERTY_TASK_CLASS = new TaskProperty("ds-third-party-task-java-class", TaskMessages.INFO_DISPLAY_NAME_THIRD_PARTY_TASK_CLASS.get(), TaskMessages.INFO_DESCRIPTION_THIRD_PARTY_TASK_CLASS.get(), String.class, true, false, false);
    static final TaskProperty PROPERTY_TASK_ARG = new TaskProperty("ds-third-party-task-argument", TaskMessages.INFO_DISPLAY_NAME_THIRD_PARTY_TASK_ARG.get(), TaskMessages.INFO_DESCRIPTION_THIRD_PARTY_TASK_ARG.get(), String.class, false, true, false);
    private static final long serialVersionUID = 8448474409066265724L;
    private final List<String> taskArguments;
    private final String taskClassName;

    public ThirdPartyTask() {
        this.taskArguments = null;
        this.taskClassName = null;
    }

    public ThirdPartyTask(String taskID, String taskClassName, List<String> taskArguments) {
        this(taskID, taskClassName, taskArguments, null, null, null, null, null);
    }

    public ThirdPartyTask(String taskID, String taskClassName, List<String> taskArguments, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnCompletion, List<String> notifyOnError) {
        super(taskID, THIRD_PARTY_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnCompletion, notifyOnError);
        Validator.ensureNotNull(taskClassName);
        this.taskClassName = taskClassName;
        this.taskArguments = taskArguments == null ? Collections.emptyList() : Collections.unmodifiableList(taskArguments);
    }

    public ThirdPartyTask(Entry entry) throws TaskException {
        super(entry);
        this.taskClassName = entry.getAttributeValue(ATTR_THIRD_PARTY_TASK_CLASS);
        if (this.taskClassName == null) {
            throw new TaskException(TaskMessages.ERR_THIRD_PARTY_TASK_NO_CLASS.get(this.getTaskEntryDN()));
        }
        String[] args = entry.getAttributeValues(ATTR_THIRD_PARTY_TASK_ARGUMENT);
        this.taskArguments = args == null || args.length == 0 ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(args));
    }

    public ThirdPartyTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(THIRD_PARTY_TASK_CLASS, properties);
        String className = null;
        String[] args = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_THIRD_PARTY_TASK_CLASS)) {
                className = ThirdPartyTask.parseString(p, values, null);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_THIRD_PARTY_TASK_ARGUMENT)) continue;
            args = ThirdPartyTask.parseStrings(p, values, null);
        }
        if (className == null) {
            throw new TaskException(TaskMessages.ERR_THIRD_PARTY_TASK_NO_CLASS.get(this.getTaskEntryDN()));
        }
        this.taskClassName = className;
        this.taskArguments = args == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(args));
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_THIRD_PARTY_TASK.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_THIRD_PARTY_TASK.get();
    }

    public String getThirdPartyTaskClassName() {
        return this.taskClassName;
    }

    public List<String> getThirdPartyTaskArguments() {
        return this.taskArguments;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Arrays.asList(OC_THIRD_PARTY_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrList = new ArrayList<Attribute>(2);
        attrList.add(new Attribute(ATTR_THIRD_PARTY_TASK_CLASS, this.taskClassName));
        if (!this.taskArguments.isEmpty()) {
            attrList.add(new Attribute(ATTR_THIRD_PARTY_TASK_ARGUMENT, this.taskArguments));
        }
        return attrList;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_TASK_CLASS, PROPERTY_TASK_ARG));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(2);
        props.put(PROPERTY_TASK_CLASS, Collections.unmodifiableList(Arrays.asList(this.taskClassName)));
        props.put(PROPERTY_TASK_ARG, Collections.unmodifiableList(this.taskArguments));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

